using System.Linq;
using Navtrack.DataAccess.Model.Devices.Messages;
using Navtrack.Listener.Protocols.Teltonika;
using Xunit;

namespace Navtrack.Listener.Tests.Protocols.Teltonika;

public class TeltonikaProtocolCodec8Tests : BaseProtocolTests<TeltonikaProtocol, TeltonikaMessageHandler>
{
    [Fact]
    public void Codec8_DeviceSendImeiV1_ServerReturnsAcknowledge()
    {
        ProtocolTester.SendHexFromDevice("000F333536333037303432343431303133");

        Assert.Equal("01", ProtocolTester.ReceiveHexInDevice());
    }

    [Fact]
    public void Codec8_DeviceSendImeiV2_ServerReturnsAcknowledge()
    {
        ProtocolTester.SendHexFromDevice("000F333532383438303236333839393631");

        Assert.Equal("01", ProtocolTester.ReceiveHexInDevice());
    }
        
    [Fact]
    public void Codec8_DeviceSendsLocationV1_ServerConfirmsDataReceived()
    {
        ProtocolTester.SendHexFromDevice("000F333536333037303432343431303133");

        Assert.Equal("01", ProtocolTester.ReceiveHexInDevice());
        Assert.NotNull(ProtocolTester.ConnectionContext.Device);

        ProtocolTester.SendHexFromDevice(
            "000000000000003608010000016B40D8EA30010000000000000000000000000000000105021503010101425E0F01F10000601A014E0000000000000000010000C7CF");

        Assert.Equal("00000001", ProtocolTester.ReceiveHexInDevice());
        Assert.Single(ProtocolTester.LastParsedMessages);
    }
        
    [Fact]
    public void Codec8_DeviceSendsLocationV2_ServerConfirmsDataReceived()
    {
        ProtocolTester.SendHexFromDevice("000F333536333037303432343431303133");

        Assert.Equal("01", ProtocolTester.ReceiveHexInDevice());
        Assert.NotNull(ProtocolTester.ConnectionContext.Device);

        ProtocolTester.SendHexFromDevice(
            "000000000000002808010000016B40D9AD80010000000000000000000000000000000103021503010101425E100000010000F22A");

        Assert.Equal("00000001", ProtocolTester.ReceiveHexInDevice());
        Assert.Single(ProtocolTester.LastParsedMessages);
    }

    [Fact]
    public void Codec8_DeviceSendsLocationV3_ServerConfirmsDataReceived()
    {
        ProtocolTester.SendHexFromDevice("000F333536333037303432343431303133");

        Assert.Equal("01", ProtocolTester.ReceiveHexInDevice());
        Assert.NotNull(ProtocolTester.ConnectionContext.Device);

        ProtocolTester.SendHexFromDevice(
            "000000000000004308020000016B40D57B480100000000000000000000000000000001010101000000000000016B40D5C198010000000000000000000000000000000101010101000000020000252C");

        Assert.Equal("00000002", ProtocolTester.ReceiveHexInDevice());
        Assert.Equal(2, ProtocolTester.LastParsedMessages.Count);
    }
        
    [Fact]
    public void Codec8_DeviceSendsLocationV4_ServerConfirmsDataReceived()
    {
        ProtocolTester.SendHexFromDevice("000F333532383438303236333839393631");

        Assert.Equal("01", ProtocolTester.ReceiveHexInDevice());
        Assert.NotNull(ProtocolTester.ConnectionContext.Device);

        ProtocolTester.SendHexFromDevice(
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

        Assert.Equal("00000012", ProtocolTester.ReceiveHexInDevice());
        Assert.Equal(18, ProtocolTester.LastParsedMessages.Count());
    }
    
    [Fact]
    public void Codec8_DeviceSendsLocationV5_CoordinatesAreCorrect()
    {
        ProtocolTester.SendHexFromDevice("000F333532383438303236333839393631");

        Assert.Equal("01", ProtocolTester.ReceiveHexInDevice());
        Assert.NotNull(ProtocolTester.ConnectionContext.Device);

        ProtocolTester.SendHexFromDevice(
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

        DeviceMessageDocument? location = ProtocolTester.LastParsedMessages?[6];
        
        // Assert.Equal(23.2759072, location?.Longitude);
        // Assert.Equal(46.7976032, location?.Latitude);
    }
}