using Navtrack.Listener.Protocols.Satellite;
using Xunit;

namespace Navtrack.Listener.Tests.Protocols.Satellite;

public class SatelliteProtocolTests : BaseProtocolTests<SatelliteProtocol, SatelliteMessageHandler>
{
    [Fact]
    public void DeviceSends5Locations_5LocationsAreParsed()
    {
        ProtocolTester.SendHexFromDevice(
            "22B5BF4CB2EC1600500122B37BA020001500CB5D2F5C68C24A0310AECD016200B1003D000004000177042700A501000000000000000101020100011E00A1657CA020001500CF5D2F5C68C24A03DBADCD013501B10097000004030177042700A501000000000000000101020101011E00816E7DA003004800B95E2F5C89C24A03FBADCD010000AA00000000040601011038363133353930333632333039323600383933373530323730313030323335343836363000323537303237303132333534383636004D5453000000000066640101005700E515CF047EA001000000295F2F5C89C24A03FBADCD0100009A0000000106020106DC30A8030048006BC13E5C19C24A03BFADCD010000AD00000000050600011338363133353930333632333039323600383933373530323730313030323335343836363000323537303237303132333534383636004D5453000000000066640101005700E515");

        Assert.Equal(5, ProtocolTester.TotalParsedMessages.Count);
        Assert.Equal("00004CBF0016ECB200003C5C", ProtocolTester.ReceiveHexInDevice());
    }
        
    [Fact]
    public void DeviceSends7Locations_7LocationAreParsed()
    {
        ProtocolTester.SendHexFromDevice(
            "F0E1BF4CB2EC1600E1005F8791E901000000C959515C2CC24A03AEADCD010E01A800250001090201878E92E901000000CB59515C2DC24A03B8ADCD018801A8001D0001080201325993E901000000CC59515C2FC24A03BFADCD01AB01A800220001080201DD8194E901000000CD59515C32C24A03CEADCD015801A8002500010802015F3795E905000900CE59515C32C24A03D8ADCD01F600A700250001091401000000000000000000863496E901000000CF59515C34C24A03DDADCD019B00A700280001090201714197E904000600CF59515C34C24A03DDADCD019B00A7002800010A1401BECD07001901");

        Assert.Equal(7, ProtocolTester.TotalParsedMessages.Count);
        Assert.Equal("00004CBF0016ECB200003C5C", ProtocolTester.ReceiveHexInDevice());
    }
}