using Navtrack.Listener.Protocols.Navtelecom;
using Xunit;

namespace Navtrack.Listener.Tests.Protocols.Navtelecom;

public class NavtelecomProtocolV3Tests : BaseProtocolTests<NavtelecomProtocol, NavtelecomMessageHandler>
{
    [Fact]
    public void SendLoginAndFlex_RepliesAreReceived()
    {
        // Send login package
        ProtocolTester.SendHexFromDevice(
            "404E5443010000000000000013004A412A3E533A313030303030303030303030303036");
        Assert.Equal("404E544300000000010000000300455E2A3C53",
            ProtocolTester.ReceiveHexInDevice());

        // Send flex package
        ProtocolTester.SendHexFromDevice(
            "404E544301000000000000002A0046742A3E464C4558B01E1EFFFFFFFFFFFFFFFFFFFFFFFFF87FF807BFFFFBFFFFC00007FFFEF0000000000000");
        Assert.Equal("404E544300000000010000000900B1A02A3C464C4558B01E1E",
            ProtocolTester.ReceiveHexInDevice());
    }
        
    [Fact]
    public void DeviceSends_T_ReplyIsReceivedAnd1LocationIsParsed()
    {
        SendLoginAndFlex_RepliesAreReceived();

        // Send T
        ProtocolTester.SendHexFromDevice(
            "7E5420000000200000000817DC4BD45E0089021E1ADC4BD45E30C45501F0A8FB017B00000000000A42450000008041000080400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000080808080808080800080000080BFFFFF80000080BFFFFFFFFFFFFFFFFFFFFFFFFFFF008000000000FFFFFF0000000000000000010100805B06370500000080E90BBF070000000000000000000000000000000000000000000000DD00000000000000000000DD00000000000000000000DDDC4BD45E000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000DC4BD45E00FFFFFFFFFFFF000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000090");

        Assert.Equal("7E542000000069", ProtocolTester.ReceiveHexInDevice());
        Assert.NotNull(ProtocolTester.LastParsedMessage);
    }

    [Fact]
    public void DeviceSends_C_ReplyIsReceivedAnd1LocationIsParsed()
    {
        SendLoginAndFlex_RepliesAreReceived();

        // Send C
        ProtocolTester.SendHexFromDevice(
            "7E43FFFF00000817014CD45E0089021E1A014CD45E30C45501F0A8FB017B00000000000A42450000008041000080400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000080808080808080800080000080BFFFFF80000080BFFFFFFFFFFFFFFFFFFFFFFFFFFF008000000000FFFFFF0000000000000000010100805B06370500000080E90BBF070000000000000000000000000000000000000000000000DD00000000000000000000DD00000000000000000000DD014CD45E000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014CD45E00FFFFFFFFFFFF000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000074");

        Assert.Equal("7E43B9", ProtocolTester.ReceiveHexInDevice());
        Assert.NotNull(ProtocolTester.LastParsedMessage);
    }

    [Fact]
    public void DeviceSends_X_ReplyIsReceivedAnd1LocationIsParsed()
    {
        SendLoginAndFlex_RepliesAreReceived();

        // Send X
        ProtocolTester.SendHexFromDevice(
            "7E582100000027000A25210000000817174CD45E1A174CD45E30C45501F0A8FB017B00000000000A4245000000804125");

        Assert.Equal("7E5821000000D3", ProtocolTester.ReceiveHexInDevice());
        Assert.NotNull(ProtocolTester.LastParsedMessage);
    }

    [Fact]
    public void DeviceSends_A_ReplyIsReceivedAnd1LocationIsParsed()
    {
        SendLoginAndFlex_RepliesAreReceived();

        // Send A
        ProtocolTester.SendHexFromDevice(
            "7E41012200000008173B4CD45E0089021E1A3B4CD45E30C45501F0A8FB017B00000000000A42450000008041000080400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000080808080808080800080000080BFFFFF80000080BFFFFFFFFFFFFFFFFFFFFFFFFFFF008000000000FFFFFF0000000000000000010100805B06370500000080E90BBF070000000000000000000000000000000000000000000000DD00000000000000000000DD00000000000000000000DD3B4CD45E0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003B4CD45E00FFFFFFFFFFFF0000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000D8");

        Assert.Equal("7E4101DF", ProtocolTester.ReceiveHexInDevice());
        Assert.Single(ProtocolTester.TotalParsedMessages);
    }

    [Fact]
    public void DeviceSends_A_ReplyIsReceivedAnd3LocationsAreParsed()
    {
        SendLoginAndFlex_RepliesAreReceived();

        // Send A
        ProtocolTester.SendHexFromDevice(
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

        Assert.Equal("7E4103BD", ProtocolTester.ReceiveHexInDevice());
        Assert.Equal(3, ProtocolTester.TotalParsedMessages.Count);
    }

    [Fact]
    public void DeviceSends_E_ReplyIsReceivedAnd3LocationsAreParsed()
    {
        SendLoginAndFlex_RepliesAreReceived();

        // Send E
        ProtocolTester.SendHexFromDevice(
            "7E450327000A25260000000817804CD45E1A804CD45E30C45501F0A8FB017B00000000000A4245000000804127000A25270000000817804CD45E1A804CD45E30C45501F0A8FB017B00000000000A4245000000804127000A25280000000817804CD45E1A804CD45E30C45501F0A8FB017B00000000000A4245000000804118");

        Assert.Equal("7E45033E", ProtocolTester.ReceiveHexInDevice());
        Assert.Equal(3, ProtocolTester.TotalParsedMessages.Count);
    }

    [Fact]
    public void DeviceSends_E_ReplyIsReceivedAnd1LocationIsParsed()
    {
        SendLoginAndFlex_RepliesAreReceived();

        // Send E
        ProtocolTester.SendHexFromDevice(
            "7E450127000A252900000008179B4CD45E1A9B4CD45E30C45501F0A8FB017B00000000000A42450000008041DA");

        Assert.Equal("7E45015C", ProtocolTester.ReceiveHexInDevice());
        Assert.Single(ProtocolTester.TotalParsedMessages);
    }
}