using Navtrack.Listener.Protocols.Meitrack;
using Xunit;

namespace Navtrack.Listener.Tests.Protocols.Meitrack;

public class MeitrackTextProtocolTests : BaseProtocolTests<MeitrackProtocol, MeitrackMessageHandler>
{
    [Fact]
    public void DeviceSendsLocationV1_LocationIsParsed()
    {
        ProtocolTester.SendStringFromDevice(
            "$$F142,123456789012345,AAA,35,48.858837,2.277019,160221001509,A,5,30,0,147,2.5,475,56364283,8983665,123|4|0000|0000,0421,0200|000E||02EF|00FC,*7E");

        Assert.NotNull(ProtocolTester.LastParsedMessage);
    }

    [Fact]
    public void DeviceSendsLocationV2_LocationIsParsed()
    {
        ProtocolTester.SendStringFromDevice(
            "$$W129,353358017784062,AAA,35,22.540113,114.076141,100313094354,A,5,22,1,174,4,129,0,435,0|0|10133|4110,0000,166|224|193|2704|916,*BE\r\n");

        Assert.NotNull(ProtocolTester.LastParsedMessage);
    }

    [Fact]
    public void DeviceSendsLocationV3_LocationIsParsed()
    {
        ProtocolTester.SendStringFromDevice(
            "$$Q128,353358017784062,AAA,34,22.543176,114.078448,100313093738,A,5,22,2,205,5,-14,0,60,0|0|10133|4110,0000,149|153|173|2707|914,*91\r\n");

        Assert.NotNull(ProtocolTester.LastParsedMessage);
    }

    [Fact]
    public void DeviceSends4Locations_4LocationsAreParsed()
    {
        ProtocolTester.SendHexFromDevice(
            "2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A");

        Assert.Equal(4, ProtocolTester.TotalParsedMessages.Count);
    }

    [Fact]
    public void DeviceSends4LocationsOfWhich1IsCorruptV1_3LocationsAreParsed()
    {
        ProtocolTester.SendHexFromDevice(
            "41412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A");

        Assert.Equal(3, ProtocolTester.TotalParsedMessages.Count);
    }

    [Fact]
    public void DeviceSends4LocationsOfWhich1IsCorruptV2_3LocationsAreParsed()
    {
        ProtocolTester.SendHexFromDevice(
            "2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C342424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A");

        Assert.Equal(3, ProtocolTester.TotalParsedMessages.Count);
    }

    [Fact]
    public void DeviceSends4LocationsOfWhich1IsCorruptV3_3LocationsAreParsedWithTheCorrectIMEI()
    {
        ProtocolTester.SendHexFromDevice(
            "2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C342424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A2424573132392C3335333335383031373738343036322C4141412C33352C32322E3534303131332C3131342E3037363134312C3130303331333039343335342C412C352C32322C312C3137342C342C3132392C302C3433352C307C307C31303133337C343131302C303030302C3136367C3232347C3139337C323730347C3931362C2A42450D0A");

        // Assert.True(ProtocolTester.TotalParsedPositions.All(x => x.Device.SerialNumber == "353358017784062"));
    }
}