using Navtrack.Listener.Protocols.Meitrack;
using Xunit;

namespace Navtrack.Listener.Tests.Protocols.Meitrack;

public class MeitrackBinaryProtocolTests : BaseProtocolTests<MeitrackProtocol, MeitrackMessageHandler>
{
    [Fact]
    public void DeviceSendsLocationV1_LocationIsParsed_CCC()
    {
        ProtocolTester.SendHexFromDevice(
            "2424473937302C3336393830303031333436303637342C4343432C020134005B000000010CE304035DB9E000EC6F591A000013000000000C001801EDB70200C96D0100E60001004838576501000300A101C20400000000010CE304035DB9E000EE6F591A000013000000000C001801EDB70200CA6D0100E60001004838576501000300A101C20400000000010CE304035DB9E000EF6F591A000013000000000C001801EDB70200CC6D0100E60001004838576501000300A101C20400000000020CE304035DB9E000F76F591A000016000000000C001801EDB70200D36D0100E60001004838576502000300A101BF04000000000A0CE304035DB9E000F76F591A000016000000000C001801EDB70200D46D0100E60001004838576500000300A101BF0400000000020CE304035DB9E000FB6F591A000016000000000C001801EDB70200D86D0100E60001004838576502000300A101760400000000180CE304035DB9E000FC6F591A0000120000000000008C00EDB70200D96D0100E60001004838576502000300A10176040000000019B1E2040323B9E0000B70591A0105150600BB0012002901EDB70200E76D0100E60001004838576502000300A2017005000000002023E304031FB9E0001070591A010615070027010D001601FCB70200EC6D0100E60001004838576502000300A201800500000000201FE3040302B9E0001170591A010615090019010D001501FEB70200ED6D0100E60001004838576502000300A2018005000000002018E30403DCB8E0001270591A0106150B0011010D00150100B80200EE6D0100E60001004838576502000300A2018005000000002036E3040345B8E0001570591A0107150B002D010B0013010AB80200F16D0100E60001004838576502000300A2018005000000002053E3040326B8E0001670591A0107150D0041010B0013010EB80200F26D0100E60001004838576502000300A2018005000000002070E3040310B8E0001770591A0107150E004F010B00130111B80200F36D0100E60001004838576502000300A2018005000000002095E3040306B8E0001870591A0107150D005A010B00140115B80200F46D0100E60001004838576502000300A20180050000000020B3E3040305B8E0001970591A0107150B0060010B00140118B80200F56D0100E60001004838576502000300A20183050000000020CFE3040308B8E0001A70591A0107150B0066010B0014011BB80200F66D0100E60001004838576502000300A20183050000000020EEE304030CB8E0001B70591A0106170B0004000D0014011EB80200F76D0100E60001004838576502000300A2018305000000002A62350D0A");

        Assert.NotNull(ProtocolTester.LastParsedMessage);
    }

    [Fact]
    public void DeviceSendsLocationV2_LocationIsParsed_CCC()
    {
        ProtocolTester.SendHexFromDevice(
            "24245838362C3336393830303031343039303032312C4343432C020134000100000023381F91FFE354B806C5E3121B0009130000000000000000D33801007CBF0200FE0101000435FEEB02000500A3010000000000002A62650D0A");

        Assert.NotNull(ProtocolTester.LastParsedMessage);
    }
        
    [Fact]
    public void DeviceSendsLocationV3_LocationIsParsed_CCE()
    {
        ProtocolTester.SendHexFromDevice(
            "2424413135382C3836383939383033303733323239372C4343452C0000000001007C0018000605000600071C140015001B000A0800000900000A00000B00001601001700001800001996011AEE0340230006027288570103F55BCC0604FE1E78230C352800000D82BA00001C00000000020E0CCC0100009227890E00000000371D00013836383939383033303030333630380001000201CD8757013160CC062A1F0D0A");

        Assert.NotNull(ProtocolTester.LastParsedMessage);
    }
}