using Navtrack.Listener.Protocols.Meiligao;
using Xunit;

namespace Navtrack.Listener.Tests.Protocols.Meiligao;

public class MeiligaoProtocolTests : BaseProtocolTests<MeiligaoProtocol, MeiligaoMessageHandler>
{
    [Fact]
    public void DeviceSendsLoginCommand_ServerRespondsWithLoginConfirmation()
    {
        ProtocolTester.SendHexFromDevice("24240011123456FFFFFFFF50008B9B0D0A");

        Assert.Equal("40400012123456FFFFFFFF400001A99B0D0A", ProtocolTester.ReceiveHexInDevice());
    }

    [Fact]
    public void DeviceSendsLocationV1_LocationIsParsed()
    {
        ProtocolTester.SendHexFromDevice(
            "24240060123456FFFFFFFF99553033353634342E3030302C412C323233322E363038332C4E2C31313430342E383133372C452C302E30302C2C3031303830392C2C2A31437C31312E357C3139347C303030307C303030302C3030303069620D0A");

        Assert.NotNull(ProtocolTester.LastParsedMessage);
    }
        
    [Fact]
    public void DeviceSendsLocationV2_LocationIsParsed()
    {
        ProtocolTester.SendHexFromDevice(
            "24240060123456FFFFFFFF99553033353634342E3030302C412C323233322E363038332C4E2C31313430342E383133372C452C302E30302C2C3031303830392C2C2A31437C31312E357C3139347C303030307C303030302C3030303069620D0A2C2C2A31437C31312E357C31393470");

        Assert.NotNull(ProtocolTester.LastParsedMessage);
    }
        
    [Fact]
    public void DeviceSendsLocationV3_LocationIsParsed()
    {
        ProtocolTester.SendHexFromDevice(
            "FF99553033353634342E303024240060123456FFFFFFFF99553033353634342E3030302C412C323233322E363038332C4E2C31313430342E383133372C452C302E30302C2C3031303830392C2C2A31437C31312E357C3139347C303030307C303030302C3030303069620D0A2C2C2A31437C31312E357C31393470");

        Assert.NotNull(ProtocolTester.LastParsedMessage);
    }
}