export const ChangelogIcon = () => (
  <svg
    width="20"
    height="20"
    viewBox="0 0 20 20"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    focusable={false}
    aria-hidden
  >
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M10.4688 2.26716C10.3077 1.83185 9.69206 1.83185 9.53098 2.26716L9.26942 2.97401C9.21878 3.11087 9.11087 3.21877 8.97401 3.26942L8.26716 3.53098C7.83185 3.69206 7.83185 4.30775 8.26716 4.46883L8.97401 4.73039C9.11087 4.78103 9.21878 4.88894 9.26942 5.0258L9.53098 5.73265C9.69206 6.16796 10.3077 6.16796 10.4688 5.73265L10.7304 5.0258C10.781 4.88894 10.8889 4.78103 11.0258 4.73039L11.7327 4.46883C12.168 4.30775 12.168 3.69206 11.7327 3.53098L11.0258 3.26942C10.8889 3.21877 10.781 3.11087 10.7304 2.97401L10.4688 2.26716ZM4.53098 5.26715C4.69206 4.83185 5.30775 4.83185 5.46883 5.26716L6.00048 6.70392C6.05112 6.84078 6.15903 6.94868 6.29589 6.99933L7.73265 7.53098C8.16796 7.69206 8.16796 8.30775 7.73265 8.46883L6.29589 9.00048C6.15903 9.05112 6.05112 9.15903 6.00048 9.29589L5.46883 10.7327C5.30775 11.168 4.69206 11.168 4.53098 10.7326L3.99933 9.29589C3.94868 9.15903 3.84078 9.05112 3.70392 9.00048L2.26716 8.46883C1.83185 8.30775 1.83185 7.69206 2.26716 7.53098L3.70392 6.99933C3.84078 6.94868 3.94868 6.84078 3.99933 6.70392L4.53098 5.26715ZM12.531 8.26716C12.6921 7.83185 13.3077 7.83185 13.4688 8.26716L14.5407 11.1637C14.5913 11.3006 14.6992 11.4085 14.8361 11.4591L17.7326 12.531C18.168 12.6921 18.168 13.3077 17.7326 13.4688L14.8361 14.5407C14.6992 14.5913 14.5913 14.6992 14.5407 14.8361L13.4688 17.7326C13.3078 18.168 12.6921 18.168 12.531 17.7326L11.4591 14.8361C11.4085 14.6992 11.3006 14.5913 11.1637 14.5407L8.26716 13.4688C7.83185 13.3077 7.83185 12.6921 8.26716 12.531L11.1637 11.4591C11.3006 11.4085 11.4085 11.3006 11.4591 11.1637L12.531 8.26716Z"
      fill="currentColor"
    />
  </svg>
);

export const ChangeLogIconOutline = ({ ...props }) => (
  <svg
    width="24"
    height="24"
    viewBox="0 0 24 24"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    focusable={false}
    aria-hidden
    {...props}
  >
    <path
      d="M6.93936 14.0081C7.08779 13.7367 7.47756 13.7367 7.62599 14.0081L8.61115 15.8094C8.64706 15.875 8.70104 15.929 8.7667 15.9649L10.568 16.9501C10.8394 17.0985 10.8394 17.4883 10.568 17.6367L8.7667 18.6219C8.70104 18.6578 8.64706 18.7118 8.61115 18.7774L7.62599 20.5787C7.47756 20.8501 7.08779 20.8501 6.93936 20.5787L5.9542 18.7774C5.91829 18.7118 5.86431 18.6578 5.79865 18.6219L3.99735 17.6367C3.72596 17.4883 3.72596 17.0985 3.99735 16.9501L5.79865 15.9649C5.86431 15.929 5.91829 15.875 5.9542 15.8094L6.93936 14.0081Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinejoin="round"
    />
    <path
      d="M13.2871 3.42118C13.4355 3.14979 13.8253 3.14979 13.9737 3.42118L16.0502 7.21803C16.0862 7.28369 16.1401 7.33767 16.2058 7.37358L20.0026 9.45014C20.274 9.59857 20.274 9.98834 20.0026 10.1368L16.2058 12.2133C16.1401 12.2492 16.0862 12.3032 16.0502 12.3689L13.9737 16.1657C13.8253 16.4371 13.4355 16.4371 13.2871 16.1657L11.2105 12.3689C11.1746 12.3032 11.1206 12.2492 11.0549 12.2133L7.25809 10.1368C6.98671 9.98834 6.98671 9.59857 7.25809 9.45014L11.0549 7.37358C11.1206 7.33767 11.1746 7.28369 11.2105 7.21803L13.2871 3.42118Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinejoin="round"
    />
  </svg>
);

export const FigmaIcon = ({ ...props }) => (
  <svg
    width="20"
    height="20"
    viewBox="0 0 20 20"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    focusable={false}
    aria-hidden
    {...props}
  >
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M3 4C3 1.80306 4.76151 0 6.96154 0H9H10H11H13.0385C15.2385 0 17 1.80306 17 4C17 5.19041 16.4828 6.26518 15.6589 7.00012C16.4828 7.73506 17 8.80982 17 10.0002C17 12.1972 15.2385 14.0002 13.0385 14.0002H12.9615C12.2462 14.0002 11.5772 13.8096 11 13.4768V14.0002V15.9608C11 18.1876 9.19358 19.9998 6.98065 19.9998C4.78895 19.9998 3 18.2051 3 15.9998C3 14.8095 3.51701 13.7349 4.34067 13C3.51701 12.2651 3 11.1905 3 10.0002C3 8.80983 3.51718 7.73506 4.34108 7.00012C3.51718 6.26518 3 5.19041 3 4ZM9 10.0002V8.00024H6.96154C5.89033 8.00024 5 8.88346 5 10.0002C5 11.1046 5.87059 11.9805 6.92578 11.9999L6.96154 11.9998H9V10.0002ZM11 10.0002C11 11.117 11.8903 12.0002 12.9615 12.0002H13.0385C14.1097 12.0002 15 11.117 15 10.0002C15 8.88346 14.1097 8.00024 13.0385 8.00024H12.9615C11.8903 8.00024 11 8.88346 11 10.0002ZM6.96154 14.0002L6.92578 14.0001C5.87059 14.0195 5 14.8954 5 15.9998C5 17.1081 5.90111 17.9998 6.98065 17.9998C8.08142 17.9998 9 17.0907 9 15.9608V14.0002H6.96154ZM6.96154 2H9V6H6.96154C5.89033 6 5 5.11678 5 4C5 2.88323 5.89033 2 6.96154 2ZM11 6V2H13.0385C14.1097 2 15 2.88323 15 4C15 5.11678 14.1097 6 13.0385 6H11Z"
      fill="currentColor"
    />
  </svg>
);

export const GithubIcon = ({ ...props }) => (
  <svg
    width="20"
    height="20"
    viewBox="0 0 20 20"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    focusable={false}
    aria-hidden
    {...props}
  >
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M9.9702 0C4.45694 0 0 4.4898 0 10.0443C0 14.4843 2.85571 18.2427 6.81735 19.5729C7.31265 19.6729 7.49408 19.3567 7.49408 19.0908C7.49408 18.858 7.47775 18.0598 7.47775 17.2282C4.70429 17.8269 4.12673 16.0308 4.12673 16.0308C3.68102 14.8667 3.02061 14.5675 3.02061 14.5675C2.11286 13.9522 3.08673 13.9522 3.08673 13.9522C4.09367 14.0188 4.62204 14.9833 4.62204 14.9833C5.51327 16.5131 6.94939 16.0808 7.52714 15.8147C7.60959 15.1661 7.87388 14.7171 8.15449 14.4678C5.94245 14.2349 3.6151 13.3702 3.6151 9.51204C3.6151 8.41449 4.01102 7.51653 4.63837 6.81816C4.53939 6.56878 4.19265 5.53755 4.73755 4.15735C4.73755 4.15735 5.57939 3.89122 7.47755 5.18837C8.29022 4.9685 9.12832 4.85666 9.9702 4.85571C10.812 4.85571 11.6702 4.97224 12.4627 5.18837C14.361 3.89122 15.2029 4.15735 15.2029 4.15735C15.7478 5.53755 15.4008 6.56878 15.3018 6.81816C15.9457 7.51653 16.3253 8.41449 16.3253 9.51204C16.3253 13.3702 13.998 14.2182 11.7694 14.4678C12.1327 14.7837 12.4461 15.3822 12.4461 16.3302C12.4461 17.6771 12.4298 18.7582 12.4298 19.0906C12.4298 19.3567 12.6114 19.6729 13.1065 19.5731C17.0682 18.2424 19.9239 14.4843 19.9239 10.0443C19.9402 4.4898 15.4669 0 9.9702 0Z"
      fill="currentColor"
    />
  </svg>
);

export const SlackIcon = ({ ...props }) => (
  <svg
    width="20"
    height="21"
    viewBox="0 0 20 21"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    focusable={false}
    aria-hidden
    {...props}
  >
    <path
      d="M4.92656 12.8086C4.92625 13.1721 4.81818 13.5274 4.616 13.8295C4.41382 14.1316 4.12661 14.3669 3.79068 14.5058C3.45475 14.6447 3.08518 14.6809 2.72869 14.6098C2.37221 14.5387 2.0448 14.3635 1.78787 14.1063C1.53094 13.8492 1.35601 13.5216 1.28521 13.1651C1.2144 12.8085 1.2509 12.439 1.39008 12.1032C1.52926 11.7674 1.76488 11.4804 2.06715 11.2784C2.36942 11.0765 2.72477 10.9688 3.08828 10.9688H4.92656V12.8086Z"
      fill="currentColor"
    />
    <path
      d="M5.85303 12.8086C5.85303 12.3211 6.0467 11.8535 6.39145 11.5088C6.73619 11.164 7.20377 10.9703 7.69131 10.9703C8.17885 10.9703 8.64643 11.164 8.99117 11.5088C9.33591 11.8535 9.52959 12.3211 9.52959 12.8086V17.4117C9.52959 17.8993 9.33591 18.3669 8.99117 18.7116C8.64643 19.0563 8.17885 19.25 7.69131 19.25C7.20377 19.25 6.73619 19.0563 6.39145 18.7116C6.0467 18.3669 5.85303 17.8993 5.85303 17.4117V12.8086Z"
      fill="currentColor"
    />
    <path
      d="M7.69146 5.42656C7.32794 5.42625 6.97269 5.31818 6.67059 5.116C6.36849 4.91382 6.13312 4.62661 5.99422 4.29068C5.85532 3.95475 5.81914 3.58518 5.89025 3.22869C5.96136 2.87221 6.13656 2.5448 6.39371 2.28787C6.65086 2.03094 6.97841 1.85601 7.33496 1.78521C7.69151 1.7144 8.06105 1.7509 8.39686 1.89008C8.73267 2.02926 9.01968 2.26488 9.2216 2.56715C9.42353 2.86942 9.5313 3.22477 9.5313 3.58828V5.42656H7.69146Z"
      fill="currentColor"
    />
    <path
      d="M7.69141 6.35315C8.17895 6.35315 8.64652 6.54682 8.99127 6.89157C9.33601 7.23631 9.52969 7.70389 9.52969 8.19143C9.52969 8.67897 9.33601 9.14655 8.99127 9.49129C8.64652 9.83604 8.17895 10.0297 7.69141 10.0297H3.08828C2.60074 10.0297 2.13316 9.83604 1.78842 9.49129C1.44368 9.14655 1.25 8.67897 1.25 8.19143C1.25 7.70389 1.44368 7.23631 1.78842 6.89157C2.13316 6.54682 2.60074 6.35315 3.08828 6.35315H7.69141Z"
      fill="currentColor"
    />
    <path
      d="M15.0735 8.19139C15.0738 7.82788 15.1819 7.47263 15.3841 7.17053C15.5862 6.86843 15.8734 6.63305 16.2094 6.49416C16.5453 6.35526 16.9149 6.31908 17.2714 6.39019C17.6278 6.4613 17.9552 6.6365 18.2122 6.89365C18.4691 7.1508 18.644 7.47835 18.7148 7.8349C18.7856 8.19145 18.7491 8.56099 18.61 8.8968C18.4708 9.23261 18.2352 9.51962 17.9329 9.72154C17.6306 9.92346 17.2753 10.0312 16.9118 10.0312H15.0735V8.19139Z"
      fill="currentColor"
    />
    <path
      d="M14.1468 8.19141C14.1468 8.67895 13.9531 9.14652 13.6084 9.49127C13.2636 9.83601 12.796 10.0297 12.3085 10.0297C11.821 10.0297 11.3534 9.83601 11.0086 9.49127C10.6639 9.14652 10.4702 8.67895 10.4702 8.19141V3.58828C10.4702 3.10074 10.6639 2.63316 11.0086 2.28842C11.3534 1.94368 11.821 1.75 12.3085 1.75C12.796 1.75 13.2636 1.94368 13.6084 2.28842C13.9531 2.63316 14.1468 3.10074 14.1468 3.58828V8.19141Z"
      fill="currentColor"
    />
    <path
      d="M12.3086 15.5734C12.6721 15.5737 13.0274 15.6818 13.3295 15.884C13.6316 16.0862 13.8669 16.3734 14.0058 16.7093C14.1447 17.0452 14.1809 17.4148 14.1098 17.7713C14.0387 18.1278 13.8635 18.4552 13.6063 18.7121C13.3492 18.9691 13.0216 19.144 12.6651 19.2148C12.3085 19.2856 11.939 19.2491 11.6032 19.1099C11.2674 18.9707 10.9804 18.7351 10.7784 18.4328C10.5765 18.1306 10.4688 17.7752 10.4688 17.4117V15.5734H12.3086Z"
      fill="currentColor"
    />
    <path
      d="M12.3085 14.6469C11.821 14.6469 11.3534 14.4532 11.0086 14.1085C10.6639 13.7637 10.4702 13.2962 10.4702 12.8086C10.4702 12.3211 10.6639 11.8535 11.0086 11.5088C11.3534 11.164 11.821 10.9703 12.3085 10.9703H16.9116C17.3992 10.9703 17.8667 11.164 18.2115 11.5088C18.5562 11.8535 18.7499 12.3211 18.7499 12.8086C18.7499 13.2962 18.5562 13.7637 18.2115 14.1085C17.8667 14.4532 17.3992 14.6469 16.9116 14.6469H12.3085Z"
      fill="currentColor"
    />
  </svg>
);

export const YarnIcon = () => (
  <svg
    width="20"
    height="20"
    viewBox="0 0 20 20"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    focusable={false}
    aria-hidden
  >
    <path
      d="M19.0336 16.0116C18.0026 16.2564 17.4807 16.482 16.2049 17.3131C14.2075 18.6018 12.0297 19.201 12.0297 19.201C12.0297 19.201 11.8493 19.4716 11.3274 19.5941C10.4253 19.8131 7.02969 20 6.72041 20.0064C5.88923 20.0129 5.38021 19.7938 5.23845 19.4523C4.80675 18.4214 5.85701 17.9704 5.85701 17.9704C5.85701 17.9704 5.62505 17.8286 5.48974 17.6997C5.36732 17.5773 5.23845 17.3325 5.19979 17.4227C5.03871 17.8157 4.95495 18.7758 4.52325 19.2075C3.93046 19.8067 2.80933 19.6069 2.14567 19.259C1.41758 18.8724 2.19722 17.9639 2.19722 17.9639C2.19722 17.9639 1.80418 18.1959 1.48845 17.7191C1.20495 17.2809 0.940773 16.5335 1.01165 15.6121C1.10186 14.549 2.27454 13.5309 2.27454 13.5309C2.27454 13.5309 2.06835 11.9781 2.7449 10.3866C3.35701 8.93685 5.00649 7.77061 5.00649 7.77061C5.00649 7.77061 3.62119 6.24355 4.13665 4.85824C4.4717 3.95618 4.60701 3.96262 4.71655 3.92396C5.10314 3.77577 5.47686 3.61468 5.75392 3.31185C7.13923 1.817 8.90469 2.10051 8.90469 2.10051C8.90469 2.10051 9.72943 -0.431708 10.5026 0.0644255C10.741 0.219065 11.598 2.12628 11.598 2.12628C11.598 2.12628 12.5129 1.59149 12.616 1.79123C13.1702 2.86726 13.2346 4.92267 12.9897 6.17267C12.5774 8.23453 11.5464 9.34278 11.1341 10.0387C11.0374 10.1997 12.2423 10.7088 13.0026 12.8157C13.7049 14.7423 13.0799 16.3595 13.1895 16.5399C13.2088 16.5722 13.2153 16.585 13.2153 16.585C13.2153 16.585 14.0207 16.6495 15.6379 15.6508C16.5013 15.116 17.5258 14.5167 18.6921 14.5039C19.8196 14.4845 19.8776 15.8118 19.0336 16.0116Z"
      fill="currentColor"
    />
  </svg>
);

export const StorybookIcon = ({ ...props }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    width="18.2"
    height="22.4"
    version="1.1"
    viewBox="0 0 52 64"
    focusable={false}
    aria-hidden
    {...props}
  >
    <defs>
      <path
        id="path-1"
        d="M1.94279175,57.1309472 L0.0022554267,5.95476663 C-0.0618328758,4.26461814 1.24754196,2.83223697 2.95307926,2.72673418 L46.9330824,0.00617628491 C48.6691159,-0.10121296 50.1644074,1.2046298 50.2729096,2.92285771 C50.2769973,2.98759391 50.2790429,3.05244063 50.2790429,3.11730315 L50.2790429,58.8828028 C50.2790429,60.6043831 48.8689636,62 47.1295431,62 C47.0824212,62 47.0353056,61.9989534 46.9882313,61.9968606 L4.94876437,60.1280997 C3.31149338,60.0553189 2.00425692,58.751918 1.94279175,57.1309472 Z"
      />
    </defs>
    <g
      id="icon-storybook-monochrome"
      fill="none"
      fillRule="evenodd"
      stroke="none"
      strokeWidth="1"
    >
      <g id="storybook-icon" transform="translate(1.000000, 1.000000)">
        <path
          id="Combined-Shape"
          fill="currentColor"
          fillRule="nonzero"
          d="M50.2729096,2.92285771 C50.2769973,2.98759391 50.2790429,3.05244063 50.2790429,3.11730315 L50.2790429,58.8828028 C50.2790429,60.6043831 48.8689636,62 47.1295431,62 C47.0824212,62 47.0353056,61.9989534 46.9882313,61.9968606 L4.94876437,60.1280997 C3.31149338,60.0553189 2.00425692,58.751918 1.94279175,57.1309472 L0.0022554267,5.95476663 C-0.0618328758,4.26461814 1.24754196,2.83223697 2.95307926,2.72673418 L37.427,0.594 L37.1272753,7.62078766 C37.1238721,7.70179664 37.1419373,7.78178731 37.179031,7.85305525 L37.2223772,7.92113026 C37.3791917,8.12573637 37.6738999,8.16578288 37.880626,8.0105767 L37.880626,8.0105767 L40.6382617,5.94019678 L42.9673936,7.75618537 C43.0546693,7.82423279 43.1634862,7.85946584 43.2745216,7.85562813 C43.5338374,7.84666553 43.7367132,7.6313391 43.7276576,7.37468316 L43.7276576,7.37468316 L43.467,0.22 L46.9330824,0.00617628491 C48.6691159,-0.10121296 50.1644074,1.2046298 50.2729096,2.92285771 Z"
          className="text-surface-default group-focus:text-surface-inverted"
        />
        <path
          id="S"
          fill="currentColor"
          fillRule="nonzero"
          d="M29.4029796,23.368648 C29.4029796,24.58142 37.6567008,24.00017 38.7646901,23.1482813 C38.7646901,14.8895929 34.2873503,10.5497821 26.0885852,10.5497821 C17.88982,10.5497821 13.2961856,14.9571143 13.2961856,21.5681161 C13.2961856,33.0822778 28.9959487,33.3026444 28.9959487,39.5830962 C28.9959487,41.3460299 28.1237396,42.3927719 26.2048797,42.3927719 C23.7045471,42.3927719 22.7160434,41.1289316 22.832338,36.8317805 C22.832338,35.8995698 13.2961856,35.6089448 13.0054493,36.8317805 C12.2651161,47.2453073 18.8201763,50.248968 26.3211742,50.248968 C33.5895831,50.248968 39.2880157,46.4144645 39.2880157,39.4729126 C39.2880157,27.132376 23.3556634,27.4629261 23.3556634,21.3477494 C23.3556634,18.8686237 25.2163761,18.5380737 26.3211742,18.5380737 C27.4841196,18.5380737 29.5774214,18.7409467 29.4029796,23.368648 Z"
          mask="url(#mask-2)"
          className="text-deepblue-700 group-focus:text-text-on-inverted"
        />
        <path
          id="bookmark"
          fill="currentColor"
          fillRule="nonzero"
          d="M37.1272753,7.62078766 L37.4276823,0.591583333 L43.4674595,0.218291667 L43.7276576,7.37468316 C43.7367132,7.6313391 43.5338374,7.84666553 43.2745216,7.85562813 C43.1634862,7.85946584 43.0546693,7.82423279 42.9673936,7.75618537 L40.6382617,5.94019678 L37.880626,8.0105767 C37.6738999,8.16578288 37.3791917,8.12573637 37.2223772,7.92113026 C37.1563661,7.83500129 37.1227378,7.72879963 37.1272753,7.62078766 Z"
          mask="url(#mask-2)"
          className="text-deepblue-700 group-focus:text-text-on-inverted"
        />
      </g>
    </g>
  </svg>
);

export const CodeSandboxLogo = ({ title, ...props }) => (
  <svg
    width="24"
    height="24"
    fill="none"
    viewBox="8 3 24 24"
    focusable="false"
    {...props}
  >
    <title>{title}</title>
    <path
      fill="currentColor"
      d="M20.54 25a.681.681 0 00.158-.074l6.174-3.69c.734-.438 1.128-.885 1.128-2.084v-6.444c0-.248-.016-.447-.063-.629l-7.397 4.434zm-8.477-12.921l7.397 4.434V25a.514.514 0 01-.15-.074l-6.182-3.69c-.726-.438-1.128-.885-1.128-2.084v-6.444c0-.248.016-.447.063-.629zM20.004 7c.443 0 .9.143 1.359.406l.068.04 5.567 3.326c.155.088.284.177.394.282l.04.04-7.428 4.426-7.436-4.425c.11-.109.233-.198.378-.286l.063-.037 4.07-2.442h.002l1.488-.883c.434-.262.868-.415 1.296-.443l.071-.003z"
    ></path>
  </svg>
);
