import { type SpacingKeys } from "../../types";
import { type StyleDictionaryToken } from "../tokens.util";

export const spacingTokenConfig = {
  spacing: {
    "0": {
      value: "0",
      type: "global-spacing",
    },
    "05": {
      value: "0.125rem",
      type: "global-spacing",
    },
    "1": {
      value: "0.25rem",
      type: "global-spacing",
    },
    "1-alt": {
      value: "0.375rem",
      type: "global-spacing",
    },
    "2": {
      value: "0.5rem",
      type: "global-spacing",
    },
    "3": {
      value: "0.75rem",
      type: "global-spacing",
    },
    "4": {
      value: "1rem",
      type: "global-spacing",
    },
    "5": {
      value: "1.25rem",
      type: "global-spacing",
    },
    "6": {
      value: "1.5rem",
      type: "global-spacing",
    },
    "7": {
      value: "1.75rem",
      type: "global-spacing",
    },
    "8": {
      value: "2rem",
      type: "global-spacing",
    },
    "9": {
      value: "2.25rem",
      type: "global-spacing",
    },
    "10": {
      value: "2.5rem",
      type: "global-spacing",
    },
    "11": {
      value: "2.75rem",
      type: "global-spacing",
    },
    "12": {
      value: "3rem",
      type: "global-spacing",
    },
    "14": {
      value: "3.5rem",
      type: "global-spacing",
    },
    "16": {
      value: "4rem",
      type: "global-spacing",
    },
    "18": {
      value: "4.5rem",
      type: "global-spacing",
    },
    "20": {
      value: "5rem",
      type: "global-spacing",
    },
    "24": {
      value: "6rem",
      type: "global-spacing",
    },
    "32": {
      value: "8rem",
      type: "global-spacing",
    },
  },
} satisfies {
  spacing: Record<SpacingKeys, StyleDictionaryToken<"global-spacing">>;
};
