import cl from "clsx";
import React, { forwardRef } from "react";

export interface ModalFooterProps extends React.HTMLAttributes<HTMLDivElement> {
  children: React.ReactNode;
}

const ModalFooter = forwardRef<HTMLDivElement, ModalFooterProps>(
  ({ className, ...rest }, ref) => {
    return (
      <div
        {...rest}
        ref={ref}
        className={cl("navds-modal__footer", className)}
      />
    );
  },
);

export default ModalFooter;
