import cl from "clsx";
import React, { forwardRef } from "react";

export interface ModalBodyProps extends React.HTMLAttributes<HTMLDivElement> {
  children: React.ReactNode;
}

const ModalBody = forwardRef<HTMLDivElement, ModalBodyProps>(
  ({ className, ...rest }, ref) => {
    return (
      <div {...rest} ref={ref} className={cl("navds-modal__body", className)} />
    );
  },
);

export default ModalBody;
