import renameProps from "../../utils/rename-props";

/**
 * @param {import('jscodeshift').FileInfo} file
 * @param {import('jscodeshift').API} api
 */
export default function transformer(file, api, options) {
  const j = api.jscodeshift;
  const root = j(file.source);

  const printOptions = options.printOptions;

  return renameProps({
    root,
    componentName: options.component,
    props: { [options.from]: options.to },
  }).toSource(printOptions);
}
