#include "natalie.hpp"

namespace Natalie {

static const long ISO885910[] = {
    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89,
    0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x90, 0x91, 0x92, 0x93,
    0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D,
    0x9E, 0x9F, 0xA0, 0x104, 0x112, 0x122, 0x12A, 0x128, 0x136, 0xA7,
    0x13B, 0x110, 0x160, 0x166, 0x17D, 0xAD, 0x16A, 0x14A, 0xB0, 0x105,
    0x113, 0x123, 0x12B, 0x129, 0x137, 0xB7, 0x13C, 0x111, 0x161, 0x167,
    0x17E, 0x2015, 0x16B, 0x14B, 0x100, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5,
    0xC6, 0x12E, 0x10C, 0xC9, 0x118, 0xCB, 0x116, 0xCD, 0xCE, 0xCF,
    0xD0, 0x145, 0x14C, 0xD3, 0xD4, 0xD5, 0xD6, 0x168, 0xD8, 0x172,
    0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, 0x101, 0xE1, 0xE2, 0xE3,
    0xE4, 0xE5, 0xE6, 0x12F, 0x10D, 0xE9, 0x119, 0xEB, 0x117, 0xED,
    0xEE, 0xEF, 0xF0, 0x146, 0x14D, 0xF3, 0xF4, 0xF5, 0xF6, 0x169,
    0xF8, 0x173, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0x138
};

Iso885910EncodingObject::Iso885910EncodingObject()
    : SingleByteEncodingObject { Encoding::ISO_8859_10, { "ISO-8859-10", "ISO8859-10" }, ISO885910 } { }

}
