module Natalie
  class Compiler
    INSTRUCTIONS = [
      AliasGlobalInstruction,
      AliasMethodInstruction,
      AnonymousBlockGetInstruction,
      AnonymousBlockSetInstruction,
      AnonymousKeywordSplatGetInstruction,
      AnonymousKeywordSplatSetInstruction,
      AnonymousSplatGetInstruction,
      AnonymousSplatSetInstruction,
      ArrayConcatInstruction,
      ArrayIsEmptyInstruction,
      ArrayPopInstruction,
      ArrayPushInstruction,
      ArrayShiftInstruction,
      ArrayWrapInstruction,
      AutoloadConstInstruction,
      BreakInstruction,
      BreakOutInstruction,
      CaseEqualInstruction,
      CatchInstruction,
      CheckArgsInstruction,
      CheckExtraKeywordsInstruction,
      CheckRequiredKeywordsInstruction,
      ClassVariableGetInstruction,
      ClassVariableSetInstruction,
      ConstFindInstruction,
      ConstSetInstruction,
      ContinueInstruction,
      CreateArrayInstruction,
      CreateComplexInstruction,
      CreateHashInstruction,
      CreateLambdaInstruction,
      CreateRangeInstruction,
      CreateRationalInstruction,
      DefineBlockInstruction,
      DefineClassInstruction,
      DefineMethodInstruction,
      DefineModuleInstruction,
      DupInstruction,
      DupObjectInstruction,
      DupRelInstruction,
      ElseInstruction,
      EndInstruction,
      FlipFlopInstruction,
      GlobalVariableDefinedInstruction,
      GlobalVariableGetInstruction,
      GlobalVariableSetInstruction,
      HashDeleteInstruction,
      HashHasKeyInstruction,
      HashMergeInstruction,
      HashPutInstruction,
      IfInstruction,
      InlineCppInstruction,
      InstanceVariableDefinedInstruction,
      InstanceVariableGetInstruction,
      InstanceVariableSetInstruction,
      IsDefinedInstruction,
      IsNilInstruction,
      LoadFileInstruction,
      MatchBreakPointInstruction,
      MatchExceptionInstruction,
      MethodDefinedInstruction,
      MoveRelInstruction,
      NextInstruction,
      NotInstruction,
      PopInstruction,
      PopKeywordArgsInstruction,
      PushArgInstruction,
      PushArgcInstruction,
      PushArgsInstruction,
      PushBlockInstruction,
      PushFalseInstruction,
      PushFloatInstruction,
      PushIntInstruction,
      PushLastMatchInstruction,
      PushNilInstruction,
      PushObjectClassInstruction,
      PushRegexpInstruction,
      PushRescuedInstruction,
      PushSelfInstruction,
      PushStringInstruction,
      PushSymbolInstruction,
      PushTrueInstruction,
      RedoInstruction,
      RetryInstruction,
      ReturnInstruction,
      SendInstruction,
      SingletonClassInstruction,
      StringAppendInstruction,
      StringToRegexpInstruction,
      SuperInstruction,
      SwapInstruction,
      ToArrayInstruction,
      TryInstruction,
      UndefineMethodInstruction,
      VariableDeclareInstruction,
      VariableGetInstruction,
      VariableSetInstruction,
      WhileBodyInstruction,
      WhileInstruction,
      WithSingletonInstruction,
      YieldInstruction
    ].freeze
  end
end
