#pragma once

#include <assert.h>
#include <setjmp.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "natalie/forward.hpp"
#include "natalie/macros.hpp"

namespace Natalie {

class Cell {
public:
    Cell() { }
    virtual ~Cell() { }

    void *operator new(size_t size);
    void *operator new(size_t size, void *cell) { return cell; }
    void operator delete(void *ptr);

    class Visitor {
    public:
        virtual void visit(const Cell *cell) = 0;
        void visit(Value);
    };

    virtual void visit_children(Visitor &) const {
    }

    // only for debugging the GC
    virtual void gc_inspect(char *buf, size_t len) const {
        snprintf(buf, len, "<Cell %p size=%zu>", this, sizeof(*this));
    }

    // only for debugging the GC
    virtual void gc_print() const {
        char buf[1000];
        gc_inspect(buf, 1000);
        printf("%s\n", buf);
    }

    virtual bool is_collectible() {
        return true;
    }

    bool is_marked() const {
        return m_marked;
    }

    void mark() const {
        m_marked = true;
    }

    void unmark() const {
        m_marked = false;
    }

private:
    mutable bool m_marked { false };
};

}
