<p align="center">
  <img alt="#100ДнейКода Front-End Development" src="https://i.imgur.com/dwYOP0B.jpg" />
</p>

---

Это несколько самоуверенный учебный план для изучения фронденда во время #100ДнейКода. Поскольку он охватывает широкий спектр тем разработки для старта, его можно рассматривать как скорее курс в стиле «обзора», а не глубокое погружение в какую-либо одну область. В идеале, вы, пройдя этот учебный план, будете иметь некоторое знакомство с каждой темой и возможность легко углубиться в любую область в будущем, когда это необходимо.


На создание этого учебного плана меня вдохновила дорожная карта [Modern Frontend Developer](https://medium.com/tech-tajawal/modern-frontend-developer-in-2018-4c2072fa2b9c) Кармана Ахмеда. Это великолепно! Обязательно загляните по ссылке.

**Примечание**: я знаю, что фронтенд включает в себя множество вещей и объединяет многих людей! Если вы разработчик и считаете, что это руководство можно улучшить, то создайте issue в репозитории проекта. Подробно процесс описан в разделе [Contributing](#contributing). Спасибо Вам!

# :calendar: Учебный план

Основополагающим принципом этой учебной программы является то, что она ограничена во времени. [Тайм-боксинг] (https://en.wikipedia.org/wiki/Timeboxing). Если раньше вы предпринимали попытки изучить фронтентд, то, скорее всего, попадали в кроличью нору и застревали на какой-то одной теме. В этом плане на каждую технологию отводится определённое количество дней, что позволяет вам переключаться, как только отведённое время закончилось.

Предполагается, что при запуске этой задачи все находятся на разных уровнях, и это нормально. Как начинающие, так и опытные разработчики фронтэнда могут извлечь выгоду из временной практики в каждой из этих областей.

Рекомендуемые ежедневные действия следующие:

- День с 1 по 8: [HTML](#html)
- День с 9 по 16: [CSS](#css)
- День с 17 по 24: [Javascript основы](#JavaScript)
- День с 25 по 27: [jQuery](#jquery)
- День с 28 по 33: [Адаптивный Веб-Дизайн](#rwd)
- День с 34 по 36: [Доступность](#accessibility)
- День с 37 по 39: [Git](#git)
- День с 40 по 44: [Node and NPM](#node)
- День с 45 по 50: [Sass](#sass)
- День с 51 по 54: [Bootstrap](#bootstrap)
- День 55: [BEM](#bem)
- День с 57 по 61: [Gulp](#gulp)
- День с 62 по 65: [Webpack](#webpack)
- День 66: [ESLint](#eslint)
- День с 68 по 83: [React](#react)
- День с 84 по 89: [Redux](#redux)
- День с 90 по 94: [Jest](#jest)
- День с 95 по 97: [TypeScript](#typescript)
- День с 98 по 100: [NextJS](#nextjs)

# :mag_right: Подробности

Ниже вы можете найти немного информации о каждой теме в учебном плане, а также некоторые идеи/рекомендации для практики. В качестве источника вдохновения для проектов, которые вы будете делать в рамках этой учебной программы, вы можете посмотреть [Раздел проектных идей](#project-ideas).

Как часть принципа тайм-боксинга, это нормально, если вы не пройдете все пункты в разделах «Темы и идеи». Вместо этого вам следует сосредоточиться на получении максимально возможного количества знаний за то время, что отводится на тему, а затем двигаться дальше.

<a name="html"></a>
![HTML](https://i.imgur.com/O0F5XSR.jpg)

Язык разметки гипертекста (HTML) является стандартным языком разметки для создания веб-страниц и веб-приложений. В связке с каскадными таблицами стилей (CSS) и JavaScript он образует триаду краеугольных технологий для веба. Веб-браузеры получают HTML документы с веб-сервера или из локального хранилища локального хранилища и превращают их в страницы. HTML описывает структуру веб-страницы семантически и изначально включает подсказки для внешнего вида документа. (Источник: [Wikipedia](https://ru.wikipedia.org/wiki/HTML))

### :bulb: Кратко

HTML действительно является основой веб-разработки. Даже в JavaScript-фреймворках вы так или иначе пишете HTML, в той или иной форме.

### :book: Темы и идеи

- Пройдите раздел [Основы HTML и HTML5](https://learn.freecodecamp.org/) на freeCodeCamp.
- HTML структура страницы
- HTML элементы
- Вложение HTML-элементов
- Семантическая разметка
- Ссылки и составные страницы
- Изображения
- Аудио / видео
- Формы и элементы формы
- Создайте многостраничный сайт! (Загляните в [Идеи проекта](#project-ideas) если вам нужно вдохновение).

<a name="css"></a>
![CSS](https://i.imgur.com/028GOR0.jpg)

Каскадные таблицы стилей (CSS) - это язык таблиц стилей, используемый для описания представления документа, написанного на языке разметки, например HTML. CSS является краеугольной технологией Всемирной паутины, наряду с HTML и JavaScript. CSS предназначен для разделения представления и содержимого, включая макет, цвета и шрифты. Такое разделение улучшает доступность контента, обеспечивает большую гибкость и контроль в определении характеристик презентации, дает возможность нескольким веб-страницам совместно использовать форматирование, указав соответствующий CSS в отдельном файле .css, а также уменьшает сложность и повторяемость структурного контента. (Источник: [Wikipedia](https://ru.wikipedia.org/wiki/CSS))

### :bulb: Кратко

CSS является еще одним важным компонентом веб-разработки. Хотя он в основном используется для стилизации и размещения элементов HTML, он становится все более способным к более динамичным задачам (например, анимации), которые когда-то можно было реализовать только при помощи  Javascript.

### :book: Темы и идеи

- Пройдите раздел  [Основы CSS, CSS flexbox, и разделы сетки CSS](https://learn.freecodecamp.org/) на freeCodeCamp.
- Инлайновый CSS
- `<style>` теги
- Подключение CSS при помощи `<link>`
- Стилизация элементов
- Селекторы
- `float`, очистка флоатов
- Сетки (grid, flexbox)
- Шрифты, веб-шрифты
- Стилизируйте HTML страницы, которые вы создали, изучая HTML!

<a name="JavaScript"></a>
![JavaScript](https://i.imgur.com/oHdD86j.jpg)

JavaScript, часто называемый JS, является интерпретируемым языком программирования высокого уровня, который соответствует спецификации ECMAScript. Это язык, который также характеризуется как динамический, слабо типизированный, основанный на прототипах и мультипарадигмальный. Наряду с HTML и CSS, JavaScript является одной из трех основных технологий Всемирной паутины. JavaScript обеспечивает интерактивность веб-страниц и, следовательно, является неотъемлемой частью веб-приложений. Подавляющее большинство сайтов используют его, и все основные браузеры имеют встроенный интерпретатор JavaScript. (Источник: [Wikipedia](https://ru.wikipedia.org/wiki/JavaScript))

### :bulb: Кратко

JavaScript занимает важное место во фронтенде. Хотя когда-то он использовался главным образом для придания страницам динамики, сейчас он является основой многих фронтенд-фреймворков. Эти структуры обрабатывают множество задач, которые ранее выполнялись на сервере (например, маршрутизация и отображение различных представлений).

### :book: Темы и идеи

- Пройдите раздел [Основы Javascript и ES6](https://learn.freecodecamp.org/) на freeCodeCamp.
- Слишком много основ языка, чтобы перечислить здесь!
- `<script>` тег и его размещение
- Доступ к элементам HTML
- Цикл событий, стек вызовов и очередь событий
- Наследование прототипов
- Ссылка против значения
- Добавьте некоторые динамические элементы или логику к вашим HTML / CSS страницам, разработанным ранее!

<a name="jquery"></a>
![jQuery](https://i.imgur.com/m9j02Fo.jpg)

jQuery - это быстрая, маленькая и многофункциональная библиотека JavaScript. Она делает такие вещи, как обход и манипулирование HTML элементами, обработка событий, анимация, и Ajax намного проще с простым в использовании API, который работает во множестве браузеров. Благодаря сочетанию универсальности и масштабируемости jQuery изменил способ, которым миллионы людей пишут JavaScript. (Источник: [jQuery.com](https://jquery.com/))

### :bulb: Кратко

После того, как вы уделили некоторое время на простой (также называемый «ванильным») JavaScript, некоторые задачи могут оказаться немного громоздкими, особенно те, которые связаны с доступом к элементам HTML и манипулированием ими. В течение долгого времени jQuery была доступной библиотекой для упрощения и согласования таких задач в разных браузерах. В настоящее время её популярность угасает из-за нововведений в ванильном JS, CSS и благодаря новым JS-фреймворкам (о них поговорим позже). Тем не менее стоит потратить время на изучение базовых вещей этой библиотеки и попрактиковаться на небольшом проекте.

### :book: Темы и идеи

- Пройдите раздел [jQuery секция](https://learn.freecodecamp.org/) на freeCodeCamp.
- `document.ready`
- Cелекторы
- Переключение классов
- Анимация
- Добавление или удаление HTML элементов
- Добавьте jQuery на свой сайт!

<a name="rwd"></a>
![Адаптивный веб-дизайн](https://i.imgur.com/Bt1zWwq.jpg)

Адаптивный веб-дизайн (RWD) - это подход к веб-дизайну, позволяющий хорошо отображать веб-страницы на различных устройствах с разными размерами экранов. С недавних пор в расчёт берётся также удалённость пользователя от экрана. Контент, дизайн и производительность необходимы на всех устройствах, чтобы обеспечить удобство использования и удовлетворение. Сайт, созданный с использованием RWD, адаптирует макет к среде просмотра используя плавные, пропорциональные сетки, гибкие изображения и медиа-запросы CSS3, что является расширением правила @media. (Источник: [Wikipedia](https://en.wikipedia.org/wiki/Responsive_web_design))

### :bulb: Кратко

Адаптивный веб-дизайн - нацелен на то, чтобы веб-приложения выглядели и функционировали должным образом при любых условиях. Простой пример: веб-сайт должен выглядеть и функционировать должным образом как в настольном веб-браузере, так и в браузере мобильного телефона. Понимание адаптивного дизайна имеет решающее значение для любого фронтэнд разработчика!

### :book: Темы и идеи

- Пройдите раздел [Responsive Web Design Principles section](https://learn.freecodecamp.org/) на freeCodeCamp.
- Медиавыражения, брейкпоинты
- Адаптивные изображения
- Сделайте свой сайт адаптивным!
- Используя Chrome DevTools, проверьте ваш сайт на разных устройствах и разрешениях экранов.

<a name="accessibility"></a>
![Доступность](https://i.imgur.com/ayioMQw.jpg)

Доступность веб-сайтов - это всеобъемлющая практика, гарантирующая, что нет никаких препятствий, мешающих взаимодействию или доступу к веб-сайтам во Всемирной паутине людьми с ограниченными возможностями. Когда сайты правильно спроектированы, разработаны и отредактированы, как правило, все пользователи имеют равный доступ к информации и функциональности. (Источник: [Wikipedia](https://en.wikipedia.org/wiki/Web_accessibility))

### :bulb: Кратко

Доступность, часто пишущаяся как a11y, является одной из самых важных тем в изучении фронтенда, но ей часто уделяется слишком мало времени. Создание доступных веб-приложений является не только этически обоснованным, но также имеет большой смысл для бизнеса, учитывая дополнительную аудиторию, которая сможет просматривать ваши приложения, когда они будут доступны.

### :book: Темы и идеи

- Пройдите раздел [Applied Accessibility section](https://learn.freecodecamp.org/) на freeCodeCamp.
- Почитайте [The A11Y Project](https://a11yproject.com/about)
- Проверьте свой сайт по [чеклисту](https://a11yproject.com/checklist)
- Обновите сайт(ы) для обеспечения доступности на основе этого чеклиста

<a name="git"></a>
![Git](https://i.imgur.com/5QoNJqs.jpg)

Git - это бесплатная распределенная система управления версиями с открытым исходным кодом, предназначенная для быстрой и эффективной работы с проектами любого размера. (Источник: [git-scm.com](https://git-scm.com/))

### :bulb: Кратко

Контроль версий и кода является неотъемлемой частью инструментария любого веб-разработчика. Существует множество различных систем контроля версий, но Git является наиболее распространенной на данный момент. Вы можете (и должны!) использовать его для ведения своих проектов в процессе обучения!

### :book: Темы и идеи

- [Git учебник для начинающих (Видео)](https://www.youtube.com/watch?v=HVsySz-h9r4)
- Установка git
- Настройка [github](https://github.com) акаунта
- Изучите наиболее часто используемые команды git:
  - init
  - clone
  - add
  - commit
  - push
  - pull
  - merge
  - rebase
- Добавьте существующие проекты на github!

<a name="node"></a>
![Node и NPM](https://i.imgur.com/8ik2alD.jpg)

Node.js - это кроссплатформенная среда исполнения JavaScript с открытым исходным кодом, которая выполняет код JavaScript вне браузера. используется в основном для реализации функциональности на клиентской стороне. Скрипты, написанные на JavaScript, встроены в HTML веб-страницы и выполняются на стороне клиента механизмом JavaScript в веб-браузере пользователя. Node.js позволяет разработчикам использовать JavaScript для написания инструментов по работе с командной строкой и для серверных скриптов - запуск скриптов на стороне сервера для создания динамического содержимого веб-страницы перед ее отправкой в веб-браузер пользователя. Следовательно, Node.js представляет собой парадигму «JavaScript везде», объединяющую разработку веб-приложений вокруг единого языка программирования, а не разных языков для скриптов на стороне сервера и на стороне клиента. (Источник: [Wikipedia](https://ru.wikipedia.org/wiki/Node.js))

### :bulb: Кратко

Хотя Node.js обычно называют серверной технологией, он довольно часто используется для поддержки фронтэнда. Он делает это несколькими способами, включая такие, как запуск инструментов сборки, тестирование и линтинг (все будет рассмотрено в ближайшее время!). Node Package Manager (NPM) является еще одной замечательной особенностью Node.js и может использоваться для управления зависимостями вашего проекта (т.е. библиотеки кода, на которых может быть основан ваш проект, например, jQuery!).

### :book: Темы и идеи

- Исследуйте Node.js, поймите чем он отличается от браузера
- Установите Node.js (NPM входит в комплект)
- Создайте простой JavaScript файл и запустите его при помощи Node.js
- Используйте NPM для управления зависимостями в существующих проектах (в том числе jQuery!)

<a name="sass"></a>
![Sass](https://i.imgur.com/ZRedLge.jpg)

Sass - это расширение CSS, которое добавляет мощность и элегантность базовому языку. Он позволяет вам использовать переменные, вложенные правила, миксины, встроенный импорт и многое другое, все с полностью совместимым с CSS синтаксисом. Sass помогает хорошо организовать большие таблицы стилей и быстро запускать небольшие таблицы стилей. Также можно быстро запускать маленькие CSS-файлы с помощью библиотеки стилей Compass. (Источник: [sass-lang.com](https://sass-lang.com/documentation/file.SASS_REFERENCE.html))

### :bulb: Кратко

Sass позволяет писать CSS более программным способом. Если вы уже успели написать некоторое количество CSS, вы возможно заметили, что в конечном итоге вы повторяете много информации - например, задаете тот же цвет. В Sass вы можете использовать такие вещи, как переменные, циклы и вложения, чтобы уменьшить избыточность и улучшить читаемость. После написания вашего кода на Sass вы можете быстро и легко скомпилировать его в обычный CSS.

### :book: Темы и идеи

- [Установка Sass](https://sass-lang.com/install) глобально с NPM!
- [Sass Crash Course Video](https://www.youtube.com/watch?v=roywYSEPSvc)
- [Изучение Sass](https://sass-lang.com/guide) учебное пособие и/или [freeCodeCamp](https://learn.freecodecamp.org/) Sass руководство.
- Перепишите стили вашего проекта с CSS на Sass!

<a name="bootstrap"></a>
![Bootstrap](https://i.imgur.com/cJ21eH2.jpg)

\* Другие альтернативы: Foundation, Bulma, Materialize

Bootstrap - это бесплатный фронтенд-фреймворк с открытым исходным кодом для разработки сайтов и веб-приложений. Он содержит HTML и CSS шаблоны оформления для типографики, форм, кнопок, навигации и прочих компонентов интерфейсов, включая JavaScript расширения. (Источник: [Wikipedia](<https://ru.wikipedia.org/wiki/Bootstrap_(%D1%84%D1%80%D0%B5%D0%B9%D0%BC%D0%B2%D0%BE%D1%80%D0%BA)>))

### :bulb: Кратко

Существует много вариантов компоновки, стилизации и создания динамического веб-приложения, но вы обнаружите, что использование фреймворка очень помогает вам быстро начать работу. Bootstrap - один из таких фреймворков, но это определенно далеко не единственный вариант! Я рекомендую ознакомиться с одним из похожих на этот фреймворков, но гораздо важнее понять основы HTML, CSS и JavaScript, чем увязать в каком-либо одном фреймворке.

### :book: Темы и идеи

- Почитайте что такое Bootstrap и чем он может быть полезен
- [Bootstrap 4 Crash Course (Video)](https://www.youtube.com/watch?v=hnCmSXCZEpU)
- Пройдите раздел, посвященный Bootstrap на [freeCodeCamp](https://learn.freecodecamp.org/)
- Используйте Bootstrap на своём проекте!

<a name="bem"></a>
![BEM](https://i.imgur.com/MCvMRQl.jpg)

Методология Блок, Элемент, Модификатор (обычно называемая БЭМ) - это популярное соглашение об именах для классов в HTML и CSS. Его цель, разработанная командой «Яндекс», заключается в том, чтобы помочь разработчикам лучше понять взаимосвязь между HTML и CSS в данном проекте. (Источник: [css-tricks.com](https://css-tricks.com/bem-101/))

### :bulb: Кратко

Важно знать, что системы именования и организации, такие как БЭМ, существуют и почему они используются. Проведите здесь некоторое исследование, но на начальном уровне я бы не рекомендовал уделять слишком много времени этому вопросу.

### :book: Темы и идеи

- Прочитайте [BEM introduction](http://getbem.com/introduction/)
- Прочитайте [БЭМ](https://ru.bem.info/)
- [Why I Use BEM (Video)](https://www.youtube.com/watch?v=SLjHSVwXYq4)
- Создайте простую веб-страницу, используя методологию БЭМ.

<a name="gulp"></a>
![Gulp](https://i.imgur.com/KQrByqq.jpg)

Gulp представляет собой набор инструментов для автоматизации болезненных или трудоемких задач в рабочем процессе разработки, так что вы можете забыть о рутине и просто творить. (Источник: [gulpjs.com](https://gulpjs.com/))

### :bulb: Кратко

В современной фронтэнд разработке часто возникает необходимость автоматизировать такие задачи, как пакетирование, перемещение файлов и вставка ссылок в HTML файлы. Gulp - один из инструментов, который может помочь вам в этом!

### :book: Темы и идеи

- Установка gulp с помощью NPM
- Следуйте [gulp для новичков](https://css-tricks.com/gulp-for-beginners/) на CSS-Tricks
- Установите gulp на вашем сайте для:
- Компиляция Sass для вас
- Размещение сгенерированного CSS-файла в подкаталог `build`
- Перемещение ваших веб-страниц в каталог сборки
- Вставка ссылки на ваш сгенерированный файл CSS в ваши веб-страницы

<a name="webpack"></a>
![Webpack](https://i.imgur.com/0rx82Kl.jpg)

По своей сути Webpack представляет собой пакет статических модулей для современных приложений Javascript. Когда Webpack обрабатывает ваше приложение, он самостоятельно строит граф зависимостей, который включает в себя каждый модуль, в котором нуждается ваш проект, и генерирует один или несколько пакетов. (Источник: [webpack.js.org](https://webpack.js.org/concepts/))

### :bulb: Кратко

Представьте, что у вас есть большой проект веб-разработки с множеством разных разработчиков, работающих над множеством разных задач. Вместо того, чтобы работать в одних и тех же файлах, вы можете захотеть максимально их модульно оформить. Webpack помогает сделать это, позволяя вашей команде работать модульно, а затем, когда придет время создавать приложение, Webpack соберет все вместе: HTML, CSS / Sass, JavasScript, изображения и т.д. Webpack - не единственный пакет модулей, но является, лидером на данный момент.

### :book: Темы и идеи

- Почитайте [webpack concepts](https://webpack.js.org/concepts/)
- [What is Webpack, How does it work? (Video)](https://www.youtube.com/watch?v=GU-2T7k9NfI)
- [This webpack tutorial](https://hackernoon.com/a-tale-of-webpack-4-and-how-to-finally-configure-it-in-the-right-way-4e94c8e7e5c1)

<a name="eslint"></a>
![ESLint](https://i.imgur.com/CJb6ZnL.jpg)

ESLint - это утилита линтинга Javascript с открытым исходным кодом, изначально созданная Николасом К. Закасом в июне 2013 года. Линтирование кода - это тип статического анализа, который часто используется для поиска проблемных шаблонов или кода, который не соответствует определенным рекомендациям по стилю. Для большинства языков программирования существуют кодовые линтеры, и компиляторы иногда включают линтинг в процесс компиляции. (Источник: [eslint.org](https://eslint.org/docs/about/))

### :bulb: Кратко

Линтер - это фантастический инструмент для проверки качества кода, улучшения читабельности и согласованности единого стиля. Использование линтера поможет вам отследить синтаксические ошибки и ошибки форматирования до того, как они попадут в продакшен. Вы можете запускать линтеры вручную или включать их в процесс сборки / деплоя.

### :book: Темы и идеи

- Установите ЕSlint используя NPM
- [How to Setup VS Code + Prettier + ESLint (Video)](https://www.youtube.com/watch?v=YIvjKId9m2c)
- "Отлиньте" ваш JavaScript

<a name="react"></a>
![React](https://i.imgur.com/uLYz15W.jpg)

\* Некоторые альтернативы: Vue, Angular, Ember

React (также известный как React.js или ReactJS) - это библиотека JavaScript для создания пользовательских интерфейсов. Он поддерживается компанией Facebook и сообществом индивидуальных разработчиков и компаний. React может быть использован как основа для разработки одностраничных и мобильных приложений. Комплексные React-приложения обычно требуют использования дополнительных библиотек для управления состояниями, роутинга и взаимодействия с API. (Источник: [Wikipedia](<https://ru.wikipedia.org/wiki/React>))

### :bulb: Кратко

JavaScript-фреймворки крайне популярны в современной разработке. Одним из важных выводов здесь является то, что React, несмотря на внушительную популярность, является всего лишь библиотекой для построения пользовательских интерфейсов, в то время, как фреймворки вроде Vue и Angular стремятся быть более функциональными. Например, если вы делаете приложение на React, которому необходима маршрутизация на другие views, вам необходимо привнести в него что-то вроде `react-router`.
React (также известный как React.js или ReactJS) - это библиотека Javascript для создания пользовательских интерфейсов. Он поддерживается компанией Facebook и сообществом индивидуальных разработчиков и компаний. React может быть использован как основа для разработки одностраничных и мобильных приложений. Комплексные React-приложения обычно требуют использования дополнительных библиотек для управления состояниями, роутинга и взаимодействия с API. (Источник: [Wikipedia](<https://en.wikipedia.org/wiki/React_(Javascript_library)>))

### :book: Темы и идеи

- Почитайте руководство [React tutorial](https://reactjs.org/tutorial/tutorial.html)
- [Learn React with Mosh](https://www.youtube.com/watch?v=Ke90Tje7VS0)
- Проведите рефакторинг вашего веб-сайта под React приложение!
- Замечание: `create-react-app` - удобный инструмент для создания новых проектов на React.

<a name="redux"></a>
![Redux](https://i.imgur.com/S9H2Dbp.jpg)

Redux является контейнером с предсказуемым состоянием для JavaScript-приложений. Он помогает вам писать приложения, которые ведут себя единообразно, работая в различном окружении (клиент, сервер, и естественное окружение), и легки для тестирования. Кроме того, он предоставляет большие возможности разработки, такие как редактирование кода в реальном времени в комбинации с отладчиком, с возможностью двигаться по ходу работы приложения в обратном направлении (Источник: [redux.js.org](https://redux.js.org/introduction/getting-started))

### :bulb: Кратко

В то время как вы создаете все более и более объемные фронтэнд приложения, вы начинаете понимать как сложно обслуживать состояние приложения: такие как авторизован ли пользователь, кто этот пользователь, и особенно что происходит в приложении. Redux это замечательная библиотека, которая поможет вам иметь один источник состояния, на котором ваше приложение будет основывать свою логику.

### :book: Темы и идеи

- [Redux video tutorial](https://www.youtube.com/watch?v=93p3LxR9xfM)
- [Redux video series](https://egghead.io/courses/getting-started-with-redux) от Дэна Абрамова, создателя Redux
- Возьмите на заметку [Redux three principles](https://redux.js.org/introduction/three-principles)
- Единственный источник истины
- Состояние только для чтения
- Изменения, сделанные на чистых функциях
- Добавьте Redux для управления состоянием в ваше приложение!

<a name="jest"></a>
![Jest](https://i.imgur.com/Cr39axw.jpg)

Jest - восхитительный JavaScript фреймворк для тестирования с упором на простоту. Его применяют в проектах, использующих Babel, TypeScript, Node, React, Angular, Vue и других! (Источник: [jestjs.io](https://jestjs.io))

### :bulb: Кратко

Очень важно настроить автоматическое тестирование на ваших фронтэнд проектах. Использование автоматического тестирования позволит делать будущие изменения с уверенностью - если вы сделали изменения и тесты прошли успешно, вы будете достаточно уверены, что не сломали никакую дополнительную функциональность. Есть множество фреймворков для тестирования; Jest - один из моих любимых.

### :book: Темы и идеи

- Изучите [Jest basics](https://jestjs.io/docs/en/getting-started)
- Если вы используете `create-react-app`, [Jest уже настроен](https://facebook.github.io/create-react-app/docs/running-tests).
- Добавьте тесты в ваше приложение!

<a name="typescript"></a>
![TypeScript](https://i.imgur.com/BZROJNs.jpg)

\* Альтернатива: Flow

TypeScript - это язык программирования с открытым исходным кодом, разработанный и поддерживаемый Microsoft. Это расширение JavaScript со строгим синтаксисом, которое добавляет в язык необязательную статическую типизацию. TypeScript предназначен для разработки больших приложений и транскомпилируется в JavaScript. Так как TypeScript расширяет JavaScript, существующие программы JavaScript также являются допустимыми TypeScript программами. TypeScript может быть использован для разработки JavaScript приложений, выполняемых как на стороне клиента, так и на стороне сервера (Node.js). (Источник: [Wikipedia](https://en.wikipedia.org/wiki/TypeScript))

### :bulb: Кратко

JavaScript имеет динамическую типизацию. Тем не менее, распространено мнение, что статическая типизация (т.е., определение типов переменных, классов, интерфейсов заранее) и яснее, и снижает вероятность появления дефектов/ошибок. Независимо от того, как вы относитесь к этому, важно, по крайней мере, испытать статически типизированную версию JavaScript, такую как TypeScript. Обратите внимание, что TypeScript компилируется в JavaScript и таким образом может быть интерпретирован браузерами (т.е. браузеры не имеют встроенной поддержки TypeScript).

### :book: Темы и идеи

- [Изучи TypeScript за 5 минут](https://medium.freecodecamp.org/learn-typescript-in-5-minutes-13eda868daeb)
- [Изучи TypeScript за 50 минут (Видео)](https://www.youtube.com/watch?v=WBPrJSw7yQA)
- Опционально [создайте React приложение используя TypeScript](https://levelup.gitconnected.com/typescript-and-react-using-create-react-app-a-step-by-step-guide-to-setting-up-your-first-app-6deda70843a4)

<a name="nextjs"></a>
![NextJS](https://i.imgur.com/YNtW38J.jpg)

Next.js - это минималистичный фреймворк для серверных приложений React. (Источник: [Next.js — React Server Side Rendering Done Right](https://hackernoon.com/next-js-react-server-side-rendering-done-right-f9700078a3b6))

### :bulb: Кратко

Теперь приступим к продвинутому! К настоящему времени вы создали приложение React (или Vue или Angular), которое выполняет довольно мало работы в браузере. По разным причинам (например, SEO, озабоченность клиента по поводу эффективности), вы могли бы хотеть, чтобы ваше фронтэнд приложение выполнялось на сервере, а не на клиенте. Вот тут и появляется такой фреймворк, как next.js.

### :book: Темы и идеи

- Next.js [Getting Started](https://nextjs.org/learn/)
- [Next.js Crash Course (Video)](https://www.youtube.com/watch?v=IkOVe40Sy0U)
- Создайте приложение на Next.js или переведите ваше существующее приложение на Next.js

# Но что дальше?

Предполагается, что этот список даст вам широкое представление о фронтэнд экосистеме, но просто невозможно затронуть каждую отдельную тему, не говоря уже о бесчисленных инструментах в каждой области! Если вы считаете, что я упустил что-то важное, пожалуйста, посмотрите раздел [Вклад] (#contributing), чтобы узнать, как вы можете помочь улучшить это руководство.

# Идеи проектов

По мере прохождения #100ДнейКода, вам понадобится один или несколько проектов, к которым вы можете применить свои новые знания. В этом разделе я попытаюсь представить несколько идей проектов, которые вы можете использовать. В качестве альтернативы, вам предлагается придумать свои собственные идеи проектов, так как эти идеи могут вас заинтересовать и мотивировать больше.

- Идеи для начинающих:
  - Создайте сайт-портфолио
- Идеи для средних/продвинутых:
  - Создайте приложение для анализа твитов (Если вы уже знаете back-end и интеграцию с API)
  
# Нужна помощь?

Как правило, я считаю следующие ресурсы бесценными для обучения разработке программного обеспечения:

- Погуглить вопрос
- [StackOverflow](http://www.stackoverflow.com) (Есть хороший шанс, что ваш вопрос уже был задан и будет иметь высокий рейтинг в поиске Google.).
- [Mozilla MDN Web Docs](https://developer.mozilla.org/en-US/)
- [freeCodeCamp](https://www.freecodecamp.org/)
- Митапы местных разработчиков програмного обеспечения! Большинство из них очень дружелюбны ко всем уровням опыта.

Если вы хотите моего вклада во что-либо, не стесняйтесь [связаться со мной в Twitter](http://www.twitter.com/nas5w), и я сделаю все возможное, чтобы попытаться предложить некоторую помощь. 
Если вы думаете, что с учебной программой есть проблемы или у вас есть рекомендации, смотрите [секцию Помощь](#contributing) ниже.

# Вклад

## Распространите это

Если вы цените работу, проделанную здесь, вы можете внести существенный вклад, распространяя информацию об этом репозитории:

- Поставьте звезду и сделайте форк этого репозитория
- Делитесь этим репозиторием в социальных сетях

## Внесите вклад в этот репозиторий

Эта работа еще не завершена, и я очень ценю любую помощь в поддержании этой базы знаний!

При внесении вклада в этот репозиторий, пожалуйста, сначала обсудите изменения, которые вы хотите сделать с помощью issue, прежде чем вносить изменения. В противном случае будет очень трудно понять ваше предложение, и это может привести к тому, что вы проделаете много работы над изменением, которое не будет слито.

Обратите внимание, что все участники этого проекта либо пытаются учиться, либо пытаются помочь - Будьте добры!

## Процесс Pull Request

1. Создайте issue с описанием предложенного pull request.
2. Получите одобрение от владельца проекта для внесения предложенных изменений.
3. Создайте pull request.
