<p align="center">
  <img alt="#100DaysOfCode Front-End Development" src="https://i.imgur.com/dwYOP0B.jpg" />
</p>

---

**এই রিপোতে একটি স্টার দিয়ে আমাকে অনুপ্রাণিত করুন এবং আমারে পেজে [ফলো করুন](https://github.com/nas5w) আরো রিসোর্সের জন্য**

ফ্রন্টএন্ড ডেভেলপমেন্ট শিখতে চান? 
-  আমার [ফ্রি নিউজলেটারে](https://buttondown.email/devtuts?100DoC) সাইনআপ করুন যেখানে আমি নিয়মিত ফ্রন্টএন্ড ডেভেলপমেন্ট নিয়ে তথ্য ও নিউজ শেয়ার করি। 
- আমার [ইউটিউব চ্যানেলে](https://www.youtube.com/c/devtutsco) সাবস্ক্রাইব করতে পারেন যেখানে আমি জাভাস্ক্রিপ্ট, টাইপস্ক্রিপ্ট এবং রিয়াক্ট শিখাই। 

---

এটি #100DaysOfCode এর সময় ফ্রন্টএন্ড ডেভলপমেন্ট শেখার জন্য কিছুটা মতামতযুক্ত পাঠ্যক্রম। যেহেতু এটি বিস্তৃত ফ্রন্টএন্ড ডেভেলপমেন্টের বিষয়গুলি কভার করে, এটি কোনও একটি অঞ্চলে গভীর ডুব না দিয়ে "জরিপ" স্টাইলের কোর্স হিসাবে বিবেচনা করা যেতে পারে।  আদর্শভাবে, এই পাঠ্যক্রমটি সম্পূর্ণ করা থেকে আপনার গ্রহণযোগ্যতা প্রতিটি বিষয়ের সাথে কিছুটা পরিচিতি হবে এবং প্রয়োজনে ভবিষ্যতে যে কোনও অঞ্চলে সহজেই গভীর গভীরতায় ডুবে যাওয়ার দক্ষতা হবে।

এই পাঠ্যক্রমটি কামরান আহমেদের [Modern Frontend Developer](https://medium.com/tech-tajawal/modern-frontend-developer-in-2018-4c2072fa2b9c) roadmap. দ্বারা উল্লেখযোগ্যভাবে প্রভাবিত হয়েছিল। অনুগ্রহপূর্বক এটি ভালো করে দেখুন, এটা অসাধারণ। 

---

**বিঃদ্রঃ** আমি জানি ফ্রন্টএন্ড ডেভলপমেন্ট মানে অনেক লোকের কাছে বিভিন্ন জিনিস! যদি আপনি ফ্রন্টএন্ড ডেভেলপার হন এবং আপনি মনে করেন যে এই গাইডটি উন্নত হতে পারে তবে [Contributing](#contributing) অংশে সমস্যা উত্থাপন করে দয়া করে আমাকে জানান। ধন্যবাদ!

# ট্রান্সলেশন 

কিছু অবিশ্বাস্য অবদানকারীকে ধন্যবাদ, এই পাঠ্যক্রমটি নিম্নলিখিত ভাষাগুলিতে অনুবাদ করা হয়েছে!

- [Russian русский](/ru) (translation by [@Ibochkarev](https://github.com/Ibochkarev) and [@JonikUl](https://github.com/JonikUl))
- [Chinese 中文](/chinese) (translation by [@simplefeel](https://github.com/simplefeel))
- [Portuguese Português](/portuguese) (translation by [@Zardosh](https://github.com/Zardosh))
- [Polish polski](/polish) (translation by [@mbiesiad](https://github.com/mbiesiad))
- [Malay/Indonesia](/Malay) (translation by [@asyraf-labs](https://github.com/asyraf-labs))
- [Vietnamese Tiếng Việt](/Vietnam) (translation by [@duca7](https://github.com/duca7))
- [Japanese 日本語](/japanese) (translation by [miily8310s](https://github.com/miily8310s))
- [Bangla বাংলা](/bangla)(অনুবাদে [mirajus-salehin](https://github.com/mirajus-salehin))


# :calendar: পাঠ্যক্রম

এই রিপোসিটরিটি [timeboxing](https://en.wikipedia.org/wiki/Timeboxing) নীতির ভিত্তিতে তৈরি করা। আপনি যদি ওয়েব ডেভলপমেন্ট বা অনুরূপ দক্ষতা শেখার চেষ্টা করে অতীতে যে কোনও সময় ব্যয় করেছেন, সম্ভবত আপনি কোনও একটি নির্দিষ্ট বিষয়ে খরগোশের গর্ত দিয়ে নেমে যাওয়ার অভিজ্ঞতা পেয়েছেন। এই রিপোসিটরিটির লক্ষ্য প্রতিটি প্রযুক্তিতে একটি নির্দিষ্ট সংখ্যক দিন নির্ধারণ করা এবং সেই দিনগুলি শেষ হয়ে গেলে আপনাকে পরবর্তীটিতে যেতে উত্সাহ দেয়।

প্রতিদিন কি কি শিখবেন তার একটি লিস্ট নিচে দেওয়া হলোঃ 

- দিন ১-৮ : [HTML](#html)
- দিন ৯-১৬ : [CSS](#css)
- দিন ১৭-২৪ : [JavaScript Basics](#javascript)
- দিন ২৮-৩৩ : [jQuery](#jquery)
- দিন ৩৪-৩৬ : [Responsive Web Design](#rwd)
- দিন ৩৭-৩৯ : [Accessibility](#accessibility)
- দিন ৩৭-৩৯ : [Git](#git)
- দিন ৪০-৪৪ : [Node and NPM](#node)
- দিন ৪৫-৫০ : [Sass](#sass)
- দিন ৫১-৫৪ : [Bootstrap](#bootstrap)
- দিন ৫৫ : [BEM](#bem)
- দিন ৫৭-৬১ : [Webpack](#webpack)
- দিন ৬৬ : [ESLint](#eslint)
- দিন ৬৮-৮৩ : [React](#react)
- দিন ৮৪-৮৯ :  [Redux](#redux)
- দিন ৯০-৯৪ : [Jest](#jest)
- দিন ৯৫-৯৭ : [TypeScript](#typescript)
- দিন ৯৮-১০০ : [NextJS](#nextjs)

# :mag_right: বর্ননা 
নীচে আপনি পাঠ্যক্রমের প্রতিটি বিষয় সম্পর্কে একটি সামান্য তথ্য পাশাপাশি প্রতিটি জন্য কী করবেন সে সম্পর্কে কিছু ধারণা/গাইডেন্স পাবেন। পাশাপাশি কোন প্রজেক্ট করার জন্য যদি অনুপ্রেননার দরকার হয় তাহলে [Project Ideas section](#project-ideas) দেখতে পারেন। 

টাইমবক্সিং নীতিটির অংশ হিসাবে, আপনি যদি "শিক্ষার ক্ষেত্র এবং ধারণা" বিভাগের আইটেমগুলির মধ্যে দিয়ে না পান তবে সমস্যা নেই । পরিবর্তে প্রতিটি ক্ষেত্রের জন্য নির্ধারিত দিনের সংখ্যা থেকে আপনি যতটা পারেন তার চেয়ে বেশি পাওয়ার দিকে মনোযোগ করা উচিত এবং তারপরে এগিয়ে যাওয়া উচিত।

<a name="html"></a>
![HTML](https://i.imgur.com/O0F5XSR.jpg)

Hypertext Markup Language (HTML) একটি স্ট্যান্ডার্ড মার্কাপ ল্যাঙ্গুয়েজ যার মাধ্যমে ওয়েব পেজ ও ওয়েব এপ্লিকেশন বানানো হয়। Cascading Style Sheets (CSS) এবং JavaScript এর সাহায্যে এটি ওয়ার্ল্ড ওয়াইড ওয়েব এর মূল ভিত্তি প্রযুক্তি । ওয়েব ব্রাউজারগুলি কোনও ওয়েব সার্ভার বা লোকাল স্টোরেজ থেকে এইচটিএমএল ডকুমেন্ট গ্রহণ করে এবং ডকুমেন্টগুলি মাল্টিমিডিয়া ওয়েব পেজ গুলিতে রেন্ডার করে। এইচটিএমএল একটি ওয়েব পৃষ্ঠার কাঠামো শব্দার্থগতভাবে বর্ণনা করে এবং ডকুমেন্ট  এর উপস্থিতির জন্য মূলত অন্তর্ভুক্ত কোডকে বর্ণনা করে।

### :bulb: কুইক টেকওয়ে

এইচটিএমএল সত্যিই ওয়েব ডেভেলপমেন্টের ভিত্তি। এমনকি জাভাস্ক্রিপ্ট-ভিত্তিক ফ্রেমওয়ার্কগুলিতে, আপনি এক বা অন্য কোনও আকারে এইচটিএমএল লেখা শেষ করেন।

### শেখার জায়গা এবং আইডিয়া 

- freeCodeCamp এ [Basic HTML and HTML5 section](https://learn.freecodecamp.org/) কোর্সটি করেন। 
- এইচটিএমএল পেজের গঠন 
- এইচটিএমএল এলিমেন্ট 
- নেস্টেড এইচটিএমএল এলিমেন্ট 
- সিম্যান্টিক মার্কাপ 
- লিংক / একাধিক পেজ 
- ছবি যুক্ত করা 
- অডিও / ভিডিও যুক্ত করা 
- ফর্ম এবং ফর্ম এলিমেন্ট 
- মাল্টিপেজ ওয়েবসাইট তৈরি করা ([Project Ideas](#project-ideas))

<a name="css"></a>
![CSS](https://i.imgur.com/028GOR0.jpg)

ক্যাসকেডিং স্টাইল শীট (সিএসএস) হলো এইচটিএমএলের মতো মার্কআপ ল্যাঙ্গুয়েজ যা একটি ডকুমেন্টের  উপস্থাপনা বর্ণনার জন্য ব্যবহৃত হয়। সিএসএস হ'ল এইচটিএমএল এবং জাভাস্ক্রিপ্টের পাশাপাশি ওয়ার্ল্ড ওয়াইড ওয়েবের মূল ভিত্তি প্রযুক্তি। লেআউট, রঙ এবং ফন্ট সহ উপস্থাপনা এবং সামগ্রীর বিভাজন সক্ষম করার জন্য সিএসএস ডিজাইন করা হয়েছে। এই বিভাজন বিষয়বস্তুর অ্যাক্সেসযোগ্যতার উন্নতি করতে পারে, উপস্থাপনা বৈশিষ্ট্যের স্পেসিফিকেশনে আরও নমনীয়তা এবং নিয়ন্ত্রণ সরবরাহ করতে পারে, পৃথক .css ফাইলে প্রাসঙ্গিক সিএসএস নির্দিষ্ট করে একাধিক ওয়েব পৃষ্ঠাগুলি ফর্ম্যাটিং ভাগ করতে সক্ষম করে এবং কাঠামোগত সামগ্রীতে জটিলতা এবং পুনরাবৃত্তি হ্রাস করতে পারে। 

### :bulb: কুইক টেকওয়ে

সিএসএস ওয়েব ডেভেলপমেন্টের আরেকটি প্রয়োজনীয় উপাদান। এটি মূলত HTML উপাদানগুলিকে স্টাইল এবং অবস্থানের জন্য ব্যবহৃত হয়, এটি আরও গতিশীল কাজগুলির (যেমন, অ্যানিমেশনগুলি) ক্রমশ সক্ষম হয়ে উঠেছে যা একবার জাভাস্ক্রিপ্ট দ্বারা পরিচালিত হবে।

### শেখার জায়গা এবং আইডিয়া 

- freeCodeCamp এ [Basic CSS, CSS flexbox, and CSS grid sections](https://learn.freecodecamp.org/) কোর্সটি করেন।
- ইন-লাইন সিএসএস 
- `<style>` ট্যাগ
- `<link>` দিয়ে এক্সটার্নাল সিএসএস 
- স্টাইলিং এলিমেন্ট
- সিলেক্টর 
- ফ্লোট এবং ফ্লোট ক্লিয়ার করা 
- লেআউট(গ্রিড এবং ফ্লেক্সবক্স)
- ফন্ট
- যখন যে এইচটিএমএল বানবেন সেইটা ডিসাইন করবেন 

<a name="javascript"></a>
![JavaScript](https://i.imgur.com/oHdD86j.jpg)

জাভাস্ক্রিপ্ট, প্রায়শই সংক্ষিপ্তসার হিসাবে জেএস হিসাবে সংক্ষেপিত হয়, একটি উচ্চ-স্তরের, অনুবাদিত প্রোগ্রামিং ভাষা যা ECMAScript নির্দিষ্টকরণের সাথে সামঞ্জস্য করে। এটি এমন একটি ভাষা যা ডায়নামিক, দুর্বলভাবে টাইপ করা, প্রোটোটাইপ-ভিত্তিক এবং মাল্টি-প্যারাডিম হিসাবে চিহ্নিত হয়। এইচটিএমএল এবং সিএসএসের পাশাপাশি, জাভাস্ক্রিপ্ট ওয়ার্ল্ড ওয়াইড ওয়েবের তিনটি মূল প্রযুক্তির মধ্যে একটি। জাভাস্ক্রিপ্ট ইন্টারেক্টিভ ওয়েব পৃষ্ঠাগুলি সক্ষম করে এবং ওয়েব অ্যাপ্লিকেশনগুলির একটি প্রয়োজনীয় অংশ। বেশিরভাগ ওয়েবসাইট এটি ব্যবহার করে এবং সমস্ত বড় ওয়েব ব্রাউজারগুলিতে এটি কার্যকর করার জন্য একটি ডেডিকেটেড জাভাস্ক্রিপ্ট ইঞ্জিন থাকে। 

### :bulb: কুইক টেকওয়ে

জাভাস্ক্রিপ্ট ফ্রন্ট-এন্ড ওয়ার্ল্ডে ক্রমবশ গুরুত্বপূর্ণ হয়ে উঠেছে। এটি একসময় ওয়েব পেজগুলিকে ডায়নামিক করার জন্য ব্যবহৃত হয়েছিল, এখন এটি অনেকগুলি ফ্রন্ট-এন্ড ফ্রেমওয়ার্কের ভিত্তি। এই ফ্রেমওয়ার্কগুলি প্রচুর কাজ পরিচালনা করে যা পূর্বে ব্যাক-এন্ড দ্বারা পরিচালনা করা হয়েছিল (উদাঃ, রাউটিং এবং বিভিন্ন পেজ প্রদর্শন)।

### শেখার জায়গা এবং আইডিয়া 

- freeCodeCamp এ [Basic JavaScript and ES6 sections](https://learn.freecodecamp.org/) কোর্সটি করেন।
- এখানে অনেক কিছু শেখার আছে। 
- `<script>` ট্যাগ এবং এর প্লেসমেন্ট।
- এইচটিএমএল এলিমেন্ট নিয়ে কাজ করা।
- ইভেন্ট লুপ, কল স্ট্যাক এবং ইভেন্ট কিউ 
- প্রোটোটাইপ ইনহেরিটেন্স 
- রেফারেন্স বনাম ভ্যালু 
- পুর্বের তৈরি ওয়েব পেজে ডায়নামিক এলিমেন্ট লজিক যূক্ত করা 

<a name="jquery"></a>
![jQuery](https://i.imgur.com/m9j02Fo.jpg)

jQuery হলো একটি দ্রুত, ছোট এবং অনেক কার্যকরী একটি জাভাস্ক্রিপ্ট লাইব্রেরি। এটি এইচটিএমএল ডকুমেন্টের ট্র্যাভারসাল এবং ম্যানিপুলেশন, ইভেন্ট হ্যান্ডলিং, অ্যানিমেশন এবং অ্যাজাক্সকে সহজেই ব্যবহারযোগ্য সহজে ব্যবহারযোগ্য API এর সাহায্যে অনেকগুলি সহজ করে তোলে যা বহু ব্রাউজার জুড়ে কাজ করে। বহুমুখিতা এবং এক্সটেনসিবিলিটির সংমিশ্রণে, jQuery কয়েক মিলিয়ন মানুষের জাভাস্ক্রিপ্ট লেখার ধরনই পরিবর্তন করেছে। 
### :bulb: কুইক টেকওয়ে

আপনি সরল (যা "ভ্যানিলা" নামে পরিচিত) জাভাস্ক্রিপ্টের সাথে কিছুটা সময় কাটিয়ে দেওয়ার পরে আপনি কিছু কাজ কিছুটা জটিল করে দেখতে পাবেন, বিশেষত এইচটিএমএল উপাদানগুলিতে অ্যাক্সেস এবং হেরফের সম্পর্কিত কাজগুলি। বেশ কিছু সময়ের জন্য, বিভিন্ন ব্রাউজারগুলিতে এই ধরণের কাজগুলি সহজ এবং সামঞ্জস্যপূর্ণ করার জন্য jQuery সাহায্য করেছে। আজকাল, ভেনিলা জাভাস্ক্রিপ্ট, সিএসএস এবং আরও নতুন জাভাস্ক্রিপ্ট ফ্রেমওয়ার্কের অগ্রগতির কারণে jQuery অগত্যা "বাধ্যতামূলক" শেখার নয় (আমরা ফ্রেমওয়ার্কগুলি পরে দেখব)। তবুও কিছু jQuery শিখতে এবং একটি ছোট প্রকল্পে এটি প্রয়োগ করতে কিছুটা সময় নেওয়া উপকারী হবে। 

### শেখার জায়গা এবং আইডিয়া 
- freeCodeCamp এ [jQuery section](https://learn.freecodecamp.org/) কোর্সটি করেন।
- ডকুমেন্ট রেডি 
- সিলেক্টর
- ক্লাস টগোল 
- এনিমেশন 
- আরো এইচটিএমএল এলিমেন্ট এড করা 
- সাইটে jQuery এড করা 

<a name="rwd"></a>
![Responsive Web Design](https://i.imgur.com/Bt1zWwq.jpg)

রিস্পন্সিভ ওয়েব ডিজাইন হলো ওয়েব ডিজাইনের একটি পদ্ধতি যা ওয়েব পৃষ্ঠাগুলিকে বিভিন্ন ডিভাইস এবং উইন্ডো বা স্ক্রিন আকারের উপর ভালভাবে সরবরাহ করে। সাম্প্রতিক কাজটি দর্শকের নিকটে দেখার প্রসঙ্গে অংশ হিসাবে বিবেচনা করে আরডাব্লুডির জন্য একটি এক্সটেনশন হিসাবে। ব্যবহারযোগ্যতা এবং সন্তুষ্টি নিশ্চিত করতে সামগ্রীতে সামগ্রী, ডিজাইন এবং কার্য সম্পাদন প্রয়োজনীয়। আরডাব্লুডি দিয়ে তৈরি একটি সাইট অনুপাত ভিত্তিক গ্রিড এবং CSS3 মিডিয়া ক্যোয়ারী, @media নিয়মের একটি এক্সটেনশান ব্যবহার করে দেখার পরিবেশের সাথে লেআউটটিকে রূপান্তর করে।

### :bulb: কুইক টেকওয়ে

রিস্পন্সিভ ওয়েব ডিজাইন হলো ওয়েব অ্যাপ্লিকেশনগুলি সমস্ত ধরণের ডিভাইসে সঠিকভাবে দেখানো এবং কার্যকর করে তোলা। একটি সহজ উদাহরণ হলো কোনো ওয়েবসাইটকে ডেস্কটপ ওয়েব ব্রাউজারে এবং একটি মোবাইল ফোন ব্রাউজারে উভয়ই সঠিকভাবে দেখা এবং ফাংশন করা। যে কোনও ফ্রন্ট-এন্ড ডেভেলপারদের জন্য রিস্পন্সিভ ডিজাইন বোঝা গুরুত্বপূর্ণ!

### শেখার জায়গা এবং আইডিয়া 

- freeCodeCamp এ [Responsive Web Design Principles section](https://learn.freecodecamp.org/) কোর্সটি করেন। 
- মিডিয়া কুয়েরি এবং ব্রেকপয়েন্ট 
- রিস্পন্সিভ ইমেজ 
- পুর্বের তৈরি ওয়েবসাইটটিকে রিস্পন্সিভ তোলা 
- ক্রোম ডেভ টুল ব্যবহার করে বিভিন্ন ডিভাইসে সাইট পর্যবেক্ষন করা 

<a name="accessibility"></a>
![Accessibility](https://i.imgur.com/ayioMQw.jpg)

ওয়েব অ্যাক্সেসিবিলিটি হ'ল প্রতিবন্ধী ব্যক্তিদের দ্বারা ওয়ার্ল্ড ওয়াইড ওয়েবে ওয়েবসাইটের সাথে যোগাযোগ বা অ্যাক্সেসকে বাধা দেওয়ার কোনও বাধা নেই তা নিশ্চিত করার অন্তর্ভুক্তিমূলক অনুশীলন। যখন সাইটগুলি সঠিকভাবে ডিজাইন করা, বিকাশিত এবং সম্পাদিত হয়, সাধারণত সমস্ত ব্যবহারকারীর তথ্য এবং কার্যকারিতা থেকে সমান অ্যাক্সেস থাকে। 

### :bulb: কুইক টেকওয়ে 

অ্যাক্সেসযোগ্যতা, প্রায়শই a11y হিসাবে লেখা, ফ্রন্ট-এন্ড ওয়েব ডেভেলপমেন্টের অন্যতম গুরুত্বপূর্ণ বিষয়, তবুও এটি প্রায়শই সংক্ষিপ্ত সুযোগ ও নজর পায় বলে মনে হয়। অ্যাক্সেসযোগ্য ওয়েব অ্যাপ্লিকেশনগুলি তৈরি করা কেবলমাত্র নৈতিকভাবে সাবলীল নয়, অতিরিক্ত শ্রোতার কথা বিবেচনা করে প্রচুর ব্যবসায়িক ধারণা তৈরি করে যা আপনার অ্যাপ্লিকেশনগুলি যখন অ্যাক্সেসযোগ্য হয় তখন তা দেখতে সক্ষম হবে। 

### শেখার জায়গা এবং আইডিয়া 

- freeCodeCamp এ [Applied Accessibility section](https://learn.freecodecamp.org/)  অংশটি দেখা 
- [The A11Y Project](https://a11yproject.com/about) সম্পর্কে জানা 
- তাদের [checklist](https://a11yproject.com/checklist) রিভিউ করা 
- চেকলিস্ট অনুযায়ী নিজের সাইটকে উন্নত করা 

<a name="git"></a>
![Git](https://i.imgur.com/5QoNJqs.jpg)

গিট একটি ফ্রি এবং ওপেন সোর্স ভার্সন নিয়ন্ত্রণ ব্যবস্থা যা গতি এবং দক্ষতার সাথে ছোট থেকে খুব বড় প্রকল্পগুলিকে হ্যান্ডেল করার জন্য ডিজাইন করা হয়েছে। 

### :bulb: কুইক টেকওয়ে 

ভার্সন / কোড নিয়ন্ত্রণ যে কোনও ওয়েব ডেভেলপারের টুলকিটের একটি প্রয়োজনীয় অংশ। বিভিন্ন ভার্সন  নিয়ন্ত্রণ সিস্টেম রয়েছে, তবে গিট এই মুহূর্তে সবচেয়ে বেশি প্রচলিত। আপনি শিখার সাথে সাথে আপনার প্রকল্পগুলি ট্র্যাক করতে এটি ব্যবহার করতে পারেন (এবং হওয়া উচিত!)

### শেখার জায়গা এবং আইডিয়া 

- [Git Tutorial for Beginners (Video)](https://www.youtube.com/watch?v=HVsySz-h9r4)
- গিট ইন্সটল করা 
- গিটহাব একাউন্ট সেটআপ করা 
- সবচেয়ে বেশি ব্যবহৃত গিট কমান্ড গুলি শেখা 
  - init
  - clone
  - add
  - commit
  - push
  - pull
  - merge
  - rebase
- চলমান কোনো প্রোজেক্টে গিট এবং গিটহাব ব্যবহার করা 

<a name="node"></a>
![Node and NPM](https://i.imgur.com/8ik2alD.jpg)

নোড.জেএস একটি ওপেন-সোর্স, ক্রস-প্ল্যাটফর্ম জাভাস্ক্রিপ্ট রান-টাইম এনভায়রনমেন্ট যা ব্রাউজারের বাইরে জাভাস্ক্রিপ্ট কোড রান করায়। জাভাস্ক্রিপ্ট মূলত ক্লায়েন্ট-সাইড স্ক্রিপ্টিংয়ের জন্য ব্যবহৃত হয়, যেখানে জাভাস্ক্রিপ্টে লিখিত স্ক্রিপ্টগুলি একটি ওয়েবপৃষ্ঠার এইচটিএমএলে এম্বেড করা থাকে এবং ব্যবহারকারীর ওয়েব ব্রাউজারে জাভাস্ক্রিপ্ট ইঞ্জিন দ্বারা ক্লায়েন্ট-সাইড চালিত হয়। নোড.জেএস ডেভেলপারদের কমান্ড লাইন সরঞ্জামগুলি লেখার জন্য এবং সার্ভার-সাইড স্ক্রিপ্টিং-জন্য চলমান স্ক্রিপ্ট সার্ভার-সাইডের জন্য পেজটি ব্যবহারকারীর ওয়েব ব্রাউজারে প্রেরণের আগে ডায়নামিক ওয়েব পেজ সামগ্রী তৈরি করতে জাভাস্ক্রিপ্ট ব্যবহার করতে দেয়। ফলস্বরূপ, নোড.জেএস সার্ভার সাইড এবং ক্লায়েন্ট সাইড স্ক্রিপ্টগুলির জন্য পৃথক ভাষার পরিবর্তে একক প্রোগ্রামিং ভাষার চারপাশে ওয়েব অ্যাপ্লিকেশন ডেভেলপমেন্টকে একত্রিত করে একটি "সর্বত্র জাভাস্ক্রিপ্ট" উপমা উপস্থাপন করে।

### :bulb: কুইক টেকওয়ে

যদিও নোড.জেএস সাধারণত ব্যাক-এন্ড সলিউশন হিসাবে পরিচিত, এটি ফ্রন্ট-এন্ড বিকাশ সমর্থন করার জন্য বেশ ঘন ঘন ব্যবহৃত হয়। এটি বিভিন্ন উপায়ে এটি করে, যেমন বিল্ড সরঞ্জামগুলি চালানো, পরীক্ষা করা এবং আবদ্ধকরণ (যা শীঘ্রই করে দেওয়া হবে!) নোড প্যাকেজ ম্যানেজার (এনপিএম) নোডের আরেকটি দুর্দান্ত বৈশিষ্ট্য এবং এটি আপনার প্রকল্পের নির্ভরতা পরিচালনা করতে ব্যবহার করা যেতে পারে (যেমন, আপনার প্রকল্পের কোড লাইব্রেরিগুলি আপনার প্রকল্পের উপর নির্ভর করতে পারে - jQuery একটি উদাহরণ!)

### শেখার জায়গা এবং আইডিয়া 

- নোড কিভাবে বিভিন্ন ব্রাউজারে কাজ করে তা নিয়ে গবেষণা করা 
- নোড  ইন্সটল করা 
- সোজা জাভাস্ক্রিপ্ট কোড লিখে নোড দিয়ে তা রান করানো 
- এনপিএম ব্যবহার করে যেকোনো ডিপেন্ডিন্সি ম্যানেজ করা 

<a name="sass"></a>
![Sass](https://i.imgur.com/ZRedLge.jpg)

Sass সিএসএসের একটি এক্সটেনশন যা মৌলিক ভাষায় শক্তি এবং সৌন্দর্য যুক্ত করে। এটি আপনাকে সম্পূর্ণ সিএসএস-সামঞ্জস্যপূর্ণ সিনট্যাক্স সহ ভেরিয়েবল, নেস্টেড নিয়ম, মিক্সিনস, ইনলাইন ইম্পোর্ট এবং আরও অনেক কিছু ব্যবহার করতে দেয়। Sass বড় স্টাইলশিটগুলিকে সুসংহত করতে এবং ছোট স্টাইলশীটগুলি দ্রুত ও দ্রুত চালিত হতে সহায়তা করে বিশেষত কমপাস স্টাইল লাইব্রেরির সাহায্যে। 

### :bulb: কুইক টেকওয়ে 

Sass আপনাকে আরও প্রোগ্রামগত পদ্ধতিতে সিএসএস লেখার অনুমতি দেয়। আপনি যদি কিছু সিএসএস করে থাকেন তবে আপনি লক্ষ্য করেছেন যে আপনি প্রচুর তথ্য পুনরাবৃত্তি করেছেন - উদাহরণস্বরূপ, একই রঙের কোডটি নির্দিষ্ট করে। Sass এ, আপনি অতিরিক্ততা হ্রাস করতে এবং পড়ার ক্ষমতা বাড়াতে ভেরিয়েবল, লুপ এবং নেস্টিংয়ের মতো জিনিস ব্যবহার করতে পারেন। Sass এ আপনার কোড লেখার পরে, আপনি তাড়াতাড়ি এবং সহজেই এটি নিয়মিত সিএসএসে সংকলন করতে পারেন।

### শেখার জায়গা এবং আইডিয়া 

- এনপিএম দিয়ে Sass ইন্সটল দেওয়া 
- [Sass Crash Course Video](https://www.youtube.com/watch?v=roywYSEPSvc)
- ফলো [Learn Sass](https://sass-lang.com/guide) টিউটোরিয়াল যা অফিসিয়াল কোর্স এবং [freeCodeCamp](https://learn.freecodecamp.org/) যা আরো জ্ঞ্যান দিবে 
- বর্তমান কোন একটি সাইটকে Sass দিয়ে আবার লেখা 

<a name="bootstrap"></a>
![Bootstrap](https://i.imgur.com/cJ21eH2.jpg)

ওয়েবসাইট এবং ওয়েব অ্যাপ্লিকেশনগুলির বিকাশের জন্য বুটস্ট্র্যাপ একটি ফ্রি এবং ওপেন সোর্স ফ্রন্ট-এন্ড ফ্রেমওয়ার্ক। এটিতে টাইপোগ্রাফি, ফর্ম, বোতাম, নেভিগেশন এবং অন্যান্য ইন্টারফেস উপাদানগুলির পাশাপাশি জাভাস্ক্রিপ্ট এক্সটেনশনগুলির জন্য এইচটিএমএল এবং সিএসএস-ভিত্তিক ডিজাইন টেম্পলেট রয়েছে। 

### :bulb: কুইক টেকওয়ে 

আপনার ওয়েব অ্যাপ্লিকেশনটিকে ডায়নামিক করা, স্টাইলিং করা এবং গতিশীল করার জন্য অনেকগুলি বিকল্প রয়েছে তবে আপনি দেখতে পাবেন যে একটি ফ্রেমওয়ার্ক দিয়ে শুরু করা আপনাকে শুরু করার ক্ষেত্রে দুর্দান্তভাবে সহায়তা করে। বুটস্ট্র্যাপ এমন একটি কাঠামো, তবে এটি অবশ্যই একমাত্র বিকল্প নয়। আমি একটি কাঠামোর সাথে পরিচিত হওয়ার পরামর্শ দিচ্ছি, তবে এটি কোনও একটি ফ্রেমওয়ার্কের মধ্যে পরে থাকার চেয়ে এইচটিএমএল, সিএসএস এবং জাভাস্ক্রিপ্টের মূল বিষয়গুলি উপলব্ধি করা আরও বেশি গুরুত্বপূর্ণ। 

### শেখার জায়গা এবং আইডিয়া 

- বুটস্ট্র্যাপ কী এবং আপনি কেন এটি ব্যবহার করতে চান তা শিখুন
- [Bootstrap 4 Crash Course (Video)](https://www.youtube.com/watch?v=hnCmSXCZEpU)
- [freeCodeCamp](https://learn.freecodecamp.org/) এ  বুটস্ট্র্যাপ বিভাগটি সম্পূর্ণ করুন
- আপনার সাইটে বুটস্ট্র্যাপ ব্যবহার করে রিফ্যাক্টর করুন 

<a name="bem"></a>
![BEM](https://i.imgur.com/MCvMRQl.jpg)

এইচটিএমএল এবং সিএসএসের ক্লাসগুলির জন্য ব্লক, এলিমেন্ট, মোডিফায়ার পদ্ধতি (সাধারণত বিইএম হিসাবে পরিচিত) হ'ল একটি জনপ্রিয় নামকরণ কনভেনশন। ইয়ানডেক্সে টিম দ্বারা বিকাশিত, এর লক্ষ্য ডেভেলপারদের প্রকল্পে এইচটিএমএল এবং সিএসএসের মধ্যে সম্পর্ক আরও ভালভাবে বুঝতে সহায়তা করা। 

### :bulb: কুইক টেকওয়ে 

নামকরণ এবং বিইএম যেমন সিস্টেম রয়েছে এবং সেগুলি কেন ব্যবহৃত হয় তা জানা গুরুত্বপূর্ণ। এখানে কিছু গবেষণা করুন, তবে প্রাথমিক পর্যায়ে আমি বিষয়টিতে খুব বেশি সময় দেওয়ার পরামর্শ দিচ্ছি না।

### শেখার জায়গা এবং আইডিয়া 

- [BEM introduction](http://getbem.com/introduction/) পড়ুন 
- [Why I Use BEM (Video)](https://www.youtube.com/watch?v=SLjHSVwXYq4)
- বিইএম কনভেনশন ব্যবহার করে একটি সাধারণ ওয়েবপেজ তৈরি করুন।

<a name="gulp"></a>
![Gulp](https://i.imgur.com/KQrByqq.jpg)

Gulp আপনার কর্মপ্রবাহে বেদনাদায়ক বা সময় সাশ্রয়ী কার্যগুলি স্বয়ংক্রিয় করার জন্য একটি সরঞ্জামকিট, যাতে আপনি চারপাশে গোলযোগ বন্ধ করে কিছু তৈরি করতে পারেন। 

### :bulb: কুইক টেকওয়ে 

আধুনিক ফ্রন্ট-এন্ড ডেভেলপমেন্টে আপনি প্রায়শই নিজেকে বান্ডিলিং, ফাইলগুলি সরানো এবং HTML ফাইলগুলিতে ইনজেকশন রেফারেন্সের মতো কাজগুলি স্বয়ংক্রিয় করতে প্রয়োজন বলে মনে করেন। Gulp একটি সরঞ্জাম যা আপনাকে এই জিনিসগুলি করতে সহায়তা করতে পারে!

### শেখার জায়গা এবং আইডিয়া 

- এনপিএম দিয়ে Gulp ইন্সটল করা 
- CSS-Tricks এ  [gulp for beginners tutorial](https://css-tricks.com/gulp-for-beginners/) ফলো করা 
- আপনার সাইটে এমনভাবে Gulp সেটআপ করুন যেন 
  - Sass কম্পাইল করতে পারে 
  - জেনারেটেড সিএসএস ফাইটি  `build` সাবডিরেক্টরিতে রাখতে পারে 
  - আপনার সব পেজগুলি যেন `build` ডিরেক্টরিটে নিতে পারে 
  - জেনারেটেড সিএসএস ফাইল আপনার ওয়েবপেজে যুক্ত করতে পারে 

<a name="webpack"></a>
![Webpack](https://i.imgur.com/0rx82Kl.jpg)

এর মূল অংশে, ওয়েবপ্যাকটি আধুনিক জাভাস্ক্রিপ্ট অ্যাপ্লিকেশনগুলির জন্য একটি স্ট্যাটিক মডিউল বান্ডেলার। ওয়েবপ্যাক আপনার অ্যাপ্লিকেশন প্রক্রিয়া করার সময়, এটি অভ্যন্তরীণভাবে নির্ভরতা গ্রাফ তৈরি করে যা আপনার প্রকল্পের প্রতিটি মডিউলকে মানচিত্র করে এবং এক বা একাধিক বান্ডিল জেনারেট করে। 

### :bulb: কুইক টেকওয়ে 

কল্পনা করুন যে আপনার কাছে একটি বিশাল ওয়েব ডেভেলপার বিভিন্ন বিভিন্ন কাজে কাজ করে। সমস্ত একই ফাইলে কাজ করার পরিবর্তে আপনি তাদের যথাসম্ভব মড্যালাইজ করতে চাইতে পারেন। ওয়েবপ্যাকটি আপনার টিমকে মডুলারিভাবে কাজ করার অনুমতি দেয় এবং তারপরে অ্যাপ্লিকেশনটি তৈরির সময় আসে, ওয়েবপ্যাক এগুলি একসাথে আটকে রাখবে: এইচটিএমএল, সিএসএস / স্যাস, জাভাস্ক্রিপ্ট, চিত্র ইত্যাদি। ওয়েবপ্যাক একমাত্র মডিউল বান্ডলার নয়, তবে এই মুহুর্তে এটি ফ্রন্ট রানার বলে মনে হচ্ছে। 

### শেখার জায়গা এবং আইডিয়া 

- [webpack concepts](https://webpack.js.org/concepts/) পড়ুন 
- [What is Webpack, How does it work? (Video)](https://www.youtube.com/watch?v=GU-2T7k9NfI)
- [This webpack tutorial](https://hackernoon.com/a-tale-of-webpack-4-and-how-to-finally-configure-it-in-the-right-way-4e94c8e7e5c1)


<a name="eslint"></a>
![ESLint](https://i.imgur.com/CJb6ZnL.jpg)

ইএসলিন্ট একটি ওপেন সোর্স জাভাস্ক্রিপ্ট লিটিং ইউটিলিটি যা জুন ২০১৩ সালে নিকোলাস সি জাকাস তৈরি করেছিলেন। কোড লিটিং হলো এক ধরণের স বিশ্লেষণ যা প্রায়শই সমস্যাযুক্ত প্যাটার্ন  বা কোড খুঁজে পেতে ব্যবহৃত হয় যা নির্দিষ্ট স্টাইলের নির্দেশিকাগুলি মেনে চলে না।  বেশিরভাগ প্রোগ্রামিং ভাষার জন্য কোড লিন্টার রয়েছে এবং সংকলকরা মাঝে মাঝে সংকলন প্রক্রিয়াতে লেটিং অন্তর্ভুক্ত করেন। 

### :bulb: কুইক টেকওয়ে

- এনপিএম দিয়ে ইএসলিন্ট ইন্সটল করা 
- [How to Setup VS Code + Prettier + ESLint (Video)](https://www.youtube.com/watch?v=YIvjKId9m2c)
- বর্তমান কোন জাভস্ক্রিপ্ট লিন্ট করা 

<a name="react"></a>
![React](https://i.imgur.com/uLYz15W.jpg)

React (যা React.js বা ReactJS নামে পরিচিত) ব্যবহারকারীর ইন্টারফেস তৈরির জন্য একটি জাভাস্ক্রিপ্ট লাইব্রেরি। এটি ফেসবুক এবং স্বতন্ত্র ডেভেলপার এবং বিভিন্ন  সংস্থার একটি কিমিউনিটি দ্বারা রক্ষণাবেক্ষণ করা হয়। React একক পেজ  বা মোবাইল অ্যাপ্লিকেশনগুলির ভিত্তি হিসাবে ব্যবহার করা যেতে পারে।  জটিল React এপ্লিকেশন গুলি সাধারণত কিছু আলাদা লাইব্রেরির সাহায়ে করা হত যা স্টেট ম্যানেজমেন্ট , রাউটিং এবং ইন্টারাকশনের  জিনিসগুলি পরিচালনা করে।

### শেখার জায়গা এবং আইডিয়া 

- [React tutorial](https://reactjs.org/tutorial/tutorial.html)
- [Learn React with Mosh](https://www.youtube.com/watch?v=Ke90Tje7VS0)
- কোন একটি সাইটকে React দিয়ে আবার নতুন করে লেখা 
- নোট `create-react-app` নতুন React প্রোজেক্ট শুরু করার জন্য ভাল 

<a name="redux"></a>
![Redux](https://i.imgur.com/S9H2Dbp.jpg)

রেডাক্স জাভাস্ক্রিপ্ট অ্যাপ্লিকেশনগুলির জন্য প্রেডিক্ট্যাবল স্টেট কন্টেইনার। এটি আপনাকে এমন অ্যাপ্লিকেশন লিখতে সহায়তা করে যা ধারাবাহিকভাবে আচরণ করে, বিভিন্ন পরিবেশে চালিত হয় (ক্লায়েন্ট, সার্ভার এবং নেটিভ) এবং পরীক্ষা করা সহজ। তার উপরে, এটি একটি দুর্দান্ত অভিজ্ঞতা সরবরাহ করে, যেমন লাইভ কোড সম্পাদনা কোনও ডিবাগারের সাথে মিলিত। 

### :bulb: কুইক টেকওয়ে

আপনি বড় এবং বড় ফ্রন্ট-এন্ড অ্যাপ্লিকেশনগুলি তৈরি করার সাথে সাথে আপনি উপলব্ধি করতে শুরু করেন যে অ্যাপ্লিকেশনের অবস্থাটি বজায় রাখা খুব কঠিন: ব্যবহারকারী যদি লগ ইন করে থাকেন তবে ব্যবহারকারী কে এবং সাধারণত অ্যাপ্লিকেশনটিতে কী চলছে তা এই জাতীয় জিনিস। রেডাক্স হলো একটি দুর্দান্ত লাইব্রেরি যা আপনাকে এমন একক স্টেটের উত্স বজায় রাখতে সহায়তা করে যার উপর ভিত্তি করে আপনার অ্যাপ্লিকেশন ও তার লজিকটি ভিত্তি গরে উঠে। 

### শেখার জায়গা এবং আইডিয়া 

- [Redux video tutorial](https://www.youtube.com/watch?v=93p3LxR9xfM)
- ড্যান আব্রামভ, রেডাক্সের স্রষ্টা হতে [Redux video series](https://egghead.io/courses/getting-started-with-redux)
- [Redux three principles](https://redux.js.org/introduction/three-principles) হতে নোট করে রাখুন 
   - Single source of truth
   - State is read-only
   - Changes are made with pure functions
- বর্তমান প্রোজেক্টে রেডাক্স যোগ করা 

<a name="jest"></a>
![Jest](https://i.imgur.com/Cr39axw.jpg)

জেস্ট হল সরলতার উপর দৃষ্টি নিবদ্ধ করে একটি আনন্দদায়ক জাভাস্ক্রিপ্ট টেস্টিং ফ্রেমওয়ার্ক। এটি ব্যবহার করে প্রকল্পগুলির সাথে কাজ করে: ব্যাবেল, টাইপস্ক্রিপ্ট, নোড, React, Angular, Vue এবং আরও অনেক কিছু!

### :bulb: কুইক টেকওয়ে

আপনার ফ্রন্ট-এন্ড প্রকল্পগুলির জন্য স্বয়ংক্রিয় পরীক্ষার সেট আপ করা খুব গুরুত্বপূর্ণ। স্বয়ংক্রিয় পরীক্ষার সেট আপ করা আপনাকে আত্মবিশ্বাসের সাথে ভবিষ্যতের পরিবর্তনগুলি করার অনুমতি দেবে - যদি আপনি পরিবর্তন করেন এবং আপনার পরীক্ষাগুলি এখনও পাস করে থাকেন তবে আপনি মোটামুটি আরামদায়ক হবেন আপনি কোনও বিদ্যমান কার্যকারিতা ভঙ্গ করেন নি। তালিকার জন্য অনেকগুলি টেস্টিং ফ্রেমওয়ার্ক রয়েছে; জেস্ট কেবল আমার প্রিয় একটি। 

### শেখার জায়গা এবং আইডিয়া 

- [Jest basics](https://jestjs.io/docs/en/getting-started)
- আপনি যদি `create-react-app`, ব্যবহার করে থাকেন তবে জেস্ট ইতিমধ্যে কনফিগার করা আছে
- বর্তমান এপ্লিকেশনে টেস্ট যুক্ত করা 

<a name="typescript"></a>
![TypeScript](https://i.imgur.com/BZROJNs.jpg)

টাইপস্ক্রিপ্ট মাইক্রোসফ্ট দ্বারা বিকাশিত এবং রক্ষণাবেক্ষণের জন্য একটি ওপেন সোর্স প্রোগ্রামিং ভাষা। এটি জাভাস্ক্রিপ্টের একটি কঠোর সিনট্যাকটিক্যাল সুপারসেট, এবং ভাষাতে স্ট্যাটিক টাইপিং যুক্ত করে। টাইপস্ক্রিপ্টটি জাভাস্ক্রিপ্টে বড় অ্যাপ্লিকেশন এবং ট্রান্সকোম্পাইলগুলির জন্য ডিজাইন করা হয়েছে। যেহেতু টাইপস্ক্রিপ্ট জাভাস্ক্রিপ্টের একটি সুপারস্টেট, বিদ্যমান জাভাস্ক্রিপ্ট প্রোগ্রামগুলিও বৈধ টাইপস্ক্রিপ্ট প্রোগ্রাম। টাইপস্ক্রিপ্ট ক্লায়েন্ট-সাইড এবং সার্ভার-সাইড (নোড.জেএস) উভয়ের প্রয়োগের জন্য জাভাস্ক্রিপ্ট অ্যাপ্লিকেশন বিকাশের জন্য ব্যবহার করা যেতে পারে। 

### :bulb: কুইক টেকওয়ে

জাভাস্ক্রিপ্ট এ ডায়নামিক টাইপ করা হয়। তবে এটি একটি সাধারণ বিশ্বাস যে স্ট্যাটিক টাইপিং (অর্থাত্ সময়ের আগে পরিবর্তনশীল প্রকার, শ্রেণি, ইন্টারফেস উল্লেখ করা) উভয়ই স্পষ্ট এবং ত্রুটি / বাগের সম্ভাবনা হ্রাস করে। বিষয়টিতে আপনি যেভাবেই অনুভব করেন না কেন, টাইপস্ক্রিপ্টের মতো জাভাস্ক্রিপ্টের একটি স্ট্যাটিকালি-টাইপিত সংস্করণটির জন্য কমপক্ষে অনুভূতি পাওয়া গুরুত্বপূর্ণ। নোট করুন যে টাইপসক্রিপ্টটি জাভাস্ক্রিপ্টে সংকলিত হয়েছে যাতে এটি ব্রাউজারগুলির দ্বারা ব্যাখ্যা করা যায় (যেমন, ব্রাউজারগুলি টাইপস্ক্রিপ্টের স্থানীয়ভাবে ব্যাখ্যা করে না)। 

### শেখার জায়গা এবং আইডিয়া 

- [Learn TypeScript in 5 minutes](https://medium.freecodecamp.org/learn-typescript-in-5-minutes-13eda868daeb)
- [Learn TypeScript in 50 minutes (Video)](https://www.youtube.com/watch?v=WBPrJSw7yQA)
- `create-react-app` দিয়ে টাইপস্ক্রিপ্ট 

<a name="nextjs"></a>
![NextJS](https://i.imgur.com/YNtW38J.jpg)

Next.js হ'ল সার্ভার-রেন্ডারযুক্ত রিঅ্যাক্ট অ্যাপ্লিকেশনগুলির জন্য একটি স্বল্পমাত্রার কাঠামো।

### :bulb: কুইক টেকওয়ে

এবার আমরা জটিলের দিকে যাচ্ছি! ইতিমধ্যে আপনি Raect,Vue বা Angualr দিয়ে কোনো একটি এপ্লিকেশন তৈরি করেছেন যেইটা ব্রাউজারে খুব ভাল কাজ করে। তবে বিভিন্ন কারণে আপনার এপ্লিকেশনটি সার্ভারে রেন্ডার করার দরকার হতে পারে। এই জায়গায় next.js আসে 

### শেখার জায়গা এবং আইডিয়া 

- Next.js [Getting Started](https://nextjs.org/learn/)
- [Next.js Crash Course (Video)](https://www.youtube.com/watch?v=IkOVe40Sy0U)
- Next.js  এ মাইগ্রেট করা 

# তবে  এক্স নিয়ে কিভাবে হেল্প নিবো? 

এই তালিকাটি আপনাকে ফ্রন্টএন্ডের জন্য বিস্তৃত ধারনা দেবে বলে মনে করা হচ্ছে, তবে প্রতিটি একক বিষয়কে আয়ত্তে আনা কেবল অসম্ভব।  আপনি যদি মনে করেন যে আমি খুব গুরুত্বপূর্ণ কিছু মিস করেছি, দয়া করে কীভাবে আপনি এই গাইডটিকে আরও ভাল করে তুলতে সহায়তা করতে পারেন তা দেখতে দয়া করে [Contributing](#contributing) অংশটি দেখুন।

# প্রোজেক্ট আইডিয়া 

আপনি #100DaysOfCode মাধ্যমে অগ্রগতির সাথে সাথে আপনি এক বা একাধিক প্রকল্প চাইবেন যেখানে আপনি আপনার নতুন জ্ঞান প্রয়োগ করতে পারবেন। আপনি ব্যবহার করতে পারেন এমন কয়েকটি প্রকল্পের ধারণা দেওয়ার চেষ্টা করি। বিকল্পভাবে, আপনি আপনার নিজের প্রকল্পের ধারণাগুলি নিয়ে আসতে উত্সাহিত হবেন কারণ এই ধারণাগুলি আপনাকে আরও আগ্রহী করতে এবং উত্সাহিত করতে পারে।

- প্রাথমিক ধারণা 
   - একটি পোর্টফোলিও ওয়েবসাইট তৈরি করুন
- মধ্যবর্তী / উন্নত ধারণা
   - একটি টুইট বিশ্লেষণ অ্যাপ্লিকেশন তৈরি করুন (আপনি যদি ইতিমধ্যে ব্যাক-এন্ড এবং এপিআই ইন্টিগ্রেশন জানেন তবে)


# আরো সাহায্য দরকার? 

সাধারণত, আমি নিম্নলিখিত উত্সগুলি সফ্টওয়্যার ডেভেলপমেন্ট শেখার জন্য অমূল্য পেয়েছি:
- ইস্যু গুগলিং
- [StackOverflow](http://www.stackoverflow.com)(আপনার প্রশ্নটি ইতিমধ্যে জিজ্ঞাসা করার একটি ভাল সুযোগ রয়েছে এবং গুগল করার সময় এটি একটি উচ্চ-পদমর্যাদার ফলাফল হবে)
- [Mozilla MDN Web Docs](https://developer.mozilla.org/en-US/)
- [freeCodeCamp](https://www.freecodecamp.org/)
- স্থানীয় সফটওয়্যার ডেভলপমেন্ট মিটআপস! বেশিরভাগ সমস্ত অভিজ্ঞতার স্তরের পক্ষে খুব বন্ধুত্বপূর্ণ।

# Contributing

## কথা ছড়িয়ে দিন

আপনি যদি এখানে সম্পন্ন কাজের প্রশংসা করেন তবে আপনি এই রিপো সম্পর্কে সবার মাঝে ছড়িয়ে গুরুত্বপূর্ণ অবদান রাখতে পারেন:
- রিপোটি স্টার বা ফর্ক করতে পারেন 
- এই রিপোটি সামাজিক যোগাযোগ মাধ্যমে ছড়িয়ে দিতে পারেন 


আপনি যদি আরো কিছু যুক্ত করতে চান তাহলে [টুইটারে আমার সাথে যোগাযোগ(http://www.twitter.com/nas5w) করতে পারেন। আমি আমার সাধ্য মতো সাহায্য করার চেষ্টা করবো। 
## এই রিপোতে কন্ট্রিবিউট করা 

এটি একটি কাজ চলছে এবং আমি এই জ্ঞানের ভিত্তি বজায় রাখতে যে কোনও সহায়তার প্রশংসা করি! 

এই রিপোতে অবদান রাখার সময়, দয়া করে প্রথমে কোনও পরিবর্তন করার আগে ইস্যুটির মাধ্যমে আপনি যে পরিবর্তনটি করতে চান তা নিয়ে আলোচনা করুন। অন্যথায়, আপনার প্রস্তাবনাটি বোঝা খুব কঠিন হবে এবং এর ফলে সম্ভবত আপনি প্রচুর পরিশ্রম করে এমন একটি পরিবর্তনের দিকে নিয়ে যেতে পারেন যা merge হবে না।

দয়া করে নোট করুন যে এই প্রকল্পের সাথে জড়িত প্রত্যেকেই হয় শেখার চেষ্টা করছেন বা সহায়তা করার চেষ্টা করছেন - দয়া করে সুন্দর আচরণ করুন!

## Pull Request এর নির্দেশনা 

1. আপনার প্রস্তাবনাটি আগে ইস্যু করুন 
2. প্রোজেক্ট মালিকের কাছ থেকে আগে সম্মতি নিন 
3. তারপর Pull Request করুন 