<p align="center">
  <img alt="#100DaysOfCode Front-End Development" src="https://i.imgur.com/dwYOP0B.jpg" />
</p>

---

Bạn muốn tìm hiểu thêm về Front-end development? Hãy ghé qua:
-  Đăng kí vào website của tôi  [free newsletter](https://buttondown.email/devtuts) nơi mà tôi sẽ chia sẻ một chút kiến thức frontend.
-  Đắng kí [YouTube channel](https://www.youtube.com/c/devtutsco) của tôi nơi tôi dạy JavaScript, Typescript, và React.

---

Đây là một giáo trình có phần kiên định để học phát triển front-end trong # 100DaysOfCode. Vì nó bao gồm một loạt các chủ đề phát triển front-end, nó có thể được coi là một khóa học kiểu "khảo sát" hơn là đi sâu vào bất kỳ lĩnh vực nào. Lý tưởng nhất là việc bạn hoàn thành chương trình học này sẽ là một số quen thuộc với từng chủ đề và khả năng dễ dàng đi sâu hơn vào bất kỳ lĩnh vực nào trong tương lai khi cần thiết.


Chương trình giảng dạy này bị ảnh hưởng đáng kể bởi lộ trình [Modern Frontend Developer](https://medium.com/tech-tajawal/modern-frontend-developer-in-2018-4c2072fa2b9c). Làm ơn hãy xem nó, rất tuyệt vời.

**Note**: Tôi biết  front-end development có ý nghĩa rất nhiều đối với rất nhiều người! Nếu bạn là một front-end developer và bạn nghĩ rằng hướng dẫn này có thể được cải thiện, vui lòng cho tôi biết bằng cách nêu vấn đề vào phần được mô tả [Contributing](#contributing). Cảm ơn!

# Những bản dịch

Cảm ơn một số cộng tác viên tuyệt vời mà giáo trình này được dịch ra những ngôn ngữ khác nhau.

- [Russian русский](/ru) (Dịch bởi [@Ibochkarev](https://github.com/Ibochkarev) và [@JonikUl](https://github.com/JonikUl))
- [Chinese 中文](/chinese) (Dịch bởi [@simplefeel](https://github.com/simplefeel))
- [Portuguese Português](/portuguese) (Dịch bởi  [@Zardosh](https://github.com/Zardosh))
- [Polish polski](/polish) (Dịch bởi  [@mbiesiad](https://github.com/mbiesiad))
- [Malay/Indonesia](/Malay) (Dịch bởi  [@asyraf-labs](https://github.com/asyraf-labs))
- [Vietnam Tiếng việt](/Vietnam) (Dịch bởi [@duca7](https://github.com/duca7))

# :calendar: Lộ trình học


Nguyên tắc cơ bản của kho lưu trữ này là [timeboxing](https://en.wikipedia.org/wiki/Timeboxing). Nếu bạn đã dành bất kỳ khoảng thời gian nào trước đây để cố gắng học phát triển web hoặc một kỹ năng tương tự, bạn có thể đã gặp phải tình trạng đi xuống hố sâu về một chủ đề cụ thể nào đó. Kho lưu trữ này nhằm chỉ định một số ngày nhất định cho từng công nghệ và khuyến khích bạn chuyển sang công nghệ tiếp theo khi số ngày đó đã hết.

Dự đoán rằng mọi người đều ở một mức độ thông thạo khác nhau khi bắt đầu thử thách này, và điều đó không sao cả. Các front-end developers chuyên nghiệp và mới bắt đầu đều có thể có lợi từ thực hành timeboxing trong từng lĩnh vực này.

Các hoạt động hàng ngày được đề xuất như sau:

- Ngày 1-8: [HTML](#html)
- Ngày 9-16: [CSS](#css)
- Ngày 17-24: [JavaScript Basics](#javascript)
- Ngày 25-27: [jQuery](#jquery)
- Ngày 28-33: [Responsive Web Design](#rwd)
- Ngày 34-36: [Accessibility](#accessibility)
- Ngày 37-39: [Git](#git)
- Ngày 40-44: [Node and NPM](#node)
- Ngày 45-50: [Sass](#sass)
- Ngày 51-54: [Bootstrap](#bootstrap)
- Ngày 55: [BEM](#bem)
- Ngày 57-61: [Gulp](#gulp)
- Ngày 62-65: [Webpack](#webpack)
- Ngày 66: [ESLint](#eslint)
- Ngày 68-83: [React](#react)
- Ngày 84-89: [Redux](#redux)
- Ngày 90-94: [Jest](#jest)
- Ngày 95-97: [TypeScript](#typescript)
- Ngày 98-100: [NextJS](#nextjs)

# :mag_right: Các chi tiết

Dưới đây, bạn có thể tìm thấy một chút thông tin về mỗi chủ đề trong chương trình giảng dạy cũng như một số ý tưởng / hướng dẫn về những việc cần làm cho mỗi chủ đề. Để có cảm hứng về các dự án sẽ thực hiện cùng với chương trình giảng dạy này, hãy xem [Project Ideas section](#project-ideas).


Như một phần của nguyên tắc timeboxing, sẽ không sao nếu bạn không vượt qua tất cả các mục trong phần "nguồn học và ý tưởng". Thay vào đó, bạn nên tập trung vào việc tận dụng tối đa số ngày được chỉ định cho từng lĩnh vực và sau đó tiếp tục.

<a name="html"></a>
![HTML](https://i.imgur.com/O0F5XSR.jpg)

Hypertext Markup Language (HTML) là ngôn ngữ đánh dấu siêu văn bản để tạo ra trang web và ứng dụng web. 
Với Cascading Style Sheets (CSS) và JavaScript, nó tạo thành một bộ ba công nghệ nền tảng cho World Wide Web. Trình duyệt web nhận tài liệu HTML từ máy chủ web hoặc từ bộ nhớ cục bộ và hiển thị tài liệu thành các trang web đa phương tiện. HTML mô tả cấu trúc của một trang web theo ngữ nghĩa và các dấu hiệu ban đầu được bao gồm cho sự xuất hiện của tài liệu (Source: [Wikipedia](https://en.wikipedia.org/wiki/HTML)).

### :bulb: Lời khuyên

HTML thực sự là nền tảng của sự phát triển web. Ngay cả trong các khuôn khổ dựa trên javascript, bạn vẫn phải viết HTML ở dạng này hay dạng khác.

### :book: Nguồn học và ý tưởng

- Học theo [Basic HTML and HTML5 section](https://learn.freecodecamp.org/) trên freeCodeCamp
- Cấu trúc trang HTML
- Phần tử HTML
- Lồng các phần tử HTML
- Đánh dấu ngữ nghĩa
- Liên kết / nhiều trang
- Hình ảnh
- Âm thanh/Video
- Biểu mẫu và những thành phần biểu mẫu
- Tạo một trang web nhiều trang (See [Project Ideas](#project-ideas) nếu bạn cần một số cảm hứng).

<a name="css"></a>
![CSS](https://i.imgur.com/028GOR0.jpg)

Cascading Style Sheets (CSS) là một ngôn ngữ bảng định kiểu được sử dụng để mô tả bản trình bày của tài liệu được viết bằng ngôn ngữ đánh dấu như HTML. CSS là công nghệ nền tảng của World Wide Web, cùng với HTML và JavaScript. CSS được thiết kế để cho phép tách bản trình bày và nội dung, bao gồm bố cục, màu sắc và phông chữ. Sự tách biệt này có thể cải thiện khả năng truy cập nội dung, cung cấp sự linh hoạt và kiểm soát hơn trong việc xác định các đặc điểm của bản trình bày, cho phép nhiều trang web chia sẻ định dạng bằng cách chỉ định CSS có liên quan trong một tệp .css riêng biệt, đồng thời giảm độ phức tạp và lặp lại trong nội dung cấu trúc. (Source: [Wikipedia](https://en.wikipedia.org/wiki/Cascading_Style_Sheets)).

### :bulb: Lời khuyên

Css là một thành phần thiết yếu khác của phát triển web. Mặc dù nó chủ yếu được sử dụng để tạo kiểu và định vị các phần tử HTML, nhưng nó ngày càng có khả năng thực hiện nhiều tác vụ động hơn (ví dụ: hình ảnh động) mà trước đây javascript sẽ xử lý.

### :book: Nguồn học và ý tưởng

- Học theo [Basic CSS, CSS flexbox, and CSS grid sections](https://learn.freecodecamp.org/) trên freeCodeCamp
- In-line CSS
-`<style>` thẻ
- External CSS với `<link>`
- Styling elements
- Selectors
- Floats, clearing floats
- Layouts (grid, flexbox)
- Fonts, custom fonts
- Style the HTML page(s) you made when learning HTML!

<a name="javascript"></a>
![JavaScript](https://i.imgur.com/oHdD86j.jpg)

JavaScript, thường được viết tắt là JS, là một ngôn ngữ lập trình thông dịch cấp cao phù hợp với đặc tả ECMAScript. Nó là một ngôn ngữ cũng được đặc trưng là năng động, được đánh máy yếu, dựa trên nguyên mẫu và đa mô hình. Cùng với HTML và CSS, JavaScript là một trong ba công nghệ cốt lõi của World Wide Web. JavaScript cho phép các trang web tương tác và do đó là một phần thiết yếu của các ứng dụng web. Phần lớn các trang web sử dụng nó và tất cả các trình duyệt web chính đều có một công cụ JavaScript chuyên dụng để thực thi nó. (Source: [Wikipedia](https://en.wikipedia.org/wiki/JavaScript))

### :bulb: Lời khuyên

JavaScript ngày càng trở nên quan trọng trong giới front-end. Mặc dù nó đã từng được sử dụng chủ yếu để làm cho các trang trở nên động, nhưng giờ đây nó là nền tảng của nhiều front-end frameworks . Các frameworks này xử lý rất nhiều tác vụ trước đây được xử lý bởi back-end (ví dụ: định tuyến và hiển thị các chế độ xem khác nhau).

### :book: Nguồn học và ý tưởng

- Học theo [Basic JavaScript and ES6 sections](https://learn.freecodecamp.org/) trên freeCodeCamp
- Có quá nhiều nguyên tắc cơ bản về ngôn ngữ để liệt kê ở đây!
- `<script>` thẻ và vị trí
- Truy cập các phần tử HTML
- Vòng lặp , ngăn xếp và hàng đợi
- Kế thừa
- Tham chiếu vs giá trị
- Thêm một số yếu tố động hoặc logic vào (các) trang HTML / CSS của bạn đã phát triển trước đó!

<a name="jquery"></a>
![jQuery](https://i.imgur.com/m9j02Fo.jpg)

jQuery là một thư viện JavaScript nhanh, nhỏ và nhiều tính năng. Nó làm cho những thứ như thao tác và duyệt tài liệu HTML, xử lý sự kiện, hoạt ảnh và Ajax đơn giản hơn nhiều với một API dễ sử dụng hoạt động trên vô số trình duyệt. Với sự kết hợp giữa tính linh hoạt và khả năng mở rộng, jQuery đã thay đổi cách mà hàng triệu người viết JavaScript.(Source: [jQuery.com](https://jquery.com/))

### :bulb: Lời khuyên

Sau khi bạn đã dành một thời gian với javascript đơn giản (còn được gọi là "vani"), bạn có thể thấy một số tác vụ hơi rườm rà, đặc biệt là những tác vụ liên quan đến truy cập và thao tác các phần tử HTML. Trong một thời gian dài, jQuery là thư viện truy cập để thực hiện các loại tác vụ này dễ dàng hơn và nhất quán trên các trình duyệt khác nhau. Ngày nay, jQuery không nhất thiết phải học "bắt buộc" vì những tiến bộ trong các khuôn khổ javascript, CSS và javascript mới hơn (chúng ta sẽ xem xét các khuôn khổ sau). Tuy nhiên, sẽ rất hữu ích nếu bạn dành một chút thời gian để học một số jQuery và áp dụng nó vào một dự án nhỏ.

### :book: Nguồn học và ý tưởng

- Học theo [jQuery section](https://learn.freecodecamp.org/) trên freeCodeCamp
- Document ready
- Selectors
- Chuyển đổi giữa các lớp
- Hiệu ứng
- Thêm hoặc di chuyển thuộc tính HTML
- Thêm jQuery vào trang của bạn!

<a name="rwd"></a>
![Responsive Web Design](https://i.imgur.com/Bt1zWwq.jpg)

Responsive web design (RWD) là một cách tiếp cận để thiết kế web giúp các trang web hiển thị tốt trên nhiều loại thiết bị và kích thước cửa sổ hoặc màn hình. Công việc gần đây cũng coi sự gần gũi của người xem là một phần của bối cảnh xem như một phần mở rộng cho RWD. Nội dung, thiết kế và hiệu suất là cần thiết trên tất cả các thiết bị để đảm bảo khả năng sử dụng và sự hài lòng. Trang web được thiết kế với RWD điều chỉnh bố cục phù hợp với môi trường xem bằng cách sử dụng lưới linh hoạt, dựa trên tỷ lệ, hình ảnh linh hoạt và truy vấn phương tiện CSS3, một phần mở rộng của quy tắc @media. (Source: [Wikipedia](https://en.wikipedia.org/wiki/Responsive_web_design))

### :bulb: Lời khuyên

Responsive web design là tất cả về việc làm cho các ứng dụng web trông và hoạt động bình thường trên tất cả các loại thiết bị. Một ví dụ nhanh và dễ hiểu là một trang web phải có giao diện và hoạt động bình thường cho cả trong trình duyệt web trên máy tính  và trình duyệt trên điện thoại di động. Sự hiểu biết về thiết kế đáp ứng là rất quan trọng đối với bất kỳ nhà phát triển front-end nào!

### :book: Nguồn học và ý tưởng

- Học theo [Responsive Web Design Principles section](https://learn.freecodecamp.org/) trên freeCodeCamp
- Media queries, breakpoints
- Responsive images
- Make your website responsive!
- Sử dụng Chrome DevTools để xem trang web của bạn trên các thiết bị / chế độ xem khác nhau

<a name="accessibility"></a>
![Accessibility](https://i.imgur.com/ayioMQw.jpg)

Web accessibility là thực hành toàn diện nhằm đảm bảo không có rào cản nào ngăn cản sự tương tác hoặc truy cập vào các trang web trên World Wide Web của người khuyết tật. Khi các trang web được thiết kế, phát triển và chỉnh sửa một cách chính xác, nói chung tất cả người dùng đều có quyền truy cập bình đẳng vào thông tin và chức năng. (Source: [Wikipedia](https://en.wikipedia.org/wiki/Web_accessibility))

### :bulb: Lời khuyên

Accessibility, thường được viết là a11y, là một trong những chủ đề quan trọng nhất trong phát triển web front-end, nhưng nó dường như thường bị thiếu hụt. Việc tạo ra các ứng dụng web có thể truy cập được không chỉ phù hợp về mặt đạo đức mà còn có ý nghĩa kinh doanh rất nhiều khi xem xét các đối tượng bổ sung sẽ có thể xem các ứng dụng của bạn khi họ có thể truy cập được.

### :book: Nguồn học và ý tưởng

- Học theo [Applied Accessibility section](https://learn.freecodecamp.org/) trên freeCodeCamp
- Đọc một số nội dung trên [The A11Y Project](https://a11yproject.com/about)
- Ôn lại [checklist](https://a11yproject.com/checklist)
- Cập nhật các trang web của bạn để có khả năng truy cập dựa trên danh sách kiểm tra này

<a name="git"></a>
![Git](https://i.imgur.com/5QoNJqs.jpg)

Git là một hệ thống kiểm soát phiên bản phân tán mã nguồn mở và miễn phí được thiết kế để xử lý mọi thứ từ các dự án nhỏ đến rất lớn với tốc độ và hiệu quả. (Source: [git-scm.com](https://git-scm.com/))

### :bulb: Lời khuyên

Kiểm soát phiên bản / mã là một phần thiết yếu của bộ công cụ của bất kỳ nhà phát triển web nào. Có một số hệ thống điều khiển phiên bản khác nhau, nhưng Git cho đến nay là phổ biến nhất tại thời điểm này. Bạn có thể (và nên!) Sử dụng nó để theo dõi các dự án của mình khi bạn học!

### :book: Nguồn học và ý tưởng

- [Git Tutorial for Beginners (Video)](https://www.youtube.com/watch?v=HVsySz-h9r4)
- Tải và cài đặt git
- Tạo một tài khoản trên [github](https://github.com)
- Tìm hiểu các lệnh git được sử dụng nhiều nhất:
  - init
  - clone
  - add
  - commit
  - push
  - pull
  - merge
  - rebase
-Thêm các dự án hiện có của bạn vào github!

<a name="node"></a>
![Node and NPM](https://i.imgur.com/8ik2alD.jpg)

Node.js là một môi trường chạy JavaScript đa nền tảng, mã nguồn mở, thực thi mã JavaScript bên ngoài trình duyệt. JavaScript được sử dụng chủ yếu cho tập lệnh phía máy khách, trong đó các tập lệnh viết bằng JavaScript được nhúng vào HTML của trang web và chạy phía máy khách bởi một công cụ JavaScript trong trình duyệt web của người dùng. Node.js cho phép các nhà phát triển sử dụng JavaScript để viết các công cụ dòng lệnh và để tạo tập lệnh phía máy chủ — chạy các tập lệnh phía máy chủ để tạo ra nội dung trang web động trước khi trang được gửi đến trình duyệt web của người dùng. Do đó, Node.js đại diện cho mô hình "JavaScript ở mọi nơi", thống nhất phát triển ứng dụng web xung quanh một ngôn ngữ lập trình duy nhất, thay vì các ngôn ngữ khác nhau cho các tập lệnh phía máy chủ và phía máy khách. (Source: [Wikipedia](https://en.wikipedia.org/wiki/Node.js))

### :bulb: Lời khuyên

Mặc dù Node.js thường được biết đến như một giải pháp back-end, nó được sử dụng khá thường xuyên để hỗ trợ phát triển front-end. Nó thực hiện điều này theo một số cách, bao gồm những thứ như chạy các công cụ xây dựng, thử nghiệm và linting (tất cả sẽ sớm được đề cập!). Node Package Manager (npm) là một tính năng tuyệt vời khác của Node và có thể được sử dụng để quản lý các phần phụ thuộc của dự án của bạn (tức là các thư viện mã mà dự án của bạn có thể dựa vào - jQuery là một ví dụ!).

### :book: Nguồn học và ý tưởng

- Nghiên cứu node và nó khác với trình duyệt như thế nào
- Tải node (npm sẽ xuất hiện từ đây)
- Tạo một tệp javascript đơn giản và chạy nó với node
- Sử dụng NPM để quản lý bất kỳ phần phụ thuộc nào trong (các) dự án hiện tại của bạn (ví dụ: jQuery!)

<a name="sass"></a>
![Sass](https://i.imgur.com/ZRedLge.jpg)

Sass là một phần mở rộng của CSS bổ sung thêm sức mạnh và sự sang trọng cho ngôn ngữ cơ bản. Nó cho phép bạn sử dụng các biến, quy tắc lồng nhau, mixin, nhập nội tuyến và hơn thế nữa, tất cả đều có cú pháp hoàn toàn tương thích với CSS. Sass giúp giữ cho các bảng định kiểu lớn được tổ chức tốt và thiết lập và chạy các bảng định kiểu nhỏ một cách nhanh chóng, đặc biệt với sự trợ giúp của thư viện kiểu La bàn. (Source: [sass-lang.com](https://sass-lang.com/documentation/file.SASS_REFERENCE.html))

### :bulb: Lời khuyên

Sass cho phép bạn viết CSS theo cách có lập trình hơn. Nếu bạn đã thực hiện một số CSS, bạn có thể nhận thấy rằng bạn sẽ lặp lại rất nhiều thông tin - ví dụ: chỉ định cùng một mã màu. Trong Sass, bạn có thể sử dụng những thứ như biến, vòng lặp và lồng để giảm dư thừa và tăng khả năng đọc. Sau khi viết mã của bạn trong Sass, bạn có thể nhanh chóng và dễ dàng biên dịch nó sang CSS thông thường.

### :book: Nguồn học và ý tưởng

- [Install Sass](https://sass-lang.com/install) toàn bộ với npm!
- [Sass Crash Course Video](https://www.youtube.com/watch?v=roywYSEPSvc)
- Theo dõi hướng dẫn Sass trên  [Learn Sass](https://sass-lang.com/guide) hoặc [freeCodeCamp](https://learn.freecodecamp.org/) 
- Cập nhật trang web hiện tại của bạn để tạo CSS của bạn bằng Sass!

<a name="bootstrap"></a>
![Bootstrap](https://i.imgur.com/cJ21eH2.jpg)

\* Một số lựa chọn thay thế: Foundation, Bulma, Materialize

Bootstrap là một front-end framework miễn phí và mã nguồn mở để phát triển các trang web và ứng dụng web. Nó chứa các mẫu thiết kế dựa trên HTML và CSS cho kiểu chữ, biểu mẫu, nút, điều hướng và các thành phần giao diện khác, cũng như các phần mở rộng JavaScript tùy chọn. (Source: [Wikipedia](<https://en.wikipedia.org/wiki/Bootstrap_(front-end_framework)>))

### :bulb: Lời khuyên

Có nhiều tùy chọn để bố trí, tạo kiểu và làm cho ứng dụng web của bạn trở nên năng động, nhưng bạn sẽ thấy rằng việc bắt đầu với một khuôn khổ sẽ giúp bạn rất nhiều trong việc bắt đầu. Bootstrap là một trong những framework như vậy, nhưng nó chắc chắn không phải là lựa chọn duy nhất! Tôi khuyên bạn nên làm quen với một khuôn khổ như thế này, nhưng việc nắm bắt các nguyên tắc cơ bản về HTML, CSS và JavaScript còn quan trọng hơn nhiều so với việc bị cuốn vào bất kỳ một khuôn khổ nào.

### :book: Nguồn học và ý tưởng

- Bootstrap là gì và tại sao bạn nên dùng nó
- [Bootstrap 4 Crash Course (Video)](https://www.youtube.com/watch?v=hnCmSXCZEpU)
- Hoàn thành phần Bootstrap trên [freeCodeCamp](https://learn.freecodecamp.org/)
- Cấu trúc lại trang web của bạn bằng bootstrap!

<a name="bem"></a>
![BEM](https://i.imgur.com/MCvMRQl.jpg)

Phương pháp luận Block, Element, Modifier (thường được gọi là BEM) là một quy ước đặt tên phổ biến cho các lớp trong HTML và CSS. Được phát triển bởi nhóm tại Yandex, mục tiêu của nó là giúp các nhà phát triển hiểu rõ hơn về mối quan hệ giữa HTML và CSS trong một dự án nhất định. (Source: [css-tricks.com](https://css-tricks.com/bem-101/))

### :bulb: Lời khuyên

Điều quan trọng là phải biết các hệ thống đặt tên và tổ chức như BEM tồn tại và tại sao chúng được sử dụng. Thực hiện một số nghiên cứu ở đây, nhưng ở trình độ mới bắt đầu, tôi không khuyên bạn nên dành quá nhiều thời gian cho chủ đề này.

### :book: Nguồn học và ý tưởng

- Đọc [BEM introduction](http://getbem.com/introduction/)
- [Why I Use BEM (Video)](https://www.youtube.com/watch?v=SLjHSVwXYq4)
- Tạo một trang web đơn giản bằng các quy ước BEM

<a name="gulp"></a>
![Gulp](https://i.imgur.com/KQrByqq.jpg)

Gulp là một bộ công cụ để tự động hóa các nhiệm vụ khó khăn hoặc tốn thời gian trong quy trình phát triển của bạn, vì vậy bạn có thể ngừng lộn xộn và xây dựng một thứ gì đó. (Source: [gulpjs.com](https://gulpjs.com/))

### :bulb: Lời khuyên

Trong quá trình phát triển giao diện front-end development,bạn thường thấy mình cần phải tự động hóa các tác vụ như đóng gói, di chuyển tệp và đưa tham chiếu vào tệp HTML. Gulp là một công cụ có thể giúp bạn làm những điều này!

### :book: Nguồn học và ý tưởng

- Dùng npm để cài đặt gulp
- Theo dõi [gulp for beginners tutorial](https://css-tricks.com/gulp-for-beginners/) trên CSS-Tricks
- In your website, set up gulp to:
  - Biên dịch Sass cho bạn
  - Đặt tệp CSS đã tạo vào thư mục con `build`
  - Di chuyển các trang web của bạn vào thư mục xây dựng
  - Chèn tham chiếu đến tệp CSS đã tạo của bạn vào các trang web của bạn

<a name="webpack"></a>
![Webpack](https://i.imgur.com/0rx82Kl.jpg)

Về cốt lõi, webpack là một gói mô-đun tĩnh cho các ứng dụng JavaScript hiện đại. Khi webpack xử lý ứng dụng của bạn, nó xây dựng nội bộ một biểu đồ phụ thuộc ánh xạ mọi mô-đun mà dự án của bạn cần và tạo một hoặc nhiều gói. (Source: [webpack.js.org](https://webpack.js.org/concepts/))

### :bulb: Lời khuyên

Hãy tưởng tượng rằng bạn có một dự án phát triển web lớn với một số nhà phát triển khác nhau làm việc trên nhiều nhiệm vụ khác nhau. Thay vì tất cả làm việc trong cùng một tệp, bạn có thể muốn mô-đun hóa chúng càng nhiều càng tốt. Webpack giúp kích hoạt điều này bằng cách cho phép nhóm của bạn làm việc theo mô-đun và sau đó, đến lúc xây dựng ứng dụng, Webpack sẽ gắn tất cả lại với nhau: HTML, CSS / Sass, JavasScript, hình ảnh... Webpack không phải là gói mô-đun duy nhất, nhưng nó dường như là người dẫn đầu tại thời điểm này.

### :book: Nguồn học và ý tưởng

- Đọc [webpack concepts](https://webpack.js.org/concepts/)
- [What is Webpack, How does it work? (Video)](https://www.youtube.com/watch?v=GU-2T7k9NfI)
- [This webpack tutorial](https://hackernoon.com/a-tale-of-webpack-4-and-how-to-finally-configure-it-in-the-right-way-4e94c8e7e5c1)

<a name="eslint"></a>
![ESLint](https://i.imgur.com/CJb6ZnL.jpg)

ESLint là một tiện ích viết mã JavaScript mã nguồn mở ban đầu được tạo bởi Nicholas C. Zakas vào tháng 6 năm 2013. Code linting là một loại phân tích tĩnh thường được sử dụng để tìm các mẫu hoặc mã có vấn đề không tuân thủ các nguyên tắc về kiểu nhất định. Có các linters mã cho hầu hết các ngôn ngữ lập trình và các trình biên dịch đôi khi kết hợp linting vào quá trình biên dịch. (Source: [eslint.org](https://eslint.org/docs/about/))

### :bulb: Lời khuyên

Linting là một công cụ tuyệt vời cho chất lượng mã, khả năng đọc và tính nhất quán. Sử dụng linter sẽ giúp bạn nắm bắt được các lỗi cú pháp và định dạng trước khi chúng được đưa vào sản xuất. Bạn có thể chạy linters theo cách thủ công hoặc đưa chúng vào quá trình xây dựng / triển khai của mình.

### :book: Nguồn học và ý tưởng

- Dùng để cài đặt eslint
- [How to Setup VS Code + Prettier + ESLint (Video)](https://www.youtube.com/watch?v=YIvjKId9m2c)
- Lint cho JavaScript của bạn

<a name="react"></a>
![React](https://i.imgur.com/uLYz15W.jpg)

\ * Một số lựa chọn thay thế: Vue, Angular, Ember

React (còn được gọi là React.js hoặc ReactJS) là một thư viện JavaScript để xây dựng giao diện người dùng. Nó được duy trì bởi Facebook và một cộng đồng các nhà phát triển và công ty cá nhân. React có thể được sử dụng như một cơ sở để phát triển các ứng dụng trang đơn hoặc di động. Các ứng dụng React phức tạp thường yêu cầu sử dụng các thư viện bổ sung để quản lý trạng thái, định tuyến và tương tác với API. (source: [Wikipedia](<https://en.wikipedia.org/wiki/React_(JavaScript_library)>))

### :bulb: Lời khuyên

Front-end JavaScript frameworks đi đầu trong front-end development. Một điều quan trọng ở đây là React, mặc dù cực kỳ phổ biến, chỉ là một thư viện để xây dựng giao diện người dùng trong khi các khung như Vue và Angular nhằm mục đích trở nên đầy đủ tính năng hơn. Ví dụ: nếu bạn xây dựng một ứng dụng trong React cần định tuyến đến các chế độ xem khác nhau, bạn sẽ cần đưa vào một số thứ như `react-router`.

### :book: Nguồn học và ý tưởng

- [React tutorial](https://reactjs.org/tutorial/tutorial.html)
- [Learn React with Mosh](https://www.youtube.com/watch?v=Ke90Tje7VS0)
- Cấu trúc lại trang web của bạn dưới dạng ứng dụng React!
- Note: `create-react-app` là một công cụ thuận tiện để xây dựng các dự án React mới
 
<a name="redux"></a>
![Redux](https://i.imgur.com/S9H2Dbp.jpg)

Redux là một vùng chứa trạng thái có thể dự đoán được cho các ứng dụng JavaScript. Nó giúp bạn viết các ứng dụng hoạt động nhất quán, chạy trong các môi trường khác nhau (máy khách, máy chủ và bản địa) và dễ kiểm tra. Trên hết, nó cung cấp trải nghiệm tuyệt vời cho nhà phát triển, chẳng hạn như chỉnh sửa mã trực tiếp kết hợp với trình gỡ lỗi du hành thời gian.

### :bulb: Lời khuyên

Khi bạn xây dựng các ứng dụng front-end lớn hơn và lớn hơn, bạn bắt đầu nhận ra rằng thật khó để duy trì trạng thái ứng dụng: những thứ như nếu người dùng đã đăng nhập, người dùng là ai và nói chung là những gì đang diễn ra trong ứng dụng. Redux là một thư viện tuyệt vời giúp bạn duy trì một nguồn trạng thái duy nhất mà ứng dụng của bạn có thể dựa trên logic của nó.

### :book: Nguồn học và ý tưởng

- [Redux video tutorial](https://www.youtube.com/watch?v=93p3LxR9xfM)
- [Redux video series](https://egghead.io/courses/getting-started-with-redux) bởi Dan Abramov, người tạo ra Redux
- Hãy lưu ý [Redux three principles](https://redux.js.org/introduction/three-principles)
  - Single source of truth
  - State is read-only
  - Changes are made with pure functions
- Thêm quản lí trạng thái Redux vào ứng dụng của bạn

<a name="jest"></a>
![Jest](https://i.imgur.com/Cr39axw.jpg)

Jest là một thử nghiệm JavaScript Framework thú vị tập trung vào sự đơn giản. Nó hoạt động với các dự án sử dụng: Babel, TypeScript, Node, React, Angular, Vue và hơn thế nữa! (Source: [jestjs.io](https://jestjs.io))

### :bulb: Lời khuyên

Điều rất quan trọng là phải thiết lập kiểm tra tự động cho các dự án front-end của bạn. Việc thiết lập thử nghiệm tự động sẽ cho phép bạn tự tin thực hiện các thay đổi trong tương lai - nếu bạn thực hiện các thay đổi và các thử nghiệm của bạn vẫn vượt qua, bạn sẽ khá thoải mái khi không phá vỡ bất kỳ chức năng hiện có nào. Có quá nhiều khuôn khổ thử nghiệm để liệt kê; Jest đơn giản là một trong những đặc ân của tôi.

### :book: Nguồn học và ý tưởng

- [Jest basics](https://jestjs.io/docs/en/getting-started)
- Nếu bạn đã dùng `create-react-app`, [Jest is already configured](https://facebook.github.io/create-react-app/docs/running-tests).
- Thêm thử nghiệm vào ứng dụng của bạn!

<a name="typescript"></a>
![TypeScript](https://i.imgur.com/BZROJNs.jpg)

\* Thay thế: Flow

TypeScript là một ngôn ngữ lập trình mã nguồn mở được phát triển và duy trì bởi Microsoft. Nó là một tập hợp siêu cú pháp nghiêm ngặt của JavaScript và thêm tính năng nhập tĩnh tùy chọn vào ngôn ngữ. TypeScript được thiết kế để phát triển các ứng dụng lớn và chuyển đổi sang JavaScript. Vì TypeScript là một tập hợp siêu JavaScript nên các chương trình JavaScript hiện có cũng là các chương trình TypeScript hợp lệ. TypeScript có thể được sử dụng để phát triển các ứng dụng JavaScript để thực thi cả phía máy khách và phía máy chủ (Node.js). (Source: [Wikipedia](https://en.wikipedia.org/wiki/TypeScript))

### :bulb: Lời khuyên

JavaScript được nhập động. Tuy nhiên, người ta thường tin rằng kiểu nhập tĩnh (tức là chỉ định loại biến, lớp, giao diện trước thời hạn) vừa rõ ràng hơn vừa giảm khả năng xảy ra lỗi / lỗi. Bất kể bạn cảm thấy thế nào về chủ đề này, điều quan trọng là ít nhất bạn phải có cảm nhận về phiên bản JavaScript được định kiểu tĩnh như TypeScript. Lưu ý rằng TypeScript biên dịch thành JavaScript để trình duyệt có thể hiểu nó (tức là, các trình duyệt không diễn giải TypeScript nguyên bản).

### :book: Nguồn học và ý tưởng

- [Learn TypeScript in 5 minutes](https://medium.freecodecamp.org/learn-typescript-in-5-minutes-13eda868daeb)
- [Learn TypeScript in 50 minutes (Video)](https://www.youtube.com/watch?v=WBPrJSw7yQA)
- [create a React app with TypeScript](https://levelup.gitconnected.com/typescript-and-react-using-create-react-app-a-step-by-step-guide-to-setting-up-your-first-app-6deda70843a4)

<a name="nextjs"></a>
![NextJS](https://i.imgur.com/YNtW38J.jpg)

Next.js là một khung công tác tối giản cho các ứng dụng React do máy chủ kết xuất. (Source: [Next.js — React Server Side Rendering Done Right](https://hackernoon.com/next-js-react-server-side-rendering-done-right-f9700078a3b6))

### :bulb: Lời khuyên

Bây giờ chúng tôi đang nâng cao! Bây giờ bạn đã xây dựng một ứng dụng React (hoặc Vue hoặc Angular) thực hiện khá nhiều công việc trong trình duyệt. Vì nhiều lý do khác nhau (ví dụ: SEO, lo ngại về hiệu suất của máy khách), bạn có thể thực sự muốn ứng dụng front-end của mình được hiển thị trên máy chủ chứ không phải máy khách. Đó là nơi xuất hiện một khuôn khổ như next.js.

### :book: Nguồn học và ý tưởng

- Next.js [Getting Started](https://nextjs.org/learn/)
- [Next.js Crash Course (Video)](https://www.youtube.com/watch?v=IkOVe40Sy0U)
- Tạo ứng dụng Next.js hoặc di chuyển ứng dụng hiện có của bạn sang Next.js

# Nhưng còn X thì sao?

Danh sách này được cho là sẽ cung cấp cho bạn khả năng tiếp xúc rộng rãi với hệ sinh thái front-end, nhưng đơn giản là không thể đánh vào mọi chủ đề, chưa kể đến vô số công cụ trong mỗi lĩnh vực! Nếu bạn nghĩ rằng tôi đã bỏ lỡ điều gì đó rất quan trọng, vui lòng xem [Contributing](#contributing) để xem cách bạn có thể giúp cải thiện hướng dẫn này.

# Project Ideas

Khi tiến bộ qua # 100DaysOfCode, bạn sẽ muốn có một hoặc nhiều dự án mà bạn có thể áp dụng kiến thức mới của mình. Trong phần này, tôi cố gắng cung cấp một vài ý tưởng dự án mà bạn có thể sử dụng. Ngoài ra, bạn được khuyến khích đưa ra các ý tưởng dự án của riêng mình vì những ý tưởng đó có thể quan tâm và thúc đẩy bạn nhiều hơn.

- Ý tưởng mới bắt đầu:
   - Xây dựng một trang web danh mục đầu tư
- Ý tưởng trung cấp / nâng cao:
   - Xây dựng ứng dụng phân tích tweet (Nếu bạn đã biết tích hợp back-end và API)

# Cần giúp đỡ?

Nói chung, tôi thấy các tài nguyên sau đây là vô giá để học phát triển phần mềm:

- Google khi gặp phải vấn đề
- [StackOverflow](http://www.stackoverflow.com) (Có nhiều khả năng câu hỏi của bạn đã được hỏi và sẽ là kết quả xếp hạng cao khi googling).
- [Mozilla MDN Web Docs](https://developer.mozilla.org/en-US/)
- [freeCodeCamp](https://www.freecodecamp.org/)
- Buổi họp mặt phát triển phần mềm, những cuộc họp mặt mọi người hầu hết đều rất thân thiện với mọi cấp độ kinh nghiệm.

Nếu bạn muốn tôi đóng góp bất cứ điều gì, vui lòng [connect with me on Twitter](http://www.twitter.com/nas5w) và tôi sẽ cố gắng hết sức để cung cấp một số hỗ trợ. Nếu bạn cho rằng có vấn đề với chương trình học hoặc có đề xuất, hãy xem [contributing section](#contributing) 

# Contributing

## Spread the Word

Nếu bạn đánh giá cao công việc được thực hiện ở đây, bạn có thể đóng góp đáng kể bằng cách quảng bá rộng rãi về kho lưu trữ này, bao gồm những thứ như:

- Gắn dấu sao và tạo kho lưu trữ này
- Chia sẻ kho này trên phương tiện truyền thông xã hội

## Contribute to this Repository

Đây là một công việc đang được tiến hành và tôi đánh giá rất cao mọi sự giúp đỡ trong việc duy trì cơ sở kiến thức này!

Khi đóng góp cho kho lưu trữ này, trước tiên hãy thảo luận về thay đổi bạn muốn thực hiện thông qua sự cố trước khi thực hiện thay đổi. Nếu không, sẽ rất khó để hiểu được đề xuất của bạn và có thể dẫn đến việc bạn phải thực hiện rất nhiều công việc dẫn đến một thay đổi không được hợp nhất.

Xin lưu ý rằng tất cả mọi người tham gia vào dự án này đều đang cố gắng học hỏi hoặc cố gắng giúp đỡ - Xin hãy tử tế!

## Pull Request Process

1. Tạo vấn đề phác thảo yêu cầu  pull request..
2. Nhận được sự chấp thuận của chủ dự án để thực hiện thay đổi được đề xuất.
3. Tạo pull request.