<p align="center">
  <img alt="#100DaysOfCode Front-End Development" src="https://i.imgur.com/dwYOP0B.jpg" />
</p>

---

Ingin mengetahui lebih lanjut mengenai Front-end development? Pertimbangkan:
- mendaftar untuk [buletin percuma](https://buttondown.email/devtuts) saya di mana saya secara berkala menghantar sedikit pengetahuan frontend yang mudah difahami!
- melanggan [saluran YouTube](https://www.youtube.com/c/devtutsco) saya tempat saya mengajar JavaScript, Typescript, dan React.

---

Ini adalah kurikulum yang mudah difahami untuk belajar Front-end Development bersama #100DaysOfCode. Oleh kerana ia merangkumi pelbagai topik 
Front-end Development, ini dapat dianggap sebagai lebih kepada gaya "survey" dan bukan menyelam mendalam ke salah satu bidang. Sebaik-baiknya, 
cara anda untuk menyelesaikan kurikulum ini akan menjadi kebiasaan dengan setiap topik dan keupayaan untuk menyelami lebih mudah 
ke dalam mana-mana bidang pada masa akan datang apabila perlu.

Kurikulum ini dipengaruhi secara signifikan oleh Kamran Ahmed [Modern Frontend Developer](https://medium.com/tech-tajawal/modern-frontend-developer-in-2018-4c2072fa2b9c)
peta jalan. Sila periksa - ini sangat baik.

**Nota**: Saya tahu Front-end development bermaksud banyak perkara berbeza bagi banyak orang! 
Sekiranya anda seorang Front-end Developer dan anda fikir panduan ini dapat diperbaiki, beritahu saya dengan membangkitkan masalah 
seperti yang dijelaskan di bahagian [Menyumbang](#menyumbang). Terima kasih! 

# Terjemahan

Terima kasih kepada beberapa penyumbang yang luar biasa, kurikulum ini telah diterjemahkan ke dalam bahasa berikut!

- [Russian русский](/ru) (terjemahan oleh [@Ibochkarev](https://github.com/Ibochkarev) and [@JonikUl](https://github.com/JonikUl))
- [Chinese 中文](/chinese) (terjemahan oleh [@simplefeel](https://github.com/simplefeel))
- [Portuguese Português](/portuguese) (terjemahan oleh [@Zardosh](https://github.com/Zardosh))
- [Polish polski](/polish) (terjemahan oleh [@mbiesiad](https://github.com/mbiesiad))
- [Malay/Indonesia](/Malay) (terjemahan oleh [@asyraf-labs](https://github.com/asyraf-labs))

# :calendar: Kurikulum

Prinsip asas repositori ini adalah [timeboxing](https://en.wikipedia.org/wiki/Timeboxing). Sekiranya anda telah menghabiskan banyak masa pada masa lalu 
untuk mempelajari pembangunan web atau kemahiran yang serupa, anda mungkin pernah mengalami istilah [Rabit hole](http://mhwilleke.com/rabbit-hole-learning) 
pada satu topik tertentu. 
Repositori ini bertujuan untuk menetapkan sejumlah hari untuk setiap teknologi dan mendorong anda untuk beralih ke hari berikutnya setelah jumlah hari habis.

Adalah dijangkakan bahawa setiap orang berada pada tahap kemahiran yang berbeza ketika memulakan cabaran ini, dan tidak apa-apa. 
Pembangun front-end pemula dan pakar juga dapat memanfaatkan latihan kotak masa di setiap bidang ini.

Aktiviti harian yang disyorkan adalah seperti berikut:

- Hari 1-8: [HTML](#html)
- Hari 9-16: [CSS](#css)
- Hari 17-24: [Asas JavaScript](#javascript)
- Hari 25-27: [jQuery](#jquery)
- Hari 28-33: [Responsive Web Design](#rwd)
- Hari 34-36: [Accessibility](#accessibility)
- Hari 37-39: [Git](#git)
- Hari 40-44: [Node dan NPM](#node)
- Hari 45-50: [Sass](#sass)
- Hari 51-54: [Bootstrap](#bootstrap)
- Hari 55: [BEM](#bem)
- Hari 57-61: [Gulp](#gulp)
- Hari 62-65: [Webpack](#webpack)
- Hari 66: [ESLint](#eslint)
- Hari 68-83: [React](#react)
- Hari 84-89: [Redux](#redux)
- Hari 90-94: [Jest](#jest)
- Hari 95-97: [TypeScript](#typescript)
- Hari 98-100: [NextJS](#nextjs)

# :mag_right: Perinciannya

Di bawah ini anda dapat mencari sedikit maklumat mengenai setiap topik dalam kurikulum serta beberapa idea/panduan mengenai 
apa yang harus dilakukan untuk setiap topik. Untuk inspirasi mengenai projek yang harus dilakukan bersama kurikulum ini, 
lihat bahagian [Idea Projek](#idea-projek).

Sebagai sebahagian daripada prinsip timeboxing, tidak mengapa jika anda tidak melalui semua item di bahagian "Kawasan dan Idea Pembelajaran". 
Sebaliknya anda harus fokus untuk memanfaatkan semaksimum mungkin dari jumlah hari yang diberikan untuk setiap kawasan dan kemudian teruskan.

<a name="html"></a>
![HTML](https://i.imgur.com/O0F5XSR.jpg)

Hypertext Markup Language (HTML) adalah bahasa markup standard untuk membuat laman web dan aplikasi web. 
Dengan Cascading Style Sheets (CSS) dan JavaScript, ia membentuk segitiga teknologi landasan untuk World Wide Web. 
Penyemak imbas web(Web browser) menerima dokumen HTML dari pelayan web atau dari storan tempatan dan menjadikan dokumen tersebut ke laman web multimedia. 
HTML menerangkan struktur laman web secara semantik dan pada asalnya termasuk petunjuk untuk penampilan dokumen.
(Sumber: [Wikipedia](https://en.wikipedia.org/wiki/HTML))

### :bulb: Pengetahuan Pantas

HTML benar-benar menjadi asas pengembangan web. Walaupun dalam kerangka kerja berasaskan javascript, anda akhirnya menulis HTML dalam satu bentuk atau yang lain.

### :book: Idea Pembelajaran

- Belajar [Asas HTML dan HTML5](https://learn.freecodecamp.org/) di freeCodeCamp.
- struktur halaman HTML (page structure)
- unsur HTML (elements)
- Elemen HTML bersarang (Nesting HTML elements)
- Penanda semantik (Semantic markup)
- Pautan/berbilang halaman (Links/multiple pages)
- Gambar (Images)
- Media audio / video
- Bentuk dan unsur bentuk (Forms and form elements)
- Buat laman web berbilang halaman! (Lihat [Idea Projek](#idea-projek) jika anda memerlukan sedikit inspirasi).

<a name="css"></a>
![CSS](https://i.imgur.com/028GOR0.jpg)

Cascading Style Sheets (CSS) adalah bahasa helaian gaya yang digunakan untuk menggambarkan penyampaian dokumen yang ditulis dalam bahasa markup seperti HTML. 
CSS adalah teknologi landasan World Wide Web, di samping HTML dan JavaScript. CSS dirancang untuk memungkinkan pemisahan persembahan dan kandungan, 
termasuk susun atur, warna, dan fon. Pemisahan ini dapat meningkatkan aksesibilitas kandungan, memberikan lebih banyak fleksibiliti dan kawalan dalam 
spesifikasi ciri persembahan, memungkinkan beberapa halaman web untuk berkongsi format dengan menentukan CSS yang relevan dalam fail .css yang terpisah, 
dan mengurangkan kerumitan dan pengulangan dalam kandungan struktur. (Sumber: [Wikipedia](https://en.wikipedia.org/wiki/Cascading_Style_Sheets))

### :bulb: Pengetahuan Pantas

CSS adalah satu lagi komponen penting dalam pembangunan web. Walaupun digunakan terutama untuk gaya dan meletakkan elemen HTML, 
ia semakin mampu melakukan tugas yang lebih dinamik (mis., Animasi) yang pernah dikendalikan oleh javascript.

### :book: Idea Pembelajaran

- Belajar [Asas CSS, CSS flexbox, dan CSS grid](https://learn.freecodecamp.org/) di freeCodeCamp.
- In-line CSS
- `<style>` tags
- CSS luaran dengan `<link>` (External CSS with `<link>`)
- Elemen gaya (Styling elements)
- Pemilih (Selectors)
- Floats, clearing floats
- Layouts (grid, flexbox)
- Fonts, custom fonts
- Gaya halaman HTML yang anda buat semasa belajar HTML!

<a name="javascript"></a>
![JavaScript](https://i.imgur.com/oHdD86j.jpg)

JavaScript, sering disingkat JS, adalah bahasa pengaturcaraan tingkat tinggi yang ditafsirkan yang sesuai dengan spesifikasi ECMAScript. 
Ia adalah bahasa yang juga disifatkan sebagai dinamik, lemah ketik, berdasarkan prototaip, dan multi-paradigma. Di samping HTML dan CSS, 
JavaScript adalah salah satu daripada tiga teknologi teras World Wide Web. JavaScript membolehkan halaman web interaktif dan dengan itu merupakan 
bahagian penting dalam aplikasi web. Sebilangan besar laman web menggunakannya, dan semua penyemak imbas web utama mempunyai mesin JavaScript khusus untuk 
melaksanakannya.(Sumber: [Wikipedia](https://en.wikipedia.org/wiki/JavaScript))

### :bulb: Pengetahuan Pantas

JavaScript menjadi semakin penting di dunia front-end. Walaupun dulu digunakan terutama untuk membuat halaman dinamis, 
sekarang menjadi asas banyak kerangka depan. Kerangka kerja ini menangani banyak tugas yang sebelumnya ditangani oleh bahagian belakang 
(mis., Merutekan dan menampilkan pandangan yang berbeza).

### :book: Idea Pembelajaran


- Belajar [Asas JavaScript dan ES6](https://learn.freecodecamp.org/) di freeCodeCamp.
- Terlalu banyak asas bahasa untuk disenaraikan di sini!
- `<script>` tag dan placement
- Accessing HTML elements
- The event loop, call stack, dan event queue
- Prototypal Inheritance
- Reference vs. value
- Tambahkan beberapa elemen atau logik dinamik ke halaman HTML / CSS anda yang dibangunkan lebih awal!

<a name="jquery"></a>
![jQuery](https://i.imgur.com/m9j02Fo.jpg)

jQuery adalah perpustakaan(library) JavaScript yang cepat, kecil, dan kaya dengan ciri. Ini menjadikan perkara seperti penyebaran dan manipulasi dokumen HTML, 
pengendalian acara, animasi, dan Ajax jauh lebih mudah dengan API yang mudah digunakan yang berfungsi di sebilangan besar penyemak imbas. 
Dengan gabungan fleksibiliti dan kepanjangan, jQuery telah mengubah cara berjuta-juta orang menulis JavaScript.

### :bulb: Pengetahuan Pantas

Setelah anda meluangkan masa dengan javascript biasa (juga disebut "vanilla"), anda mungkin akan mendapati beberapa tugas agak membebankan, 
terutamanya yang berkaitan dengan mengakses dan memanipulasi elemen HTML. Untuk beberapa ketika, jQuery adalah pustaka yang dituju untuk membuat tugas seperti ini lebih mudah dan konsisten di pelbagai penyemak imbas. Pada masa ini, jQuery tidak semestinya "wajib" belajar kerana kemajuan dalam javascript vanilla, CSS, dan kerangka javascript yang lebih baru (kita akan melihat kerangka kerja kemudian). Namun, adalah bermanfaat untuk meluangkan sedikit masa untuk mempelajari beberapa jQuery dan menerapkannya pada projek kecil.

### :book: Idea Pembelajaran

- Belajar [jQuery](https://learn.freecodecamp.org/) di freeCodeCamp.
- Document ready
- Selectors
- Toggle classes
- Animation
- Add or move HTML elements
- Tambahkan jQuery ke laman web anda!

<a name="rwd"></a>
![Responsive Web Design](https://i.imgur.com/Bt1zWwq.jpg)

Reka bentuk web responsif (RWD) adalah pendekatan untuk reka bentuk web yang menjadikan laman web dapat dibuat dengan baik pada pelbagai peranti dan 
tingkap atau ukuran skrin. Karya terbaru juga menganggap jarak penonton sebagai sebahagian daripada konteks tontonan sebagai lanjutan bagi RWD. 
Kandungan, reka bentuk, dan prestasi diperlukan di semua peranti untuk memastikan kebolehgunaan dan kepuasan. Laman web yang dirancang dengan 
RWD menyesuaikan susun atur ke lingkungan tontonan dengan menggunakan cairan, grid berdasarkan perkadaran, gambar fleksibel, dan pertanyaan media CSS3, 
lanjutan dari peraturan @media. (Sumber: [Wikipedia](https://en.wikipedia.org/wiki/Responsive_web_design))

### :bulb: Pengetahuan Pantas

Reka bentuk web responsif adalah membuat aplikasi web kelihatan dan berfungsi dengan baik pada semua jenis peranti. 
Contoh cepat dan kotor ialah laman web harus kelihatan dan berfungsi dengan baik baik dalam penyemak imbas web desktop dan pada penyemak imbas telefon bimbit. 
Pemahaman mengenai reka bentuk responsif sangat penting bagi mana-mana pembangun front-end!

### :book: Idea Pembelajaran

- Belajar [Reka bentuk web responsif](https://learn.freecodecamp.org/) di freeCodeCamp.
- Media queries, breakpoints
- imej responsif
- Jadikan laman web anda responsif!
- Gunakan Chrome DevTools untuk melihat laman web anda di pelbagai peranti / kawasan pandang.

<a name="accessibility"></a>
![Accessibility](https://i.imgur.com/ayioMQw.jpg)

Kebolehaksesan web adalah praktik inklusif untuk memastikan tidak ada halangan yang menghalang interaksi dengan, 
atau akses ke laman web di World Wide Web oleh orang kurang upaya. Apabila laman web dirancang, dikembangkan, dan diedit dengan betul, 
umumnya semua pengguna mempunyai akses yang sama ke maklumat dan fungsi.(Sumber: [Wikipedia](https://en.wikipedia.org/wiki/Web_accessibility))

### :bulb: Pengetahuan Pantas

Kebolehcapaian, yang sering ditulis sebagai a11y, adalah salah satu topik yang paling penting dalam pembangunan web front-end, 
namun nampaknya sering menjadi pendek. Membuat aplikasi web yang dapat diakses bukan hanya etika yang baik tetapi juga masuk akal bagi perniagaan
memandangkan penonton tambahan yang akan dapat melihat aplikasi anda apabila mereka dapat diakses.

### :book: Idea Pembelajaran

- Belajar [Kebolehcapaian](https://learn.freecodecamp.org/) di freeCodeCamp.
- Baca beberapa kandungan di [The A11Y Project](https://a11yproject.com/about)
- Semak [senarai semak](https://a11yproject.com/checklist) mereka
- Kemas kini laman web anda untuk dilayari berdasarkan senarai semak ini

<a name="git"></a>
![Git](https://i.imgur.com/5QoNJqs.jpg)

Git adalah sistem kawalan versi diedarkan sumber terbuka dan bebas yang direka untuk mengendalikan segala-galanya dari projek kecil hingga 
sangat besar dengan kelajuan dan kecekapan. (Sumber: [git-scm.com](https://git-scm.com/))

### :bulb: Pengetahuan Pantas

Kawalan versi / kod adalah bahagian penting dari mana-mana toolkit pembangun web. Terdapat sebilangan besar sistem kawalan versi yang berbeza, 
tetapi Git adalah yang paling lazim pada masa ini. Anda boleh (dan seharusnya!) Menggunakannya untuk mengesan projek anda semasa anda belajar!

### :book: Idea Pembelajaran

- [Git Tutorial untuk permulaan (Video)](https://www.youtube.com/watch?v=HVsySz-h9r4)
- Pasang git (install)
- Set up a [github](https://github.com) account
- Ketahui arahan git yang paling banyak digunakan:
  - init
  - clone
  - add
  - commit
  - push
  - pull
  - merge
  - rebase
- Tambahkan projek sedia ada anda ke Github!

<a name="node"></a>
![Node and NPM](https://i.imgur.com/8ik2alD.jpg)

Node.js adalah persekitaran waktu-terbuka JavaScript sumber terbuka dan platform yang melaksanakan kod JavaScript di luar penyemak imbas. 
JavaScript digunakan terutamanya untuk skrip sisi pelanggan, di mana skrip yang ditulis dalam JavaScript disematkan dalam HTML laman web dan 
jalankan sisi klien dengan mesin JavaScript di penyemak imbas web pengguna. Node.js memungkinkan pengembang menggunakan JavaScript untuk 
menulis alat baris perintah dan untuk skrip sisi pelayan — menjalankan skrip sisi pelayan untuk menghasilkan kandungan halaman web yang dinamis 
sebelum halaman tersebut dikirim ke penyemak imbas web pengguna. Oleh itu, Node.js mewakili paradigma "JavaScript di mana sahaja", 
menyatukan pengembangan aplikasi web di sekitar satu bahasa pengaturcaraan, dan bukannya bahasa yang berbeza untuk skrip sisi pelayan dan pelanggan.

### :bulb: Pengetahuan Pantas

Walaupun Node.js biasanya dikenali sebagai penyelesaian belakang, ia sering digunakan untuk menyokong pengembangan front-end. 
Ia melakukan ini dalam beberapa cara, termasuk perkara seperti menjalankan alat binaan, pengujian, dan pelekapan (semua akan segera dilindungi!).
Node Package Manager (npm) adalah satu lagi ciri hebat Node dan boleh digunakan untuk menguruskan pergantungan projek anda (iaitu, 
pustaka kod yang mungkin bergantung pada projek anda - jQuery adalah contoh!).

### :book: Idea Pembelajaran

- Node penyelidikan dan bagaimana ia berbeza daripada penyemak imbas
- Install node (npm comes with it)
- Buat fail javascript sederhana dan jalankan dengan nod
- Gunakan NPM untuk menguruskan kebergantungan dalam projek anda yang ada (mis., JQuery!)

<a name="sass"></a>
![Sass](https://i.imgur.com/ZRedLge.jpg)

Sass adalah lanjutan dari CSS yang menambah kekuatan dan keanggunan pada bahasa asas. Ini membolehkan anda menggunakan pemboleh ubah, peraturan bersarang,
mixin, import sebaris, dan banyak lagi, semuanya dengan sintaks yang sepenuhnya sesuai dengan CSS. Sass membantu memastikan lembaran gaya besar 
disusun dengan baik, dan menyusun lembaran gaya kecil dengan cepat, terutamanya dengan bantuan perpustakaan gaya Kompas.
(Sumber: [sass-lang.com](https://sass-lang.com/documentation/file.SASS_REFERENCE.html))

### :bulb: Pengetahuan Pantas

Sass membolehkan anda menulis CSS dengan cara yang lebih teratur. Sekiranya anda telah melakukan beberapa CSS, anda mungkin menyedari bahawa 
anda akhirnya mengulang banyak maklumat - misalnya, menentukan kod warna yang sama. Di Sass, anda boleh menggunakan perkara seperti pemboleh ubah, gelung, 
dan bersarang untuk mengurangkan kelebihan dan meningkatkan kebolehbacaan. Setelah menulis kod anda di Sass, 
anda dapat mengumpulkannya dengan cepat dan mudah ke CSS biasa.

### :book: Idea Pembelajaran

- [Install Sass](https://sass-lang.com/install) globally with npm!
- [Sass Crash Course Video](https://www.youtube.com/watch?v=roywYSEPSvc)
- Follow the [Learn Sass](https://sass-lang.com/guide) tutorial and/or [freeCodeCamp](https://learn.freecodecamp.org/) Sass tutorial.
- Kemas kini laman web anda yang ada untuk menghasilkan CSS anda menggunakan Sass!


<a name="bootstrap"></a>
![Bootstrap](https://i.imgur.com/cJ21eH2.jpg)

\* Some alternatives: Foundation, Bulma, Materialize

Bootstrap adalah kerangka depan dan sumber terbuka yang terbuka untuk membangunkan laman web dan aplikasi web. 
Ini berisi templat reka bentuk berbasis HTML dan CSS untuk tipografi, bentuk, butang, navigasi, dan komponen antara muka lain, 
serta sambungan JavaScript pilihan.
(Sumber: [Wikipedia](<https://en.wikipedia.org/wiki/Bootstrap_(front-end_framework)>))

### :bulb: Pengetahuan Pantas

Terdapat banyak pilihan untuk menyusun, menggayakan, dan menjadikan aplikasi web anda dinamis, tetapi anda akan mendapati bahawa bermula dengan kerangka kerja
sangat membantu anda dalam memulai. Bootstrap adalah salah satu kerangka seperti itu, tetapi ia pasti jauh dari satu-satunya pilihan! 
Saya cadangkan untuk membiasakan diri dengan satu kerangka seperti ini, tetapi jauh lebih penting untuk memahami asas HTML, CSS dan JavaScript daripada 
terjebak dalam satu kerangka.

### :book: Idea Pembelajaran

- Ketahui apa itu Bootstrap dan mengapa anda mahu menggunakannya
- [Bootstrap 4 Crash Course (Video)](https://www.youtube.com/watch?v=hnCmSXCZEpU)
- Complete the Bootstrap section on [freeCodeCamp](https://learn.freecodecamp.org/)
- Refactor laman web anda menggunakan bootstrap!

<a name="bem"></a>
![BEM](https://i.imgur.com/MCvMRQl.jpg)

Metodologi Blok, Elemen, Pengubah (biasanya disebut sebagai BEM) adalah konvensyen penamaan yang popular untuk kelas dalam HTML dan CSS. 
Dibangunkan oleh pasukan di Yandex, tujuannya adalah untuk membantu pembangun memahami dengan lebih baik hubungan antara HTML dan CSS dalam projek tertentu.

### :bulb: Pengetahuan Pantas

Penting untuk mengetahui sistem penamaan dan organisasi seperti BEM wujud dan mengapa ia digunakan. 
Lakukan penyelidikan di sini, tetapi pada peringkat pemula, saya tidak akan mengesyorkan untuk meluangkan banyak masa untuk subjek ini.

### :book: Idea Pembelajaran

- Baca pengenalan [BEM](http://getbem.com/introduction/)
- [Kenapa saya guna BEM (Video)](https://www.youtube.com/watch?v=SLjHSVwXYq4)
- Buat laman web mudah menggunakan konvensyen BEM.

<a name="gulp"></a>
![Gulp](https://i.imgur.com/KQrByqq.jpg)

Gulp adalah alat untuk mengautomasikan tugas yang menyakitkan atau memakan masa dalam aliran kerja pembangunan anda, 
jadi anda boleh berhenti bermain-main dan membina sesuatu. (Sumber: [gulpjs.com](https://gulpjs.com/))

### :bulb: Pengetahuan Pantas

Dalam pengembangan front-end moden, anda sering mendapati diri anda perlu mengotomatisasi tugas seperti membundel, memindahkan fail, 
dan memasukkan rujukan ke dalam fail HTML. Gulp adalah salah satu alat yang dapat membantu anda melakukan perkara-perkara ini!

### :book: Idea Pembelajaran

- Install gulp with npm
- Ikuti [gulp untuk permulaan tutorial](https://css-tricks.com/gulp-for-beginners/) di CSS-Tricks
- Di laman web anda, sediakan gulp dengan cara:
  - Compile Sass for you
  - Put the generated CSS file in `build` subdirectory
  - Move your web pages to the build directory
  - Inject a reference to your generated CSS file into your web pages
  
 <a name="webpack"></a>
![Webpack](https://i.imgur.com/0rx82Kl.jpg)

Pada intinya, webpack adalah penyusun modul statik untuk aplikasi JavaScript moden. Apabila beg web memproses aplikasi anda, 
secara dalaman akan membina grafik kebergantungan yang memetakan setiap modul yang diperlukan oleh projek anda dan menghasilkan 
satu atau lebih kumpulan. (Sumber: [webpack.js.org](https://webpack.js.org/concepts/))

### :bulb: Pengetahuan Pantas

Bayangkan bahawa anda mempunyai projek pembangunan web yang besar dengan sebilangan pembangun berbeza yang mengerjakan banyak tugas yang berbeza. 
Daripada semua bekerja dalam fail yang sama, anda mungkin ingin memodelkannya sebanyak mungkin. Webpack membantu mengaktifkannya 
dengan membiarkan pasukan anda bekerja secara modular dan kemudian, tiba waktunya untuk membina aplikasi, Webpack akan menyatukan semuanya: 
HTML, CSS / Sass, JavasScript, gambar, dll. Webpack bukan satu-satunya bundler modul, tetapi nampaknya untuk menjadi pelopor pada masa ini.

### :book: Idea Pembelajaran


- Baca [webpack](https://webpack.js.org/concepts/) konsep
- [What is Webpack, How does it work? (Video)](https://www.youtube.com/watch?v=GU-2T7k9NfI)
- [webpack tutorial](https://hackernoon.com/a-tale-of-webpack-4-and-how-to-finally-configure-it-in-the-right-way-4e94c8e7e5c1)

<a name="eslint"></a>
![ESLint](https://i.imgur.com/CJb6ZnL.jpg)

ESLint adalah utiliti peletakan JavaScript sumber terbuka yang pada mulanya dibuat oleh Nicholas C. Zakas pada bulan Jun 2013.
Penyisipan kod adalah sejenis analisis statik yang sering digunakan untuk mencari corak atau kod bermasalah yang tidak mematuhi garis panduan gaya tertentu. 
Terdapat linting kod untuk kebanyakan bahasa pengaturcaraan, dan penyusun kadang-kadang memasukkan linting ke dalam proses penyusunan

### :bulb: Pengetahuan Pantas

Linting adalah alat yang hebat untuk kualiti kod, kebolehbacaan, dan ketekalan. Menggunakan linter akan membantu anda menangkap kesilapan sintaks 
dan format sebelum mereka memulakan produksi. Anda boleh menjalankan linters secara manual atau memasukkannya dalam proses build / deployment anda.

### :book: Idea Pembelajaran

- Install eslint menggunakan npm
- [How to Setup VS Code + Prettier + ESLint (Video)](https://www.youtube.com/watch?v=YIvjKId9m2c)
- Lint your JavaScript

<a name="react"></a>
![React](https://i.imgur.com/uLYz15W.jpg)

\* Some alternatives: Vue, Angular, Ember, Svelte

React (juga dikenali sebagai React.js atau ReactJS) adalah perpustakaan JavaScript untuk membina antara muka pengguna.
Ia dikendalikan oleh Facebook dan komuniti pemaju dan syarikat individu. React dapat digunakan sebagai asas dalam pengembangan aplikasi satu halaman 
atau mudah alih. Aplikasi React Kompleks biasanya memerlukan penggunaan perpustakaan tambahan untuk pengurusan negara, penghalaan, dan interaksi dengan API.
(Sumber: [Wikipedia](<https://en.wikipedia.org/wiki/React_(JavaScript_library)>))

### :bulb: Pengetahuan Pantas

Kerangka JavaScript front-end berada di barisan hadapan pembangunan front-end moden. Satu perkara penting di sini adalah bahawa React, 
walaupun sangat popular, hanya perpustakaan untuk membina antara muka pengguna sedangkan kerangka kerja seperti Vue dan Angular bertujuan untuk
menjadi lebih lengkap. Sebagai contoh, jika anda membina aplikasi dalam React yang perlu mengarahkan ke pandangan yang berbeza, anda perlu membawa sesuatu 
seperti `react-router`.

### :book: Idea Pembelajaran

- Belajar [React tutorial](https://reactjs.org/tutorial/tutorial.html)
- [Belajar React bersama Mosh](https://www.youtube.com/watch?v=Ke90Tje7VS0)
- Refactor laman web anda sebagai aplikasi React!
- Nota: `create-react-app` adalah alat yang sesuai untuk membuat perancah projek React baru.

<a name="redux"></a>
![Redux](https://i.imgur.com/S9H2Dbp.jpg)

Redux adalah wadah keadaan yang boleh diramal untuk aplikasi JavaScript. Ini membantu anda menulis aplikasi yang berkelakuan secara konsisten, 
berjalan di persekitaran yang berbeza (pelanggan, pelayan, dan asli), dan mudah diuji. Di samping itu, ia memberikan pengalaman pembangun yang hebat, 
seperti penyuntingan kod langsung yang digabungkan dengan penyahpepijat perjalanan masa.

### :bulb: Pengetahuan Pantas

Semasa anda membina aplikasi front-end yang lebih besar dan besar, anda mula menyedari bahawa sukar untuk mengekalkan keadaan aplikasi: 
perkara seperti jika pengguna log masuk, siapa pengguna, dan umumnya apa yang berlaku dalam aplikasi. 
Redux adalah perpustakaan hebat yang membantu anda mengekalkan satu sumber keadaan di mana aplikasi anda dapat mendasari logiknya.

### :book: Idea Pembelajaran

- This [Redux video tutorial](https://www.youtube.com/watch?v=93p3LxR9xfM)
- This [Redux video series](https://egghead.io/courses/getting-started-with-redux) by Dan Abramov, creator of Redux
- Take note of the [Redux three principles](https://redux.js.org/introduction/three-principles)
  - Single source of truth
  - State is read-only
  - Changes are made with pure functions
- Add Redux state management to your app!

<a name="jest"></a>
![Jest](https://i.imgur.com/Cr39axw.jpg)

Jest adalah Kerangka Pengujian JavaScript yang menarik dengan fokus pada kesederhanaan. Ia berfungsi dengan projek yang menggunakan: 
Babel, TypeScript, Node, React, Angular, Vue, dan banyak lagi! (Sumber: [jestjs.io](https://jestjs.io))

### :bulb: Pengetahuan Pantas

Adalah sangat penting untuk membuat ujian automatik untuk projek akhir anda. Menyiapkan ujian automatik akan membolehkan anda membuat perubahan 
di masa depan dengan yakin - jika anda membuat perubahan dan ujian anda masih lulus, anda akan merasa cukup selesa kerana anda tidak mematahkan fungsi yang ada. 
Terdapat terlalu banyak kerangka ujian untuk disenaraikan; Jest hanyalah salah satu kegemaran saya.

### :book: Idea Pembelajaran

- Belajar [asas Jest](https://jestjs.io/docs/en/getting-started)
- Jika awak menggunakan `create-react-app`, [Jest is already configured](https://facebook.github.io/create-react-app/docs/running-tests).
- Tambahkan ujian ke aplikasi anda!

<a name="typescript"></a>
![TypeScript](https://i.imgur.com/BZROJNs.jpg)

TypeScript adalah bahasa pengaturcaraan sumber terbuka yang dikembangkan dan dikendalikan oleh Microsoft. Ini adalah superset sintaksis JavaScript yang ketat,
dan menambahkan penaipan statik pilihan pada bahasa. TypeScript direka untuk pengembangan aplikasi besar dan transkompil ke JavaScript. Oleh kerana 
TypeScript adalah superset JavaScript, program JavaScript yang ada juga merupakan program TypeScript yang sah. TypeScript dapat digunakan untuk 
mengembangkan aplikasi JavaScript untuk pelaksanaan sisi klien dan sisi pelayan (Node.js). (Sumber: [Wikipedia](https://en.wikipedia.org/wiki/TypeScript))

### :bulb: Pengetahuan Pantas

JavaScript ditaip secara dinamik. Walau bagaimanapun, adalah kepercayaan umum bahawa menaip statik (iaitu, menentukan jenis, kelas, 
antara muka yang berubah-ubah lebih awal) lebih jelas dan mengurangkan kemungkinan kecacatan / bug. Terlepas dari bagaimana perasaan anda mengenai topik ini, 
paling tidak penting untuk merasakan versi JavaScript yang ditaip secara statik seperti TypeScript. Perhatikan bahawa TypeScript menyusun ke JavaScript 
sehingga dapat ditafsirkan oleh penyemak imbas (iaitu, penyemak imbas tidak mentafsirkan TypeScript secara asli).

### :book: Idea Pembelajaran

- [Belajar TypeScript dalam 5 minutes](https://medium.freecodecamp.org/learn-typescript-in-5-minutes-13eda868daeb)
- [Belajar TypeScript dalam 50 minutes (Video)](https://www.youtube.com/watch?v=WBPrJSw7yQA)
- Optionally [create a React app with TypeScript](https://levelup.gitconnected.com/typescript-and-react-using-create-react-app-a-step-by-step-guide-to-setting-up-your-first-app-6deda70843a4)

<a name="nextjs"></a>
![NextJS](https://i.imgur.com/YNtW38J.jpg)

Next.js adalah kerangka minimalis untuk aplikasi React yang diberikan pelayan(server-side render).(Source: [Next.js — React Server Side Rendering Done Right](https://hackernoon.com/next-js-react-server-side-rendering-done-right-f9700078a3b6))

### :bulb: Pengetahuan Pantas

Sekarang kita semakin maju! Sekarang anda telah membina aplikasi React (atau Vue atau Angular) yang tidak banyak berfungsi dalam penyemak imbas. 
Atas pelbagai alasan (mis., SEO, kebimbangan terhadap prestasi pelanggan), anda mungkin mahu aplikasi depan anda diberikan pada pelayan dan bukannya pelanggan. 
Di situlah kerangka seperti next.js masuk.

### :book: Idea Pembelajaran

- Next.js [Getting Started](https://nextjs.org/learn/)
- [Next.js Crash Course (Video)](https://www.youtube.com/watch?v=IkOVe40Sy0U)
- Create a Next.js app or migrate your existing app to Next.js

# Tetapi Bagaimana dengan X?

Senarai ini seharusnya memberi anda pendedahan luas mengenai ekosistem front-end, tetapi mustahil untuk menyentuh setiap topik, 
apatah lagi pelbagai alat di setiap kawasan! Sekiranya anda rasa saya terlepas sesuatu yang sangat penting, sila lihat bahagian 
[Menyumbang] (# menyumbang) untuk melihat bagaimana anda dapat membantu menjadikan panduan ini lebih baik.

# Idea Projek

Semasa anda melalui # 100DaysOfCode, anda memerlukan satu atau beberapa projek di mana anda boleh menggunakan pengetahuan baru anda. 
Pada bahagian ini, saya cuba memberikan beberapa idea projek yang boleh anda gunakan. Sebagai alternatif, 
anda digalakkan untuk mengemukakan idea projek anda sendiri kerana idea tersebut mungkin menarik dan memotivasi anda.

- Idea pemula:
  - Bina laman web portfolio
- Idea pertengahan / lanjutan:
  - Bina aplikasi analisis tweet (If you know back-end and API integration already)
  
 # Perlukan Pertolongan ?
 
 Secara amnya, saya dapati sumber-sumber berikut sangat berharga untuk mempelajari pembangunan perisian:
 
 - Googling the issue
- [StackOverflow](http://www.stackoverflow.com) (Ada kemungkinan besar pertanyaan anda telah diajukan dan akan menjadi hasil peringkat tinggi ketika melakukan googling).
- [Mozilla MDN Web Docs](https://developer.mozilla.org/en-US/)
- [freeCodeCamp](https://www.freecodecamp.org/)
- Mesyuarat pembangunan perisian tempatan(meetup)! Sebilangan besar sangat ramah kepada semua peringkat pengalaman.

Sekiranya anda mahukan input saya mengenai apa-apa, jangan ragu untuk [berhubung dengan saya di Twitter](http://www.twitter.com/nas5w) 
dan saya akan berusaha sebaik mungkin untuk menawarkan bantuan. Sekiranya anda rasa ada masalah dengan kurikulum atau mempunyai cadangan, 
lihat [bahagian penyumbang](#menyumbang) di bawah.

# Menyumbang

## Sebarkan

Sekiranya anda menghargai kerja yang dilakukan di sini, anda boleh memberi sumbangan yang besar dengan menyebarkan berita mengenai repositori ini, termasuk perkara seperti:

- Membintangi dan memalsukan repositori ini
- Berkongsi repositori ini di media sosial

## Sumbang ke Repositori ini

Ini adalah kerja yang sedang berjalan dan saya sangat menghargai apa-apa pertolongan dalam mengekalkan pangkalan pengetahuan ini!

Semasa menyumbang ke repositori ini, sila bincangkan terlebih dahulu perubahan yang ingin anda lakukan melalui isu sebelum membuat perubahan. 
Jika tidak, sangat sukar untuk memahami cadangan anda dan berpotensi mengakibatkan anda melakukan banyak usaha untuk perubahan yang tidak akan digabungkan.

Harap maklum bahawa semua orang yang terlibat dalam projek ini sama ada berusaha belajar atau cuba menolong - Harap bersikap baik!

## Proses Permintaan Tarik (pull request)

1. Buat masalah(issue) yang menggariskan permintaan tarik yang dicadangkan.
2. Dapatkan persetujuan daripada pemilik projek untuk membuat perubahan yang dicadangkan.
3. Buat permintaan tarik(pull request).
