# TorPleng🎙

การต่อเพลงไทยที่ยาวที่สุดในประวัติศาสตร์

## Rules

- เนื้อเพลงที่มาต่อ ต้องมีความยาวอย่างน้อย 1 ประโยค และจบด้วยคำสุดท้ายของประโยคนั้น
- คำหรือวลีที่มาต่อ ต้องเป็นคำเดียวกับคำสุดท้ายของเพลงที่แล้ว หรือพ้องเสียง
- เป็นเพลงไทย ที่มีคลิปบนเว็บ Youtube แนบคลิปพร้อมเวลาของท่อนเพลงที่จะใช้
- กฎอาจมีการเพิ่มเติม หรือยกเว้น ตามความเหมาะสม
- ไม่ใช้ท่อนเดิม จากเพลงเดิมซ้ำ
- เรียงลำดับเพลงจาก Pull Request ที่เปิดก่อน
- หากท่อนล่าสุดไม่สามารถต่อได้ หรือต่อยาก จะมีข้อยกเว้นให้ตามลำดับ
  - เพิ่มท่อนเพลงล่าสุดอีก 1-2 ประโยค เพื่อเปลี่ยนคำที่จะมาต่อ [ตัวอย่าง](https://github.com/narze/torpleng/pull/96)
  - หากไม่สามารถเพิ่มท่อนเพลงได้ อนุโลมให้ใช้คำที่ 2 หรือ 3 ของเพลงที่มาต่อได้ โดยใส่วงเล็บครอบคำที่ข้ามไป [ตัวอย่าง](https://github.com/narze/torpleng/pull/27)
  - ให้นำท่อนล่าสุดออกและเปลี่ยนเพลงได้ (ไม่แนะนำ เพราะเป็นการลบเพลงของคนอื่น)

## Pull Request

- ไม่แก้ไขไฟล์ README.md โดยตรง (ไฟล์จะถูกจัดการด้วย append_on_merge GitHub action)
- สร้างไฟล์ในโฟล์เดอร์ input ด้วย[ลิงก์นี้](https://github.com/narze/torpleng/new/main?filename=input/) โดยใช้ Format ตามตัวอย่าง (อย่าลืม `-` นำหน้าบรรทัด)
```markdown
- ดีแล้ว ที่เธอกระทำอยู่ทุกวันนี้ [สหายแห่งสายลม - ดีแล้ว](https://youtu.be/52rn8wsfxSM?t=52&end=59)
```
- สร้าง Pull Request

## Format

- เนื้อเพลงที่นำมาต่อ
- ชื่อเพลง
- ชื่อศิลปิน หรือวง
- ลิงก์ของคลิป Youtube พร้อมเวลาของท่อนเพลงที่นำมาต่อ และวินาทีที่ท่อนนั้นจบ โดยตัด Query String อื่นๆ ออก เช่น https://youtu.be/T6F6hOKPCo4?t=71&end=82 (`t=วินาทีที่เริ่ม` จะได้จากการกดแชร์คลิปบนเว็บ Youtube ส่วน `end=วินาทีที่จบ` ต้องใส่เองโดยคั่นด้วยตัว `&`)

![image](https://user-images.githubusercontent.com/248741/194059671-357a8b94-9ae2-46cb-aa60-498a27f34605.png)

## Features

- Render with HTML (Vue.js) - Done by @neizod :pray:
- Validate format with Github Actions

## Entries

- ขวัญเจ้าเอยขวัญมาใยหนอล่องลอยหลุดไป อยู่ที่ไหนช่วยบอกได้ไหมใจ ใยถึงไม่คืนกลับมา [Palmy - ขวัญเอยขวัญมา](https://youtu.be/T6F6hOKPCo4?t=71&end=82)
- กลับมาได้หรือเปล่า กลับมาหาฉันทีได้ไหมคนดี [2 Day ago Kids - กลับมา](https://youtu.be/8M9N_eZh4KQ?t=70&end=87)
- ดีแล้ว ที่เธอกระทำอยู่ทุกวันนี้ [สหายแห่งสายลม - ดีแล้ว](https://youtu.be/52rn8wsfxSM?t=52&end=59)
- วันนี้ วันไหน อยากให้เธอมั่นใจ ว่าไม่ว่าเธอฝันอย่างไหน แม้มันจะไกลสุดไกลเท่าไร [Bodyslam - ทางของฉัน ฝันของเธอ](https://youtu.be/TgvXisKG2CY?t=47&end=64)
- เท่าไหร่ก็ไม่จำ ไม่สำคัญ แค่ฉันลืมตามาพบเธอ เหมือนแสงส่องทาง ที่ดูงดงาม เหมือนเป็นคำถาม ที่คำตอบก็คือเธอ [POTATO - เท่าไหร่ไม่จำ](https://youtu.be/UHKS37Inpdc?t=203&end=224)
- เธอ เธอยังคิดถึงฉันไหม เมื่อสองเรานั้นยังคงห่างไกล เมื่อเวลาพาเราให้ไกลกัน รู้บ้างไหมคนไกลยังคงหวั่นไหว เมื่อเขามองดูภาพเธอทีไร น้ำตามันยังไหลออกมา [COCKTAIL - เธอ](https://youtu.be/nY9sHiZ4bTU?t=88&end=116)
- มาทำไมให้อายบ้านนา เล่านวลน้อง ไม่ต้องกลับคืนมา [ทิดเซียง - กลับมาทำไม](https://youtu.be/tw5LTC__YWk?t=24&end=31)
- มารักทำไมตอนนี้ ตอนที่จะเสียฉันไป ทั้งๆ ที่ฉันทุ่มให้หมดใจ แต่เธอกลับทิ้งมัน [Am Fine - มารักทำไมตอนนี้](https://youtu.be/maz6gnq-n6g?t=12&end=26)
- มันเจ็บจะขาดใจอยู่ตรงหน้าเธอ แต่ต้องเก็บไว้ไม่แสดงว่าเสียใจ [Pancake - ขาดใจ](https://youtu.be/l9MRG7XV3V0?t=43&end=58)
- ใจมันยังเกเรเสมอไม่เคยจะเชื่อฟัง [Nice 2 Meet U - ใจเกเร](https://youtu.be/zDQeip3CPzI?t=102&end=109)
- ฟังเสียงใครต่อใครมากกว่าหัวใจตัวเราเองสวยงามคนเราแล้วแต่ใจใคร [SIN feat. โอม Cocktail - ฟัง](https://youtu.be/f05VJ1moOKE?t=162&end=170)
- ใครกันที่ทำให้ฉันรัก ใครกันที่มาอยู่ในความฝัน คนที่ฉันคิดถึงอยู่ทุกวัน ก็ใครคนนั้น ฉันเรียกว่าเธอ [ALL KAMIKAZE - รักฉันเรียกว่าเธอ](https://youtu.be/iRCb_PodGfQ?t=13&end=25)
- เธอยังคิดถึงฉันทุกนาทีอยู่หรือเปล่า เธอยังจำเรื่องเราในวันวานได้หรือไม่ เธอยังมีใจให้ฉันคนเดียว ยังรอฉันแค่คนเดียว เธอยังคงเป็นเหมือนเดิมอยู่ใช่ไหม ช่วยบอกให้รู้ที [POTATO - เธอยัง](https://www.youtube.com/watch?v=bNVxKaPxr6w&t=79s&end=107)
- ทีใครทีมัน หนทางยังอีกไกล คราวใครคราวมัน วัดกันไปจนวันสุดท้าย วันสุดท้าย ฮูว ฮูว.. [25hours - ทีใครทีมัน](https://youtu.be/hFse57E5Bw8?t=47&end=63)
- Hula Hula, Hoo la la la ไปทะเล Hoorey Hoorey, Yeah yeah ทุกเวลา [HULA HULA - 2005 ทิวา Hula Hula](https://youtu.be/BQHL4rwGc68?t=16&end=23)
- เวลาที่เราได้มองตากัน ไม่รู้ว่าเธอสงสัยฉันบ้างไหม ว่าใครคนนึงเฝ้ามองเธออยู่ และเขาก็อยากให้เธอได้รู้ใจ [Whal & Dolph - ใจเดียว](https://youtu.be/p5CsJurJ5Lo?t=89&end=104)
- ใจฉันไม่ได้รู้สึก เหมือนครั้งที่เราได้เจอกันเมื่อก่อนนั้น [Whal & Dolph - ไม่รู้ทำไม](https://youtu.be/CCxlsWFH3Nc?t=39&end=46)
- (เมื่อเรา)นั้นคิดจะปิด ทุกความสัมพันธ์ใดๆ ร่างกายมีเพียงแค่ฉันและเธอ [Musketeers - ใจความสำคัญ](https://youtu.be/rw1BXzZgoPc?t=37&end=44)
- เธอ เธอทั้งนั้นที่ทำ ให้ช่วงชีวิตของฉันน่าจดจำ [Groove Riders - เธอทั้งนั้น](https://youtu.be/f-eE1z1Pv7Y?t=40&end=53)
- จำเก่งจนไม่เคยลืมเธอ [F.HERO x Tilly Birds - จำเก่ง](https://youtu.be/7iSia7rb1PY?t=92&end=95)
- เธอไม่เคยเอ่ยคำว่ารักกัน มีแต่ฉันที่คิดไปฝ่ายเดียว ที่อยู่กับฉันใช้เวลาด้วยกัน นั่นเพียงฉันแค่คิด [ส้ม มารี - หรือฉันคิดไปเอง](https://youtu.be/UfgPHAZD5e0?t=65&end=77)
- คิด(แต่ไม่) ถึง คิด คิด(แต่ไม่) ถึงเธอ [Tilly Birds - คิด(แต่ไม่)ถึง](https://youtu.be/dJ9uVVNWClk?t=38&end=44)
- เธอคงไม่รู้ ว่าฉันเองยังไม่มีใคร หากเป็นเธอ ก็คงเข้าที เธออาจจะมีใคร คนนั้นที่แสนดี [LOSO - ฝนตกที่หน้าต่าง](https://youtu.be/SXy-v1KbF4k?t=53&end=69)
- ดีแล้วได้อะไร เมื่อใจทั้งใจ เธอให้เขา [KOOKKI - ดีแล้วได้อะไร](https://youtu.be/Kzr04RysKdI?t=33&end=41)
- เขาเดินจากไปแล้วไม่ต้องคิดถึง ไม่ต้องนึกถึงเขาอีกแล้ว [wonderframe - เขาไปแล้ว](https://youtu.be/paIrJvhXFXU?t=71&end=78)
- แล้วฉันเลือกอะไรได้ไหม เลือกให้เธอไม่ไปได้หรือเปล่า [ZAZA - เลือกได้ไหม](https://youtu.be/xoP_kqiqRgM?t=112&end=119)
- เปล่า ไม่มีเขานอกเหนือจิตใจ ไม่มีรัก จะหลงผู้ใด [สุนทราภรณ์ - เปล่า](https://youtu.be/CsIdMaYOQZk?t=53&end=60)
- ผู้ใดเข้ามาไม่เคยไหวหวั่น เหมือนใจฉันเกิดมาเพื่อเป็นของเธอ [ไอซ์ ศรัณยู - บุพเพสันนิวาส](https://youtu.be/uNWIeZWD4sw?t=82&end=89)
- เธอจะรักฉันได้ไหม ถ้าเธอยังไม่รักใคร อยากให้เธอเปิดใจให้กัน [INSTINCT - เธอจะรักฉันได้ไหม](https://youtu.be/zJ0YMTvh3d4?t=70&end=79)
- กัญชามาแล้ว มาแล้วมาช่วยผู้คนที่ทุกข์ทน ไม่ว่ารวยหรือจน ก็ใช้ได้เพียงป้ายใต้ลิ้นก็พอ [เล็ก คาราบาว - กัญชามาแล้ว](https://youtu.be/Vft3czE3UQc?t=79&end=94)
- พอแล้วพอ พอฉันพอดีกว่า คิดไปเองทำให้ใจต้องเจ็บ สุขเพียงสุขเล็กน้อยยามพบคนถูกใจ แต่พอเจ็บมันเจ็บเกินใครเป็นเพราะใจเราบางเหลือเกิน [Joe Pause - ใจบางบาง](https://youtu.be/bJJ4MmIElfA?t=95&end=125)
- เกินกว่าคำว่ารัก มันมากกว่าคำว่าผูกพัน แค่พูดว่าเราเป็นเพื่อนกัน เท่านั้นพอ [หั่ง - เกินกว่ารัก มากกว่าผูกพัน](https://youtu.be/K_ygchXBLGg?t=55&end=66)
- พอเสียที กับชีวิตที่ต้องมีเธอต่อไป [Atom ชนกันต์ - พอ](https://youtu.be/4_fRHGZdkuA?t=122&end=131)
- ไปทั้งหัวใจเลย เธอไม่ต้องกังวล ความรู้สึกนี้ไม่ต้องใช้ช้อนคน [โอมงกะลงปง x ตะมู่ยคริ x ต๊ะอิ๊อึอัส feat. สมปองงานวัด - แทนบ๋อย](https://youtu.be/o8-Bj5ACAMw?t=80&end=87)
- (เพราะ) คนไม่จำเป็นก็ต้องเดินจากไป ถึงแม้ว่าภายในใจจะรักเธอแค่ไหน [Getsunova - คนไม่จำเป็น](https://youtu.be/fmAEiuuoc_0?t=58&end=68)
- ไหนว่าจะไม่หลอกกัน ไหนว่าเธอจะมีฉัน ไหนว่าเธอจะเป็นเหมือนเก่า [SILLY FOOLS - ไหนว่าจะไม่หลอกกัน](https://www.youtube.com/watch?v=H24s52FrRNg&t=133&end=146)
- (รัก) เก่าเก่า หนทางใหม่ๆ จะเลือกอย่างไหน เธอก็คงรู้เอง [Soul After Six - รักเก่าๆ](https://youtu.be/beVDtbbAJ5s?t=74&end=87)
- (บอกตัว) เองว่าเราต้องลืมเรื่องราวที่ผ่าน แม้ความจริงทรมานและไม่มีวันไหนไม่คิดถึงเธอ [ROOM39 Feat.โป่ง ปฐมพงศ์ (โป่ง หินเหล็กไฟ) - บอกตัวเอง | Remind](https://youtu.be/5VrXPPKVb4g?t=109&end=123)
- เธอคนเดียว เธอคือนางฟ้าในใจ คอยนำทางคนที่อ้างว้างเดียวดาย เปิดใจ ให้พบรักแท้มีจริง จากดวงใจ ที่เปี่ยมความหมาย [Clash - เธอคือนางฟ้าในใจ](https://youtu.be/nmVrMXPCtN4?t=65&end=93)
- ไม่ทราบมันเป็นไร ไม่รู้ว่ามาไง อาการรักเธอ [ไอ..น้ำ - รักคนมีเจ้าของ](https://youtu.be/wadd_1CR5DA?t=45&end=52)
- เธอสวย ทุกนาทีที่เคยสัมผัส รู้ทันทีว่าเธอคือคนพิเศษ [Double You - เธอสวย](https://youtu.be/ecD7rrzQWFg?t=43&end=55)
- เธอคือคนพิเศษ เสกให้ใจของฉัน โบกปีกบินสู่ฟ้า [Calories Blah Blah - คนพิเศษ](https://youtu.be/oE8kMw9QUs8?t=15&end=28)
- ฟ้า ที่ยังรอดวงตะวันขึ้นมาใหม่ ไม่ต่างสักเท่าไรกับตัวฉัน ที่ยังรอดวงตะวันของหัวใจ ให้คืนมาพบกัน [นัท มีเรีย - ฟ้ากับตะวัน](https://youtu.be/dPOLu7KlKLM?t=75&end=96)
- (ที่พาเรา) พบกัน แล้วเวลา ก็พาเราจากกัน [Thaitanium - สบายดีหรือเปล่า 2017](https://youtu.be/Tk2ojsflPws?t=73&end=81)
- จากกันไปเสียนาน ได้เจอเธออีกครั้ง ฉันดีใจอย่างบอกไม่ถูก [Raptor - จำฉันได้ไหม](https://youtu.be/oycSIZvXz04?t=34&end=47)
- ถูกแล้วฉันนี่ไง ตัวแทนของคําว่าดีไม่พอ [ว่าน ธนกฤต - เดคิสุงิ](https://youtu.be/uQkAvzsl2zQ?t=58&end=65)
- พอเถอะพอแล้วพอ พอเถอะควรพอได้แล้ว [MEAN - พอเถอะ](https://youtu.be/3SAa6uca2IA?t=62&end=68)
- แล้วมันจะผ่านไปด้วยดี แล้วใจของเธอจะเปลี่ยนไป แล้ววันหนึ่ง เขาจะหายไป แม้วันนี้จะยังรู้สึก [ป๊อบ ปองกูล - ปล่อย](https://youtu.be/cF1zMxjKApc?t=101&end=135)
- (ฉัน) รู้สึกไม่ดี ฉันเป็นห่วงเธอ เธออยากให้ฉันอยู่ด้วยไหม อยากให้ฉันอยู่ด้วยไหมเธอ [อัสนี วสันต์ - อยากให้อยู่ด้วยไหม?](https://youtu.be/GNzQeUceJX8?t=56&end=73)
- เธอคงเคยเห็นฉันผ่านผ่านตา ให้รู้ว่าชอบชอบเธอ [Three Man Down - ผ่านตา (Everyday)](https://youtu.be/7-kQeLoDxBU?t=69&end=75)
- เธอคือหวานเย็น ดับร้อนข้างในหัวใจที่ฉันมี [Mild - หวานเย็น](https://youtu.be/I2VIv-QJ6xA?t=67&end=73)
- มีเรื่องราวมากมาย ที่ไม่มีใครได้ฟัง คำพูดนับร้อยพัน ที่ต้องการเอื้อนเอ่ย [Musketeers - ของขวัญ](https://youtu.be/NZ-_o6y5FaI?t=21&end=31)
- เอ่ยคำลา ว่าจะกลับมาเร็ววัน เพื่อพบกัน ใจมั่นสัญญา ความจริงใจที่มี ดั่งราตรีมีเพียงแสงจันทร์ [เรนโบว์ - ยากยิ่งนัก](https://youtu.be/Zekv0D89YtE?t=72&end=90)
- (ในคืน) แสงจันทร์ส่อง ระยิบตาดวงดารา ดั่งดวงตานางฟ้าจ้องมอง เป็นพยานในยามราตรีบรรเลงขับขาน เพลงรักเพื่อเรา [Cocktail feat. นิว นภัสสร - งานเต้นรำในคืนพระจันทร์เต็มดวง](https://youtu.be/y04gImu0qiw?t=122&end=147)
- เรามาไกลเท่านี้ก็ดีเหลือเกิน ขอบใจนะที่เคยมีกันมันถึงเวลายอมรับความจริง [ฺBigAss - ลมเปลี่ยนทิศ](https://youtu.be/5H4Lg-rl58U?t=90&end=106)
- (มี) จริงหรือ รักแรกพบเพียงสบตาแค่หนึ่งครั้ง แค่แรกเห็นเดินผ่านมาไม่พูดจา ไม่ทักไม่ทาย ไม่รู้ว่าใคร เหตุใดจึงรักกัน [Tattoo Colour - รักแรกพบ](https://youtu.be/rc7KnQAh_1I?t=36&end=58)
- (เรา) กันเองอยู่แล้ว โธ่ เรื่องแค่นี้ไม่เห็นต้องปิด คนเราจะรัก ไม่ใช่เรื่องผิด บอกมาเถอะเธอคิดยังไง [กัน เดอะสตาร์ - กันเอง](https://youtu.be/MBWVdKl-W0s?t=49&end=63)
- ยังไง ยังไงดี กลัวเธอลำบากจังเลย ทำไงดี ทำไงดี กลัวเธอจะไม่เข้าใจ [Raptor - เกรงใจ](https://youtu.be/xq8zkaEGgo8?t=83&end=91)
- ใจนักเลงจึงปวดร้าวเจียนตาย ปล่อยเธอไปตามใจเธอต้องการ จะยอมให้สั่งและตัดสิน ว่าฉันต้องถูกทอดทิ้ง เรานั้นมันไม่อาจฝืนความจริง [พงษ์พัฒน์ วชิรบรรจง - ใจนักเลง](https://youtu.be/ebrQ8A8K7is?t=29&end=57)
- ความจริงในใจไม่เคยมีใครแทนที่ความรู้สึก ที่ฉันยังมีให้เธออยู่ เธอยังคงมาวนเวียนอยู่ในความฝันยามคำ่คืน ให้ฉันเองสับสนในใจ [Crescendo - ความจริงในใจ](https://youtu.be/jcHFVcHj_xE?t=171&end=193)
- ใจหนึ่งใจ จะต้องการอะไร ให้มันมากมาย ให้มันวุ่นวาย เพียงเธอนั้น ใส่ใจกันเบาเบา พอให้สองเรา ได้ทำอะไรมากมายในตอนนี้ [Singular - เบาเบา](https://youtu.be/k73IcXf4hK4?t=17&end=51)
- (เนื่องจาก) ตอนนี้ ฉันรู้สึกจิตใจมันอ่อนไหว อยากจะรู้ว่าเขาเป็นยังไง จากคำพูดวันนี้ [Pause - ดาว](https://youtu.be/n_NTET76qZU?t=55&end=68)
- วันนี้ที่เป็นวันแรกที่ฉัน จับมือของเธอ เรามองหน้ากัน แล้วฉันก็พูดคำว่ารักเธอ [เอก สุระเชษฐ์ - วันนี้เมื่อปีที่แล้ว](https://youtu.be/utV6qhUZErA?t=26&end=40)
- เธอทำให้ฉันรักเธอก่อนไม่อาจถอน หัวใจมันคอยแอบแอบมองแบบซึ้งซึ้ง เธอทำให้ฉันหลงใจอ่อนนอนกอดหมอนทุกคืน จะทนได้นานสักเท่าไหร่ หากคิดถึง…โอ๊ย…โอ๊ย [เบน ชลาทิศ - โอ๊ย โอ๊ย](https://youtu.be/4EJb35Uco0M?t=124&end=155)
- โอ๊ยยยย ก็แล้วจะทำยังไง กลายเป็นหมาหางกุด พวกมนุษย์ก็เลิกเลี้ยงดูแล ความจริงก็คงจะไม่แคร์แต่หมู่หมาก็งงงวย [Pause - หมา (นิทานมาหางกุด)](https://youtu.be/dnt1n1caiIc?t=78&end=99)
- งวยงงยิ่งนักใจเราต่างก็รัก รักกันสุดชีวา รอวันสุขสดใส เหมือนไฟคุคอยเวลา มีแววจะลุกไม่ช้า ไม่นาน [สวลี ผกาพันธุ์ - เหมือนตายจากกัน](https://youtu.be/EAZirAbBPRQ?t=14&end=48)
- ไม่นานก็ช้า ถึงหัวใจ ก็ต้องเป็นของของเธออยู่ดี ช่วยรอได้ไหมแค่รอก่อน รอไม่นานคนดี [เอ๊ะ จิรากร - ไม่ใช่ความลับ](https://youtu.be/488q2rxLUao?t=79&end=94)
- (โอ้) คนดีฉันคงได้บอกไปแล้ว ยังมีอีกหลายสิ่ง ที่ฉันยังไม่เคยพูดสักที และมีอีกหลายอย่าง ที่ไม่เคยทำจนวันนี้ รัก รักเธอ ทั้งหมดของหัวใจ สิ่งเหล่านั้นเก็บไว้ข้างใน [Pause - รักเธอทั้งหมดของหัวใจ (For my Brother)](https://youtu.be/AyLUSxspYAI?t=146&end=191)
- ในใจไม่เคยมีผู้ใด จนความรักเธอเข้ามา ทำให้ดวงตาฉันเห็นความสดใส ข้างกายไม่เคยมีผู้ใด จนความรักเธอเมตตา เป็นพลังให้ฉันสู้ต่อไป [Moderndog - ก่อน](https://youtu.be/Bn5JCe-7aIg?t=40&end=62)
- ไปสู่ความจริงที่ปวดใจ อยากฉุดรั้งยั้งเอาไว้ ไม่อยากให้เดินไปจนนาทีสุดท้าย ฉันก็รู้สักวันต้องจบลง และชีวิตก็คงกลับไปเหมือนเก่า ยื้อฉันยื้อ ไม่ให้เธอจากไป จะฉุดรั้งเอาไว้ให้เธอไม่ไปจากเรา [Flure - ยื้อ](https://www.youtube.com/watch?v=E0Yp5SdFjC4&t=135s&end=170)
- เราจะทำตามสัญญา ขอเวลาอีกไม่นาน แล้วแผ่นดินที่งดงามจะคืนกลับมา [อัสนี โชติกุล - คืนความสุขให้ประเทศไทย](https://youtu.be/nP8FPJXibtE?t=60&end=75)
- มาทำไม ไม่รักก็ไม่ต้องมา เป็นอะไร ไม่รักก็คงไม่มา มาทำไม ไม่รักก็ไม่ต้องมา เป็นอะไร ไม่รักก็คงไม่มา [เบิร์ด ธงไชย, จินตหรา พูนลาภ - มาทำไม](https://youtu.be/XR4BP3SfPPs?t=89&end=104)
- มานี่มา มานี่มา มานี่ ไหนเจ็บตรงไหน ปวดตรงไหน จะจูบตรงนั้นให้ความช้ำหมดไปเจอคนใจร้าย มาใช่ไหมเธอ คนที่ไม่รู้อะไรเลยว่าหากได้มองรอยยิ้มของเธอแค่หนึ่งครั้ง และจะให้ตายตรงนั้นก็ไม่เสียดาย [POLYCAT - มานี่มา](https://youtu.be/NG4xXB9A03Q?t=7&end=51)
- เสียดาย...ที่วันนี้ไม่มีเธออยู่ อยากจะทำทุกสิ่ง อยากจะทำทุกอย่าง หากจะพอมีหวัง ให้คืนวันมันย้อนไป [Bodyslam - เสียดาย](https://youtu.be/3Nf5HriW9XA?t=134&end=150)
- ไปเถอะเธอไปที่ที่ดีกว่า หากอยู่กับฉันเสียเวลา สุดท้ายไม่นานฉันคงเข้าใจ [Three Man Down - ไปเถอะเธอ](https://youtu.be/wexEbXItRIs?t=6&end=19)
- ใจหนอใจคน คงต้องหม่นหมองสุขที่เคยครอง ไม่ได้เป็นดังใจ [Slot Machine - ใจหนอใจ](https://youtu.be/JrU15mDzVx0?t=44&end=52)
- ใจสู้หรือเปล่า ไหวไหมบอกมา โอกาสของผู้กล้า ศรัทธาไม่มีท้อ [หิน เหล็ก ไฟ - ศรัทธา](https://youtu.be/4wdkhztdXmo?t=92&end=116)
- (แต่ถามว่า) ท้อไหม ฉันตอบเลยว่ามาก ยากเย็นจนเกินความเข้าใจ [เบิร์ด ธงไชย - ก้อนหินกับนาฬิกา](https://www.youtube.com/watch?v=2cmI4ldY3ek&t=87s&end=98)
- ใจและใจแค่ลองแลกกัน มันก็อาจะเกิดความสัมพันธ์ ความรู้สึกที่มีให้กัน อาจเป็นรัก ... เข้าสักวัน [Pause - สัมพันธ์](https://www.youtube.com/watch?v=qZNWorOwLYA&t=103s&end=117)
- วันเดือนปีเคยเป็นแค่เพียงสายลมผ่าน ใครคนหนึ่งทำเวลาฉันให้รู้สึกมีความหมาย [Scrubb - คู่กัน](https://www.youtube.com/watch?v=E4iYZy2UWiw&t=47s&end=66)
- (หมด)ความหมาย แต่บทแสดงยังหายใจอยู่ ถูกคนลบหลู่บาดใจทุกวัน ปิดฉากไปเสียดีกว่า แสดงเป็นคนไร้ค่า อาจมีสักวันเข้าใจมากกว่านี้ [เสือ ธนพล - รักคงยังไม่พอ](https://youtu.be/JXI21WGBItA?t=102&end=128)
- มากกว่านี้ ก็ชีวิตฉัน มันคงให้เธอได้เท่านี้ มากกว่านี้ก็คงจะมีแค่ลมหายใจ มากกว่านี้ก็ชีวิตฉัน กับเธอคงไม่มีความหมาย ต่อให้ฉันต้องตาย ก็คงยื้อไม่ได้ เมื่อความรักมันไม่มีค่าอะไร ที่เธอต้องการ [มากกว่านี้ก็ชีวิต - สำราญราษฎร์](https://youtu.be/6vVERqgAFwA?t=63&end=97)
- การเดินทางของฉันและเธอคือการเรียนรู้ การเรียนรู้ของเราสองคนคือความเข้าใจ เธอเข้าใจและฉันเข้าใจก็ทำให้เรามั่นใจ [ชาติ สุชาติ - การเดินทาง](https://youtu.be/Jy35oa5oFoY?t=48&end=61)
- (ไม่เอาอีกแล้วคน)ใจร้าย ที่ผ่านมาทุกที ต้องเจ็บปวดทุกที ทำไมชีวิตต้องเจอกับคนแบบนี้ [LIPTA Feat. Ink Waruntorn - เจอแต่คนใจร้าย](https://www.youtube.com/watch?v=DXPrQ4w-pSg&t=43s&end=60)
- นี่แหละคือความเสียใจ ความเสียใจมันเป็นอย่างนี้จำซะใหม่ ต้องเจ็บจนร้องไห้โดยไม่อาย ต้องช้ำทุรนทุรายขนาดนี้ [Potato - นี่แหละความเสียใจ](https://youtu.be/NSc5YSVQSNs?t=121&end=145)
- นี่ฉันเอง คนนี้ นี่ฉันเองคนเดิมที่ยังรักเธอ นี่ฉันรอที่จะได้เจอ ยังรอที่จะพบเธอ ไม่ว่านานแค่ไหน [Lipta Feat. Kob Flat Boy - นี่ฉันเอง](https://youtu.be/lFsXixn7PGY?t=7&end=28)
- ไหนใคร โน่นไง แฝงตัวร่มเงาไม้ใหญ่ ใช่ใครนกเขา คู่มัน เสียงใคร ไหนกัน เสียงนั่น อ๋อ นกมันพรอดคำรำพัน ฝากชีวันรักกันไงเล่า [เกษม คมสันต์/อัมพร แหวนเพชร - นกเขาคูรัก](https://youtu.be/O1f-X_vBcw8?t=103&end=121)
- (ใคร)เล่าเลยจะรู้ว่าความรัก แม้แรกเจอต่างคนไม่รู้จัก แต่ปักใจเพียงครั้งเดียว ติดในใจชั่วกาล ยามที่เราทั้งสองได้พานพบ ลบเรื่องราวอดีตที่ร้าวราน เธอคือความรักแท้ ที่ฉันหามาเนิ่นนาน [Billkin - กีดกัน (Skyline) OST.แปลรักฉันด้วยใจเธอ](https://www.youtube.com/watch?v=hJeEOzEZstU#t=13&end=48)
- (อยู่)นาน นาน ได้ไหม นาน นานจะเจอกันสักที ให้ฉันได้มีวันที่ดี อบอุ่นอย่างนี้ นาน นานได้ไหม แล้วค่อยลา [SIN - อยู่นานๆได้ไหม](https://youtu.be/1tyEOknorf0?t=57&end=81)
- (เว)ลาของเธอหมดแล้ว เธอทำให้ชายชราตัณหากลับ เธอน็อคชายฉกรรจ์นอนนับดาวเดือน [หิน เหล็ก ไฟ - นางแมว](https://youtu.be/Dbo8MdJ6DME?t=80&end=99)
- เดือน 9 เช้าที่ 11 World Trade กลายเป็นความหลัง ยิ่งสูงก็ยิ่งล้มดัง ยิ่งใหญ่ ก็ยิ่งล้มตาย [คาราบาว - เดือน 9 เช้า 11](https://youtu.be/8FO2W1Davgc?t=52&end=65)
- ตายทั้ง เป็น ช้ำครั้งนี้ฉันคงจะทนไม่ได้นาน หัวใจคงจะโดนธาตุไฟรัก เผาแหลกลาญ นอนไหม้เกรียมตายทั้งเป็น [แจ้ ดนุพล แก้วกาญจน์ - ตายทั้งเป็น](https://youtu.be/WhBFGW95ef8?t=40&end=56)
- เป็นทุกอย่างให้เธอแล้ว แม้ว่าเธอไม่เคยเป็นอะไรกับฉันเลย ฉันก็แค่คนหนึ่ง ที่เธอต้องการในบางครั้ง ได้อยู่ตรงนี้ก็ดีแค่ไหน [Room39 - เป็นทุกอย่าง](https://youtu.be/totIVAi9BUc?t=118&end=137)
- ไหนว่าจะจำ จะจำแล้วไงไม่จำ พี่เชื่อถ้อยคำแม้จำติดใจ ไม่ลืม มิลืมไม่ลืม ให้จำคืนหนึ่งคืนนั้น สวรรค์อันเคยดูดดื่ม แล้วใครที่ลืมถ้อยคำ [ดิอิมพอสซิเบิ้ล (The Impossible) - ไหนว่าจะจำ](https://www.youtube.com/watch?v=_gm91BHZ6Sw&t=9&end=29)
- คำว่ารักมันกลายเป็นฝุ่นไปแล้ว อะไรที่หวังก็พังไปตั้งนานแล้ว แต่ชีวิตไม่รู้ทำไม มันยังคงค้างคาใจ ไม่มีวันใดที่ฉันไม่จดจำ [Big Ass - ฝุ่น (Official MV)](https://youtu.be/n3tdS0Xrl7U?t=33&end=62)
- จำไว้ว่าอย่านะ อย่าให้เป็นอย่างนั้น อย่าเป็นอย่างฉัน โอ้ว อย่านะ อย่าให้เป็นอย่างฉัน อย่าเลือกยอมให้อารมณ์ หวั่นไหวชั่วคราวนั้นอยู่ เหนือกว่าเหตุผล [Flure - อย่า](https://www.youtube.com/watch?v=W8X58yiOhu0&t=206s&end=228)
- (กี่)เหตุผลของคนหมดใจ ลงท้ายแปลได้คำเดียวว่าเลิกกัน บอกมาเลยได้ไหมว่าไม่รัก ว่าไม่รัก [Pancake - เหตุผลของคนหมดใจ (Official MV)](https://youtu.be/_kPWnpT2O_E?t=174&end=215)
- รักในครั้งนี้ยังไม่จบลงใช่ไหม ไม่ว่าอะไรเปียกปอนฉันภาวนา ให้เป็นเพราะฝนอย่าให้ต้องเปียกเพราะน้ำตา มีเพลงผิดหวังที่เรา ได้เปิดมันฟังด้วยกัน อย่าปล่อยให้เป็นแบบนั้นได้โปรด [POLYCAT - เป็นเพราะฝน](https://youtu.be/qOjlSEkUilc?t=64&end=96)
- โปรดส่งใครมาเป็นคู่กัน ที่ไม่ทำให้ฉันเดียวดาย ช่วยมาทำให้ฉันเข้าใจ และได้รักใคร [Instinct - โปรดส่งใครมารักฉันที](https://youtu.be/EDF7riZLhNA?t=81&end=96)
- ใครกันเล่าจะมาเป็นคู่กัน ก็ใครกันเล่าจะเดินอยู่ข้างกัน จะมีบ้างไหมแค่ใครซักคน ที่ไม่มองข้ามคนอย่างฉัน [เอก สุระเชษฐ์ - ใครสักคน](https://youtu.be/HxJdX3rFoGs?t=127&end=140)
- ฉันเหมือนคนไม่มีกําลัง และหมดแรงจะยืนจะลุกจะเดินไป [อ๊อฟ ปองศักดิ์ - แทงข้างหลัง..ทะลุถึงหัวใจ](https://youtu.be/CtLxoB1sQjk?t=106&end=115)
- (ฉันจะไม่เปลี่ยน)ไป จะมีทางไหน ที่ทำให้ฉันค้นพบคนดีของหัวใจ [ARMCHAIR - รักแท้](https://www.youtube.com/watch?v=TCLKItcu75c&t=73s&end=84)
- ใจเย็นจนเริ่มจะชา ดาดาดี๊ด่าด้า ใจเย็นจนกลัวว่าหมา อา อา จะคาบไป ใจเย็นจนเริ่มจะชา ดาดาก็หวั่นไหว ไม่รู้จะพูดยังไงว่าคนคนนี้นั้นมันแอบ รักเธอ [Pancake - ใจเย็น](https://www.youtube.com/watch?v=7L1hQJAMrJQ&t=61s&end=86)
- เธอคือทุกสิ่งในความจริงในความฝันคือทุกอย่างเหมือนใจต้องการเธอเป็นนิทานที่ฉันอ่านก่อนหลับตาและนอนฝัน [COCKTAIL - คู่ชีวิต](https://youtu.be/3mYVyVY-lU4?t=39&end=60)
- ฝันถึงแฟนเก่า ในฝันมันช่างดี เหมือนไม่เคยเก่า และเหมือนว่าเธอยังอยู่ตรงนี้ เพราะด้วยเรื่องต่างๆ มากมายในวันนั้น ที่ทำให้เราไม่ได้ไปกันต่อ จนถึงวันนี้ [Three Man Down - ฝันถึงแฟนเก่า](https://youtu.be/3O_Hxdtoyac?t=49&end=74)
- (เพลง)นี้เกี่ยวกับความรัก มันเกี่ยวกับหัวใจ มันเกี่ยวกับที่ว่างข้างใน ที่เก็บไว้ให้เธอคนเดียว [SILLY FOOLS - เพลงนี้เกี่ยวกับความรัก](https://youtu.be/ce_KPVqfp0E?t=1&end=18)
- เดี๋ยวเธอกับเขาก็คืนดีกัน เพราะเธอยังคิดถึงเขาทุกวัน ถึงตัวเธอจะอยู่กับฉัน แต่ใจเธออยู่กับเขา ฉันควรเลิกหวังเรื่องเรา [COPTER FEAT.3RD TILLY BIRDS - เดี๋ยวเธอกับเขาก็คืนดีกัน](https://www.youtube.com/watch?v=h5jOfE3anoc&t=13s)
- เราแค่ผ่านมาเจอกัน สักวันก็คงต้องจากไม่เคยโกรธเธอเลยยินดีที่เจอด้วยซ้ำขอบคุณทุกเรื่องที่ผ่านมาถึงแม้บางครั้งมีน้ำตายินดีที่ได้รักกัน [MAN'R - เราแค่ผ่านมาเจอกัน - ft OWEN , P.A.P BEATBAND](https://youtu.be/_QKCHF3qQqs?t=13&end=31)
- (เข้า)กันดีกับที่หัวใจบอกไว้ ฉันไม่เคยเจอใคร ไม่ขวา ไม่ซ้าย ไม่สมบูรณ์ไป ไม่มองแง่ร้ายหรือเอาแต่ใจ แต่มีอะไรไม่ธรรมดา [Scrubb - เข้ากันดี](https://www.youtube.com/watch?v=rGVXV1Z12Uo&t=171s&end=192)
- ไม่ธรรมดา อือฮือ ไม่ธรรมดา ไม่ธรรมดา โอ้โฮ ไม่ธรรมดา [ไชยา มิตรชัย - ไม่ธรรมดา](https://youtu.be/hbw-t4dvja8?t=48&end=56)
- ดาดีด้าว โด่ดาดีด้าดีด้าว โด่ดาดีด้าดีด้าว โด่ดาดี้ดาว ดาดีด้าว โด่ดาดีด้าดีด้าว โด่ดาดีด้าดีด้าว โด่ดาดี้ดาว [Raffy & Nancy - UFO(ยูเอฟโอ)](https://youtu.be/Um9IX-DjonA?t=47&end=60)
- ดาวนับล้านที่ลอยอยู่บนท้องฟ้า จะมีไหมหนาที่ลอยอยู่เองเฉยๆ ไม่ยอมโคจรหนุนไปไหนเลย ไม่เคยไม่เห็นเลยสักดวง [Scrubb - เธอหมุนรอบฉัน ฉันหมุนรอบเธอ](https://www.youtube.com/watch?v=T59Xl5AnCzw&t=17s&end=33)
- ดวงจันทร์วันเพ็ญ ลอยเด่นอยู่ในนภา ทรงกลดสดสี รัศมีทอแสงงามตา [ท่านผู้หญิงละเอียด พิบูลสงคราม - ดวงจันทร์วันเพ็ญ](https://youtu.be/a4jF_h5Yd0I?t=33&end=45)
- (สาย)ตามันหลอกกันไม่ได้ เขาพูดกันว่าสายตามันเป็นสิ่งเดียวที่พูดแทนหัวใจ [Ink Waruntorn - สายตาหลอกกันไม่ได้](https://youtu.be/C-Edz_RXi8E?t=48&end=58)
- หัวใจเต้นแรง หน้าแดงทุกที ใช่เธอหรือนี่ ที่คอยตลอดมา ควบคุมไม่อยู่ รู้เลยว่าตัวสั่น แค่เจอไม่นาน ถูกใจเหลือเกิน [ป้าง นครินทร์ - ทำอะไรสักอย่าง](https://youtu.be/8zySm-ja78k?t=24&end=46)
- เกินกว่าคำว่ารัก มันมากกว่าคำว่าผูกพัน แค่พูดว่าเราเป็นเพื่อนกัน เท่านั้นพอ [เกินกว่ารัก มากกว่าผูกพัน I หั่ง ทีฆทัศน์](https://youtu.be/uq832ZvQl8Y?t=80&end=90)
- พอแล้วที่ให้เธอ จะไม่เผลอทำตัวให้อ่อนไหว คงต้องเหงา แต่คงไม่ตาย เราไม่มีอะไร เกี่ยวข้องกันอีกแล้วเธอ [Zeal,บัวชมพู ฟอร์ด - หมดชีวิต (ฉันให้เธอ)](https://youtu.be/O4K2scQxioM?t=199&end=223)
- เธอคนนั้น เราพบกันและต้องไกล ในวันที่ฝนพรำ เช่นวันนี้ ฝนตก ยิ่งนึกถึงทีไร ก็ยิ่งชุ่มฉ่ำอุ่นในหัวใจ แม้ว่าคืนนี้อากาศจะหนาวสักเท่าไร ก็ขอฝากลมฝนช่วยเป็นสื่อให้เธอรู้ ว่าฉันคิดถึง และยังคิดถึง ในคืนที่ฝนโปรยเราอยู่ด้วยกัน [Flure - Rain](https://www.youtube.com/watch?v=ZIqDPxvb_r4&t=30s&end=69)
- (จะได้มี)กันและกัน ให้มันเป็นเพลง บนทางเดินเคียง ที่จะมีเพียงเสียงเธอกับฉัน อยู่ด้วยกันตราบนานๆ ดั่งในใจความบอกในกวี ว่าตราบใดที่มีรักย่อมมีหวัง คือทุกครั้งที่รักของเธอส่องใจ ฉันมีปลายทาง [Q Flure - กันและกัน](https://www.youtube.com/watch?v=DnQS-kn06EE&t=79s&end=120)
- ปลายทางที่ฉันรอเธอ ที่สุดก็จบตรงนี้ ไปดีเถอะนะคนดี ไม่ต้องคิดอะไร เข้าใจว่าวันเวลา มันทำให้คนเปลี่ยนไป แต่ฉันก็คงไม่คิดโทษใครอยู่แล้ว อย่าห่วงเลย [บอดี้สแลม - ปลายทาง](https://www.youtube.com/watch?v=TMhAcmSqx-4&t=23s&end=51)
- อย่าห่วงเลยไม่เห็นเธอต้องเกรงใจ ที่ฉันนั้นคอยห่วงใย ดูแลเธอมานาน มันผิดเหรอเมื่อฉันเองก็เต็มใจ ทุกอย่างที่ทำให้ไปจะคืนกลับมาไหมไม่สำคัญ [บิ๊กแอส - เหตุผลง่ายๆ](https://www.youtube.com/watch?v=qQZ-oEmR6sI&t=11s&end=36)
- ไม่สำคัญว่าเธออยู่กับใคร แค่ได้เห็นเธอยิ้ม ก็ดีใจ [The 38 Years Ago - จริงๆนะ (Jing Jing Na)](https://youtu.be/lInd0NnAknw?t=176&end=186)
- ใจของฉันมันเป็นของเธอ ไม่ว่านานเท่าไร และมันจะเป็นของเธอตลอดไป ใจของฉันมันเป็นของเธอคนเดียวทั้งใจ จะรอเธอรักเธอจนตายใจเอย [บอย Peacemaker - ใจฉันเป็นของเธอ (Ost. ใจร้าว)](https://youtu.be/K2ynPjhXkEw?t=75&end=106)
- (ดวงเดือน)เอย ข้อยมาเว้า รักเจ้าสาวคำดวง โอ้ดึกแล้วหนอ ข้อยขอลาล่วง อกพี่เป็นห่วง รักเจ้าดวงเดือนเอย [พระเจ้าบรมวงศ์เธอ กรมหมื่นพิไชยมหินทโรดม - ลาวดวงเดือน](https://www.youtube.com/watch?v=VMQvBQlZCWU&t=18s&end=53)
- (โอ้ใจ)เอ๋ย ทำไมหัวใจไม่หลาบจำ ดึงดันจะรักเธออยู่ ทั้งที่รู้ว่าเขาไม่ใช่ แต่ยังจะรักเขาหมดหัวใจ ปล่อยเขาทำร้ายย้ำๆ ซ้ำๆ เติมอยู่ [COCKTAIL X ตั๊ก ศิริพร - ดึงดัน](https://youtu.be/AZ_t9iAJRDw?t=122&end=135)
- อยู่เป็นของขวัญ ให้ฉันก่อน ฉันเพียงอยากขอเก็บช่วงเวลานี้ของเรา [Uncle Ben - อยู่เป็นของขวัญให้ฉันก่อน](https://youtu.be/iwRwJKISNqI?t=128&end=151)
- (แต่)เรามาลองลองคิดกันดูไหมในวันที่สองเราไม่ได้บอกรักกัน [DRG - เรื่องราวที่เราเขียน feat.spsalola](https://youtu.be/Gbtg204DP88?t=74)
- (คือเพื่อน)กัน เพื่อนตาย ตลอดไป [LOSO - เราและนาย](https://youtu.be/Bd-Gju4bnW0?t=90)
- ไปไม่ถึงฝันแต่ฉันจะไม่โทษใคร แค่ได้รัก รักเธอก็ดีแค่ไหน จะไม่เหนี่ยวรั้งตัวเธอ ทั้งที่หมดทั้งหัวใจฉันยังรักเธอ แต่ฝันนั้นเราก็ไปไม่ถึง [BIG ASS X WANYAi - ไปไม่ถึง](https://youtu.be/uFjfyg2M5RI?t=78&end=110)
- (ใย)ถึงไม่เข่นฆ่าเมื่อไม่ใยดี ทิ้งฉันขื่นขมสมใจผละหนี ฝากไว้คือความบัดสีราคีติดกาย [สวลี ผกาพันธุ์ - ฆ่าฉันให้ตายดีกว่า](https://youtu.be/pth2Z2_TU7E?t=17&end=39)
- (ภาษา)กาย มันบอกลาที่ตรงหัวใจดีกว่าพูดจา [Potato - ภาษากาย](https://youtu.be/4Z0VJE-UXn0?t=149&end=162)
- พูดจาภาษาเดิม หัวเติมต่อท้าย พูดจาภาษาไทย จริงใจอย่างนี้ไทยไทย [พงษ์พัฒน์ วชิรบรรจง - พูดจาภาษาไทย](https://youtu.be/n3SJ19Do_tY?t=18&end=35)
- (ประเทศ)ไทยมีวันนี้หนอ ก็ใครเล่าพระเจ้าแผ่นดิน [คาราบาว - ผู้ปิดทองหลังพระ](https://youtu.be/sZ4iuUJWe5A?t=41&end=48)
- (บวกกันเป็น)ดินเดียว ให้พ่อได้สุขใจ ไม่ต้องเหนื่อยเกินไป อย่างที่เป็นมา [เบิร์ด ธงไชย - ของขวัญจากก้อนดิน](https://youtu.be/iL568u8Z3bk?t=114&end=126)
- (โอ้)มาเถิดหนากระไรแม่มาเร็วเร็วอย่าช้าเลยนะแม่หน้านวลใย [เอกชัย ศรีวิชัย - หมากัด](https://youtu.be/f7JHCazelV0?t=28&end=34)
- ใยใครมองหารักกันทำไม [สาว สาว สาว - รักคือฝันไป](https://youtu.be/ca3bx9MF6K8?t=97&end=103)
- (ทำ)ทำไมมาพูดแทงใจดำอย่างนี้ มาขยี้ขยี้ขยี้เพื่ออะไร รอมานานกี่ปีก็ยังไม่มีใคร ฉันเองก็ช้ำใจเดียวดายอยู่ในความเหงา [ป้าง นครินทร์ กิ่งศักดิ์ - ขยี้ทำไม](https://youtu.be/qr5gH3kJxA4?t=114s&end=130)
- (นี่คือ)เหงา นี่แหละเหงา นี่คือความจริงที่ได้เจอ เจ็บปวดทรมาน ลึกลงข้างในใจ [PEACEMAKER - เหงา](https://youtu.be/UHIeh8cTuDA?t=61)
- ในใจไม่เคยมีผู้ใด จนความรักเธอเข้ามา ทำให้ดวงตาฉันเห็นความสดใส [Moderndog - ก่อน](https://youtu.be/Bn5JCe-7aIg?t=40&end=51)
- (น้ำ)ใส หาดสวย คนไปเที่ยวทะเล ก็มีแต่ความสุข ทะเลก็มีชีวิต ทะเลก็มีหัวใจ [คาราบาว - รั้วทะเล](https://youtu.be/NMnXq8l7XB4?t=186&end=203)
- ใจของฉันมันเป็นของเธอ ไม่ว่านานเท่าไร และมันจะเป็นของเธอตลอดไป ใจของฉันมันเป็นของเธอ คนเดียวทั้งใจ จะรอเธอ รักเธอจนตายใจเอย [บอย Peacemaker - ใจฉันเป็นของเธอ (Ost. ใจร้าว)](https://youtu.be/K2ynPjhXkEw?t=75&end=107)
- (รัก)เอย อยู่ที่ใด ยังฝันใฝ่ ยังคงตามหา (ยังคงตามหา) [Bodyslam - แค่หลับตา](https://youtu.be/b2np6DDYqVY?t=199&end=213)
- ตามหาหัวใจ ที่ลืมไว้กับใครซักคน จะตามจะค้นจนเจอ เธอคนนั้นในความทรงจำของฉัน [Dan Beam - ตามหาหัวใจ](https://youtu.be/GykjLWyTFGU?t=143&end=164)
- ฉันต้องทำ ทำอะไรสักอย่างแล้ว ให้เธอนี้ไม่แคล้วไม่คลาดกัน [นครินทร์ กิ่งศักดิ์ - ทำอะไรสักอย่าง](https://youtu.be/8zySm-ja78k?t=60&end=71)
- (ขอบคุณที่รัก)กัน ขอบคุณทุกครั้งที่คอยกอดฉันในวันที่ปัญหา ถาโถมเข้ามาใส่ จะตอบแทนความรัก ที่ฉันได้จากเธออย่างไร [Potato - ขอบคุณที่รักกัน](https://youtu.be/J4dnYkO42RU?t=166&end=190)
- (ไม่ว่า)อย่างไรก็รัก และรักเธอที่สุดตลอดไป [Patiparn Pataweekarn - อย่างไรก็รัก](https://youtu.be/94oev0omjiQ?t=81&end=89)
- ไปจากชีวิตของฉัน ได้โปรดอย่ามองกลับหลังมา ไม่อยากให้เธอ มาสบตาแล้วทำเสียใจ [Instinct - นับถอยหลัง](https://www.youtube.com/watch?v=4I9IyrAiRtk&t=69s&end=80)
- (ก็)ใจมันหายละลายละลายละลายละไหลไปกับเธอ [Four-Mod - ละลาย](https://youtu.be/2fpzIswK2WM?t=112&end=115)
- เธอหัวใจกระดาษเบาๆก็ขาดแค่ลมบางเบาก็ปลิว เคว้งคว้างล่องลอยตามสายลมรักของคนเรื่อยไป [อู๋ ธรรพ์ณธร - หัวใจกระดาษ](https://youtu.be/IIDFcMkh8II?t=112&end=129)
- ไป ไป ไปลงนรกด้วยกันที่รักฉันจะลงโทษเธอ [หิน เหล็ก ไฟ - นางแมว](https://youtu.be/Dbo8MdJ6DME?t=65&end=72)
- เธอยังเป็นคนเดียวที่เคยชนะใจกัน แต่เธอไม่กลับมาเอารางวัล ปล่อยให้ฉันต้องเหงาคนเดียวตรงนี้ [Mirrr - เจ้าของที่](https://youtu.be/5xYlc4OBnPg?t=27&end=40)
- ตรงนี้มันไม่ใช่พื้นที่ปลอดภัย และถ้าทนไม่ไหวก็แค่เดินออกไป [BOTCASH ft. YOUNGOHM - พื้นที่ปลอดภัย](https://youtu.be/nUl7Ct8vp8Q?t=96&end=105)
- ไปกะไปให้ฟ้าวไปน้องหล่า บ่ต้องหัวซาบ่ต้องมาสนใจอ้าย [ถ่าหยังไปถะแหมะ - ละไมหรรษา feat.ปิ๊ก เลอก๊ากซง](https://youtu.be/Msf94hpDsOM?t=162&end=169)
- (ได้ฮักกับ)อ้ายเหมือนใจได้ปริญญา ชีวิตผู้สาวบ้านนาวุฒิการศึกษามีน้อย [ศิริพร อำไพพงษ์ - ปริญญาใจ](https://youtu.be/Rkh9Enepk5U?t=53&end=66)
- (อย่าง)น้อยฉันเคยได้รักเธอ รักด้วยการไม่หวังอะไร ก็รู้ฉันเองก็ยังไม่ใช่ ไม่ต้องการอะไรทั้งนั้น อย่างน้อยฉันได้เรียนรู้ ได้เข้าใจ ทุกนาทีที่ฉันมีเธอ รักคือความสุขที่ยิ่งใหญ่ [Big Ass - อย่างน้อย](https://youtu.be/mDa8FfZkntA?t=59&end=86)
- (อ๊ะตอนนี้)ใหญ่ที่หนู ก็ตอนนี้อยู่ที่ไหน อ๊ะตอนนี้ใหญ่กับครู ก็ตอนนี้อยู่กับใคร แล้วจะไก่เมื่อหลับ ก็พ่อจะกลับเมื่อไหร่ ต่อไปพูดแบบนี้ พูดแบบเนี้ย อ่ะเครมั้ย อย่ากระโต๊ก กระต๊าก ตามจิกเป็นนก เป็นนก ประเดี๋ยวกระต่ายตื่นตูม ต้องค่อย ค่อยคุม อย่าให้ตื่นตะหน๊ก นะ อย่ากระโต๊ก กระต๊าก ตามจิกเป็นนก เป็นนก ประเดี๋ยวกระต่ายตื่นตูม ต้องค่อย ค่อยคุม อย่าให้ตื่นตะหน๊ก จ๊าก จ๊าก จ๊าก จ๊าก จ๊าก จ๊าก จ๊าก จ๊าก จ๊าก [หมูยอ อาร์ สยาม - ใหญ่ที่หนู?](https://youtu.be/sk212DKQP_k?t=85&end=127)
- จั๊กกิ้มก็คือจิ้งจกส่วนต๊กโตก็คือตุ๊กแก โตมาจนจะแก่เพิ่งรู้ตุ๊กแกก็คือต๊กโต [จั๊กกิ้มกับต๊กโต : วงต๊กโต อาร์ สยาม](https://youtu.be/KNSnvejrgAI?t=86&end=92)
- โตแล้ว ฉันคงต้องเรียนรู้ ที่จะต้องยอมรับ ว่าคำว่าไม่รักคือไม่รัก จะดีพร้อมแสนดีสักแค่ไหน เขาก็ไม่สนใจ จะกลับมารักกัน เหมือนดังเก่า [Ammy The Bottom Blues - โตแล้ว](https://youtu.be/MzaW6Y5j1uM?t=84&end=120)
- (เรานะคน)เก่า ส่วนเค้านะคนใหม่ เมื่อเรานะคนเก่า จะเอาอะไรไปสู้คนใหม่ เรานั้นพยายาม แต่เขาแทบไม่ต้องทำอะไรโอ๋...ที่รักช่วยบอกที ว่าเธอนะเป็นคนยังไง [AOFZ x NOAH x SPIDERMEI - เก่า](https://youtu.be/DueF-LrcjG8?t=31&end=44)
- (เป็น)ไงวันนี้ เธอเหนื่อยใช่ไหม ก็ไม่เป็นไรนะเธอ ให้เพลงๆนี้ มันฮีลใจของเธอ แม้ว่าต้องเจอโลกที่ใจร้ายเท่าไร ให้กอดของฉัน ส่งผ่านเพลงนี้ไป แม้ไม่มีใคร เธอก็ยังมีฉันอยู่ [พัด Vorapat x LIT Ent. x First Anuwat,sarah,Kinkaworn,NINEW,pluto.,DoubleBam,JEEP - ฮีลใจ](https://youtu.be/2FxYYY9E6hs?t=34&end=67)
- อยู่ กับฉันก่อน ทิ้งตัวลงนอน ช่วยให้ใจของฉัน ได้พบกับวันนั้น [Zweed n' Roll - อยู่ (You)](https://youtu.be/lY__VKI0Vs8?t=245&end=266)
- นั่นแหละคือความกดดัน ที่ฉันต้องทนต้องเจอ [แอม เสาวลักษณ์ - กดดัน](https://www.youtube.com/watch?v=CcTgfJHEyac&t=84&end=92)
- (อยาก)เจอเหลือเกิน ยิ่งคิดถึงเธอเท่าไร ยิ่งทำให้รู้สึกว่าขาดเธอแล้วทำให้ฉันทนแทบไม่ไหว และยิ่งแน่ใจ ที่ทำให้ฉันหวั่นไหว ไม่ใช่ความเงียบงัน แต่มันคือทุกครั้งที่คิดถึงเธอ [Blue Shade - อยากเจอ (Reason of loneliness)](https://youtu.be/2KOoxnQz5oo?t=73&end=111)
- เธอทำให้ระหว่างทางกลับดูสวยงาม โชคดีที่มีเธอมีคนที่มาเดินด้วยกัน [BRIGHT x Thanaerng - ระหว่างทาง (Good Time)](https://youtu.be/UmfZEAvsYVE?t=71&end=84)
- (รัก)กันไว้เถิด เราเกิดร่วมแดนไทย จะเกิดภาคไหน ๆ ก็ไทยด้วยกัน เชื้อสายประเพณีไม่มีขีดขั้น เกิดใต้ธงไทยนั้น ปวงชนทุกคนคือไทย [รักกันไว้เถิด : รวมศิลปิน (ร็อกรักชาติ)](https://youtu.be/9PjG3Gwmofg?t=44&end=61)
- ไทยเรามาจากไหนกัน ไทยเรามาจากไหนกัน หรือเผ่าพันธุ์เราอยู่ตรงนี้ [คาราบาว - คนไทย](https://youtu.be/TyG6R6KJuUk?t=17&end=25) 
- ตรงนี้ได้หรือเปล่า ฉันขอร้องเธออีกครั้ง จูบกับฉันอีกครั้งได้มั้ยเธอ [SARAN - อยากให้เธออยู่ตรงนี้](https://youtu.be/bZNo-6Z6ODE?t=39&end=49) 
- เธอปล่อยให้ฉันรอ เธอปล่อยให้ฉันคอย แต่เวลามันช่างเหลือน้อย แล้วเธอก็จากไป [Paradox(Feat. ทราย ฟาเรนไฮธ์) - การรอคอย](https://youtu.be/mSw6-xdh77k?t=0&end=13)
- ไปไหนแล้วคนที่บอกกันว่าจะไม่ไปไหน ไปไหนแล้วคนที่สัญญา ว่าจะไม่ทำฉันเสียใจ [Chilling Sunday - ไปไหนแล้ว(Gone)](https://youtu.be/zVRsvu77UdY?t=48&end=61)
- ใจหายไปเลย หายไปในอากาศ ลอยไปกับสายลม ไปสู่ความเหงา [MR.TEAM - ใจหายไปเลย](https://youtu.be/aDbVSU__DCE?t=120&end=130)
- (ฉัน)เหงาเธอรู้ไหม ฉันหนาวจนแทบขาดใจ ไม่มีอ้อมกอดจากเธอที่รู้ใจ รอคอยเธอกลับมาหา เฝ้ารอจนฝนซา สุดท้ายก็ว่างเปล่า [Flure - ฤดูที่ฉันเหงา](https://youtu.be/LoM1YWSwBjM?t=71&end=95)
- (ปะ ปะ ปะ)เปล่าเจ้าชู้ ก็เธอมันน่าเอ็นดู [I am Four-Mod - เปล่าเจ้าชู้](https://youtu.be/6BAdM4bwzxQ?t=56&end=63)
- ดู ดู้ ดู ดูเธอทำ ทำไมถึงทำกับฉันได้ ดู ดู้ ดู ดูเธอทำ ทำไมถึงทำกับฉันได้ [จ๊อบ บรรจบ - ดูเธอทำ](https://youtu.be/Dmhg_zFMvIY?t=100&end=120)
- ได้โปรด พูดความจริงให้ฉันได้ยิน ว่ารักเขาจริงก่อนที่จะไป ให้ฉันได้ซึ้งได้ทราบอีกครั้ง ตอบมา ฉันจะไปไม่ขวางทางใคร ไม่แค้นในใจเธอคิดยังไง เธอมีอะไรกับเขารึยัง [ตั๊ก ศิริพร อยู่ยอด - หมดห่วง](https://youtu.be/3kCgxJZNUo8?si=d9hiTOc51IYXTtTU&t=132)
- ยังเฝ้ารอเธอคนเดียวทั้งหัวใจ [Musketeers - ไกล](https://youtu.be/hmlTq97_sRQ?si=mX-ai0z0js4In_xH&t=162)
- ใจนักเลงถึงปวดร้าวเจียนตาย [พงษ์พัฒน์ วชิรบรรจง - ใจนักเลง](https://youtu.be/sSGzUthHGt8?si=vq48Ow6oiXkGi0Ij&t=23&end=27)
- (หากจะ)ตายก็ตายไปแล้ว เจ็บอีกทีจะสักเท่าไร ใจมันเจ็บมาแล้วกี่ครั้ง จะช้ำแค่ไหนไม่เห็นมันตายสักที [ทนได้ทุกที - ตั้ม สมประสงค์](https://youtu.be/8tlRd6C81K4?t=103&end=124)
- ทีนี้เลยก้าว แล้วไปไม่ได้ไกล จารใช้โมเดลถุงยางอนามัย [TangBadVoice - จารไม่ฟัง](https://youtu.be/6gfwCx7cT_I?t=58&end=61)
- อนามัยไกลบ้านเหลือเกิน [หมออนามัย - ปอยฝ้าย มาลัยพร](https://youtu.be/JDRZqLbmGUs?t=70)
<!--%%% APPEND_ON_MERGE %%%-->