# Generated by Django 4.1.7 on 2023-04-10 01:04

from django.db import migrations
from django.db import models
import hashlib

def set_text_hash(apps, schema_editor):
    Prompt = apps.get_model('promptbook', 'Prompt')
    for prompt in Prompt.objects.all():
        prompt.text_hash = hashlib.md5(prompt.text.encode('utf-8')).hexdigest()
        prompt.save()

class Migration(migrations.Migration):

    dependencies = [
        ('promptbook', '0009_category_help_text'),
    ]

    operations = [
        migrations.AddField(
            model_name='prompt',
            name='text_hash',
            field=models.CharField(max_length=32, null=True),
        ),
        migrations.RunPython(set_text_hash),
        migrations.AlterField(
            model_name='prompt',
            name='text_hash',
            field=models.CharField(max_length=32, null=False),
        ),
    ]
