# Lesson 3 - HTML Review and Intro to CSS
## Introduction
Welcome back! 
Last week, you were introduced to your first coding language: HTML. 
You began learning using the KhanAcademy course, and hopefully you had fun making your very first webpages! Over the next week, you will begin learning your next language: CSS. This language, as we discussed in the last lesson, shows how the website will look when displayed in your browser.

## HTML Review
The exercises for this lesson are just a few things to remember from the Intro to HTML course. 
In the Intro to HTML course, you learned these tags:
- `<h1></h1>` The header tags
- `<p></p>` The paragraph tag
- `<br>` The break tag
- `<em></em>` The emphasis tag
- `<strong></strong>` The strong tag
- `<ul></ul>` The unordered list tag
- `<ol></ol>` The ordered list tag
- `<li></li>` The list item tag
- `<img>` The image tag

The exercises will ask you questions about the appropriate use of such tags.

## Starting CSS
Now it's time for you to learn CSS! Go ahead and begin the KhanAcademy CSS course [here](https://www.khanacademy.org/computing/computer-programming/html-css/intro-to-css/pt/css-basics).



## Bonus: Setting up your text editor
So far, you have been using the KhanAcademy Live Editor to write your code. But for your project for this course, that editor won't work. Instead, we'll be setting up an editor for you to use on the computer you are using.

We will be using Github's Atom editor for all supported devices, for consistency's sake.

### Installing Atom on Windows
To install atom on Windows, simply click [this download link](https://github.com/atom/atom/releases/download/v1.33.0/AtomSetup-x64.exe) (or [this one](https://github.com/atom/atom/releases/download/v1.33.0/AtomSetup.exe) for 32-bit systems), open the file and follow the instructions. 

### Installing Atom on macOS
To install atom on macOS, download from [here](https://github.com/atom/atom/releases/download/v1.33.0/atom-mac.zip), extract the zip file, and put the `.app` bundle into your desktop folder.

### Installing Atom on Linux
To install atom on Linux (Ubuntu or Debian), click [this link](https://atom.io/download/deb) to download it. Then `cd` into the directory where you downloaded it, and run `sudo dpkg -i atom-amd64.deb`.



### Installing the Atom live reload package
On KhanAcademy, the canvas updates live with your code. This speeds up development and is often a handy tool. To add similar functionality to the atom editor, you need to install the `livereload` package.

With atom installed, open your terminal (or command prompt in Windows), and run `apm install livereload`.

Next, if you're using Chrome browser, you're going to want to use the `LiveReload` chrome extension [here](https://chrome.google.com/webstore/detail/livereload/jnihajbhpnppcggbcgedagnkighmdlei).

Now you're all set!

### Activating the Atom live reload package
To activate the live reload feature for atom, simply open the file you are editing in atom, then select `Packages->LiveReload->Toggle Live Reload` or press `Ctrl+Shift-R`. Now your file is being 'watched' by LiveReload.

Open your file in the browser, then click on the browser extension to start the live reload. Now every time you save the project, it will update live in your browser!
