import React, { PureComponent } from "react";
import { Text, StyleSheet } from "react-native";
import { PropTypes } from "prop-types";
import { withTheme } from "../Theme";

export const icons = {
  "3d-rotation": "\ue84d",
  "ac-unit": "\ueb3b",
  "access-alarm": "\ue190",
  "access-alarms": "\ue191",
  "access-time": "\ue192",
  accessibility: "\ue84e",
  accessible: "\ue914",
  "account-balance": "\ue84f",
  "account-balance-wallet": "\ue850",
  "account-box": "\ue851",
  "account-circle": "\ue853",
  adb: "\ue60e",
  add: "\ue145",
  "add-a-photo": "\ue439",
  "add-alarm": "\ue193",
  "add-alert": "\ue003",
  "add-box": "\ue146",
  "add-circle": "\ue147",
  "add-circle-outline": "\ue148",
  "add-location": "\ue567",
  "add-shopping-cart": "\ue854",
  "add-to-photos": "\ue39d",
  "add-to-queue": "\ue05c",
  adjust: "\ue39e",
  "airline-seat-flat": "\ue630",
  "airline-seat-flat-angled": "\ue631",
  "airline-seat-individual-suite": "\ue632",
  "airline-seat-legroom-extra": "\ue633",
  "airline-seat-legroom-normal": "\ue634",
  "airline-seat-legroom-reduced": "\ue635",
  "airline-seat-recline-extra": "\ue636",
  "airline-seat-recline-normal": "\ue637",
  "airplanemode-active": "\ue195",
  "airplanemode-inactive": "\ue194",
  airplay: "\ue055",
  "airport-shuttle": "\ueb3c",
  alarm: "\ue855",
  "alarm-add": "\ue856",
  "alarm-off": "\ue857",
  "alarm-on": "\ue858",
  album: "\ue019",
  "all-inclusive": "\ueb3d",
  "all-out": "\ue90b",
  android: "\ue859",
  announcement: "\ue85a",
  archive: "\ue149",
  "arrow-back": "\ue5c4",
  "arrow-downward": "\ue5db",
  "arrow-drop-down": "\ue5c5",
  "arrow-drop-down-circle": "\ue5c6",
  "arrow-drop-up": "\ue5c7",
  "arrow-forward": "\ue5c8",
  "arrow-upward": "\ue5d8",
  "art-track": "\ue060",
  "aspect-ratio": "\ue85b",
  assessment: "\ue85c",
  assignment: "\ue85d",
  "assignment-ind": "\ue85e",
  "assignment-late": "\ue85f",
  "assignment-return": "\ue860",
  "assignment-returned": "\ue861",
  "assignment-turned-in": "\ue862",
  assistant: "\ue39f",
  "assistant-photo": "\ue3a0",
  "attach-file": "\ue226",
  "attach-money": "\ue227",
  attachment: "\ue2bc",
  audiotrack: "\ue3a1",
  autorenew: "\ue863",
  "av-timer": "\ue01b",
  backspace: "\ue14a",
  "battery-alert": "\ue19c",
  "battery-charging-full": "\ue1a3",
  "battery-full": "\ue1a4",
  "battery-std": "\ue1a5",
  "battery-unknown": "\ue1a6",
  "beach-access": "\ueb3e",
  beenhere: "\ue52d",
  block: "\ue14b",
  bluetooth: "\ue1a7",
  "bluetooth-audio": "\ue60f",
  "bluetooth-connected": "\ue1a8",
  "bluetooth-disabled": "\ue1a9",
  "bluetooth-searching": "\ue1aa",
  "blur-circular": "\ue3a2",
  "blur-linear": "\ue3a3",
  "blur-off": "\ue3a4",
  "blur-on": "\ue3a5",
  book: "\ue865",
  bookmark: "\ue866",
  "bookmark-border": "\ue867",
  "border-all": "\ue228",
  "border-bottom": "\ue229",
  "border-clear": "\ue22a",
  "border-color": "\ue22b",
  "border-horizontal": "\ue22c",
  "border-inner": "\ue22d",
  "border-left": "\ue22e",
  "border-outer": "\ue22f",
  "border-right": "\ue230",
  "border-style": "\ue231",
  "border-top": "\ue232",
  "border-vertical": "\ue233",
  "branding-watermark": "\ue06b",
  "brightness-1": "\ue3a6",
  "brightness-2": "\ue3a7",
  "brightness-3": "\ue3a8",
  "brightness-4": "\ue3a9",
  "brightness-5": "\ue3aa",
  "brightness-6": "\ue3ab",
  "brightness-7": "\ue3ac",
  "brightness-auto": "\ue1ab",
  "brightness-high": "\ue1ac",
  "brightness-low": "\ue1ad",
  "brightness-medium": "\ue1ae",
  "broken-image": "\ue3ad",
  brush: "\ue3ae",
  "bubble-chart": "\ue6dd",
  "bug-report": "\ue868",
  build: "\ue869",
  "burst-mode": "\ue43c",
  business: "\ue0af",
  "business-center": "\ueb3f",
  cached: "\ue86a",
  cake: "\ue7e9",
  call: "\ue0b0",
  "call-end": "\ue0b1",
  "call-made": "\ue0b2",
  "call-merge": "\ue0b3",
  "call-missed": "\ue0b4",
  "call-missed-outgoing": "\ue0e4",
  "call-received": "\ue0b5",
  "call-split": "\ue0b6",
  "call-to-action": "\ue06c",
  "camera-alt": "\ue3b0",
  "camera-enhance": "\ue8fc",
  "camera-front": "\ue3b1",
  "camera-rear": "\ue3b2",
  "camera-roll": "\ue3b3",
  cancel: "\ue5c9",
  "card-giftcard": "\ue8f6",
  "card-membership": "\ue8f7",
  "card-travel": "\ue8f8",
  cast: "\ue307",
  "cast-connected": "\ue308",
  "center-focus-strong": "\ue3b4",
  "center-focus-weak": "\ue3b5",
  "change-history": "\ue86b",
  "chat-bubble": "\ue0ca",
  "chat-bubble-outline": "\ue0cb",
  check: "\ue5ca",
  "check-box": "\ue834",
  "check-box-outline-blank": "\ue835",
  "check-circle": "\ue86c",
  "chevron-left": "\ue5cb",
  "chevron-right": "\ue5cc",
  "child-care": "\ueb41",
  "child-friendly": "\ueb42",
  "chrome-reader-mode": "\ue86d",
  class: "\ue86e",
  clear: "\ue14c",
  "clear-all": "\ue0b8",
  close: "\ue5cd",
  "closed-caption": "\ue01c",
  cloud: "\ue2bd",
  "cloud-circle": "\ue2be",
  "cloud-done": "\ue2bf",
  "cloud-download": "\ue2c0",
  "cloud-off": "\ue2c1",
  "cloud-queue": "\ue2c2",
  "cloud-upload": "\ue2c3",
  code: "\ue86f",
  collections: "\ue3b6",
  "collections-bookmark": "\ue431",
  "color-lens": "\ue3b7",
  colorize: "\ue3b8",
  comment: "\ue0b9",
  compare: "\ue3b9",
  "compare-arrows": "\ue915",
  computer: "\ue30a",
  "confirmation-number": "\ue638",
  "contact-mail": "\ue0d0",
  "contact-phone": "\ue0cf",
  contacts: "\ue0ba",
  "content-copy": "\ue14d",
  "content-cut": "\ue14e",
  "content-paste": "\ue14f",
  "control-point": "\ue3ba",
  "control-point-duplicate": "\ue3bb",
  copyright: "\ue90c",
  create: "\ue150",
  "create-new-folder": "\ue2cc",
  "credit-card": "\ue870",
  crop: "\ue3be",
  "crop-16-9": "\ue3bc",
  "crop-3-2": "\ue3bd",
  "crop-5-4": "\ue3bf",
  "crop-7-5": "\ue3c0",
  "crop-din": "\ue3c1",
  "crop-free": "\ue3c2",
  "crop-landscape": "\ue3c3",
  "crop-original": "\ue3c4",
  "crop-portrait": "\ue3c5",
  "crop-rotate": "\ue437",
  "crop-square": "\ue3c6",
  dashboard: "\ue871",
  "data-usage": "\ue1af",
  "date-range": "\ue916",
  dehaze: "\ue3c7",
  delete: "\ue872",
  "delete-forever": "\ue92b",
  "delete-sweep": "\ue16c",
  description: "\ue873",
  "desktop-mac": "\ue30b",
  "desktop-windows": "\ue30c",
  details: "\ue3c8",
  "developer-board": "\ue30d",
  "developer-mode": "\ue1b0",
  "device-hub": "\ue335",
  devices: "\ue1b1",
  "devices-other": "\ue337",
  "dialer-sip": "\ue0bb",
  dialpad: "\ue0bc",
  directions: "\ue52e",
  "directions-bike": "\ue52f",
  "directions-boat": "\ue532",
  "directions-bus": "\ue530",
  "directions-car": "\ue531",
  "directions-railway": "\ue534",
  "directions-run": "\ue566",
  "directions-subway": "\ue533",
  "directions-transit": "\ue535",
  "directions-walk": "\ue536",
  "disc-full": "\ue610",
  dns: "\ue875",
  "do-not-disturb": "\ue612",
  "do-not-disturb-alt": "\ue611",
  "do-not-disturb-off": "\ue643",
  "do-not-disturb-on": "\ue644",
  dock: "\ue30e",
  domain: "\ue7ee",
  done: "\ue876",
  "done-all": "\ue877",
  "donut-large": "\ue917",
  "donut-small": "\ue918",
  drafts: "\ue151",
  "drag-handle": "\ue25d",
  "drive-eta": "\ue613",
  dvr: "\ue1b2",
  chat: "\ue0b7",
  forum: "\ue0bf",
  wallpaper: "\ue1bc",
  widgets: "\ue1bd",
  headset: "\ue310",
  keyboard: "\ue312",
  laptop: "\ue31e",
  mouse: "\ue323",
  router: "\ue328",
  scanner: "\ue329",
  tablet: "\ue32f",
  camera: "\ue3af",
  lens: "\ue3fa",
  looks: "\ue3fc",
  apps: "\ue5c3",
  backup: "\ue864",
  casino: "\ueb40",
  spa: "\ueb4c",
  edit: "\ue3c9",
  "edit-location": "\ue568",
  eject: "\ue8fb",
  email: "\ue0be",
  "enhanced-encryption": "\ue63f",
  equalizer: "\ue01d",
  error: "\ue000",
  "error-outline": "\ue001",
  "euro-symbol": "\ue926",
  "ev-station": "\ue56d",
  event: "\ue878",
  "event-available": "\ue614",
  "event-busy": "\ue615",
  "event-note": "\ue616",
  "event-seat": "\ue903",
  "exit-to-app": "\ue879",
  "expand-less": "\ue5ce",
  "expand-more": "\ue5cf",
  explicit: "\ue01e",
  explore: "\ue87a",
  exposure: "\ue3ca",
  "exposure-neg-1": "\ue3cb",
  "exposure-neg-2": "\ue3cc",
  "exposure-plus-1": "\ue3cd",
  "exposure-plus-2": "\ue3ce",
  "exposure-zero": "\ue3cf",
  extension: "\ue87b",
  face: "\ue87c",
  "fast-forward": "\ue01f",
  "fast-rewind": "\ue020",
  favorite: "\ue87d",
  "favorite-border": "\ue87e",
  "featured-play-list": "\ue06d",
  "featured-video": "\ue06e",
  feedback: "\ue87f",
  "fiber-dvr": "\ue05d",
  "fiber-manual-record": "\ue061",
  "fiber-new": "\ue05e",
  "fiber-pin": "\ue06a",
  "fiber-smart-record": "\ue062",
  "file-download": "\ue2c4",
  "file-upload": "\ue2c6",
  filter: "\ue3d3",
  "filter-1": "\ue3d0",
  "filter-2": "\ue3d1",
  "filter-3": "\ue3d2",
  "filter-4": "\ue3d4",
  "filter-5": "\ue3d5",
  "filter-6": "\ue3d6",
  "filter-7": "\ue3d7",
  "filter-8": "\ue3d8",
  "filter-9": "\ue3d9",
  "filter-9-plus": "\ue3da",
  "filter-b-and-w": "\ue3db",
  "filter-center-focus": "\ue3dc",
  "filter-drama": "\ue3dd",
  "filter-frames": "\ue3de",
  "filter-hdr": "\ue3df",
  "filter-list": "\ue152",
  "filter-none": "\ue3e0",
  "filter-tilt-shift": "\ue3e2",
  "filter-vintage": "\ue3e3",
  "find-in-page": "\ue880",
  "find-replace": "\ue881",
  fingerprint: "\ue90d",
  "first-page": "\ue5dc",
  "fitness-center": "\ueb43",
  flag: "\ue153",
  flare: "\ue3e4",
  "flash-auto": "\ue3e5",
  "flash-off": "\ue3e6",
  "flash-on": "\ue3e7",
  flight: "\ue539",
  "flight-land": "\ue904",
  "flight-takeoff": "\ue905",
  flip: "\ue3e8",
  "flip-to-back": "\ue882",
  "flip-to-front": "\ue883",
  folder: "\ue2c7",
  "folder-open": "\ue2c8",
  "folder-shared": "\ue2c9",
  "folder-special": "\ue617",
  "font-download": "\ue167",
  "format-align-center": "\ue234",
  "format-align-justify": "\ue235",
  "format-align-left": "\ue236",
  "format-align-right": "\ue237",
  "format-bold": "\ue238",
  "format-clear": "\ue239",
  "format-color-fill": "\ue23a",
  "format-color-reset": "\ue23b",
  "format-color-text": "\ue23c",
  "format-indent-decrease": "\ue23d",
  "format-indent-increase": "\ue23e",
  "format-italic": "\ue23f",
  "format-line-spacing": "\ue240",
  "format-list-bulleted": "\ue241",
  "format-list-numbered": "\ue242",
  "format-paint": "\ue243",
  "format-quote": "\ue244",
  "format-shapes": "\ue25e",
  "format-size": "\ue245",
  "format-strikethrough": "\ue246",
  "format-textdirection-l-to-r": "\ue247",
  "format-textdirection-r-to-l": "\ue248",
  "format-underlined": "\ue249",
  forward: "\ue154",
  "forward-10": "\ue056",
  "forward-30": "\ue057",
  "forward-5": "\ue058",
  "free-breakfast": "\ueb44",
  fullscreen: "\ue5d0",
  "fullscreen-exit": "\ue5d1",
  functions: "\ue24a",
  "g-translate": "\ue927",
  gamepad: "\ue30f",
  games: "\ue021",
  gavel: "\ue90e",
  gesture: "\ue155",
  "get-app": "\ue884",
  gif: "\ue908",
  "golf-course": "\ueb45",
  "gps-fixed": "\ue1b3",
  "gps-not-fixed": "\ue1b4",
  "gps-off": "\ue1b5",
  grade: "\ue885",
  gradient: "\ue3e9",
  grain: "\ue3ea",
  "graphic-eq": "\ue1b8",
  "grid-off": "\ue3eb",
  "grid-on": "\ue3ec",
  group: "\ue7ef",
  "group-add": "\ue7f0",
  "group-work": "\ue886",
  hd: "\ue052",
  "hdr-off": "\ue3ed",
  "hdr-on": "\ue3ee",
  "hdr-strong": "\ue3f1",
  "hdr-weak": "\ue3f2",
  "headset-mic": "\ue311",
  healing: "\ue3f3",
  hearing: "\ue023",
  help: "\ue887",
  "help-outline": "\ue8fd",
  "high-quality": "\ue024",
  highlight: "\ue25f",
  "highlight-off": "\ue888",
  history: "\ue889",
  home: "\ue88a",
  "hot-tub": "\ueb46",
  hotel: "\ue53a",
  "hourglass-empty": "\ue88b",
  "hourglass-full": "\ue88c",
  http: "\ue902",
  https: "\ue88d",
  image: "\ue3f4",
  "image-aspect-ratio": "\ue3f5",
  "import-contacts": "\ue0e0",
  "import-export": "\ue0c3",
  "important-devices": "\ue912",
  inbox: "\ue156",
  "indeterminate-check-box": "\ue909",
  info: "\ue88e",
  "info-outline": "\ue88f",
  input: "\ue890",
  "insert-chart": "\ue24b",
  "insert-comment": "\ue24c",
  "insert-drive-file": "\ue24d",
  "insert-emoticon": "\ue24e",
  "insert-invitation": "\ue24f",
  "insert-link": "\ue250",
  "insert-photo": "\ue251",
  "invert-colors": "\ue891",
  "invert-colors-off": "\ue0c4",
  iso: "\ue3f6",
  "keyboard-arrow-down": "\ue313",
  "keyboard-arrow-left": "\ue314",
  "keyboard-arrow-right": "\ue315",
  "keyboard-arrow-up": "\ue316",
  "keyboard-backspace": "\ue317",
  "keyboard-capslock": "\ue318",
  "keyboard-hide": "\ue31a",
  "keyboard-return": "\ue31b",
  "keyboard-tab": "\ue31c",
  "keyboard-voice": "\ue31d",
  kitchen: "\ueb47",
  label: "\ue892",
  "label-outline": "\ue893",
  landscape: "\ue3f7",
  language: "\ue894",
  "laptop-chromebook": "\ue31f",
  "laptop-mac": "\ue320",
  "laptop-windows": "\ue321",
  "last-page": "\ue5dd",
  launch: "\ue895",
  layers: "\ue53b",
  "layers-clear": "\ue53c",
  "leak-add": "\ue3f8",
  "leak-remove": "\ue3f9",
  "library-add": "\ue02e",
  "library-books": "\ue02f",
  "library-music": "\ue030",
  "lightbulb-outline": "\ue90f",
  "line-style": "\ue919",
  "line-weight": "\ue91a",
  "linear-scale": "\ue260",
  link: "\ue157",
  "linked-camera": "\ue438",
  list: "\ue896",
  "live-help": "\ue0c6",
  "live-tv": "\ue639",
  "local-activity": "\ue53f",
  "local-airport": "\ue53d",
  "local-atm": "\ue53e",
  "local-bar": "\ue540",
  "local-cafe": "\ue541",
  "local-car-wash": "\ue542",
  "local-convenience-store": "\ue543",
  "local-dining": "\ue556",
  "local-drink": "\ue544",
  "local-florist": "\ue545",
  "local-gas-station": "\ue546",
  "local-grocery-store": "\ue547",
  "local-hospital": "\ue548",
  "local-hotel": "\ue549",
  "local-laundry-service": "\ue54a",
  "local-library": "\ue54b",
  "local-mall": "\ue54c",
  "local-movies": "\ue54d",
  "local-offer": "\ue54e",
  "local-parking": "\ue54f",
  "local-pharmacy": "\ue550",
  "local-phone": "\ue551",
  "local-pizza": "\ue552",
  "local-play": "\ue553",
  "local-post-office": "\ue554",
  "local-printshop": "\ue555",
  "local-see": "\ue557",
  "local-shipping": "\ue558",
  "local-taxi": "\ue559",
  "location-city": "\ue7f1",
  "location-disabled": "\ue1b6",
  "location-off": "\ue0c7",
  "location-on": "\ue0c8",
  "location-searching": "\ue1b7",
  lock: "\ue897",
  "lock-open": "\ue898",
  "lock-outline": "\ue899",
  "looks-3": "\ue3fb",
  "looks-4": "\ue3fd",
  "looks-5": "\ue3fe",
  "looks-6": "\ue3ff",
  "looks-one": "\ue400",
  "looks-two": "\ue401",
  loop: "\ue028",
  loupe: "\ue402",
  "low-priority": "\ue16d",
  loyalty: "\ue89a",
  mail: "\ue158",
  "mail-outline": "\ue0e1",
  map: "\ue55b",
  markunread: "\ue159",
  "markunread-mailbox": "\ue89b",
  memory: "\ue322",
  menu: "\ue5d2",
  "merge-type": "\ue252",
  message: "\ue0c9",
  mic: "\ue029",
  "mic-none": "\ue02a",
  "mic-off": "\ue02b",
  mms: "\ue618",
  "mode-comment": "\ue253",
  "mode-edit": "\ue254",
  "monetization-on": "\ue263",
  "money-off": "\ue25c",
  "monochrome-photos": "\ue403",
  mood: "\ue7f2",
  "mood-bad": "\ue7f3",
  more: "\ue619",
  "more-horiz": "\ue5d3",
  "more-vert": "\ue5d4",
  motorcycle: "\ue91b",
  "move-to-inbox": "\ue168",
  movie: "\ue02c",
  "movie-creation": "\ue404",
  "movie-filter": "\ue43a",
  "multiline-chart": "\ue6df",
  "music-note": "\ue405",
  "music-video": "\ue063",
  "my-location": "\ue55c",
  nature: "\ue406",
  "nature-people": "\ue407",
  "navigate-before": "\ue408",
  "navigate-next": "\ue409",
  navigation: "\ue55d",
  "near-me": "\ue569",
  "network-cell": "\ue1b9",
  "network-check": "\ue640",
  "network-locked": "\ue61a",
  "network-wifi": "\ue1ba",
  "new-releases": "\ue031",
  "next-week": "\ue16a",
  nfc: "\ue1bb",
  "no-encryption": "\ue641",
  "no-sim": "\ue0cc",
  "not-interested": "\ue033",
  note: "\ue06f",
  "note-add": "\ue89c",
  notifications: "\ue7f4",
  "notifications-active": "\ue7f7",
  "notifications-none": "\ue7f5",
  "notifications-off": "\ue7f6",
  "notifications-paused": "\ue7f8",
  "offline-pin": "\ue90a",
  "ondemand-video": "\ue63a",
  opacity: "\ue91c",
  "open-in-browser": "\ue89d",
  "open-in-new": "\ue89e",
  "open-with": "\ue89f",
  pages: "\ue7f9",
  pageview: "\ue8a0",
  palette: "\ue40a",
  "pan-tool": "\ue925",
  panorama: "\ue40b",
  "panorama-fish-eye": "\ue40c",
  "panorama-horizontal": "\ue40d",
  "panorama-vertical": "\ue40e",
  "panorama-wide-angle": "\ue40f",
  "party-mode": "\ue7fa",
  pause: "\ue034",
  "pause-circle-filled": "\ue035",
  "pause-circle-outline": "\ue036",
  payment: "\ue8a1",
  people: "\ue7fb",
  "people-outline": "\ue7fc",
  "perm-camera-mic": "\ue8a2",
  "perm-contact-calendar": "\ue8a3",
  "perm-data-setting": "\ue8a4",
  "perm-device-information": "\ue8a5",
  "perm-identity": "\ue8a6",
  "perm-media": "\ue8a7",
  "perm-phone-msg": "\ue8a8",
  person: "\ue7fd",
  "person-add": "\ue7fe",
  "person-outline": "\ue7ff",
  "person-pin": "\ue55a",
  "person-pin-circle": "\ue56a",
  "personal-video": "\ue63b",
  pets: "\ue91d",
  phone: "\ue0cd",
  "phone-android": "\ue324",
  "phone-bluetooth-speaker": "\ue61b",
  "phone-forwarded": "\ue61c",
  "phone-in-talk": "\ue61d",
  "phone-iphone": "\ue325",
  "phone-locked": "\ue61e",
  "phone-missed": "\ue61f",
  "phone-paused": "\ue620",
  phonelink: "\ue326",
  "phonelink-erase": "\ue0db",
  "phonelink-lock": "\ue0dc",
  "phonelink-off": "\ue327",
  "phonelink-ring": "\ue0dd",
  "phonelink-setup": "\ue0de",
  photo: "\ue410",
  "photo-album": "\ue411",
  "photo-camera": "\ue412",
  "photo-filter": "\ue43b",
  "photo-library": "\ue413",
  "photo-size-select-actual": "\ue432",
  "photo-size-select-large": "\ue433",
  "photo-size-select-small": "\ue434",
  "picture-as-pdf": "\ue415",
  "picture-in-picture": "\ue8aa",
  "picture-in-picture-alt": "\ue911",
  "pie-chart": "\ue6c4",
  "pie-chart-outlined": "\ue6c5",
  "pin-drop": "\ue55e",
  place: "\ue55f",
  "play-arrow": "\ue037",
  "play-circle-filled": "\ue038",
  "play-circle-outline": "\ue039",
  "play-for-work": "\ue906",
  "playlist-add": "\ue03b",
  "playlist-add-check": "\ue065",
  "playlist-play": "\ue05f",
  "plus-one": "\ue800",
  poll: "\ue801",
  polymer: "\ue8ab",
  pool: "\ueb48",
  "portable-wifi-off": "\ue0ce",
  portrait: "\ue416",
  power: "\ue63c",
  "power-input": "\ue336",
  "power-settings-new": "\ue8ac",
  "pregnant-woman": "\ue91e",
  "present-to-all": "\ue0df",
  print: "\ue8ad",
  "priority-high": "\ue645",
  public: "\ue80b",
  publish: "\ue255",
  "query-builder": "\ue8ae",
  "question-answer": "\ue8af",
  queue: "\ue03c",
  "queue-music": "\ue03d",
  "queue-play-next": "\ue066",
  radio: "\ue03e",
  "radio-button-checked": "\ue837",
  "radio-button-unchecked": "\ue836",
  "rate-review": "\ue560",
  receipt: "\ue8b0",
  "recent-actors": "\ue03f",
  "record-voice-over": "\ue91f",
  redeem: "\ue8b1",
  redo: "\ue15a",
  refresh: "\ue5d5",
  remove: "\ue15b",
  "remove-circle": "\ue15c",
  "remove-circle-outline": "\ue15d",
  "remove-from-queue": "\ue067",
  "remove-red-eye": "\ue417",
  "remove-shopping-cart": "\ue928",
  reorder: "\ue8fe",
  repeat: "\ue040",
  "repeat-one": "\ue041",
  replay: "\ue042",
  "replay-10": "\ue059",
  "replay-30": "\ue05a",
  "replay-5": "\ue05b",
  reply: "\ue15e",
  "reply-all": "\ue15f",
  report: "\ue160",
  "report-problem": "\ue8b2",
  restaurant: "\ue56c",
  "restaurant-menu": "\ue561",
  restore: "\ue8b3",
  "restore-page": "\ue929",
  "ring-volume": "\ue0d1",
  room: "\ue8b4",
  "room-service": "\ueb49",
  "rotate-90-degrees-ccw": "\ue418",
  "rotate-left": "\ue419",
  "rotate-right": "\ue41a",
  "rounded-corner": "\ue920",
  rowing: "\ue921",
  "rss-feed": "\ue0e5",
  "rv-hookup": "\ue642",
  satellite: "\ue562",
  save: "\ue161",
  schedule: "\ue8b5",
  school: "\ue80c",
  "screen-lock-landscape": "\ue1be",
  "screen-lock-portrait": "\ue1bf",
  "screen-lock-rotation": "\ue1c0",
  "screen-rotation": "\ue1c1",
  "screen-share": "\ue0e2",
  "sd-card": "\ue623",
  "sd-storage": "\ue1c2",
  search: "\ue8b6",
  security: "\ue32a",
  "select-all": "\ue162",
  send: "\ue163",
  "sentiment-dissatisfied": "\ue811",
  "sentiment-neutral": "\ue812",
  "sentiment-satisfied": "\ue813",
  "sentiment-very-dissatisfied": "\ue814",
  "sentiment-very-satisfied": "\ue815",
  settings: "\ue8b8",
  "settings-applications": "\ue8b9",
  "settings-backup-restore": "\ue8ba",
  "settings-bluetooth": "\ue8bb",
  "settings-brightness": "\ue8bd",
  "settings-cell": "\ue8bc",
  "settings-ethernet": "\ue8be",
  "settings-input-antenna": "\ue8bf",
  "settings-input-component": "\ue8c0",
  "settings-input-composite": "\ue8c1",
  "settings-input-hdmi": "\ue8c2",
  "settings-input-svideo": "\ue8c3",
  "settings-overscan": "\ue8c4",
  "settings-phone": "\ue8c5",
  "settings-power": "\ue8c6",
  "settings-remote": "\ue8c7",
  "settings-system-daydream": "\ue1c3",
  "settings-voice": "\ue8c8",
  share: "\ue80d",
  shop: "\ue8c9",
  "shop-two": "\ue8ca",
  "shopping-basket": "\ue8cb",
  "shopping-cart": "\ue8cc",
  "short-text": "\ue261",
  "show-chart": "\ue6e1",
  shuffle: "\ue043",
  "signal-cellular-4-bar": "\ue1c8",
  "signal-cellular-connected-no-internet-4-bar": "\ue1cd",
  "signal-cellular-no-sim": "\ue1ce",
  "signal-cellular-null": "\ue1cf",
  "signal-cellular-off": "\ue1d0",
  "signal-wifi-4-bar": "\ue1d8",
  "signal-wifi-4-bar-lock": "\ue1d9",
  "signal-wifi-off": "\ue1da",
  "sim-card": "\ue32b",
  "sim-card-alert": "\ue624",
  "skip-next": "\ue044",
  "skip-previous": "\ue045",
  slideshow: "\ue41b",
  "slow-motion-video": "\ue068",
  smartphone: "\ue32c",
  "smoke-free": "\ueb4a",
  "smoking-rooms": "\ueb4b",
  sms: "\ue625",
  "sms-failed": "\ue626",
  snooze: "\ue046",
  sort: "\ue164",
  "sort-by-alpha": "\ue053",
  "space-bar": "\ue256",
  speaker: "\ue32d",
  "speaker-group": "\ue32e",
  "speaker-notes": "\ue8cd",
  "speaker-notes-off": "\ue92a",
  "speaker-phone": "\ue0d2",
  spellcheck: "\ue8ce",
  star: "\ue838",
  "star-border": "\ue83a",
  "star-half": "\ue839",
  stars: "\ue8d0",
  "stay-current-landscape": "\ue0d3",
  "stay-current-portrait": "\ue0d4",
  "stay-primary-landscape": "\ue0d5",
  "stay-primary-portrait": "\ue0d6",
  stop: "\ue047",
  "stop-screen-share": "\ue0e3",
  storage: "\ue1db",
  store: "\ue8d1",
  "store-mall-directory": "\ue563",
  straighten: "\ue41c",
  streetview: "\ue56e",
  "strikethrough-s": "\ue257",
  style: "\ue41d",
  "subdirectory-arrow-left": "\ue5d9",
  "subdirectory-arrow-right": "\ue5da",
  subject: "\ue8d2",
  subscriptions: "\ue064",
  subtitles: "\ue048",
  subway: "\ue56f",
  "supervisor-account": "\ue8d3",
  "surround-sound": "\ue049",
  "swap-calls": "\ue0d7",
  "swap-horiz": "\ue8d4",
  "swap-vert": "\ue8d5",
  "swap-vertical-circle": "\ue8d6",
  "switch-camera": "\ue41e",
  "switch-video": "\ue41f",
  sync: "\ue627",
  "sync-disabled": "\ue628",
  "sync-problem": "\ue629",
  "system-update": "\ue62a",
  "system-update-alt": "\ue8d7",
  tab: "\ue8d8",
  "tab-unselected": "\ue8d9",
  "tablet-android": "\ue330",
  "tablet-mac": "\ue331",
  "tag-faces": "\ue420",
  "tap-and-play": "\ue62b",
  terrain: "\ue564",
  "text-fields": "\ue262",
  "text-format": "\ue165",
  textsms: "\ue0d8",
  texture: "\ue421",
  theaters: "\ue8da",
  "thumb-down": "\ue8db",
  "thumb-up": "\ue8dc",
  "thumbs-up-down": "\ue8dd",
  "time-to-leave": "\ue62c",
  timelapse: "\ue422",
  timeline: "\ue922",
  timer: "\ue425",
  "timer-10": "\ue423",
  "timer-3": "\ue424",
  "timer-off": "\ue426",
  title: "\ue264",
  toc: "\ue8de",
  today: "\ue8df",
  toll: "\ue8e0",
  tonality: "\ue427",
  "touch-app": "\ue913",
  toys: "\ue332",
  "track-changes": "\ue8e1",
  traffic: "\ue565",
  train: "\ue570",
  tram: "\ue571",
  "transfer-within-a-station": "\ue572",
  transform: "\ue428",
  "trending-down": "\ue8e3",
  "trending-flat": "\ue8e4",
  "trending-up": "\ue8e5",
  tune: "\ue429",
  "turned-in": "\ue8e6",
  "turned-in-not": "\ue8e7",
  tv: "\ue333",
  unarchive: "\ue169",
  undo: "\ue166",
  "unfold-less": "\ue5d6",
  "unfold-more": "\ue5d7",
  update: "\ue923",
  usb: "\ue1e0",
  "verified-user": "\ue8e8",
  "vertical-align-bottom": "\ue258",
  "vertical-align-center": "\ue259",
  "vertical-align-top": "\ue25a",
  vibration: "\ue62d",
  "video-call": "\ue070",
  "video-label": "\ue071",
  "video-library": "\ue04a",
  videocam: "\ue04b",
  "videocam-off": "\ue04c",
  "view-agenda": "\ue8e9",
  "view-array": "\ue8ea",
  "view-carousel": "\ue8eb",
  "view-column": "\ue8ec",
  "view-comfy": "\ue42a",
  "view-compact": "\ue42b",
  "view-day": "\ue8ed",
  "view-headline": "\ue8ee",
  "view-list": "\ue8ef",
  "view-module": "\ue8f0",
  "view-quilt": "\ue8f1",
  "view-stream": "\ue8f2",
  "view-week": "\ue8f3",
  vignette: "\ue435",
  visibility: "\ue8f4",
  "visibility-off": "\ue8f5",
  "voice-chat": "\ue62e",
  voicemail: "\ue0d9",
  "volume-down": "\ue04d",
  "volume-mute": "\ue04e",
  "volume-off": "\ue04f",
  "volume-up": "\ue050",
  "vpn-key": "\ue0da",
  "vpn-lock": "\ue62f",
  warning: "\ue002",
  watch: "\ue334",
  "watch-later": "\ue924",
  "wb-auto": "\ue42c",
  "wb-cloudy": "\ue42d",
  "wb-incandescent": "\ue42e",
  "wb-iridescent": "\ue436",
  "wb-sunny": "\ue430",
  wc: "\ue63d",
  web: "\ue051",
  "web-asset": "\ue069",
  weekend: "\ue16b",
  whatshot: "\ue80e",
  wifi: "\ue63e",
  "wifi-lock": "\ue1e1",
  "wifi-tethering": "\ue1e2",
  work: "\ue8f9",
  "wrap-text": "\ue25b",
  "youtube-searched-for": "\ue8fa",
  "zoom-in": "\ue8ff",
  "zoom-out": "\ue900",
  "zoom-out-map": "\ue56b"
};

class Icon extends PureComponent {
  render() {
    const { name, style, theme, onPress, size, color, children } = this.props;

    if (!icons[name]) console.warn(`The icon name of ${name} is not supported`);

    return (
      <Text
        allowFontScaling={true}
        style={[
          theme.icon,
          style,
          {
            fontSize: size,
            color
          }
        ]}
        onPress={onPress}
      >
        {children || icons[name]}
      </Text>
    );
  }
}

Icon.propTypes = {
  name: PropTypes.string,
  color: PropTypes.string,
  size: PropTypes.number,
  onPress: PropTypes.func
};

Icon.defaultProps = {
  color: "#000",
  size: 16
};

Icon.themeConfig = {
  style: {
    icon: {
      fontFamily: "Material Icons",
      backgroundColor: "transparent"
    }
  }
};

export default withTheme("Icon", Icon);
