<?php

namespace AlibabaCloud\Sas\V20181203;

use AlibabaCloud\Client\Resolver\ApiResolver;

/**
 * @method AddVpcHoneyPot addVpcHoneyPot(array $options = [])
 * @method CheckQuaraFileId checkQuaraFileId(array $options = [])
 * @method CheckSecurityEventId checkSecurityEventId(array $options = [])
 * @method CreateAntiBruteForceRule createAntiBruteForceRule(array $options = [])
 * @method CreateBackupPolicy createBackupPolicy(array $options = [])
 * @method CreateOrUpdateAssetGroup createOrUpdateAssetGroup(array $options = [])
 * @method CreateRestoreJob createRestoreJob(array $options = [])
 * @method CreateSasOrder createSasOrder(array $options = [])
 * @method CreateServiceLinkedRole createServiceLinkedRole(array $options = [])
 * @method CreateSimilarSecurityEventsQueryTask createSimilarSecurityEventsQueryTask(array $options = [])
 * @method DeleteBackupPolicy deleteBackupPolicy(array $options = [])
 * @method DeleteBackupPolicyMachine deleteBackupPolicyMachine(array $options = [])
 * @method DeleteGroup deleteGroup(array $options = [])
 * @method DeleteLoginBaseConfig deleteLoginBaseConfig(array $options = [])
 * @method DeleteTagWithUuid deleteTagWithUuid(array $options = [])
 * @method DeleteVpcHoneyPot deleteVpcHoneyPot(array $options = [])
 * @method DescribeAccesskeyLeakList describeAccesskeyLeakList(array $options = [])
 * @method DescribeAffectedMaliciousFileImages describeAffectedMaliciousFileImages(array $options = [])
 * @method DescribeAlarmEventDetail describeAlarmEventDetail(array $options = [])
 * @method DescribeAlarmEventList describeAlarmEventList(array $options = [])
 * @method DescribeAlarmEventStackInfo describeAlarmEventStackInfo(array $options = [])
 * @method DescribeAllEntity describeAllEntity(array $options = [])
 * @method DescribeAllGroups describeAllGroups(array $options = [])
 * @method DescribeAllRegionsStatistics describeAllRegionsStatistics(array $options = [])
 * @method DescribeAntiBruteForceRules describeAntiBruteForceRules(array $options = [])
 * @method DescribeAssetDetailByUuid describeAssetDetailByUuid(array $options = [])
 * @method DescribeAssetDetailByUuids describeAssetDetailByUuids(array $options = [])
 * @method DescribeAutoDelConfig describeAutoDelConfig(array $options = [])
 * @method DescribeBackupDirs describeBackupDirs(array $options = [])
 * @method DescribeBackupFiles describeBackupFiles(array $options = [])
 * @method DescribeBackupMachineStatus describeBackupMachineStatus(array $options = [])
 * @method DescribeBackupPolicies describeBackupPolicies(array $options = [])
 * @method DescribeBackupPolicy describeBackupPolicy(array $options = [])
 * @method DescribeBackupRestoreCount describeBackupRestoreCount(array $options = [])
 * @method DescribeBruteForceSummary describeBruteForceSummary(array $options = [])
 * @method DescribeCheckEcsWarnings describeCheckEcsWarnings(array $options = [])
 * @method DescribeCheckWarningDetail describeCheckWarningDetail(array $options = [])
 * @method DescribeCheckWarnings describeCheckWarnings(array $options = [])
 * @method DescribeCheckWarningSummary describeCheckWarningSummary(array $options = [])
 * @method DescribeCloudCenterInstances describeCloudCenterInstances(array $options = [])
 * @method DescribeCloudProductFieldStatistics describeCloudProductFieldStatistics(array $options = [])
 * @method DescribeConcernNecessity describeConcernNecessity(array $options = [])
 * @method DescribeContainerStatistics describeContainerStatistics(array $options = [])
 * @method DescribeCriteria describeCriteria(array $options = [])
 * @method DescribeDialogMessages describeDialogMessages(array $options = [])
 * @method DescribeDingTalk describeDingTalk(array $options = [])
 * @method DescribeDomainCount describeDomainCount(array $options = [])
 * @method DescribeDomainDetail describeDomainDetail(array $options = [])
 * @method DescribeDomainList describeDomainList(array $options = [])
 * @method DescribeEmgVulItem describeEmgVulItem(array $options = [])
 * @method DescribeExcludeSystemPath describeExcludeSystemPath(array $options = [])
 * @method DescribeExportInfo describeExportInfo(array $options = [])
 * @method DescribeExposedInstanceCriteria describeExposedInstanceCriteria(array $options = [])
 * @method DescribeExposedInstanceDetail describeExposedInstanceDetail(array $options = [])
 * @method DescribeExposedInstanceList describeExposedInstanceList(array $options = [])
 * @method DescribeExposedStatistics describeExposedStatistics(array $options = [])
 * @method DescribeExposedStatisticsDetail describeExposedStatisticsDetail(array $options = [])
 * @method DescribeFieldStatistics describeFieldStatistics(array $options = [])
 * @method DescribeFrontVulPatchList describeFrontVulPatchList(array $options = [])
 * @method DescribeGraph4InvestigationOnline describeGraph4InvestigationOnline(array $options = [])
 * @method DescribeGroupedContainerInstances describeGroupedContainerInstances(array $options = [])
 * @method DescribeGroupedInstances describeGroupedInstances(array $options = [])
 * @method DescribeGroupedMaliciousFiles describeGroupedMaliciousFiles(array $options = [])
 * @method DescribeGroupedTags describeGroupedTags(array $options = [])
 * @method DescribeGroupedVul describeGroupedVul(array $options = [])
 * @method DescribeHoneyPotAuth describeHoneyPotAuth(array $options = [])
 * @method DescribeHoneyPotSuspStatistics describeHoneyPotSuspStatistics(array $options = [])
 * @method DescribeImageGroupedVulList describeImageGroupedVulList(array $options = [])
 * @method DescribeImageStatistics describeImageStatistics(array $options = [])
 * @method DescribeImageVulList describeImageVulList(array $options = [])
 * @method DescribeInstallCaptcha describeInstallCaptcha(array $options = [])
 * @method DescribeInstanceAntiBruteForceRules describeInstanceAntiBruteForceRules(array $options = [])
 * @method DescribeInstanceStatistics describeInstanceStatistics(array $options = [])
 * @method DescribeIpInfo describeIpInfo(array $options = [])
 * @method DescribeLogstoreStorage describeLogstoreStorage(array $options = [])
 * @method DescribeModuleConfig describeModuleConfig(array $options = [])
 * @method DescribeNoticeConfig describeNoticeConfig(array $options = [])
 * @method DescribePropertyCount describePropertyCount(array $options = [])
 * @method DescribePropertyCronDetail describePropertyCronDetail(array $options = [])
 * @method DescribePropertyPortDetail describePropertyPortDetail(array $options = [])
 * @method DescribePropertyPortItem describePropertyPortItem(array $options = [])
 * @method DescribePropertyProcDetail describePropertyProcDetail(array $options = [])
 * @method DescribePropertyProcItem describePropertyProcItem(array $options = [])
 * @method DescribePropertyScaDetail describePropertyScaDetail(array $options = [])
 * @method DescribePropertySoftwareDetail describePropertySoftwareDetail(array $options = [])
 * @method DescribePropertySoftwareItem describePropertySoftwareItem(array $options = [])
 * @method DescribePropertyUsageNewest describePropertyUsageNewest(array $options = [])
 * @method DescribePropertyUserDetail describePropertyUserDetail(array $options = [])
 * @method DescribePropertyUserItem describePropertyUserItem(array $options = [])
 * @method DescribeQuaraFileDownloadInfo describeQuaraFileDownloadInfo(array $options = [])
 * @method DescribeRestoreJobs describeRestoreJobs(array $options = [])
 * @method DescribeRiskCheckItemResult describeRiskCheckItemResult(array $options = [])
 * @method DescribeRiskCheckResult describeRiskCheckResult(array $options = [])
 * @method DescribeRiskCheckSummary describeRiskCheckSummary(array $options = [])
 * @method DescribeRiskItemType describeRiskItemType(array $options = [])
 * @method DescribeRiskListCheckResult describeRiskListCheckResult(array $options = [])
 * @method DescribeSasAssetStatisticsColumn describeSasAssetStatisticsColumn(array $options = [])
 * @method DescribeScanTaskProgress describeScanTaskProgress(array $options = [])
 * @method DescribeSearchCondition describeSearchCondition(array $options = [])
 * @method DescribeSecureSuggestion describeSecureSuggestion(array $options = [])
 * @method DescribeSecurityCheckScheduleConfig describeSecurityCheckScheduleConfig(array $options = [])
 * @method DescribeSecurityEventOperations describeSecurityEventOperations(array $options = [])
 * @method DescribeSecurityEventOperationStatus describeSecurityEventOperationStatus(array $options = [])
 * @method DescribeSecurityStatInfo describeSecurityStatInfo(array $options = [])
 * @method DescribeServiceLinkedRoleStatus describeServiceLinkedRoleStatus(array $options = [])
 * @method DescribeSimilarEventScenarios describeSimilarEventScenarios(array $options = [])
 * @method DescribeSimilarSecurityEvents describeSimilarSecurityEvents(array $options = [])
 * @method DescribeSnapshots describeSnapshots(array $options = [])
 * @method DescribeStrategyExecDetail describeStrategyExecDetail(array $options = [])
 * @method DescribeSummaryInfo describeSummaryInfo(array $options = [])
 * @method DescribeSupportRegion describeSupportRegion(array $options = [])
 * @method DescribeSuspEventDetail describeSuspEventDetail(array $options = [])
 * @method DescribeSuspEventQuaraFiles describeSuspEventQuaraFiles(array $options = [])
 * @method DescribeSuspEvents describeSuspEvents(array $options = [])
 * @method DescribeUserBackupMachines describeUserBackupMachines(array $options = [])
 * @method DescribeUserBaselineAuthorization describeUserBaselineAuthorization(array $options = [])
 * @method DescribeUserLayoutAuthorization describeUserLayoutAuthorization(array $options = [])
 * @method DescribeUuidsByVulNames describeUuidsByVulNames(array $options = [])
 * @method DescribeVersionConfig describeVersionConfig(array $options = [])
 * @method DescribeVolDingdingMessage describeVolDingdingMessage(array $options = [])
 * @method DescribeVpcHoneyPotCriteria describeVpcHoneyPotCriteria(array $options = [])
 * @method DescribeVpcHoneyPotList describeVpcHoneyPotList(array $options = [])
 * @method DescribeVpcList describeVpcList(array $options = [])
 * @method DescribeVulDetails describeVulDetails(array $options = [])
 * @method DescribeVulList describeVulList(array $options = [])
 * @method DescribeVulWhitelist describeVulWhitelist(array $options = [])
 * @method DescribeWarningMachines describeWarningMachines(array $options = [])
 * @method DescribeWebLockBindList describeWebLockBindList(array $options = [])
 * @method DescribeWebLockConfigList describeWebLockConfigList(array $options = [])
 * @method ExportRecord exportRecord(array $options = [])
 * @method FixCheckWarnings fixCheckWarnings(array $options = [])
 * @method GetBackupStorageCount getBackupStorageCount(array $options = [])
 * @method GetIncIOCs getIncIOCs(array $options = [])
 * @method GetIOCs getIOCs(array $options = [])
 * @method GetSuspiciousStatistics getSuspiciousStatistics(array $options = [])
 * @method GetVulStatistics getVulStatistics(array $options = [])
 * @method HandleSecurityEvents handleSecurityEvents(array $options = [])
 * @method HandleSimilarSecurityEvents handleSimilarSecurityEvents(array $options = [])
 * @method IgnoreHcCheckWarnings ignoreHcCheckWarnings(array $options = [])
 * @method InstallBackupClient installBackupClient(array $options = [])
 * @method ModifyAntiBruteForceRule modifyAntiBruteForceRule(array $options = [])
 * @method ModifyAssetGroup modifyAssetGroup(array $options = [])
 * @method ModifyBackupPolicy modifyBackupPolicy(array $options = [])
 * @method ModifyBackupPolicyStatus modifyBackupPolicyStatus(array $options = [])
 * @method ModifyCreateVulWhitelist modifyCreateVulWhitelist(array $options = [])
 * @method ModifyEmgVulSubmit modifyEmgVulSubmit(array $options = [])
 * @method ModifyGroupProperty modifyGroupProperty(array $options = [])
 * @method ModifyInstanceAntiBruteForceRule modifyInstanceAntiBruteForceRule(array $options = [])
 * @method ModifyLoginBaseConfig modifyLoginBaseConfig(array $options = [])
 * @method ModifyLoginSwitchConfig modifyLoginSwitchConfig(array $options = [])
 * @method ModifyNoticeConfig modifyNoticeConfig(array $options = [])
 * @method ModifyOpenLogShipper modifyOpenLogShipper(array $options = [])
 * @method ModifyOperateVul modifyOperateVul(array $options = [])
 * @method ModifyPushAllTask modifyPushAllTask(array $options = [])
 * @method ModifyRiskCheckStatus modifyRiskCheckStatus(array $options = [])
 * @method ModifyRiskSingleResultStatus modifyRiskSingleResultStatus(array $options = [])
 * @method ModifySecurityCheckScheduleConfig modifySecurityCheckScheduleConfig(array $options = [])
 * @method ModifyStartVulScan modifyStartVulScan(array $options = [])
 * @method ModifyTagWithUuid modifyTagWithUuid(array $options = [])
 * @method ModifyVpcHoneyPot modifyVpcHoneyPot(array $options = [])
 * @method ModifyVulTargetConfig modifyVulTargetConfig(array $options = [])
 * @method ModifyWebLockCreateConfig modifyWebLockCreateConfig(array $options = [])
 * @method ModifyWebLockDeleteConfig modifyWebLockDeleteConfig(array $options = [])
 * @method ModifyWebLockStart modifyWebLockStart(array $options = [])
 * @method ModifyWebLockStatus modifyWebLockStatus(array $options = [])
 * @method ModifyWebLockUnbind modifyWebLockUnbind(array $options = [])
 * @method ModifyWebLockUpdateConfig modifyWebLockUpdateConfig(array $options = [])
 * @method OperateSuspiciousTargetConfig operateSuspiciousTargetConfig(array $options = [])
 * @method OperateVuls operateVuls(array $options = [])
 * @method OperationSuspEvents operationSuspEvents(array $options = [])
 * @method PauseClient pauseClient(array $options = [])
 * @method RefreshContainerAssets refreshContainerAssets(array $options = [])
 * @method RollbackSuspEventQuaraFile rollbackSuspEventQuaraFile(array $options = [])
 * @method SasInstallCode sasInstallCode(array $options = [])
 * @method StartBaselineSecurityCheck startBaselineSecurityCheck(array $options = [])
 * @method StartImageVulScan startImageVulScan(array $options = [])
 * @method StartVirusScanTask startVirusScanTask(array $options = [])
 * @method UnbindAegis unbindAegis(array $options = [])
 * @method UninstallBackupClient uninstallBackupClient(array $options = [])
 * @method ValidateHcWarnings validateHcWarnings(array $options = [])
 */
class SasApiResolver extends ApiResolver
{
}

class Rpc extends \AlibabaCloud\Client\Resolver\Rpc
{
    /** @var string */
    public $product = 'Sas';

    /** @var string */
    public $version = '2018-12-03';

    /** @var string */
    public $method = 'POST';

    /** @var string */
    public $serviceCode = 'sas';
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getVpcSwitchId()
 * @method $this withVpcSwitchId($value)
 * @method string getVpcId()
 * @method $this withVpcId($value)
 */
class AddVpcHoneyPot extends Rpc
{
}

/**
 * @method array getQuaraFileIds()
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class CheckQuaraFileId extends Rpc
{

    /**
     * @param array $quaraFileIds
     *
     * @return $this
     */
	public function withQuaraFileIds(array $quaraFileIds)
	{
	    $this->data['QuaraFileIds'] = $quaraFileIds;
		foreach ($quaraFileIds as $i => $iValue) {
			$this->options['query']['QuaraFileIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method array getSecurityEventIds()
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class CheckSecurityEventId extends Rpc
{

    /**
     * @param array $securityEventIds
     *
     * @return $this
     */
	public function withSecurityEventIds(array $securityEventIds)
	{
	    $this->data['SecurityEventIds'] = $securityEventIds;
		foreach ($securityEventIds as $i => $iValue) {
			$this->options['query']['SecurityEventIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getForbiddenTime()
 * @method $this withForbiddenTime($value)
 * @method string getFailCount()
 * @method $this withFailCount($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getEnableSmartRule()
 * @method $this withEnableSmartRule($value)
 * @method array getUuidList()
 * @method string getName()
 * @method $this withName($value)
 * @method string getSpan()
 * @method $this withSpan($value)
 * @method string getDefaultRule()
 * @method $this withDefaultRule($value)
 */
class CreateAntiBruteForceRule extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getUuidList()
 * @method string getPolicy()
 * @method $this withPolicy($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class CreateBackupPolicy extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getGroupName()
 * @method $this withGroupName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class CreateOrUpdateAssetGroup extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSnapshotId()
 * @method $this withSnapshotId($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSnapshotHash()
 * @method $this withSnapshotHash($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getSnapshotVersion()
 * @method $this withSnapshotVersion($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getIncludes()
 * @method $this withIncludes($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class CreateRestoreJob extends Rpc
{
}

/**
 * @method string getSasWebguardBoolean()
 * @method $this withSasWebguardBoolean($value)
 * @method string getAutoUseCoupon()
 * @method $this withAutoUseCoupon($value)
 * @method string getSpec()
 * @method $this withSpec($value)
 * @method string getInstanceCount()
 * @method $this withInstanceCount($value)
 * @method string getSasWebguardOrderNum()
 * @method $this withSasWebguardOrderNum($value)
 * @method string getContainerImageScan()
 * @method $this withContainerImageScan($value)
 * @method string getAutoRenewPeriod()
 * @method $this withAutoRenewPeriod($value)
 * @method string getPeriod()
 * @method $this withPeriod($value)
 * @method string getAutoPay()
 * @method $this withAutoPay($value)
 * @method string getSasAntiRansomware()
 * @method $this withSasAntiRansomware($value)
 * @method string getPeriodUnit()
 * @method $this withPeriodUnit($value)
 * @method string getSasSc()
 * @method $this withSasSc($value)
 * @method string getVcore()
 * @method $this withVcore($value)
 * @method string getSasSlsStorage()
 * @method $this withSasSlsStorage($value)
 * @method string getSasProductService()
 * @method $this withSasProductService($value)
 */
class CreateSasOrder extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class CreateServiceLinkedRole extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getSecurityEventId()
 * @method $this withSecurityEventId($value)
 * @method string getSimilarEventScenarioCode()
 * @method $this withSimilarEventScenarioCode($value)
 */
class CreateSimilarSecurityEventsQueryTask extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 */
class DeleteBackupPolicy extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPolicyId()
 * @method $this withPolicyId($value)
 * @method array getUuidList()
 */
class DeleteBackupPolicyMachine extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DeleteGroup extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class DeleteLoginBaseConfig extends Rpc
{
}

/**
 * @method string getTagName()
 * @method $this withTagName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuidList()
 * @method $this withUuidList($value)
 */
class DeleteTagWithUuid extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getVpcId()
 * @method $this withVpcId($value)
 */
class DeleteVpcHoneyPot extends Rpc
{
}

/**
 * @method string getQuery()
 * @method $this withQuery($value)
 * @method string getStartTs()
 * @method $this withStartTs($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeAccesskeyLeakList extends Rpc
{
}

/**
 * @method string getRepoId()
 * @method $this withRepoId($value)
 * @method string getRepoNamespace()
 * @method $this withRepoNamespace($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getImageDigest()
 * @method $this withImageDigest($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getImageTag()
 * @method $this withImageTag($value)
 * @method string getMaliciousMd5()
 * @method $this withMaliciousMd5($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRepoName()
 * @method $this withRepoName($value)
 * @method string getRepoInstanceId()
 * @method $this withRepoInstanceId($value)
 * @method string getImageLayer()
 * @method $this withImageLayer($value)
 * @method array getUuids()
 * @method string getRepoRegionId()
 * @method $this withRepoRegionId($value)
 */
class DescribeAffectedMaliciousFileImages extends Rpc
{

    /**
     * @param array $uuids
     *
     * @return $this
     */
	public function withUuids(array $uuids)
	{
	    $this->data['Uuids'] = $uuids;
		foreach ($uuids as $i => $iValue) {
			$this->options['query']['Uuids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getAlarmUniqueInfo()
 * @method $this withAlarmUniqueInfo($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeAlarmEventDetail extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getAlarmEventType()
 * @method $this withAlarmEventType($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getAlarmEventName()
 * @method $this withAlarmEventName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method array getOperateErrorCodeList()
 * @method string getLevels()
 * @method $this withLevels($value)
 */
class DescribeAlarmEventList extends Rpc
{

    /**
     * @param array $operateErrorCodeList
     *
     * @return $this
     */
	public function withOperateErrorCodeList(array $operateErrorCodeList)
	{
	    $this->data['OperateErrorCodeList'] = $operateErrorCodeList;
		foreach ($operateErrorCodeList as $i => $iValue) {
			$this->options['query']['OperateErrorCodeList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getUniqueInfo()
 * @method $this withUniqueInfo($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getEventName()
 * @method $this withEventName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeAlarmEventStackInfo extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeAllEntity extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeAllGroups extends Rpc
{
}

/**
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getAllRegion()
 * @method $this withAllRegion($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getWebGroupId()
 * @method $this withWebGroupId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getTag()
 * @method $this withTag($value)
 * @method string getFlow()
 * @method $this withFlow($value)
 * @method string getSaleId()
 * @method $this withSaleId($value)
 * @method string getRuleType()
 * @method $this withRuleType($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSecureToken()
 * @method $this withSecureToken($value)
 * @method string getAction1()
 * @method $this withAction1($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeAllRegionsStatistics extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeAntiBruteForceRules extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeAssetDetailByUuid extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeAssetDetailByUuids extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeAutoDelConfig extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPolicyId()
 * @method $this withPolicyId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeBackupDirs extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getPath()
 * @method $this withPath($value)
 * @method string getSnapshotHash()
 * @method $this withSnapshotHash($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class DescribeBackupFiles extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPolicyId()
 * @method $this withPolicyId($value)
 */
class DescribeBackupMachineStatus extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeBackupPolicies extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 */
class DescribeBackupPolicy extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeBackupRestoreCount extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeBruteForceSummary extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeCheckEcsWarnings extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCheckWarningId()
 * @method $this withCheckWarningId($value)
 */
class DescribeCheckWarningDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeCheckWarnings extends Rpc
{
}

/**
 * @method string getRiskName()
 * @method $this withRiskName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskStatus()
 * @method $this withRiskStatus($value)
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 * @method string getTypeName()
 * @method $this withTypeName($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeCheckWarningSummary extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getImportance()
 * @method $this withImportance($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getNoPage()
 * @method $this withNoPage($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLogicalExp()
 * @method $this withLogicalExp($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 */
class DescribeCloudCenterInstances extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeCloudProductFieldStatistics extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeConcernNecessity extends Rpc
{
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeContainerStatistics extends Rpc
{
}

/**
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getValue()
 * @method $this withValue($value)
 */
class DescribeCriteria extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeDialogMessages extends Rpc
{
}

/**
 * @method string getRuleActionName()
 * @method $this withRuleActionName($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeDingTalk extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeDomainCount extends Rpc
{
}

/**
 * @method string getDomainName()
 * @method $this withDomainName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeDomainDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getFuzzyDomain()
 * @method $this withFuzzyDomain($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getDomainType()
 * @method $this withDomainType($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeDomainList extends Rpc
{
}

/**
 * @method string getScanType()
 * @method $this withScanType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getVulName()
 * @method $this withVulName($value)
 * @method string getRiskStatus()
 * @method $this withRiskStatus($value)
 */
class DescribeEmgVulItem extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeExcludeSystemPath extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getExportId()
 * @method $this withExportId($value)
 */
class DescribeExportInfo extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getValue()
 * @method $this withValue($value)
 */
class DescribeExposedInstanceCriteria extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeExposedInstanceDetail extends Rpc
{
}

/**
 * @method string getExposurePort()
 * @method $this withExposurePort($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getVulStatus()
 * @method $this withVulStatus($value)
 * @method string getExposureIp()
 * @method $this withExposureIp($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getExposureComponent()
 * @method $this withExposureComponent($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getInstanceName()
 * @method $this withInstanceName($value)
 * @method string getHealthStatus()
 * @method $this withHealthStatus($value)
 */
class DescribeExposedInstanceList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeExposedStatistics extends Rpc
{
}

/**
 * @method string getStatisticsType()
 * @method $this withStatisticsType($value)
 * @method string getStatisticsTypeGatewayType()
 * @method $this withStatisticsTypeGatewayType($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStatisticsTypeInstanceValue()
 * @method $this withStatisticsTypeInstanceValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeExposedStatisticsDetail extends Rpc
{
}

/**
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeFieldStatistics extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperateType()
 * @method $this withOperateType($value)
 * @method string getInfo()
 * @method $this withInfo($value)
 */
class DescribeFrontVulPatchList extends Rpc
{
}

/**
 * @method string getVertexId()
 * @method $this withVertexId($value)
 * @method string getAnomalyId()
 * @method $this withAnomalyId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAnomalyUuid()
 * @method $this withAnomalyUuid($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getDirection()
 * @method $this withDirection($value)
 * @method string getPathLength()
 * @method $this withPathLength($value)
 * @method string getNamespace()
 * @method $this withNamespace($value)
 */
class DescribeGraph4InvestigationOnline extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getGroupField()
 * @method $this withGroupField($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLogicalExp()
 * @method $this withLogicalExp($value)
 * @method string getFieldValue()
 * @method $this withFieldValue($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 */
class DescribeGroupedContainerInstances extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getGroupField()
 * @method $this withGroupField($value)
 * @method string getNoPage()
 * @method $this withNoPage($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getFieldValue()
 * @method $this withFieldValue($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 */
class DescribeGroupedInstances extends Rpc
{
}

/**
 * @method string getRepoId()
 * @method $this withRepoId($value)
 * @method string getFuzzyMaliciousName()
 * @method $this withFuzzyMaliciousName($value)
 * @method string getRepoNamespace()
 * @method $this withRepoNamespace($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getImageDigest()
 * @method $this withImageDigest($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getImageTag()
 * @method $this withImageTag($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRepoName()
 * @method $this withRepoName($value)
 * @method string getRepoInstanceId()
 * @method $this withRepoInstanceId($value)
 * @method string getImageLayer()
 * @method $this withImageLayer($value)
 * @method string getLevels()
 * @method $this withLevels($value)
 * @method array getUuids()
 * @method string getRepoRegionId()
 * @method $this withRepoRegionId($value)
 */
class DescribeGroupedMaliciousFiles extends Rpc
{

    /**
     * @param array $uuids
     *
     * @return $this
     */
	public function withUuids(array $uuids)
	{
	    $this->data['Uuids'] = $uuids;
		foreach ($uuids as $i => $iValue) {
			$this->options['query']['Uuids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeGroupedTags extends Rpc
{
}

/**
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getMinScore()
 * @method $this withMinScore($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeGroupedVul extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeHoneyPotAuth extends Rpc
{
}

/**
 * @method string getStatisticsDays()
 * @method $this withStatisticsDays($value)
 * @method string getStatisticsKeyType()
 * @method $this withStatisticsKeyType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 */
class DescribeHoneyPotSuspStatistics extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getLastTsEnd()
 * @method $this withLastTsEnd($value)
 * @method string getCreateTsStart()
 * @method $this withCreateTsStart($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getImageTag()
 * @method $this withImageTag($value)
 * @method string getLevel()
 * @method $this withLevel($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getOrderBy()
 * @method $this withOrderBy($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getPatchId()
 * @method $this withPatchId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getCreateTsEnd()
 * @method $this withCreateTsEnd($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 * @method string getRepoId()
 * @method $this withRepoId($value)
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getCveId()
 * @method $this withCveId($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getRepoNamespace()
 * @method $this withRepoNamespace($value)
 * @method string getImageDigest()
 * @method $this withImageDigest($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getLastTsStart()
 * @method $this withLastTsStart($value)
 * @method string getDirection()
 * @method $this withDirection($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSearchTags()
 * @method $this withSearchTags($value)
 * @method string getRepoName()
 * @method $this withRepoName($value)
 * @method string getRepoInstanceId()
 * @method $this withRepoInstanceId($value)
 * @method string getImageLayer()
 * @method $this withImageLayer($value)
 * @method string getRepoRegionId()
 * @method $this withRepoRegionId($value)
 */
class DescribeImageGroupedVulList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeImageStatistics extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getCreateTsStart()
 * @method $this withCreateTsStart($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTag()
 * @method $this withTag($value)
 * @method string getModifyTsEnd()
 * @method $this withModifyTsEnd($value)
 * @method string getLevel()
 * @method $this withLevel($value)
 * @method string getResource()
 * @method $this withResource($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getIds()
 * @method $this withIds($value)
 * @method string getCreateTsEnd()
 * @method $this withCreateTsEnd($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 * @method string getRepoId()
 * @method $this withRepoId($value)
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getCveId()
 * @method $this withCveId($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getRepoNamespace()
 * @method $this withRepoNamespace($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getDigest()
 * @method $this withDigest($value)
 * @method string getModifyTsStart()
 * @method $this withModifyTsStart($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getBatchName()
 * @method $this withBatchName($value)
 * @method string getRepoName()
 * @method $this withRepoName($value)
 * @method string getRepoInstanceId()
 * @method $this withRepoInstanceId($value)
 * @method string getRepoRegionId()
 * @method $this withRepoRegionId($value)
 */
class DescribeImageVulList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getDeadline()
 * @method $this withDeadline($value)
 */
class DescribeInstallCaptcha extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getUuidList()
 */
class DescribeInstanceAntiBruteForceRules extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeInstanceStatistics extends Rpc
{
}

/**
 * @method string getIp()
 * @method $this withIp($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getField()
 * @method $this withField($value)
 */
class DescribeIpInfo extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeLogstoreStorage extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeModuleConfig extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeNoticeConfig extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuidList()
 * @method $this withUuidList($value)
 */
class DescribePropertyCount extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getSource()
 * @method $this withSource($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getUser()
 * @method $this withUser($value)
 */
class DescribePropertyCronDetail extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getPort()
 * @method $this withPort($value)
 * @method string getProcName()
 * @method $this withProcName($value)
 */
class DescribePropertyPortDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPort()
 * @method $this withPort($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertyPortItem extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getCmdline()
 * @method $this withCmdline($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getUser()
 * @method $this withUser($value)
 */
class DescribePropertyProcDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertyProcItem extends Rpc
{
}

/**
 * @method string getSearchItemSub()
 * @method $this withSearchItemSub($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getSearchItem()
 * @method $this withSearchItem($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getSearchInfoSub()
 * @method $this withSearchInfoSub($value)
 * @method string getSearchInfo()
 * @method $this withSearchInfo($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getBizType()
 * @method $this withBizType($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getScaName()
 * @method $this withScaName($value)
 */
class DescribePropertyScaDetail extends Rpc
{
}

/**
 * @method string getSoftwareVersion()
 * @method $this withSoftwareVersion($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getPath()
 * @method $this withPath($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getName()
 * @method $this withName($value)
 */
class DescribePropertySoftwareDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertySoftwareItem extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribePropertyUsageNewest extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getIsRoot()
 * @method $this withIsRoot($value)
 * @method string getUser()
 * @method $this withUser($value)
 */
class DescribePropertyUserDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getUser()
 * @method $this withUser($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertyUserItem extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getQuaraFileId()
 * @method $this withQuaraFileId($value)
 */
class DescribeQuaraFileDownloadInfo extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getMachineRemark()
 * @method $this withMachineRemark($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeRestoreJobs extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getItemId()
 * @method $this withItemId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class DescribeRiskCheckItemResult extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getAssetType()
 * @method $this withAssetType($value)
 * @method string getQueryFlag()
 * @method $this withQueryFlag($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method array getItemIds()
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskLevel()
 * @method $this withRiskLevel($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeRiskCheckResult extends Rpc
{

    /**
     * @param array $itemIds
     *
     * @return $this
     */
	public function withItemIds(array $itemIds)
	{
	    $this->data['ItemIds'] = $itemIds;
		foreach ($itemIds as $i => $iValue) {
			$this->options['query']['ItemIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeRiskCheckSummary extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeRiskItemType extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getInstanceIds()
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeRiskListCheckResult extends Rpc
{

    /**
     * @param array $instanceIds
     *
     * @return $this
     */
	public function withInstanceIds(array $instanceIds)
	{
	    $this->data['InstanceIds'] = $instanceIds;
		foreach ($instanceIds as $i => $iValue) {
			$this->options['query']['InstanceIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeSasAssetStatisticsColumn extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 */
class DescribeScanTaskProgress extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeSearchCondition extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeSecureSuggestion extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeSecurityCheckScheduleConfig extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getSecurityEventId()
 * @method $this withSecurityEventId($value)
 */
class DescribeSecurityEventOperations extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method array getSecurityEventIds()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 */
class DescribeSecurityEventOperationStatus extends Rpc
{

    /**
     * @param array $securityEventIds
     *
     * @return $this
     */
	public function withSecurityEventIds(array $securityEventIds)
	{
	    $this->data['SecurityEventIds'] = $securityEventIds;
		foreach ($securityEventIds as $i => $iValue) {
			$this->options['query']['SecurityEventIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeSecurityStatInfo extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeServiceLinkedRoleStatus extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getSecurityEventId()
 * @method $this withSecurityEventId($value)
 */
class DescribeSimilarEventScenarios extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 */
class DescribeSimilarSecurityEvents extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getMachineRemark()
 * @method $this withMachineRemark($value)
 * @method string getNextToken()
 * @method $this withNextToken($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getApiVersion()
 * @method $this withApiVersion($value)
 * @method string getMachineRegion()
 * @method $this withMachineRegion($value)
 */
class DescribeSnapshots extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 */
class DescribeStrategyExecDetail extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeSummaryInfo extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeSupportRegion extends Rpc
{
}

/**
 * @method string getSuspiciousEventId()
 * @method $this withSuspiciousEventId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeSuspEventDetail extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getQuaraTag()
 * @method $this withQuaraTag($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeSuspEventQuaraFiles extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getSource()
 * @method $this withSource($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getAlarmUniqueInfo()
 * @method $this withAlarmUniqueInfo($value)
 * @method string getUniqueInfo()
 * @method $this withUniqueInfo($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method array getOperateErrorCodeList()
 * @method string getName()
 * @method $this withName($value)
 * @method string getLevels()
 * @method $this withLevels($value)
 * @method string getParentEventTypes()
 * @method $this withParentEventTypes($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeSuspEvents extends Rpc
{

    /**
     * @param array $operateErrorCodeList
     *
     * @return $this
     */
	public function withOperateErrorCodeList(array $operateErrorCodeList)
	{
	    $this->data['OperateErrorCodeList'] = $operateErrorCodeList;
		foreach ($operateErrorCodeList as $i => $iValue) {
			$this->options['query']['OperateErrorCodeList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeUserBackupMachines extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeUserBaselineAuthorization extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeUserLayoutAuthorization extends Rpc
{
}

/**
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getVpcInstanceIds()
 * @method $this withVpcInstanceIds($value)
 * @method array getVulNames()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTag()
 * @method $this withTag($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getLevel()
 * @method $this withLevel($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getFieldValue()
 * @method $this withFieldValue($value)
 * @method string getFieldName()
 * @method $this withFieldName($value)
 * @method string getSearchTags()
 * @method $this withSearchTags($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 */
class DescribeUuidsByVulNames extends Rpc
{

    /**
     * @param array $vulNames
     *
     * @return $this
     */
	public function withVulNames(array $vulNames)
	{
	    $this->data['VulNames'] = $vulNames;
		foreach ($vulNames as $i => $iValue) {
			$this->options['query']['VulNames.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeVersionConfig extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeVolDingdingMessage extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeVpcHoneyPotCriteria extends Rpc
{
}

/**
 * @method string getVpcName()
 * @method $this withVpcName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getHoneyPotExistence()
 * @method $this withHoneyPotExistence($value)
 * @method string getVpcRegionId()
 * @method $this withVpcRegionId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getVpcId()
 * @method $this withVpcId($value)
 */
class DescribeVpcHoneyPotList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeVpcList extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeVulDetails extends Rpc
{
}

/**
 * @method string getMinScore()
 * @method $this withMinScore($value)
 * @method string getAttachTypes()
 * @method $this withAttachTypes($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getVpcInstanceIds()
 * @method $this withVpcInstanceIds($value)
 * @method string getCreateTsStart()
 * @method $this withCreateTsStart($value)
 * @method string getContainerFieldName()
 * @method $this withContainerFieldName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getModifyTsEnd()
 * @method $this withModifyTsEnd($value)
 * @method string getLevel()
 * @method $this withLevel($value)
 * @method string getResource()
 * @method $this withResource($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getIds()
 * @method $this withIds($value)
 * @method string getCreateTsEnd()
 * @method $this withCreateTsEnd($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getContainerFieldValue()
 * @method $this withContainerFieldValue($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getModifyTsStart()
 * @method $this withModifyTsStart($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getClusterId()
 * @method $this withClusterId($value)
 * @method string getBatchName()
 * @method $this withBatchName($value)
 */
class DescribeVulList extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeVulWhitelist extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getMachineName()
 * @method $this withMachineName($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeWarningMachines extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeWebLockBindList extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeWebLockConfigList extends Rpc
{
}

/**
 * @method string getExportType()
 * @method $this withExportType($value)
 * @method string getParams()
 * @method $this withParams($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ExportRecord extends Rpc
{
}

/**
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getCheckParams()
 * @method $this withCheckParams($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class FixCheckWarnings extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetBackupStorageCount extends Rpc
{
}

/**
 * @method string getDate()
 * @method $this withDate($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetIncIOCs extends Rpc
{
}

/**
 * @method string getDate()
 * @method $this withDate($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetIOCs extends Rpc
{
}

/**
 * @method string getGroupIdList()
 * @method $this withGroupIdList($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetSuspiciousStatistics extends Rpc
{
}

/**
 * @method string getTypeList()
 * @method $this withTypeList($value)
 * @method string getGroupIdList()
 * @method $this withGroupIdList($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetVulStatistics extends Rpc
{
}

/**
 * @method string getMarkMissParam()
 * @method $this withMarkMissParam($value)
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method array getSecurityEventIds()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperationCode()
 * @method $this withOperationCode($value)
 * @method string getOperationParams()
 * @method $this withOperationParams($value)
 * @method string getMarkBatch()
 * @method $this withMarkBatch($value)
 */
class HandleSecurityEvents extends Rpc
{

    /**
     * @param array $securityEventIds
     *
     * @return $this
     */
	public function withSecurityEventIds(array $securityEventIds)
	{
	    $this->data['SecurityEventIds'] = $securityEventIds;
		foreach ($securityEventIds as $i => $iValue) {
			$this->options['query']['SecurityEventIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getMarkMissParam()
 * @method $this withMarkMissParam($value)
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperationCode()
 * @method $this withOperationCode($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getOperationParams()
 * @method $this withOperationParams($value)
 */
class HandleSimilarSecurityEvents extends Rpc
{
}

/**
 * @method string getReason()
 * @method $this withReason($value)
 * @method string getCheckIds()
 * @method $this withCheckIds($value)
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getCheckWarningIds()
 * @method $this withCheckWarningIds($value)
 */
class IgnoreHcCheckWarnings extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getUuidList()
 */
class InstallBackupClient extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getForbiddenTime()
 * @method $this withForbiddenTime($value)
 * @method string getFailCount()
 * @method $this withFailCount($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getEnableSmartRule()
 * @method $this withEnableSmartRule($value)
 * @method array getUuidList()
 * @method string getId()
 * @method $this withId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getSpan()
 * @method $this withSpan($value)
 * @method string getDefaultRule()
 * @method $this withDefaultRule($value)
 */
class ModifyAntiBruteForceRule extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ModifyAssetGroup extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getUuidList()
 * @method string getId()
 * @method $this withId($value)
 * @method string getPolicy()
 * @method $this withPolicy($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getName()
 * @method $this withName($value)
 */
class ModifyBackupPolicy extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyBackupPolicyStatus extends Rpc
{
}

/**
 * @method string getReason()
 * @method $this withReason($value)
 * @method string getWhitelist()
 * @method $this withWhitelist($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ModifyCreateVulWhitelist extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getUserAgreement()
 * @method $this withUserAgreement($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ModifyEmgVulSubmit extends Rpc
{
}

/**
 * @method string getData()
 * @method $this withData($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ModifyGroupProperty extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getNewRuleId()
 * @method $this withNewRuleId($value)
 */
class ModifyInstanceAntiBruteForceRule extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class ModifyLoginBaseConfig extends Rpc
{
}

/**
 * @method string getItem()
 * @method $this withItem($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyLoginSwitchConfig extends Rpc
{
}

/**
 * @method string getProject()
 * @method $this withProject($value)
 * @method string getTimeLimit()
 * @method $this withTimeLimit($value)
 * @method string getRoute()
 * @method $this withRoute($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ModifyNoticeConfig extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 */
class ModifyOpenLogShipper extends Rpc
{
}

/**
 * @method string getReason()
 * @method $this withReason($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getInfo()
 * @method $this withInfo($value)
 * @method string getOperateType()
 * @method $this withOperateType($value)
 */
class ModifyOperateVul extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTasks()
 * @method $this withTasks($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ModifyPushAllTask extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getItemId()
 * @method $this withItemId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyRiskCheckStatus extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getIds()
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyRiskSingleResultStatus extends Rpc
{

    /**
     * @param array $ids
     *
     * @return $this
     */
	public function withIds(array $ids)
	{
	    $this->data['Ids'] = $ids;
		foreach ($ids as $i => $iValue) {
			$this->options['query']['Ids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getDaysOfWeek()
 * @method $this withDaysOfWeek($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ModifySecurityCheckScheduleConfig extends Rpc
{
}

/**
 * @method string getTypes()
 * @method $this withTypes($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ModifyStartVulScan extends Rpc
{
}

/**
 * @method string getTagId()
 * @method $this withTagId($value)
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getTagList()
 * @method $this withTagList($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuidList()
 * @method $this withUuidList($value)
 */
class ModifyTagWithUuid extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getHoneyPotAction()
 * @method $this withHoneyPotAction($value)
 * @method string getVpcId()
 * @method $this withVpcId($value)
 */
class ModifyVpcHoneyPot extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class ModifyVulTargetConfig extends Rpc
{
}

/**
 * @method string getLocalBackupDir()
 * @method $this withLocalBackupDir($value)
 * @method string getExclusiveFile()
 * @method $this withExclusiveFile($value)
 * @method string getExclusiveFileType()
 * @method $this withExclusiveFileType($value)
 * @method string getDir()
 * @method $this withDir($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getMode()
 * @method $this withMode($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getInclusiveFile()
 * @method $this withInclusiveFile($value)
 * @method string getExclusiveDir()
 * @method $this withExclusiveDir($value)
 * @method string getInclusiveFileType()
 * @method $this withInclusiveFileType($value)
 * @method string getDefenceMode()
 * @method $this withDefenceMode($value)
 */
class ModifyWebLockCreateConfig extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ModifyWebLockDeleteConfig extends Rpc
{
}

/**
 * @method string getLocalBackupDir()
 * @method $this withLocalBackupDir($value)
 * @method string getExclusiveFile()
 * @method $this withExclusiveFile($value)
 * @method string getExclusiveFileType()
 * @method $this withExclusiveFileType($value)
 * @method string getDir()
 * @method $this withDir($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getMode()
 * @method $this withMode($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getExclusiveDir()
 * @method $this withExclusiveDir($value)
 * @method string getInclusiveFileType()
 * @method $this withInclusiveFileType($value)
 * @method string getDefenceMode()
 * @method $this withDefenceMode($value)
 */
class ModifyWebLockStart extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyWebLockStatus extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ModifyWebLockUnbind extends Rpc
{
}

/**
 * @method string getLocalBackupDir()
 * @method $this withLocalBackupDir($value)
 * @method string getExclusiveFile()
 * @method $this withExclusiveFile($value)
 * @method string getExclusiveFileType()
 * @method $this withExclusiveFileType($value)
 * @method string getDir()
 * @method $this withDir($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getMode()
 * @method $this withMode($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getId()
 * @method $this withId($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getInclusiveFile()
 * @method $this withInclusiveFile($value)
 * @method string getExclusiveDir()
 * @method $this withExclusiveDir($value)
 * @method string getInclusiveFileType()
 * @method $this withInclusiveFileType($value)
 * @method string getDefenceMode()
 * @method $this withDefenceMode($value)
 */
class ModifyWebLockUpdateConfig extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getTargetOperations()
 * @method $this withTargetOperations($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class OperateSuspiciousTargetConfig extends Rpc
{
}

/**
 * @method string getReason()
 * @method $this withReason($value)
 * @method string getType()
 * @method $this withType($value)
 * @method array getVulNames()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPrecondition()
 * @method $this withPrecondition($value)
 * @method string getOperateType()
 * @method $this withOperateType($value)
 * @method array getUuids()
 */
class OperateVuls extends Rpc
{

    /**
     * @param array $vulNames
     *
     * @return $this
     */
	public function withVulNames(array $vulNames)
	{
	    $this->data['VulNames'] = $vulNames;
		foreach ($vulNames as $i => $iValue) {
			$this->options['query']['VulNames.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $uuids
     *
     * @return $this
     */
	public function withUuids(array $uuids)
	{
	    $this->data['Uuids'] = $uuids;
		foreach ($uuids as $i => $iValue) {
			$this->options['query']['Uuids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSuspiciousEventIds()
 * @method $this withSuspiciousEventIds($value)
 * @method string getSubOperation()
 * @method $this withSubOperation($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getWarnType()
 * @method $this withWarnType($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getOperation()
 * @method $this withOperation($value)
 */
class OperationSuspEvents extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAppName()
 * @method $this withAppName($value)
 * @method string getValue()
 * @method $this withValue($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class PauseClient extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAssetType()
 * @method $this withAssetType($value)
 */
class RefreshContainerAssets extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getQuaraFileId()
 * @method $this withQuaraFileId($value)
 */
class RollbackSuspEventQuaraFile extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class SasInstallCode extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method array getItemIds()
 * @method string getType()
 * @method $this withType($value)
 * @method array getAssets()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class StartBaselineSecurityCheck extends Rpc
{

    /**
     * @param array $itemIds
     *
     * @return $this
     */
	public function withItemIds(array $itemIds)
	{
	    $this->data['ItemIds'] = $itemIds;
		foreach ($itemIds as $i => $iValue) {
			$this->options['query']['ItemIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $assets
     *
     * @return $this
     */
	public function withAssets(array $assets)
	{
	    $this->data['Assets'] = $assets;
		foreach ($assets as $i => $iValue) {
			$this->options['query']['Assets.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getRepoId()
 * @method $this withRepoId($value)
 * @method string getRepoNamespace()
 * @method $this withRepoNamespace($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getImageDigest()
 * @method $this withImageDigest($value)
 * @method string getRepName()
 * @method $this withRepName($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getImageTag()
 * @method $this withImageTag($value)
 * @method array getRegistryTypes()
 * @method string getRepoInstanceId()
 * @method $this withRepoInstanceId($value)
 * @method string getImageLayer()
 * @method $this withImageLayer($value)
 * @method string getRepoRegionId()
 * @method $this withRepoRegionId($value)
 */
class StartImageVulScan extends Rpc
{

    /**
     * @param array $registryTypes
     *
     * @return $this
     */
	public function withRegistryTypes(array $registryTypes)
	{
	    $this->data['RegistryTypes'] = $registryTypes;
		foreach ($registryTypes as $i => $iValue) {
			$this->options['query']['RegistryTypes.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTargetInfo()
 * @method $this withTargetInfo($value)
 */
class StartVirusScanTask extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class UnbindAegis extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getPolicyVersion()
 * @method $this withPolicyVersion($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getUuidList()
 */
class UninstallBackupClient extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getRiskIds()
 * @method $this withRiskIds($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ValidateHcWarnings extends Rpc
{
}
