<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="description" content="MyCms是一款基于Laravel8+layuimini开发的模块化后台管理系统。MyCms基于Apache2.0开源协议发布，免费且不限制商业使用，欢迎持续关注我们。">
    <meta name="author" content="MyCms">
    <meta name="keywords" content="MyCms,Laravel模块化">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <title>MyCms | 基于Laravel模块化的PHP7开源后台管理系统</title>
    <link rel="stylesheet" href="/mycms/common/css/welcome.css">
</head>
<body>
<div id='app'>
    <!-- 头部-->
    <header>
        <!-- logo -->
        <p class="left logo-box">
            <i class="img-logo-header logo"></i>
            <a href="/">MyCms</a>
        </p>
        <div class="right">
            <!-- 导航-->
            <div class="navbar">
                <a class="navbar-item active" href="/">首页</a>
                <a class="navbar-item" href="https://www.mycms.net.cn/shouce" target="_blank">文档</a>
                <a class="navbar-item" href="/system/login" target="_blank">演示</a>
                <a class="navbar-item" href="https://qm.qq.com/cgi-bin/qm/qr?k=y3Q3pCWJdIRtCzdLMGdqMv3Jx04bib8D&jump_from=webapi" target="_blank">QQ群</a>
            </div>
        </div>
    </header>

    <div class="home-main">
        <div class="title">
            <p>
                <img src="/mycms/common/images/logo-2.png" height="300px">
            </p>
            <p class="operation">
                <a class="start" target="_blank" href="https://www.mycms.net.cn/shouce"> 起步 <i class="icon-play"></i></a>
                <a class="gitee button-grya" target="_blank" href="https://gitee.com/qq386654667/mycms"><i class="icon-gitee"></i>Gitee</a>
            </p>
        </div>
        <!-- 框架特性-->
        <div class="introduction">
            <!-- 特性标题-->
            <div class="top">
                <div class="part-title">
                    <p class="text">系统描述</p>
                    <p class="line"></p>
                </div>
                <p class="part-desc">
                    MyCms是一款基于Laravel8+layuimini开发的模块化后台管理系统。MyCms基于Apache2.0开源协议发布，免费且不限制商业使用，欢迎持续关注我们。
                </p>
            </div>
            <!-- 特性介绍-->
            <div class="bottom">
                <div class="item">
                    <p class="item-title"><span>内置权限管理</span></p>
                    <p class="item-desc">使用Laravel中间件实现更智能的RBAC权限管理，自动读取更新，无需手动插入节点，告别手工插入时代</p>
                </div>
                <div class="item">
                    <p class="item-title"><span>模块化开发</span></p>
                    <p class="item-desc">万丈高楼平地起，打下扎实的基础，采用Laravel-module实现模块化，降低耦合度，分工更明确，为做大做强创造无限可能</p>
                </div>
                <div class="item">
                    <p class="item-title"><span>JS整合封装</span></p>
                    <p class="item-desc">后台采用Layuimini进行开发，对表格、表单进行封装，统一样式，统一交互，开发更快捷，使用更舒服</p>
                </div>
                <div class="item">
                    <p class="item-title"><span>响应式开发</span></p>
                    <p class="item-desc">后台页面基于Layui开发，手机、平板、PC均已自动适配，无需担心兼容性问题，专注业务逻辑代码开发</p>
                </div>
                <div class="item">
                    <p class="item-title"><span>更快的PHP7</span></p>
                    <p class="item-desc">系统基于PHP7.3+进行开发，相比PHP5有倍级的性能提升，更完善的类型声明，PHP是世界上最好的开发语言。</p>
                </div>
                <div class="item">
                    <p class="item-title"><span>高拓展性</span></p>
                    <p class="item-desc">基于Laravel8进行后台程序开发，让您从杂乱的代码解脱出来，高质量的文档，丰富的拓展包，开发更高效，代码更优雅</p>
                </div>
            </div>
        </div>
    </div>

    <!-- 底部-->
    <footer class="site-footer">
        <div class="container">
            <p class="protocol">遵循 Apache-2.0 开源协议 </p>
            <p class="beian-number">Copyright © <a href="https://www.mycms.net.cn/">MyCms</a> 版权所有，并保留所有权利</p>
        </div>
    </footer>
</div>
</body>
</html>
