<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"/>
    <title>{{page_title()}}</title>
    <meta name="keywords" content="{{page_keyword()}}">
    <meta name="description" content="{{page_description()}}">
    <meta name="sogou_site_verification" content="1ScNA1wOA3" />
    <link rel="shortcut icon" href="/favicon.ico">
    <link rel="stylesheet" href="/mycms/cms/theme/T20220219/bootstrap/3.3.7/css/bootstrap.min.css">
    <link rel="stylesheet" href="/mycms/cms/theme/T20220219/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="/mycms/cms/theme/T20220219/highlight.js/8.5/styles/monokai_sublime.min.css">
    <link href="/mycms/cms/theme/T20220219/magnific-popup.js/1.0.0/magnific-popup.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="/mycms/cms/theme/T20220219/css/screen.css">
    <link rel="stylesheet" type="text/css" href="/mycms/cms/theme/T20220219/css/index.css">

    @if(($headerJs = system_config('site_header_js')) !== null)
        {!! $headerJs !!}
    @endif

    <script>
        function search()
        {
            location.href = '/search/' + $('#keyword').val();
        }
    </script>

    <style>

    </style>

    @if(is_home())
        <style>
            .logo h1{
                text-indent: -9999px;
                height: 0;
                margin: 0;
            }
        </style>
    @endif

</head>
<body class="home-template">
<header class="main-header">
    <div class="container">
        <div class="row">
            <div class="col-sm-7 logo">
                @if(is_home())
                    <h1>{{system_config('site_name')}}</h1>
                @endif
                <img src="{{system_config('site_logo')}}" alt="{{system_config('site_name')}}">
            </div>
            <div class="col-sm-5 seach">
                <form action="/search" method="get" onkeydown="if(event.keyCode==13)return false;" onsubmit="return search();">
                    <div class="input-group input-group-sm seach-dx">
                        <input name="key" type="text" id="keyword" class="form-control" placeholder="搜索"
                               aria-describedby="sizing-addon1">
                        <span class="input-group-btn">
                                <button class="btn btn-success" onclick="search()" type="button">搜索</button>
                            </span>
                    </div>
                </form>
            </div>

        </div>
    </div>
</header>
<!-- end header -->
<!-- start navigation -->
<nav class="main-navigation">
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <div class="navbar-header">
                        <span class="nav-toggle-button collapsed" data-toggle="collapse" data-target="#main-menu">
                            <span class="sr-only">菜单</span>
                            <i class="fa fa-bars" style='font-family: "Font Awesome 5 Free";' aria-hidden="true"></i>
                        </span>
                </div>
                <div class="collapse navbar-collapse" id="main-menu">
                    <ul class="menu">
                        @foreach(navs() as $key => $nav)
                        <li><a href="{{$nav->url}}" target="{{$nav->target}}">{{$nav->name}}</a></li>
                        @endforeach
                    </ul>
                </div>
            </div>

        </div>
    </div>
</nav>
