# 2019-05-23

## Rails recap

1. Path helper

    ``` ruby
    require 'module'
    <%= link_ to 'article details', article_path(3) %>

    # or you can pass in an obj
    <%= link_ to 'article details', @article %>
    ```

1. Non-resourceful route: explicitly designate

    ``` ruby
    get 'students/:id/:user_Id', to: 'students#show'
    ```

    - have params
    - constraints
    - redirect path
    - root, '/', only get
    - i18n char

1. Name a route

## View

1. Helper methods
    - link_to
    - search form
    - check boxes

### helper methods exmmple

1. Create routes

    ``` sh
    rails new app

    cd config/routes.rb
    ```

    ``` ruby routes.rb
    resources :songs
    ```

    ``` sh
    rails routes -c song    # check routes for song
    ```

1. copy db

    ``` sh
    cp ... 

    rails dbconsole
    sqlite> .tables
    sqlite> select * from songs
    ```

1. Add controller

    ``` ruby songs_controller
    class SongController < ApplicationController
        # to show.html.erb
        def show
            @song = Song.find(params[:id])
        end
    end
    ```

    ``` ruby
    <%= for_for @song do |f| %>
        Title: <%= f.text_field :title %>
        Lyrics: <%= f.text_area :lyrics %>
        Released on: <%= f.text_field :relaesed_on %>
        Length: <%= f.text_field :length %>
    <% end %>
    ```

    ``` ruby model/song.rb
    class Song < ApplicationRecord
    end
    ```

1. scaffolding: gen mvc at one time => generate everything

    ``` sh
    rails generate scaffold Student fitstname lastname
    ```

    then migrate db

## Post site

1. Structure
    - Resources: relation: 1 user => many post
        - user: id, name, email
        - post: post_id, content, user_id(foreign key)

1. code

    ``` sh
    rails g scaffold User name email
    rails g scaffold Post content:text user:references  # user_id

    rails db:migrate
    rails s
    ```

    ``` ruby app/view/post/show.html.erb
    ... post.user.name
    ```

1. change model

    ``` ruby app/model/post.rb
    class ...
        belongs_to :user
    end
    ```

    ``` ruby app/model/user.rb
    class ...
        has_many(:post, dependent: :destroy)
    end
    ```

## Project - online store

1. Resoureces
    - Product: name, image, price

1. View
    - Admin: index(), show(), delete(), edit()
    - Shopper: browser(), addCart(), placeOrder()