# 2019-05-21

## Recap - Model migrations

1. no model, no table

    ``` sh
    rails generate controller Home page1 page2
    ```

1. program to generate tables

    ``` sh
    rails generate migration CreateProducts name part_num
    ```

1. call the migration programs, only runs whichever is "down"

    ``` sh
    rails db:migrate
    ```

1. Check model status

    ``` sh
    rails db:migrate:status
    ```

1. Modify existing migration
    - Add columns

        ``` sh
        rails generate migration AddSomethingToProducts part_num1:integer
        ```

    - Roll back

        ``` sh
        rails db:rollback
        ```

    - Remove columns by creating another migration

        ``` sh
        rials generate migration RemoveSomethingFromProducts part_num1:integer
        ```

1. Run specific migration

    ``` sh
    rails g migration AddSomthing2ToProducts part_number2:Integer
    rails g migration AddSomthing3ToProducts part_number3:Integer
    rails g migration AddSomthing4ToProducts part_number4:Integer

    # migrate until ID
    rails db:migrate VERSION=<Migration ID>

    # rollback one migrations (even more executed)
    rails db:rollback

    # rollback n steps
    rails db:rollback STEP=n
    ```

1. Create model migrations directly (without using migration generator)

    ``` sh
    rails g model Country name population:interger
    ```

    - Automatically add timestamp fields: `created_at`, `updated_at`

1. Populate data

    ``` sh
    rials console

    # run seed program
    rails db:seed
    ```

    ``` ruby
    # sample data should be put in seed.rb
    Country.connection     # connect to db model

    Country.create(
        name:"USA", 
        population: "12345"
    )
    Country.create(
        name:"India", 
        population: "1234567"
    )
    Country.create(
        name:"China", 
        population: "1234567"
    )

    countryList = [
        ["Germany", 1234], 
        ["Japan", 1234], 
        ["Spain", 1234]
    ]
    countryList.each do |name, population|
        Country.create(
            name: name, 
            population: population
        )
    end
    ```

    ``` sql
    SELECT * FROM Countries
    ```

1. Queries

    ``` ruby
    Country.all

    Country.find(1)         # id = 1
    Country.find([1, 2, 3]) # id = 1 or 2 or 3

    Country.where(name:"india")
    Country.where(population:1..99999)
    Country.where(name:["Germany", "USA"]).first

    Country.count
    Country.average(:population)
    Country.sum(:population)
    Country.maximum(:population)

    Country.last.destroy
    ```

1. Table validation using model

    ``` ruby
    # country.rb

    class
        validates name, 
    end
    ```

1. tips
    - DB console => same as sqlite3

        ``` sh
        rails dbconsole
        ```

    - console => irb

        ``` sh
        rails console
        ```

## Controller

1. Notation

1. Params
    - use clean url only

1. session => actually cookie default (and recommanded)
    - clear ->nil
    - flash: special, last longer than one session, ideal for log out msg

## Routing

1. Format

    ``` ruby
    verb 'URL' to: 'route' as: 'name'
    ```

1. 4 HTTP _Resourceful_ requests <=> 7 standard _RESTful_ actions

1. Resources route

    ``` ruby
    resources :students     # create all 7 RESTful routes
    ```

    ``` sh
    rails routes

    rails routes -c students    # specific controller routes
    ```

    ``` ruby
    resources :posts, :only => [:index, :show]     # if not all 7 are needed
    ```

1. Clean URLs
    - Synonynums
    - comparison

