# 2019-05-09

## Sinatra continue

### database

1. ORM: obj relational mapper
    - wrapped in api
    - install using `gem data wrapper`

1. Connect db

    ``` ruby
    DataMapper.setup(                   # sqlite
        :default,
        "sqlite3://#{Dir.pwd}/song.db"  # any ext
    )

    DataMapper.setup(                   # mysql

    )

    DataMapper.setup(                   # ...

    )
    ```

1. Connect to another database;
    ``` ruby
    ```

1. Define Table

    ``` ruby
    class Song      # database name auto plural form => Songs
        include DataMapper::Resource    # mix-in
        property :id,       Serial      # increamental primary key
        property :title,    String
        property :lyrics,   Text
        property :length,   Integer
        property :released, Data
    end
    DataMapper.auto_migrate!            # recreate

    class Song      # database name auto plural form => Songs
        include DataMapper::Resource    # mix-in
        property :new,       Text
    end
    DataMapper.auto_upgrade!            # modify
    ```

1. Record: CRUD
    - as obj
        - Create
        - Read
        - Update: `song.update(title: "your way")`
        - Delete: `song.destroy`
    - Class method
        - `count`
        - `.all`
        - `.all(:title.like => 'way%')` query
        - `.get`
        - `.first`
        - `.last`

1. example

    ``` ruby
    require 'dm-core'
    require 'md-migrations'

    DataMapper.setup(:default, "sqlite3://#{Dir.pwd}"/song.db)

    # Define the model
    class Song
        include DataMapper::Resource

        property :id,       Serial
        property :title,    String
        property :lyrics,   Text
        property :length,   Integer
        property :released, Date
    end

    DataMapper.finalize     # chechin
    ```

    ``` ruby
    # irb
    require './song'

    Song.auto_migrate!      # song.db created

    song = Song.new         # new row
    song.title      = "my way"
    song.lyrics     = "this is my way"
    song.length     = "345"
    song.released   = Data.new(2019)    # 209-01-01
    song.save               # row saved

    # or use class method
    Song.create(
        title: "new york", 
        lyrics: "new york new york", 
        length: 211, 
        released: Data.new(1967)
        )

    Song.all    # select all
    Song.all.reverse
    Song.count
    Song.get(1)
    Song.first
    Song.last

    Song.last.destroy


    get '/songs' do     # require './song' in app.rb
        @songs = Song.all
        erb :songs      # view to be rendered
    end

    get '/songs/:id' do
        # use id to query talbe
        erb :show_song
    end

    delete '/songs/:id'...

    get '/songs/new' do # use post for new, put for modify
        # create a new row
        erb :new_song
    end

    put '/songs/:id' do
    
    end
    ```

    ``` ruby
    # songs.erb

    <h2>Song list</h2>
    <ul>
        <% @songs.each do |song| %>
            <li><a href="/songs/<%= song.id %>"><%= song.title %></a></li>
        <% end %>
    </ul>
    ```

    ``` ruby
    # show_song.erb
        <!-- - title, lyrics, length, "delete"(form, hidden field, val=delete) -->
        edit button "get", query the song at erb :edit_song, same form as "new song form"
        <!-- save button: hidden field, val="put"-->
    ```

1. Modify program: layout
