# 2019-05-07

## Sinatra Continue

### View

1. With framework

    ``` rb
    get '/' do
        erb :home
    end
    ```

1. Example

    ``` rb
    requite 'sinatra'

    get '/' do
        erb :home
    end

    get '/about' do
        erb :about
    end

    get '/contact' do
        erb :contact
    end
    __END__

    @@home          # view
    <html>
    <head></head>
    <body>
        <h1>Songs by Sinatra</h1>
        <ul>
            <li><a href="/">Home</a></li>
            <li><a href="/about">About</a></li>
            <li><a href="/contact">Contact</a></li>
        </ul>
        <h3>Welcome to site about sinatra</h3>
    </body>
    </html>

    @@contact       # view
    <html>
    <head></head>
    <body>
        <h1>Songs by Sinatra</h1>
        <ul>
            <li><a href="/">Home</a></li>
            <li><a href="/about">About</a></li>
            <li><a href="/contact">Contact</a></li>
        </ul>
        <h3>Please contact me</h3>
    <h3>
    </body>
    </html>

    @@abuot         # view
    <html>
    <head></head>
    <body>
        <h1>Songs by Sinatra</h1>
        <ul>
            <li><a href="/">Home</a></li>
            <li><a href="/about">About</a></li>
            <li><a href="/contact">Contact</a></li>
        </ul>
        <h3>Infor mation about my site</h3>
    </body>
    </html>
    ```

### Layout

1. Template of template, reduce duplication

    ``` rb
    requite 'sinatra'

    get '/' do
        @title = "home"
        erb :home, :layout=>:homelayout
    end

    get '/about' do
        @title = "about"
        erb :about
    end

    get '/contact' do
        @title = "contact"
        erb :contact    # actually => erb(:contact)
    end

    get '/*' do
        @route = params[:splat]
        pass    # go on to not_found
    end

    not_found do
        erb :contact, :layout=>false
    end
    __END__

    @@layout        # layout
    <html>
    <head>
        <link href = "style.css" rel = "stylesheet" type = "text/css">  # laod css
        <head><%= @title || "Songs by Sinatra" %></head>
    </head>
    <body>
        <h1>Songs by Sinatra</h1>
        <img src="sinatra.jpg" alt = "sinatra" width=10%></img>
        <ul>
            <li><a href="/">Home</a></li>
            <li><a href="/about">About</a></li>
            <li><a href="/contact">Contact</a></li>
        </ul>
        <%= yield %>
        <%= erb @name %>     # partial dynamically
    </body>
    </html>

    @@homelayout        # layout
    <html>
    <head></head>
    <body>
        <h1>Songs by Sinatra (in Home layout)</h1>
        <ul>
            <li><a href="/">Home</a></li>
            <li><a href="/about">About</a></li>
            <li><a href="/contact">Contact</a></li>
        </ul>
        <%= yield %>
    </body>
    </html>

    @@home          # view
        <h3>Welcome to site about sinatra</h3>


    @@contact       # view
        @name = :anotherview
        <h3>Please contact me</h3>

    @@about         # view
        <h3>Infor mation about my site</h3>

    @@notefound
        <h3>I don't know how to handle <%= @route %></h3>
    ```

1. How to put the into seperate files.

1. CSS file: in public folder

1. SASS: template for CSS, CSS preprocessor
    - type
        - SCSS: newer
        - Indent syntax
    - Contents: 
        - variables
        - mixin

    ``` rb
    get '/styles.css' do
        get 
    end
    ```

1. A log-on form inside all views

    ``` rb
    @@about         # view
        <h3>Infor mation about my site</h3>
        <%= erb :logon %>       # inculde a view in another one.

    @@logon
    <h1>Please log on</h1>
    ```

1. Layout vs. partials

## Database

1. MVC design pattern
    - Controller
    - Model
    - View

1. SQLite
    - open source
    - serverless, light weight
    - single database file
    - no installation / configuration

    ``` sql
    sqlite3

    .open name.db   -- commands
    .tables         -- list tables

    CREATE TABLE students (
        id VARCHAR(10) PRIMARY KEY, 
        first name  TEXT, 
        lastname    TEXT
    );

    .schemas

    INSERT INTO student VALUES ("w1234", "yuan", "wang");
    INSERT INTO student VALUES ("w1235", "Someone", "else");

    SELECT * FROM students;
    ```