# 2019-04-30

## recap

- Manual CGI
- CGI standard
- Template system

## Frameworks

### Sinatra

1. A ruby library to provide a DSL (domain specific language)
    - Install: <code>gen install sinatra</code>

1. Not as framework as Ruby on Rails
    - no file structure

    ``` ruby
    require sinatra

    get '/hello' do     # request, using clean url
        "<h1>...</h1>"  # response
    end
    ```
    - clean url: not necessarily files, just a identifier.


    ``` ruby
    require 'sinatra'

    get '/home' do
    %{

    }
    end
    ```

1. THIN => application server

1. Match the request from top-down

1. Passing named parameter
    - different route share same controller
    - Wild card: see slides
        - Be careful for the sequence
    - RegEx

1. `redirect`: sending back to the browser
1. Static page will be in `public` folder, will be in higher priority than router.

1. Filter
    - before
    - after

1. Configure
    - Sinatra only have 4 methods defined???

1. not found

1. sinatra-contrib: non stop

1. Set ip & port

1. login page

``` ruby
require 'sinatra'

get '/login' do
    %{
<html>
<body>
<h1>Please login</h1>
<form action='/login' method='post'>
    username: <input type='text' name='username'></input><br>
    password: <input type='text' name='password'></input><br>
    <input type='submit' name='login'></input>
</body>
</html>
    }
end

post '/login' do
    "<h1>id #{params[:username]}, password: #{params[:password]}</h1>"
end

```

1. upload file

```html
<!-- upload.html -->
<html>
<h1>Upload a file</h1>
<form action="/upload" method="post" enctype="multipart/form-data">
    file to upload: <input type="file" name="file">
    <input type="submit" value="upload">
</html>
```

``` ruby
require 'sinatra'

post '/upload' do
    tempfile = params['file'][:tempfile]
    filename = params['file'][:filename]
    File.write("./uploadfoler/#{filename}", tempfile.read)
    "File uploaded complete: #{filename}"
end
```

1. Guess name

``` ruby
require 'sinatra'

get '/guess/:who' do
    pass unless params[:who] = 'yuan'   # pass leads to next route
    "you got me!"
end

get 'guess/*' do
    "you missed!"
end
```

1. Bet

``` ruby
require 'sinatra'

get '/bet/:stake/on/:number' do
    stake  = params[:stake].to_i    # don't forget type
    number = params[:number].to_i
    roll = rand(6) + 1

    if nubmer == roll
        "<h1>the dice landed on #{roll} you win #{10*stake} dollars"
    else
        "<h1>the dice landed on #{roll} you lose #{stake} dollars"
    end
end
```
