# 2019-04-25

## recap

## Web application

1. Goal: generate HTML pages

1. ways
    - manual CGI script
    - RUby CGI

### CGI script

cgi-folder

1. set up a CGI server

### Ruby CGI standard library

1. Send data from browser to server
    - query string
    - form
    - ajax

1. Retrieving data: 

`CGI#params`

example: http request => CGI hash

``` ruby
require 'cgi'

cgi = CGI.new
cgi.user_agent
cg...
```

1. Form: a CGI program

slides

``` ruby
require 'cgi'

cgi = CGI.new
cgi.user_agent
cg...
```

1. Cookie: storing session information
    - Store on the client
    - Session: a whole browsing procedure

```ruby
cookie = CGI::Cookie.new(cookie_name, cookie_value)
```

1. Session: another technique to store session info
    - Data store on the server
    - Session key on the client as a cookie

```ruby
session = CGI::Session.new(cgi, 
    "session_key"       => "mysession", 
    "sessiion_expires"  => Time.now + 30*60)
```

### Template Systems

static text + program => static text + string

1. Catagories
    - erb (Web Programming I)
    - PHP (embedded ruby)
    - haml

### ERB template system

1. Define method
    - Huge string
    - external file
        - naming convention: `filename.output_type.erb`

``` html
<% ruby code %>
<%= ruby expression %>

```

``` html
<ul>
    <% for item in @shopping_list %>
        <li><%= item %></li>
    <% end %>
</ul>
```

1. Filter template

```ruby
renderer = ERB.new(template)
```

### HAML

1. Install HAML

``` sh
gem install haml
```

## Frameworks

## Midterm

1. 1 page cheat sheet.

### Ruby on Rails



### Sinatra