# 2019-04-23

## Recap

1. RegEx
1. File IO: the use of blocks

## IO

### BasicSocket

1. Web programming
    - Web server
    - server side app: CGI script

#### Web Server

1. Based onf HTTP, supported by TCP/IP

1. TCP Socket APIs
    - open a TCP socket: abstraction to represent connections
    - layers: IO -> BasicSocket -> Socket -> IPSocket -> TCPSocket
    - Programs
        - Listener: listen => infinite loop
        - Initiator: connect

    ``` ruby
    require 'socket'
    ```

1. Server (Listener)
    - Structure: Create -> Bind -> Listen -> Accept -> Close (-> listen)
    - Create a socket

        ```ruby
        socket = Socket.new(domain, socktype, )
        ```

    - Bind

        ```ruby
        address = Socket.pack_sockaddr_in(port, addr)

        ```

    - Listen

        ```ruby

        ```

    - Accept

        ```ruby

        ```

1. Syntax Sugar (wrap the complicated code)

    ```ruby
    require `socket`

    server = TCPServer.new('localhost', 4444)

    Socket.accept_loop(server) {|connection|
        connection.close}
    ```

    Even sweeter

    ```ruby
    require `socket`

    Socket.TCPServer.new('localhost', 1234)
    ```

1. Client: Create -> Connect -> Close

1. Syntax Sugar

    ```ruby
    require `socket`

    Socket.TCPSocket.new('localhost', 1234)
    ```

1. Exchange data
    - 
        - write to
        - read from

            ``` ruby
            connection.read
            connection.gets     # line by line
            ```

    ``` ruby
    require 'socket'

    p

    Socket.tcp_server_loop(1234) { |connection|
        connection.read
        connection.close
    }
    ```

    ```h
    echo ... | nc localhost port
    ```

    ``` ruby
    require 'socket'

    # string not have is_integer
    class String
        def is_interger?
            /^\d+{4,5}$/ =~ self
        end
    end

    if ARGV.size < 2
        puts "port or message missing..."
    else
        begin
            port = ARGV[0]
            raise ArgumentError unless port.is_integer?

            ARGV.slice!(0)
            message = ARGV.join(' ')
            socket = TCPSocket.new('lcoalhost', port)
            socket.write(message)
        rescue ArgumentError
            puts "port is not a number."
        rescue                                  # any other error
            puts "connection error ... exiting ..."
        end
    end
    ```

1. Linux pipe

1. Exception handling

    ``` ruby
    def raise_exception
        puts "before raise"
        raise "I created this error"    # Anything after raise won't be executed
        puts "after raise"
    end
    ```

    - not String

        ``` ruby
        def inverse(n)
            raise Argument Error, "NaN" unless n.is_a?Numeric
            1.0/n
        end
        ```

    - handle the exception

        ``` ruby
        def raise_rescue
            begin
                puts "before raise"
                raise "I created this error"    # Anything after raise won't be executed
                puts "after raise"
            rescue
                puts "this is a rescue"
            end

            puts "after rescue"
        end
        ```

1. HTTP request example

    ```
    GET /hello.htm HTTP/1.1
    User-Agent: Mozilla/4.0 (Compatible)
    ```

1. Write a server

    ```ruby
    require 'socket'

    # Get port number
    if ARGV.size != 1
        puts "please specify port ..."
        exit
    else
        port = ARGV[0]
    end

    puts "listening at port #{port}"

    server = TCPServer.new("127.0.0.1", port)
    Socket.accept_loop(server) { |connection|
        request = connection.gets
        request_file_name = request.gsub('/GET\ \//', "").gsub("/\ HTTP.*", "")
        filename = request_file_name.chomp  # get rid of weird chars

        if filename == ""
            filename = "index.html"
        end

        begin
            f = File.open(filename, "r")
            content = f.read

            # head
            connection.print "HTTP/1.1 200 OK\r\nConnect-type:text/html\r\n"
            connection.print "Content-Length: #{content.size}"
            connection.print "Connection: close\r\n"
            connection.print "\r\n"

            # body
            connection.print content

        rescue Errno::ENOENT
            puts "requested file #{filename} not found"
            conneciton.print "HTTP/1.1 404 Not Found"
            conneciton.print "Server: myserver"
            conneciton.print "Connection close\r\n"
            conneciton.print "\r\n"

            # body
            conneciton.print "<h1> File can not be found</h1>"
        end

    }

    ```

    ``` html
    <!-- index.html -->
    <html>
    <head>    </head>
    <body>
        <h1>welcome to my default page</h1>
    </body>
    </html>

    <!-- page.html -->
    <html>
    <head>    </head>
    <body>
        <div style = "test-align:center">
        <h1>welcome to my defualt page</h1>
        <img src="newevoli.jpg" />
        <h1>new evoli</h1>
        </div>
    </body>
    </html>
    ```

1. Standard Library
    - Net::HTTP: simple client o fetch header and 
    - open-uri: wrapper of 

1. CGI -> program