# 2019-04-18

## Recap

### Module

get all the vowels

```ruby
class VowelFinder
    include Enumerable
    def initialize(string)
        @string = string
    end

    def each
        @string.scan(/[aeiou]/) do |vowel|
            yield vowel
        end
    end
end

"about" # a, o, u

vf = VowelFinder.new("For a mixin, this means you can call them.")
vf.each {|v| p v, '-'}

p vf.select {|v| v >= 'o'}
p vf.map {|v| v*5}
p vf.inject {:+}    # concatenate all
```

## RegEx Continue

1. `=~` return the matching position or `nil`.
    - `\A\Z` is the same as`^$`

    ```ruby
    w = ["new", "New", "NEW"]

    w.each do |word|
        case word
        when /^[a-z]*$/ then p "#{word} is lower case"
        when /^[A-Z]*$/ then p "#{word} is upper case"
        else then p "#{word} is mixed case"
        end
    end
    ```

1. `\b` Boundary

```ruby
"This is a sentence".gsub(/\b/, "*")
"This is a sentence".gsub(/\bis/, "*")
"This is a sentence".gsub(/\Bis/, "*")
```

1. `\w` Word

```ruby
/(\w+)\1/ =~ "banana"       # exact same \w+ twice
/(\w+)(\w+)/ =~ "banana"    # any two \w+, not required to be same
```

1. Methods of RegEx
    - `.match` return a obj
    - `.pre_match` the position before matching
    - `.post_match` the position after matching

1. `%r{mm/dd}` is exactly same as `/mm\/dd`, no need to escape.

1. `.` for any single char

    ```ruby
    "012345" =~ /.4/    # 3
    "abcde" =~ /.e/     # 3
    ```

1. Greedy repetition and lazy repetition
    - greedy repetition: default, return as many chars as possible
    - lazy: less

    ```ruby
    /go?d/.match("this is a good class")    # goo, greedy
    /go??d/.match("this is a good class")   # go, lazy
    /g(o?)?d/.match("this is a good class")
    ```

1. Grouping

    ```ruby
    /an+/.match("banana")
    /(an)+/.match("banana")

    /(\d\d):(\d\d)(..)/.match("12:30am")
    ```

    - name the group, can be used in local variables

## I/O

1. Two way
    - Kernel methods
    - CLasses

### Kernel methods

1. `Kernel` (mixin) included in object
    - puts
    - puts
    - gets: get a line from input / file in argv
    - readlines: read each line using gets

        ```ruby

        ```

1. Can use class method and/or instance method

1. `ARGV`, `ARGF`

    ```ruby
    > ruby my.rb 
    ```

    - argv returns all the arguments
    - argf only returns file arguments

1. `Dir`
1. `CSV`

    ```ruby
    require csv
    
    foreach("myfile.csv") do |row|

    CSV.
    ```