# Ruby

## Module

1. Def: Similar to a class, except
    - without `.new()`
    - no super class

1. Creation
    - Class -> myClass (pointer to Class) (super class) -> myObj (pointer to myClass)
    - Module -> myModule (pointer to Class) (instance of Module class, singleton), no super class

    Item | Module | Class
    --- | --- | ---

    See the sildes

1. Contents
    - classes / modules
    - constants
    - module methods
    - instance methods
    - instance variables

```ruby
module MyModule     # like a name space for classes
    class MyClass
        def my_method
        end
    end
end
```

1. Reason to have classes
    - Organize constants (including class and modules within)
    - Provide collection of methods.
    - As namespace

1. Constant:
    - Class / modules names
    - Can be changed but will generate warnings.
    - Scope: global, can be put in anywhere and accessed from anywhere using `::COSTANT_NAME`
    - Cannot defined inside instance method
    - If multiple with same name, "nearest"(physically) one will be returned
    - `::` notation, for top ones

1. Diff constant and variables: make a chart

1. Function -> stack (This is the reason of scope)

1. Scope:
    - Enter a new scope:
        - module
        - class
        - method
    - `p local_variables`: get local variables in the current scope

1. Module methods
    - same as class method

1. Instance methods in module: create sub class

    ```ruby
    module MyModule
        def my_method
        end
    end

    class MyClass
        include MyModule
    end

    myObj = MyClass...
    myObj.my_method()
    ```

    modules included called __mixin__, behaves as super classes (see the slide)

    - can not inheritate from multiple class, but can include multiple modules
    - two pointer problem: anonymuos pointers point to __mixin__, actually have no super class pointer

1. Another way to mix-in: prepend, see the slides, differences

    ```ruby
    module MyModule
        def my_method
        end
    end

    class MyClass
        include MyModule
    end

    myObj = MyClass...
    myObj.my_method()
    ```

    resson: different order in chain

1. Extend: another way to define class method

    make module instance method to be class method

1. require and include

1. do not define instance variable in mixin

1. built-in mixin:

    ```ruby
    class  Student
        include Comparable
        attr_accessor :name
        ...
        def <=>(otherStudent)
            self.name <=> otherStudent.name
        end

        def to_s
            "#{@name}"
        end
    ```

1. Kernel
    - `Object` class is using mixin called `Kernel`
1. Enumerate

## Regular Expression

1. Def: a way to define a language: `/abc/` (meta char)

```ruby
/abc/

/abc|xyz/
/(Homer|Marge|Bart) Simpson/

/^abc$/
```

1. Meta Chars
    - `/, \, ^, $, +, -`
    - `+`, `*`, `?`
    - `{max, min}`: number of times (exact or range)
    - `[]`, short version -> `[a-z]`, `[a-z0-9]`, `[a-zA-Z0-9]`, use `^` to negate inside [] (even shorter: \d, \D, \w, \W, \s, \S)

1. Method:
    - `.scan`
    - `.sub` replace the first matching
    - `.gsub` replace all matching
    - 

1. Matching Operator: `/RegEx/ =~ "String`