# Ruby

## Recap

1. variable length

    ```ruby
    def m(a, b, *c) 
        puts "#{a}, #{b}, #[c]"
    end
    ```

    - `m 1, 2, 3, 4` and `m 1, *[2, 3, 4]` are the same.

1. keyword params

    ```ruby
    def search(field, genre: "pop", duration:120) 
        puts [field, genre, duration]
    end
    ```

    ``` ruby
    search(:title)
    search(:title, duration:200)
    search(:title, duration:200, genre:200)
    ```

    all above are acceptable, but `search(:title, duration:200, genre:200, other:"somekthing")` will generate a key error

    - collect addition args

        ```ruby
        def search(field, *x, genre: "pop", duration:120, **rest) 
            puts [field, genre, duration]
        end

        search(:title, 4, "love", "you", duration:200, genre:200, other:"somekthing")
        ```

        ```ruby
        def m(a, *b, **c) 
            p [a, b, c]
        end

        m 10
        m 10, 20, 30
        m 10, 20, 30, a:1, b:2

        h = {c:3, d:4}
        m = 10, h, f:5      # h as an obj, will be collected in b
        m = 10, **h, f:5    # h flattened
        ```

        - `*` collects whatever is left
        - `**` collects leftover hashes

##

1. nested method: same as defined in top level, no scope restrictions (different from py), ACTUALLY NO NESTED METHOD, except for lambda.

    ```ruby
    def out_method
        def in_method1
            p "inside 1"
        end
        def in_method2
            p "inside 2"
        end
        p "out method"
    end

    outmethod
    in_method1
    in_method2
    ```

1. Scope in Ruby
    - method
    - class
    - module

1. Operator as a method
    ```ruby
    x, y, z = 1, 2, 3

    p (x+y)*z       # 9
    p (x.+(y)).*z   # 9
    ```

1. Alias
    ```ruby
    def m
        "orginal method"
    end

    alias oldm m    # rename original method as oldm

    def m
        "another method"
    end

    p m
    p oldm

    # -----------
    class Integer
        alias ori_* *   # rename original method

        def *(n)        # overwrite
            ori_*(n) + 8
        end
    end
    ```

1. Chain method call

    ```ruby
    class MyClass
        def initialize
            @total = @count = 0
        end

        def <<(n)
            @total += n
            @count += 1
            self            # return itself
        end

        def avarage
            Float(@total) / @count
        end
    end

    obj = Myclass.new
    p (obj << 34 << 42 << 560).average     # add multiple numbers

1. OO example

    - Same as database design philosophy, class are columns, values are objects.

    - A classs for bike: in ppt, separate part in separate files, call `drive.rb` automatically loads other two files.

    ```ruby
    # gear.rb
    class Gear
        def initialize(chainring, cog, wheel=nil)
            @chainring = chainring
            @cog = cog
            @wheel = wheel
        end

        def ratio
            @chainring / @cog.to_f
        end

        def gear_inches
            @wheel.diameter * ratio
        end
    end

    # wheel.rb
    class Wheel
        def initialize(rim, tire)
            @rim  = rim     # internal diameter
            @tire = tire    # distance from internal ring to outer ring
        end

        def diameter
            @rim 2 * @tire
        end

        def circumference
            diameter * Math::PI
        end 
    end

    # drive.rb
    require_relative  'gear'  # require in the same folder
    require_relative  'wheel'

    wheel = Wheel.new(26, 2)

    p wheel.circumference

    g = Gear.new(25, 10, wheel)
    p g.gear_inches
    ```

1. Inheritance

    ```ruby
    class MyClass
        def initialize
            @total = @count = 0
        end

        def <<(n)
            @total += n
            @count += 1
            self            # return itself
        end

        def avarage
            Float(@total) / @count
        end
    end

    class MySubClass < MyClass  # inherit methods from a super class
        def sub_method
            p "method of sub class"
        end
    end

    obj = MySubClass.new
    obj.sub_method
    p (obj << 34 << 42 << 560).average

    p MySubClass.superclass # get name of upper level super class
    p MySubClass.ancestors  # get a chain of super classes
    ```

1. Super

    ```ruby
    class Greeting
        def greet
            "Hello"
        end
    end

    class WarmGreeting < Greeting
        def greet
            "hey, #{super}" # call the same name method in the parent class
        end
    end

    p WarmGreeting.new.greet
    ```

    no way to specify the level within acestors

    ```ruby
    class Vehicle
        attr_accessor :position

        def initialize(n=0)
            @position = n
        end

        def moving_forward(n)
            @position += n
            p "moved forward: #{@position}"
        end
    end

    class Car < Vehicle
        def moving_forward(n, m)
            p "VROOM!!!"
            super(n)   # call the same name method in the parent class
        end
    end

    obj = Car.new(0)
    obj.moving_forward(100)
    ```

1. In Ruby, class itself is an object.

    ```ruby
    Class.new()

    class C
        def C.static1
            "static method"
        end

        def self.static1
            "also static method"
        end

        def method
            "common instance method"
        end
    end
    ```

1. Instance variable and class variable `[?]`

    ```ruby
    class C
        @var = 10

        def initialize
            @var = 5
        end
    end
    ```

1. Singleton Method: method for one particular object only
    - create an anonymous child class of original class
    - class methods are all singleton

    ```ruby
    class MyClass
        class << self
            def cmethod
                "A singleton method."
            end
        end
    end
    ```