(() => {
  const LOCALES = {
    es: {
      must_not: 'no debe',
      must: 'debe',
      solution: 'la solución',
      Assigns_named: (binding, must, target, tokens) => `${binding} ${must} asignar ${target}`,
      Assigns: (binding, must, target, tokens) => `${binding} ${must} realizar asignaciones`,
      Calls_named: (binding, must, target, tokens) => `${binding} ${must} utilizar ${target}`,
      Calls: (binding, must, target, tokens) => `${binding} ${must} delegar`,
      Declares_named: (binding, must, target, tokens) => `${binding} ${must} declarar ${target}`,
      Declares: (binding, must, target, tokens) => `${binding} ${must} contener declaraciones`,
      DeclaresAttribute_named: (binding, must, target, tokens) => `${binding} ${must} declarar un atributo ${target}`,
      DeclaresAttribute: (binding, must, target, tokens) => `${binding} ${must} declarar atributos`,
      DeclaresClass_named: (binding, must, target, tokens) => `${binding} ${must} declarar una clase ${target}`,
      DeclaresClass: (binding, must, target, tokens) => `${binding} ${must} declarar clases`,
      DeclaresComputation_named: (binding, must, target, tokens) => `${binding} ${must} declarar una computación ${target}`,
      DeclaresComputation: (binding, must, target, tokens) => `${binding} ${must} declarar computaciones`,
      DeclaresComputationWithArity0_named: (binding, must, target, tokens) => `${target} ${must} tener cero parametros`,
      DeclaresComputationWithArity1_named: (binding, must, target, tokens) => `${target} ${must} tener un parámetro`,
      DeclaresComputationWithArity2_named: (binding, must, target, tokens) => `${target} ${must} tener dos parámetros`,
      DeclaresComputationWithArity3_named: (binding, must, target, tokens) => `${target} ${must} tener tres parámetros`,
      DeclaresComputationWithArity4_named: (binding, must, target, tokens) => `${target} ${must} tener cuatro parámetros`,
      DeclaresComputationWithArity5_named: (binding, must, target, tokens) => `${target} ${must} tener cinco parámetros`,
      DeclaresEntryPoint: (binding, must, target, tokens) => `${binding} ${must} declarar un punto de entrada`,
      DeclaresEnumeration_named: (binding, must, target, tokens) => `${binding} ${must} declarar una enumeracion ${target}`,
      DeclaresEnumeration: (binding, must, target, tokens) => `${binding} ${must} declarar enumeraciones`,
      DeclaresFact_named: (binding, must, target, tokens) => `${binding} ${must} declarar un hecho ${target}`,
      DeclaresFact: (binding, must, target, tokens) => `${binding} ${must} declarar hechos`,
      DeclaresFunction_named: (binding, must, target, tokens) => `${binding} ${must} declarar una función ${target}`,
      DeclaresFunction: (binding, must, target, tokens) => `${binding} ${must} declarar funciones`,
      DeclaresInterface_named: (binding, must, target, tokens) => `${binding} ${must} declarar una interfaz ${target}`,
      DeclaresInterface: (binding, must, target, tokens) => `${binding} ${must} declarar interfaces`,
      DeclaresMethod_named: (binding, must, target, tokens) => `${binding} ${must} declarar un método ${target}`,
      DeclaresMethod: (binding, must, target, tokens) => `${binding} ${must} declarar métodos`,
      DeclaresObject_named: (binding, must, target, tokens) => `${binding} ${must} declarar un objeto ${target}`,
      DeclaresObject: (binding, must, target, tokens) => `${binding} ${must} declarar objetos`,
      DeclaresPredicate_named: (binding, must, target, tokens) => `${binding} ${must} declarar un predicado ${target}`,
      DeclaresPredicate: (binding, must, target, tokens) => `${binding} ${must} declarar predicados`,
      DeclaresProcedure_named: (binding, must, target, tokens) => `${binding} ${must} declarar un procedimiento ${target}`,
      DeclaresProcedure: (binding, must, target, tokens) => `${binding} ${must} declarar procedimientos`,
      DeclaresRecursively_named: (binding, must, target, tokens) => `${target} ${must} estar declarado recursivamente`,
      DeclaresRule_named: (binding, must, target, tokens) => `${binding} ${must} declarar una regla ${target}`,
      DeclaresRule: (binding, must, target, tokens) => `${binding} ${must} declarar reglas`,
      DeclaresSuperclass_named: (binding, must, target, tokens) => `${binding} ${must} declarar una superclase ${target}`,
      DeclaresSuperclass: (binding, must, target, tokens) => `${binding} ${must} declarar una superclase`,
      DeclaresTypeAlias_named: (binding, must, target, tokens) => `${binding} ${must} declarar un sinónimo de tipo ${target}`,
      DeclaresTypeAlias: (binding, must, target, tokens) => `${binding} ${must} declarar sinónimos de tipo`,
      DeclaresTypeSignature_named: (binding, must, target, tokens) => `${binding} ${must} declarar una firma ${target}`,
      DeclaresTypeSignature: (binding, must, target, tokens) => `${binding} ${must} declarar firmas de tipos`,
      DeclaresVariable_named: (binding, must, target, tokens) => `${binding} ${must} declarar una variable ${target}`,
      DeclaresVariable: (binding, must, target, tokens) => `${binding} ${must} declarar variables`,
      Delegates: (binding, must, target, tokens) => `${binding} ${must} delegar`,
      DiscardsExceptions: (binding, must, target, tokens) => `${binding} está ignorando excepciones silenciosamiente`,
      DoesConsolePrint: (binding, must, target, tokens) => `${binding} está realizando impresiones por pantalla`,
      DoesNilTest: (binding, must, target, tokens) => `${binding} hace comparaciones contra <code>${tokens['keyword_Nil']}</code>`,
      DoesNullTest: (binding, must, target, tokens) => `${binding} hace comparaciones contra <code>${tokens['keyword_Nil']}</code>`,
      DoesTypeTest: (binding, must, target, tokens) => `${binding} hace comparaciones contra strings`,
      HasAssignmentCondition: (binding, must, target, tokens) => `${binding} evalúa el resultado de una asignación en donde se esperaba una expresión booleana. ¿Quizás quisiste usar el operador <code>${tokens['operator_Equal']}</code>?`,
      HasAssignmentReturn: (binding, must, target, tokens) => `${binding} devuelve el resultado de una asignación. ¿Quizás quisiste usar el operador <code>${tokens['operator_Equal']}</code>?`,
      HasCodeDuplication: (binding, must, target, tokens) => `${binding} tiene código repetido`,
      HasDeclarationTypos_named: (binding, must, target, tokens) => `La solución parece tener un error de tipeo: debe declarar ${target}, pero declara ${binding}. ¿Quizás quisiste decir ${target}?`,
      HasEmptyIfBranches: (binding, must, target, tokens) => `${binding} tiene ramas de <code>${tokens['keyword_If']}</code> vacías`,
      HasEmptyRepeat: (binding, must, target, tokens) => `${binding} tiene un <code>${tokens['keyword_Repeat']}</code> vacío`,
      HasEqualIfBranches: (binding, must, target, tokens) =>  `${binding} tiene <code>${tokens['keyword_If']}</code>s innecesarios porque sus dos ramas son iguales`,
      HasLongParameterList: (binding, must, target, tokens) => `${binding} tiene demasiados parámetros. Te podría estar faltando una abstracción`,
      HasMisspelledBindings: (binding, must, target, tokens) => `${binding} está mal escrito. Revisá la ortografía y procurá no usar abreviaturas`,
      HasMisspelledIdentifiers: (binding, must, target, tokens) => `${binding} está mal escrito. Revisá la ortografía y procurá no usar abreviaturas`,
      HasRedundantBooleanComparison: (binding, must, target, tokens) => `${binding} hace comparaciones booleanas innecesarias`,
      HasRedundantGuards: (binding, must, target, tokens) => `${binding} tiene guardas innecesarias`,
      HasRedundantIf: (binding, must, target, tokens) => `${binding} tiene <code>${tokens['keyword_If']}</code>s innecesarios que pueden ser reemplazados por expresiones booleanas`,
      HasRedundantLambda: (binding, must, target, tokens) => `${binding} tiene lambdas innecesarias`,
      HasRedundantLocalVariableReturn: (binding, must, target, tokens) => `${binding} usa variables locales innecesarias; podés retornar directamente la expresión`,
      HasRedundantParameter: (binding, must, target, tokens) => `${binding} tiene parámetros innecesarios (se pueden eliminar mediante point-free)`,
      HasRedundantReduction: (binding, must, target, tokens) => `${binding} usa <code>${tokens['keyword_Is']}</code>, pero no realiza cálculos`,
      HasRedundantRepeat: (binding, must, target, tokens) => `${binding} tiene un <code>${tokens['keyword_Repeat']}</code> innecesario`,
      HasTooManyMethods: (binding, must, target, tokens) => `${binding} tiene demasiados métodos`,
      HasTooShortBindings: (binding, must, target, tokens) => `${binding} es un identificador muy corto`,
      HasTooShortIdentifiers: (binding, must, target, tokens) => `${binding} es un identificador muy corto`,
      HasUnreachableCode: (binding, must, target, tokens) => `${binding} tiene código inalcanzable`,
      HasUsageTypos_named: (binding, must, target, tokens) => `La solución parece tener un error de tipeo: debe usar ${target}, pero usa ${binding}. ¿Quizás quisiste decir ${target}?`,
      HasWrongCaseBindings: (binding, must, target, tokens) => `${binding} no respeta la convención de nombres`,
      HasWrongCaseIdentifiers: (binding, must, target, tokens) => `${binding} no respeta la convención de nombres`,
      Implements_named: (binding, must, target, tokens) => `${binding} ${must} implementar ${target}`,
      Implements: (binding, must, target, tokens) => `${binding} ${must} implementar intefaces`,
      Includes_named: (binding, must, target, tokens) => `${binding} ${must} incluir el mixin ${target}`,
      Includes: (binding, must, target, tokens) => `${binding} ${must} incluir mixins`,
      Inherits_named: (binding, must, target, tokens) => `${binding} ${must} declarar una superclase ${target}`,
      Inherits: (binding, must, target, tokens) => `${binding} ${must} declarar una superclase`,
      Instantiates_named: (binding, must, target, tokens) => `${binding} ${must} instanciar ${target}`,
      Instantiates: (binding, must, target, tokens) => `${binding} ${must} instanciar objetos`,
      IsLongCode: (binding, must, target, tokens) => `${binding} es muy largo. Tratá de delegar más`,
      OverridesEqualOrHashButNotBoth: (binding, must, target, tokens) => `${binding} redefine los métodos <code>equals</code> o <code>hash</code>, pero no ambos`,
      Raises_named: (binding, must, target, tokens) => `${binding} ${must} lanzar ${target}`,
      Raises: (binding, must, target, tokens) => `${binding} ${must} lanzar excepciones`,
      Rescues_named: (binding, must, target, tokens) => `${binding} ${must} capturar ${target}`,
      Rescues: (binding, must, target, tokens) => `${binding} ${must} capturar excepciones`,
      Returns: (binding, must, target, tokens) => `${binding} ${must} retornar`,
      ReturnsNil: (binding, must, target, tokens) => `${binding} retorna null, lo cual es una mala práctica`,
      ReturnsNull: (binding, must, target, tokens) => `${binding} retorna null, lo cual es una mala práctica`,
      ShouldInvertIfCondition: (binding, must, target, tokens) => `${binding} debería invertir la condición del <code>${tokens['keyword_If']}</code> e intercambiar las ramas`,
      ShouldUseStrictComparators: (binding, must, target, tokens) => `${binding} debería usar los operadores de equivalencia <code>${tokens['operator_Equal']}</code> y <code>${tokens['operator_NotEqual']}</code> en lugar de los operadores de similitud <code>${tokens['operator_Similar']}</code> y <code>${tokens['operator_NotSimilar']}</code>`,
      SubordinatesDeclarationsTo: (binding, must, target, tokens) => `Todas las declaraciones en ${binding} ${must} ser usadas desde ${target}`,
      SubordinatesDeclarationsToEntryPoint: (binding, must, target, tokens) => `Todas las declaraciones en ${binding} ${must} deben ser usadas desde un <code>${tokens['keyword_EntryPoint']}</code>`,
      TypesAs_named: (binding, must, target, tokens) => `${binding} ${must} ser de tipo ${target}`,
      TypesAs: (binding, must, target, tokens) => `${binding} ${must} tipar`,
      TypesParameterAs_named: (binding, must, target, tokens) => `${binding} ${must} tipar parámetros con el tipo ${target}`,
      TypesParameterAs: (binding, must, target, tokens) => `${binding} ${must} tipar parámetros`,
      TypesReturnAs_named: (binding, must, target, tokens) => `${binding} ${must} tipar su valor de retorno como ${target}`,
      TypesReturnAs: (binding, must, target, tokens) => `${binding} ${must} tipar su valor de retorno`,
      Uses_named: (binding, must, target, tokens) => `${binding} ${must} utilizar ${target}`,
      Uses: (binding, must, target, tokens) => `${binding} ${must} delegar`,
      UsesAnonymousVariable: (binding, must, target, tokens) => `${binding} ${must} utilizar una variable anónima`,
      UsesComposition: (binding, must, target, tokens) => `${binding} ${must} usar composición`,
      UsesComprehension: (binding, must, target, tokens) => `${binding} ${must} emplear listas por comprensión`,
      UsesConditional: (binding, must, target, tokens) => `${binding} ${must} utilizar condicionales`,
      UsesCut: (binding, must, target, tokens) => `${binding} usa el operador !, lo cual es una mala práctica`,
      UsesDynamicMethodOverload: (binding, must, target, tokens) => `${binding} ${must} usar sobrecarga`,
      UsesDynamicPolymorphism: (binding, must, target, tokens) => `${binding} ${must} usar polimorfismo`,
      UsesExceptionHandling: (binding, must, target, tokens) => `${binding} ${must} realizar manejo de excepciones`,
      UsesExceptions: (binding, must, target, tokens) => `${binding} ${must} usar excepciones`,
      UsesFail: (binding, must, target, tokens) => `${binding} usa <code>${tokens['keyword_Fail']}</li>, lo cual es una mala práctica`,
      UsesFindall: (binding, must, target, tokens) => `${binding} ${must} utilizar <code>${tokens['keyword_Findall']}</code>`,
      UsesForall: (binding, must, target, tokens) => `${binding} ${must} utilizar <code>${tokens['keyword_Forall']}</code>`,
      UsesForeach: (binding, must, target, tokens) => `${binding} ${must} usar <code>${tokens['keyword_ForEach']}</code>`,
      UsesForLoop: (binding, must, target, tokens) => `${binding} ${must} usar <code>${tokens['keyword_For']}</code>`,
      UsesGuards: (binding, must, target, tokens) => `${binding} ${must} usar guardas`,
      UsesIf: (binding, must, target, tokens) => `${binding} ${must} usar <code>${tokens['keyword_If']}</code>`,
      UsesInheritance: (binding, must, target, tokens) => `${binding} ${must} usar herencia`,
      UsesLambda: (binding, must, target, tokens) => `${binding} ${must} emplear expresiones lambda`,
      UsesLogic: (binding, must, target, tokens) => `${binding} ${must} usar expresiones booleanas`,
      UsesLoop: (binding, must, target, tokens) => `${binding} ${must} usar un bucle`,
      UsesMath: (binding, must, target, tokens) => `${binding} ${must} usar expresiones matemáticas`,
      UsesMixin: (binding, must, target, tokens) => `${binding} ${must} utilizar mixins`,
      UsesMixins: (binding, must, target, tokens) => `${binding} ${must} usar mixins`,
      UsesNamedSelfReference: (binding, must, target, tokens) => `${binding} debería usar <code>${tokens['keyword_Self']}</code> en lugar de una referencia global`,
      UsesNot: (binding, must, target, tokens) => `${binding} ${must} utilizar <code>${tokens['keyword_Not']}</code>`,
      UsesObjectComposition: (binding, must, target, tokens) => `${binding} ${must} usar composición`,
      UsesPatternMatching: (binding, must, target, tokens) => `${binding} ${must} utilizar pattern matching`,
      UsesRepeat: (binding, must, target, tokens) => `${binding} ${must} usar <code>${tokens['keyword_Repeat']}</code>`,
      UsesRepeatOf: (binding, must, target, tokens) => `${binding} ${must} usar un <code>${tokens['keyword_Repeat']}</code> de ${target}`,
      UsesStaticMethodOverload: (binding, must, target, tokens) => `${binding} ${must} usar sobrecarga`,
      UsesStaticPolymorphism: (binding, must, target, tokens) => `${binding} ${must} usar polimorfismo`,
      UsesSwitch: (binding, must, target, tokens) => `${binding} ${must} utilizar un <code>${tokens['keyword_Switch']}</code>`,
      UsesTemplateMethod: (binding, must, target, tokens) => `${binding} ${must} usar un método plantilla`,
      UsesUnificationOperator: (binding, must, target, tokens) => `${binding} usa el operador de unificación (=)`,
      UsesWhile: (binding, must, target, tokens) => `${binding} ${must} utilizar un <code>${tokens['keyword_While']}</code>`,
      UsesYield: (binding, must, target, tokens) => `${binding} ${must} utilizar un <code>${tokens['keyword_yield']}</code>`
    },
    en: {
      must_not: 'must not',
      must: 'must',
      solution: 'solution',
      Assigns_named: (binding, must, target, tokens) => `${binding} ${must} assign ${target}`,
      Assigns: (binding, must, target, tokens) => `${binding} ${must} perform assignments`,
      Calls_named: (binding, must, target, tokens) => `${binding} ${must} use ${target}`,
      Calls: (binding, must, target, tokens) => `${binding} ${must} delegate`,
      Declares_named: (binding, must, target, tokens) => `${binding} ${must} declare ${target}`,
      Declares: (binding, must, target, tokens) => `${binding} ${must} contain declarations`,
      DeclaresAttribute_named: (binding, must, target, tokens) => `${binding} ${must} declare an attribute ${target}`,
      DeclaresAttribute: (binding, must, target, tokens) => `${binding} ${must} declare attributes`,
      DeclaresClass_named: (binding, must, target, tokens) => `${binding} ${must} declare a class ${target}`,
      DeclaresClass: (binding, must, target, tokens) => `${binding} ${must} declare classes`,
      DeclaresComputation_named: (binding, must, target, tokens) => `${binding} ${must} declare a computation ${target}`,
      DeclaresComputation: (binding, must, target, tokens) => `${binding} ${must} declare computations`,
      DeclaresComputationWithArity0_named: (binding, must, target, tokens) => `${target} ${must} have zero parameters`,
      DeclaresComputationWithArity1_named: (binding, must, target, tokens) => `${target} ${must} have one parameter`,
      DeclaresComputationWithArity2_named: (binding, must, target, tokens) => `${target} ${must} have 2 parameters`,
      DeclaresComputationWithArity3_named: (binding, must, target, tokens) => `${target} ${must} have 3 parameters`,
      DeclaresComputationWithArity4_named: (binding, must, target, tokens) => `${target} ${must} have 4 parameters`,
      DeclaresComputationWithArity5_named: (binding, must, target, tokens) => `${target} ${must} have 5 parameters`,
      DeclaresEntryPoint: (binding, must, target, tokens) => `${binding} ${must} declare an entry point`,
      DeclaresEnumeration_named: (binding, must, target, tokens) => `${binding} ${must} declare an enumeration ${target}`,
      DeclaresEnumeration: (binding, must, target, tokens) => `${binding} ${must} declare enumerations`,
      DeclaresFact_named: (binding, must, target, tokens) => `${binding} ${must} declare a fact ${target}`,
      DeclaresFact: (binding, must, target, tokens) => `${binding} ${must} declare facts`,
      DeclaresFunction_named: (binding, must, target, tokens) => `${binding} ${must} declare a function ${target}`,
      DeclaresFunction: (binding, must, target, tokens) => `${binding} ${must} declare functions`,
      DeclaresInterface_named: (binding, must, target, tokens) => `${binding} ${must} declare an interface ${target}`,
      DeclaresInterface: (binding, must, target, tokens) => `${binding} ${must} declare interfaces`,
      DeclaresMethod_named: (binding, must, target, tokens) => `${binding} ${must} declare a method ${target}`,
      DeclaresMethod: (binding, must, target, tokens) => `${binding} ${must} declare methods`,
      DeclaresObject_named: (binding, must, target, tokens) => `${binding} ${must} declare an object ${target}`,
      DeclaresObject: (binding, must, target, tokens) => `${binding} ${must} declare objects`,
      DeclaresPredicate_named: (binding, must, target, tokens) => `${binding} ${must} declare a predicate ${target}`,
      DeclaresPredicate: (binding, must, target, tokens) => `${binding} ${must} declare predicates`,
      DeclaresProcedure_named: (binding, must, target, tokens) => `${binding} ${must} declare a procedure ${target}`,
      DeclaresProcedure: (binding, must, target, tokens) => `${binding} ${must} declare procedures`,
      DeclaresRecursively_named: (binding, must, target, tokens) => `${target} ${must} be declared recursively`,
      DeclaresRule_named: (binding, must, target, tokens) => `${binding} ${must} declare a rule ${target}`,
      DeclaresRule: (binding, must, target, tokens) => `${binding} ${must} declare rules`,
      DeclaresTypeAlias_named: (binding, must, target, tokens) => `${binding} ${must} declare a type alias ${target}`,
      DeclaresTypeAlias: (binding, must, target, tokens) => `${binding} ${must} declare type aliases`,
      DeclaresTypeSignature_named: (binding, must, target, tokens) => `${binding} ${must} declare a type signature ${target}`,
      DeclaresTypeSignature: (binding, must, target, tokens) => `${binding} ${must} declare type signatures`,
      DeclaresVariable_named: (binding, must, target, tokens) => `${binding} ${must} declare a variable ${target}`,
      DeclaresVariable: (binding, must, target, tokens) => `${binding} ${must} declare variables`,
      Delegates: (binding, must, target, tokens) => `${binding} ${must} delegate`,
      DiscardsExceptions: (binding, must, target, tokens) => `${binding} is ignoring exceptions silently`,
      DoesConsolePrint: (binding, must, target, tokens) => `${binding} is printing to the console`,
      DoesNilTest: (binding, must, target, tokens) => `${binding} does <code>${tokens['keyword_Nil']}</code> tests`,
      DoesNullTest: (binding, must, target, tokens) => `${binding} does <code>${tokens['keyword_Nil']}</code> tests`,
      DoesTypeTest: (binding, must, target, tokens) => `${binding} string type tests`,
      HasAssignmentCondition: (binding, must, target, tokens) => `${binding} evaluates the result of an assignment where a boolean expression is expected. Perhaps you meant to use the <code>${tokens['operator_Equal']}</code> operator?`,
      HasAssignmentReturn: (binding, must, target, tokens) => `${binding} returns the result of an assignment. Perhaps you meant to use the <code>${tokens['operator_Equal']}</code> operator?`,
      HasCodeDuplication: (binding, must, target, tokens) => `${binding} has code duplication`,
      HasDeclarationTypos_named: (binding, must, target, tokens) => `Solution must declare ${target}, but declares ${binding}. Perhaps you meant ${target}?`,
      HasEmptyIfBranches: (binding, must, target, tokens) => `${binding} has empty <code>${tokens['keyword_If']}</code> branches`,
      HasEmptyRepeat: (binding, must, target, tokens) => `${binding} has empty an <code>${tokens['keyword_Repeat']}</code>`,
      HasEqualIfBranches: (binding, must, target, tokens) => `${binding} has unnecessary <code>${tokens['keyword_If']}</code> whose branches are equal`,
      HasLongParameterList: (binding, must, target, tokens) => `${binding} has too many parameters. You may be missing an abstraction.`,
      HasMisspelledBindings: (binding, must, target, tokens) => `${binding} is misspelled`,
      HasMisspelledIdentifiers: (binding, must, target, tokens) => `${binding} is misspelled`,
      HasRedundantBooleanComparison: (binding, must, target, tokens) => `${binding} makes unnecessary boolean comparisons`,
      HasRedundantGuards: (binding, must, target, tokens) => `${binding} has unnecessary guards`,
      HasRedundantIf: (binding, must, target, tokens) => `${binding} has unnecessary <code>${tokens['keyword_If']}</code>s that can be replaced by a boolean expression`,
      HasRedundantLambda: (binding, must, target, tokens) => `${binding} has unnecessary lambdas`,
      HasRedundantLocalVariableReturn: (binding, must, target, tokens) => `${binding} has unnecessary local variables; please try returning the expression directly`,
      HasRedundantParameter: (binding, must, target, tokens) => `${binding} has unnecessary parameters that can be removed using point-free`,
      HasRedundantReduction: (binding, must, target, tokens) => `${binding} uses <code>${tokens['keyword_Is']}</code>, but it does no arithmetics`,
      HasRedundantRepeat: (binding, must, target, tokens) => `${binding} has an unnecessary <code>${tokens['keyword_Repeat']}</code>`,
      HasTooManyMethods: (binding, must, target, tokens) => `${binding} has too many methods`,
      HasTooShortBindings: (binding, must, target, tokens) => `${binding} is too short an identifier`,
      HasTooShortIdentifiers: (binding, must, target, tokens) => `${binding} is too short an identifier`,
      HasUnreachableCode: (binding, must, target, tokens) => `${binding} has unreachable code`,
      HasUsageTypos_named: (binding, must, target, tokens) => `Solution must use ${target}, but it uses ${binding}. Perhaps you meant ${target}?`,
      HasWrongCaseBindings: (binding, must, target, tokens) => `${binding} does not honor case conventions`,
      HasWrongCaseIdentifiers: (binding, must, target, tokens) => `${binding} does not honor case conventions`,
      Implements_named: (binding, must, target, tokens) => `${binding} ${must} implement ${target}`,
      Implements: (binding, must, target, tokens) => `${binding} ${must} implement intefaces`,
      Includes_named: (binding, must, target, tokens) => `${binding} ${must} include the ${target} mixin`,
      Includes: (binding, must, target, tokens) => `${binding} ${must} include mixins`,
      Instantiates_named: (binding, must, target, tokens) => `${binding} ${must} instantiate ${target}`,
      Instantiates: (binding, must, target, tokens) => `${binding} ${must} instantiate objects`,
      IsLongCode: (binding, must, target, tokens) => `${binding} is too long`,
      OverridesEqualOrHashButNotBoth: (binding, must, target, tokens) => `${binding} overrides <code>equals</code> or <code>hash</code> methods, but not both`,
      Raises_named: (binding, must, target, tokens) => `${binding} ${must} throw ${target}`,
      Raises: (binding, must, target, tokens) => `${binding} ${must} throw exceptions`,
      Returns: (binding, must, target, tokens) => `${binding} ${must} return`,
      ReturnsNil: (binding, must, target, tokens) => `${binding} retuns <code>${tokens['keyword_Nil']}</code>, which is a bad practice`,
      ReturnsNull: (binding, must, target, tokens) => `${binding} retuns <code>${tokens['keyword_Nil']}</code>, which is a bad practice`,
      ShouldInvertIfCondition: (binding, must, target, tokens) => `${binding} should invert <code>${tokens['keyword_If']}</code> condition and swap branches`,
      ShouldUseStrictComparators: (binding, must, target, tokens) => `${binding} should use strict operators <code>${tokens['operator_Equal']}</code> and <code>${tokens['operator_NotEqual']}</code> instead of <code>${tokens['operator_Similar']}</code> and <code>${tokens['operator_NotSimilar']}</code>'`,
      SubordinatesDeclarationsTo: (binding, must, target, tokens) => `All declarations in ${binding} ${must} be used from ${target}`,
      SubordinatesDeclarationsToEntryPoint: (binding, must, target, tokens) => `All declarations in ${binding} ${must} be used from <code>${tokens['keyword_EntryPoint']}</code>`,
      TypesAs_named: (binding, must, target, tokens) => `${binding} ${must} type as ${target}`,
      TypesAs: (binding, must, target, tokens) => `${binding} ${must} type`,
      TypesParameterAs_named: (binding, must, target, tokens) => `${binding} ${must} type parameters with type ${target}`,
      TypesParameterAs: (binding, must, target, tokens) => `${binding} ${must} type parameters`,
      TypesReturnAs_named: (binding, must, target, tokens) => `${binding} ${must} type its return value as ${target}`,
      TypesReturnAs: (binding, must, target, tokens) => `${binding} ${must} type its return value`,
      Uses_named: (binding, must, target, tokens) => `${binding} ${must} use ${target}`,
      Uses: (binding, must, target, tokens) => `${binding} ${must} delegate`,
      UsesAnonymousVariable: (binding, must, target, tokens) => `${binding} ${must} use an anonymous variable`,
      UsesComposition: (binding, must, target, tokens) => `${binding} ${must} use composition`,
      UsesComprehension: (binding, must, target, tokens) => `${binding} ${must} use comprehensions`,
      UsesConditional: (binding, must, target, tokens) => `${binding} ${must} use conditionals`,
      UsesCut: (binding, must, target, tokens) => `${binding} uses <code>!</li> operator, which is a bad practice`,
      UsesDynamicMethodOverload: (binding, must, target, tokens) => `${binding} ${must} use overload`,
      UsesDynamicPolymorphism: (binding, must, target, tokens) => `${binding} ${must} use polymorphism`,
      UsesFail: (binding, must, target, tokens) => `${binding} uses <code>${tokens['keyword_Fail']}</li>, which is a bad practice`,
      UsesFindall: (binding, must, target, tokens) => `${binding} ${must} use <code>${tokens['keyword_Findall']}</code>`,
      UsesForall: (binding, must, target, tokens) => `${binding} ${must} use <code>${tokens['keyword_Forall']}</code>`,
      UsesForeach: (binding, must, target, tokens) => `${binding} ${must} use <code>${tokens['keyword_ForEach']}</code>`,
      UsesForLoop: (binding, must, target, tokens) => `${binding} ${must} use <code>${tokens['keyword_For']}</code>`,
      UsesGuards: (binding, must, target, tokens) => `${binding} ${must} use guards`,
      UsesIf: (binding, must, target, tokens) => `${binding} ${must} use <code>${tokens['keyword_If']}</code>`,
      UsesLambda: (binding, must, target, tokens) => `${binding} ${must} use lambda expressions`,
      UsesLogic: (binding, must, target, tokens) => `${binding} ${must} use boolean expressions`,
      UsesLoop: (binding, must, target, tokens) => `${binding} ${must} use a loop`,
      UsesMath: (binding, must, target, tokens) => `${binding} ${must} use math expressions`,
      UsesMixin: (binding, must, target, tokens) => `${binding} ${must} use mixins`,
      UsesNamedSelfReference: (binding, must, target, tokens) => `${binding} should use <code>${tokens['keyword_Self']}</code> instead of a global reference`,
      UsesNot: (binding, must, target, tokens) => `${binding} ${must} use not`,
      UsesObjectComposition: (binding, must, target, tokens) => `${binding} ${must} use composition`,
      UsesPatternMatching: (binding, must, target, tokens) => `${binding} ${must} use pattern matching`,
      UsesRepeat: (binding, must, target, tokens) => `${binding} ${must} use <code>${tokens['keyword_Repeat']}</code>`,
      UsesRepeatOf: (binding, must, target, tokens) => `${binding} ${must} use <code>${tokens['keyword_Repeat']}</code>`,
      UsesStaticMethodOverload: (binding, must, target, tokens) => `${binding} ${must} use overload`,
      UsesStaticPolymorphism: (binding, must, target, tokens) => `${binding} ${must} use polymorphism`,
      UsesSwitch: (binding, must, target, tokens) => `${binding} ${must} use a <code>${tokens['keyword_Switch']}</code>`,
      UsesTemplateMethod: (binding, must, target, tokens) => `${binding} ${must} use a template method`,
      UsesUnificationOperator: (binding, must, target, tokens) => `${binding} uses the unification operator (=)`,
      UsesWhile: (binding, must, target, tokens) => `${binding} ${must} use <code>${tokens['keyword_While']}</code>`
    },
    pt: {
      must_not: 'não deve',
      must: 'deve',
      solution: 'a solução',
      Assigns_named: (binding, must, target, tokens) => `${binding} ${must} atribuir ${target}`,
      Assigns: (binding, must, target, tokens) => `${binding} ${must} fazer atribuições`,
      Calls_named: (binding, must, target, tokens) => `${binding} ${must} usar ${target}`,
      Calls: (binding, must, target, tokens) => `${binding} ${must} delegate`,
      Declares_named: (binding, must, target, tokens) => `${binding} ${must} declarar ${target}`,
      Declares: (binding, must, target, tokens) => `${binding} ${must} contém declarações`,
      DeclaresAttribute_named: (binding, must, target, tokens) => `${binding} ${must} declarar um atributo ${target}`,
      DeclaresAttribute: (binding, must, target, tokens) => `${binding} ${must} declarar atributos`,
      DeclaresClass_named: (binding, must, target, tokens) => `${binding} ${must} declarar uma classe ${target}`,
      DeclaresClass: (binding, must, target, tokens) => `${binding} ${must} declarar classes`,
      DeclaresComputation_named: (binding, must, target, tokens) => `${binding} ${must} declarar uma computação ${target}`,
      DeclaresComputation: (binding, must, target, tokens) => `${binding} ${must} declarar cálculos`,
      DeclaresComputationWithArity0_named: (binding, must, target, tokens) => `${target} ${must} ter zero parâmetros`,
      DeclaresComputationWithArity1_named: (binding, must, target, tokens) => `${target} ${must} ter um parâmetro`,
      DeclaresComputationWithArity2_named: (binding, must, target, tokens) => `${target} ${must} ter dois parâmetros`,
      DeclaresComputationWithArity3_named: (binding, must, target, tokens) => `${target} ${must} ter três parâmetros`,
      DeclaresComputationWithArity4_named: (binding, must, target, tokens) => `${target} ${must} ter quatro parâmetros`,
      DeclaresComputationWithArity5_named: (binding, must, target, tokens) => `${target} ${must} ter cinco parâmetros`,
      DeclaresEntryPoint: (binding, must, target, tokens) => `${binding} ${must} declarar um ponto de entrada`,
      DeclaresEnumeration_named: (binding, must, target, tokens) => `${binding} ${must} declarar uma enumeração ${target}`,
      DeclaresEnumeration: (binding, must, target, tokens) => `${binding} ${must} declarar enumerações`,
      DeclaresFact_named: (binding, must, target, tokens) => `${binding} ${must} declarar um fato ${target}`,
      DeclaresFact: (binding, must, target, tokens) => `${binding} ${must} declarar fatos`,
      DeclaresFunction_named: (binding, must, target, tokens) => `${binding} ${must} declarar uma função ${target}`,
      DeclaresFunction: (binding, must, target, tokens) => `${binding} ${must} declarar funções`,
      DeclaresInterface_named: (binding, must, target, tokens) => `${binding} ${must} declarar uma interface ${target}`,
      DeclaresInterface: (binding, must, target, tokens) => `${binding} ${must} declarar interfaces`,
      DeclaresMethod_named: (binding, must, target, tokens) => `${binding} ${must} declarar um método ${target}`,
      DeclaresMethod: (binding, must, target, tokens) => `${binding} ${must} declarar métodos`,
      DeclaresObject_named: (binding, must, target, tokens) => `${binding} ${must} declarar um objeto ${target}`,
      DeclaresObject: (binding, must, target, tokens) => `${binding} ${must} declarar objetos`,
      DeclaresPredicate_named: (binding, must, target, tokens) => `${binding} ${must} declarar um predicado ${target}`,
      DeclaresPredicate: (binding, must, target, tokens) => `${binding} ${must} declarar predicados`,
      DeclaresProcedure_named: (binding, must, target, tokens) => `${binding} ${must} declarar um procedimento ${target}`,
      DeclaresProcedure: (binding, must, target, tokens) => `${binding} ${must} declarar procedimentos`,
      DeclaresRecursively_named: (binding, must, target, tokens) => `${target} ${must} ser declarado recursivamente`,
      DeclaresRule_named: (binding, must, target, tokens) => `${binding} ${must} declarar uma regra ${target}`,
      DeclaresRule: (binding, must, target, tokens) => `${binding} ${must} declarar regras`,
      DeclaresSuperclass_named: (binding, must, target, tokens) => `${binding} ${must} declarar uma superclasse ${target}`,
      DeclaresSuperclass: (binding, must, target, tokens) => `${binding} ${must} declarar uma superclasse`,
      DeclaresTypeAlias_named: (binding, must, target, tokens) => `${binding} ${must} declarar um sinônimo do tipo ${target}`,
      DeclaresTypeAlias: (binding, must, target, tokens) => `${binding} ${must} declarar o tipo de sinônimos`,
      DeclaresTypeSignature_named: (binding, must, target, tokens) => `${binding} ${must} declarar uma assinatura ${target}`,
      DeclaresTypeSignature: (binding, must, target, tokens) => `${binding} ${must} excluir assinaturas de tipo`,
      DeclaresVariable_named: (binding, must, target, tokens) => `${binding} ${must} declarar uma variável ${target}`,
      DeclaresVariable: (binding, must, target, tokens) => `${binding} ${must} declarar variáveis`,
      Delegates: (binding, must, target, tokens) => `${binding} ${must} delegar`,
      DiscardsExceptions: (binding, must, target, tokens) => `${binding}  está silenciosamente ignorando exceções`,
      DoesConsolePrint: (binding, must, target, tokens) => `${binding}  está fazendo impressões na tela`,
      DoesNilTest: (binding, must, target, tokens) => `${binding}  faz comparações contra <code>${tokens['keyword_Nil']}</code>`,
      DoesNullTest: (binding, must, target, tokens) => `${binding}  faz comparações contra <code>${tokens['keyword_Nil']}</code>`,
      DoesTypeTest: (binding, must, target, tokens) => `${binding}  faz comparações contra strings`,
      HasAssignmentCondition: (binding, must, target, tokens) => `${binding} avalia o resultado de uma atribuição no qual uma expressão booleana era esperada. Talvez você queira usar o operador <code>${tokens['operator_Equal']}</code>?`,
      HasAssignmentReturn: (binding, must, target, tokens) => `${binding}  retorna o resultado de uma atribuição. Talvez você queira usar o operador <code>${tokens['operator_Equal']}</code>?`,
      HasCodeDuplication: (binding, must, target, tokens) => `${binding}  tem código repetido`,
      HasDeclarationTypos_named: (binding, must, target, tokens) => `A solução deve declarar ${target}, mas declarar ${binding}. Você poderia ter cometido um erro de digitação?`,
      HasEmptyIfBranches: (binding, must, target, tokens) => `${binding} tem vazio <code>${tokens['keyword_If']}</code> ramos`,
      HasEmptyRepeat: (binding, must, target, tokens) => `${binding} tem um <code>${tokens['keyword_Repeat']}</code> vazio`,
      HasEqualIfBranches: (binding, must, target, tokens) => `${binding} possui <code>${tokens['keyword_If']}</code>s desnecessários porque seus dois ramos são iguais`,
      HasLongParameterList: (binding, must, target, tokens) => `${binding} tem muitos parâmetros. Você pode estar perdendo uma abstração.`,
      HasMisspelledBindings: (binding, must, target, tokens) => `${binding}  está incorreto. Verifique a ortografia e tente não usar abreviaturas`,
      HasMisspelledIdentifiers: (binding, must, target, tokens) => `${binding}  está incorreto. Verifique a ortografia e tente não usar abreviaturas`,
      HasRedundantBooleanComparison: (binding, must, target, tokens) => `${binding}  faz comparações booleanas desnecessárias`,
      HasRedundantGuards: (binding, must, target, tokens) => `${binding}  possui protetores desnecessários`,
      HasRedundantIf: (binding, must, target, tokens) => `${binding} possui <code>${tokens['keyword_If']}</code>s desnecessários que podem ser substituídos por expressões booleanas`,
      HasRedundantLambda: (binding, must, target, tokens) => `${binding}  possui lambdas desnecessários`,
      HasRedundantLocalVariableReturn: (binding, must, target, tokens) => `${binding}  usa variáveis ​​locais desnecessárias; você pode retornar a expressão diretamente`,
      HasRedundantParameter: (binding, must, target, tokens) => `${binding}  possui parâmetros desnecessários (pode ser removido por ponto-livre)`,
      HasRedundantReduction: (binding, must, target, tokens) => `${binding}  usa <code>${tokens['keyword_Is']}</code>, mas não executa cálculos`,
      HasRedundantRepeat: (binding, must, target, tokens) => `${binding} tem <code>${tokens['keyword_Repeat']}</code> desnecessário`,
      HasTooManyMethods: (binding, must, target, tokens) => `${binding} tem muitos métodos`,
      HasTooShortBindings: (binding, must, target, tokens) => `${binding}  é um identificador muito curto`,
      HasTooShortIdentifiers: (binding, must, target, tokens) => `${binding} é um identificador muito curto`,
      HasUnreachableCode: (binding, must, target, tokens) => `${binding} tem código inacessível`,
      HasUsageTypos_named: (binding, must, target, tokens) => `A solução deve usar ${target}, mas use ${binding}. Você poderia ter cometido um erro de digitação?`,
      HasWrongCaseBindings: (binding, must, target, tokens) => `${binding}  não respeita a convenção de nomenclatura`,
      HasWrongCaseIdentifiers: (binding, must, target, tokens) => `${binding}  não respeita a convenção de nomenclatura`,
      Implements_named: (binding, must, target, tokens) => `${binding} ${must} implementar ${target}`,
      Implements: (binding, must, target, tokens) => `${binding} ${must} implementar interfaces`,
      Inherits_named: (binding, must, target, tokens) => `${binding} ${must} declarar uma superclasse ${target}`,
      Inherits: (binding, must, target, tokens) => `${binding} ${must} declarar uma superclasse`,
      Instantiates_named: (binding, must, target, tokens) => `${binding} ${must} instantiate ${target}`,
      Instantiates: (binding, must, target, tokens) => `${binding} ${must} instanciar objetos`,
      IsLongCode: (binding, must, target, tokens) => `${binding}  é muito longo. Tente delegar mais`,
      OverridesEqualOrHashButNotBoth: (binding, must, target, tokens) => `${binding} redefine os métodos <code>equals</code> ou <code>hash </code>, mas não ambos`,
      Raises_named: (binding, must, target, tokens) => `${binding} ${must} launch ${target}`,
      Raises: (binding, must, target, tokens) => `${binding} ${must} lançar exceções`,
      Rescues_named: (binding, must, target, tokens) => `${binding} ${must} capture ${target}`,
      Rescues: (binding, must, target, tokens) => `${binding} ${must} capturar exceções`,
      Returns: (binding, must, target, tokens) => `${binding} ${must} retornar`,
      ReturnsNil: (binding, must, target, tokens) => `${binding}  retorna nulo, o que é uma prática ruim`,
      ReturnsNull: (binding, must, target, tokens) => `${binding}  retorna nulo, o que é uma prática ruim`,
      ShouldInvertIfCondition: (binding, must, target, tokens) => `${binding} deve inverter a condição da <code>${tokens['keyword_If']}</code> e trocar as ramos`,
      ShouldUseStrictComparators: (binding, must, target, tokens) => `${binding} deve usar os operadores de equivalência <code>${tokens['operator_Equal']}</code> e <code>${tokens['operator_NotEqual']}</code> em vez dos operadores de similaridade <code>${tokens['operator_Similar']}</code> e <code>${tokens['operator_NotSimilar']}</code>`,
      SubordinatesDeclarationsTo: (binding, must, target, tokens) => `Todas as declarações em ${binding} ${must} ser usadas a partir de ${target}`,
      SubordinatesDeclarationsToEntryPoint: (binding, must, target, tokens) => `Todas as declarações em ${binding} ${must} devem ser usadas a partir de <code>${tokens['keyword_EntryPoint']}</code>`,
      TypesAs_named: (binding, must, target, tokens) => `${binding} ${must} é do tipo ${target}`,
      TypesAs: (binding, must, target, tokens) => `${binding} ${must} ter tipo`,
      TypesReturnAs_named: (binding, must, target, tokens) => `${binding} ${must} ter tipo de valor de retorno ${target}`,
      TypesReturnAs: (binding, must, target, tokens) => `${binding} ${must} ter tipo de valor de retorno`,
      Uses_named: (binding, must, target, tokens) => `${binding} ${must} usar ${target}`,
      Uses: (binding, must, target, tokens) => `${binding} ${must} delegar`,
      UsesAnonymousVariable: (binding, must, target, tokens) => `${binding} ${must} usar uma variável anônima`,
      UsesComposition: (binding, must, target, tokens) => `${binding} ${must} usar a composição`,
      UsesComprehension: (binding, must, target, tokens) => `${binding} ${must} usar listas pelo entendimento`,
      UsesConditional: (binding, must, target, tokens) => `${binding} ${must} usar conditional`,
      UsesCut: (binding, must, target, tokens) => `${binding}  usa o operador !, que é uma má prática`,
      UsesDynamicMethodOverload: (binding, must, target, tokens) => `${binding} ${must} usar sobrecarga`,
      UsesDynamicPolymorphism: (binding, must, target, tokens) => `${binding} ${must} usar polimorfismo`,
      UsesExceptionHandling: (binding, must, target, tokens) => `${binding} ${must} executar o tratamento de exceção`,
      UsesExceptions: (binding, must, target, tokens) => `${binding} ${must} usar exceções`,
      UsesFail: (binding, must, target, tokens) => `${binding}  usa <code>${tokens['keyword_Fail']}</li>, o que é uma prática ruim`,
      UsesFindall: (binding, must, target, tokens) => `${binding} ${must} usar <code>${tokens['keyword_Findall']}</code>`,
      UsesFor: (binding, must, target, tokens) => `${binding} ${must} usar <code>${tokens['keyword_For']}</code>`,
      UsesForall: (binding, must, target, tokens) => `${binding} ${must} usar <code>${tokens['keyword_Forall']}</code>`,
      UsesForeach: (binding, must, target, tokens) => `${binding} ${must} usar <code>${tokens['keyword_ForEach']}</code>`,
      UsesGuards: (binding, must, target, tokens) => `${binding} ${must} usar guardas`,
      UsesIf: (binding, must, target, tokens) => `${binding} ${must} usar <code>${tokens['keyword_If']}</code>`,
      UsesInheritance: (binding, must, target, tokens) => `${binding} ${must} usar herança`,
      UsesLambda: (binding, must, target, tokens) => `${binding} ${must} usar expressões lambda`,
      UsesLogic: (binding, must, target, tokens) => `${binding} ${must} usar expressões booleanas`,
      UsesLoop: (binding, must, target, tokens) => `${binding} ${must} usar um loop`,
      UsesMath: (binding, must, target, tokens) => `${binding} ${must} usar expressões matemáticas`,
      UsesMixins: (binding, must, target, tokens) => `${binding} ${must} usar mixins`,
      UsesNamedSelfReference: (binding, must, target, tokens) => `${binding} deve usar <code>${tokens['keyword_Self']}</code> em vez de uma referência global`,
      UsesNot: (binding, must, target, tokens) => `${binding} ${must} usar <code>${tokens['keyword_Not']}</code>`,
      UsesObjectComposition: (binding, must, target, tokens) => `${binding} ${must} usar composição`,
      UsesPatternMatching: (binding, must, target, tokens) => `${binding} ${must} usar o padrão de correspondência`,
      UsesRepeat: (binding, must, target, tokens) => `${binding} ${must} usar <code>${tokens['keyword_Repeat']}</code>`,
      UsesRepeatOf: (binding, must, target, tokens) => `${binding} ${must} usar uma <code>${tokens['keyword_Repeat']}</code> de ${target}`,
      UsesStaticMethodOverload: (binding, must, target, tokens) => `${binding} ${must} usar sobrecarga`,
      UsesStaticPolymorphism: (binding, must, target, tokens) => `${binding} ${must} usar polimorfismo`,
      UsesSwitch: (binding, must, target, tokens) => `${binding} ${must} usar um <code>${tokens['keyword_Switch']}</code>`,
      UsesTemplateMethod: (binding, must, target, tokens) => `${binding} ${must} usar um _template method_`,
      UsesUnificationOperator: (binding, must, target, tokens) => `${binding}  usa o operador de unificação (=)`,
      UsesWhile: (binding, must, target, tokens) => `${binding} ${must} usar um <code>${tokens['keyword_While']}</code>`,
    }
  };

  const I18n = new class {
    constructor() {
      this.locale = 'en';
    }

    get _translations() {
      return LOCALES[this.locale];
    }

    translate(binding, inspection, tokens) {
      const match = inspection.match(/^(Not:)?([^:]+)(:([^:]+))?$/);

      if (!match) throw `unsupported inspection ${inspection}`;

      let key;
      let targetHtml;

      if (match[3] && match[4] !== '*') {
        key = `${match[2]}_named`;
        targetHtml = `<code>${match[4]}</code>`
      } else {
        key = match[2];
        targetHtml = null;
      }

      if (!this._translations[key]) throw `unsupported inspection ${inspection} - ${match[1]} - ${match[2]}`;
      return this._translations[key](this._translateBinding(binding), this._translateMust(match), targetHtml, this._translationTokens(tokens));
    }

    _translationTokens(tokens) {
      let givenTokens;
      if (!tokens) {
        givenTokens = {};
      } else if (typeof(tokens) == 'object') {
        givenTokens = tokens;
      } else {
        givenTokens = ghcjsExports.Tokens.TOKENS[tokens];
      }

      let actualTokens = {};
      Object.assign(actualTokens, ghcjsExports.Tokens.DEFAULT_TOKENS);
      Object.assign(actualTokens, givenTokens);
      return actualTokens;
    }

    _translateBinding(binding) {
      return binding === '*' ? this._translations.solution : `<code>${binding.replace('Intransitive:', '')}</code>`;
    }

    _translateMust(match) {
      return match[1] ? this._translations.must_not : this._translations.must;
    }
  }

  I18n.LOCALES = LOCALES;

  ghcjsExports.I18n = I18n;
})();
