---
title: Overview
---

# MUI X - Overview

<p class="description">MUI X is a collection of advanced React UI components for complex use cases. Use the native integration with Material UI or extend your design system.</p>

## Introduction

MUI X is a collection of advanced UI components, including:

- [Data Grid](/x/react-data-grid/)
- [Date and Time Pickers](/x/react-date-pickers/)
- [Charts](/x/react-charts/)
- [Tree View](/x/react-tree-view/)

These components are significantly more complex than the ones found in the MUI Core libraries.
They feature advanced functionality for data-rich applications and a wide range of other use cases.

:::info
MUI X is **open core**—base components are MIT-licensed, while more advanced features require a Pro or Premium commercial license.
See [Licensing](/x/introduction/licensing/) for details.

Throughout the documentation, Pro- and Premium-only features are denoted with the [<span class="plan-pro"></span>](/x/introduction/licensing/#pro-plan 'Pro plan') and [<span class="plan-premium"></span>](/x/introduction/licensing/#premium-plan 'Premium plan') icons, respectively.
:::

## Advantages of MUI X

- **Ship faster:** Our team has invested thousands of hours into these components so you don't have to. Get up and running in a fraction of the time it would take to build from scratch.
- **Expand on the power of MUI Core**: MUI X components work seamlessly with MUI Core libraries like Material UI, delivering more advanced functionality, but can also be used standalone.
- **Grow with us:** You can start for free with the MIT-licensed packages, and upgrade to Pro or Premium when you need more advanced features or technical support.
- **Dedicated maintenance:** MUI X is maintained by a full-time staff of engineers, so you can rest assured that any issues will be addressed in a timely manner.
- **Technical support:** Pro and Premium users get access to technical support from our team as well as priority for bug fixes and feature requests.

## MUI X vs. MUI Core

MUI X is a collection of advanced UI components for complex use cases.
Most of MUI X's components are available for free, but more advanced features require a Pro or Premium commercial license.

MUI Core focuses on empowering the creation of great design systems with React.
It comes with two themes (Material Design and an in-house one).
It's about solving design problems.
It contains foundational UI component libraries like Material UI and Base UI.
These libraries are open source, MIT-licensed, and free forever.

MUI X components are fully compatible with MUI Core.
MUI X can extend the functionality of UIs built with Material UI or Base UI, but its components can also stand on their own, they can be used with third-parties React component libraries that implement different designs.

You can find [more details](https://mui-org.notion.site/MUI-s-products-a-brief-overview-9c5e8e11eb1247c3a124b446be7451cb) about the difference in our handbook.
