import { randomId } from '@mui/x-data-grid-generator';

export const INITIAL_ROWS = [
  {
    id: randomId(),
    type: 'zip',
    name: 'archive.zip',
    description: 'Compressed archive of project files',
    size: 128_313_213,
    createdBy: 'Kenan Yusuf',
    createdAt: new Date('2023-09-15T08:30:00').toISOString(),
    updatedAt: new Date('2023-09-15T08:30:00').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'docx',
    name: 'invoice-322.docx',
    description: 'Invoice document for client 322',
    size: 1_694_986,
    createdBy: 'José Freitas',
    createdAt: new Date('2024-01-18T11:30:00').toISOString(),
    updatedAt: new Date().toISOString(), // Today
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'png',
    name: 'screenshot_2024-02-14_12-34-56.png',
    description: 'Screenshot of application interface',
    size: 522_078,
    createdBy: 'José Freitas',
    createdAt: new Date('2024-02-14T12:35:16').toISOString(),
    updatedAt: new Date(Date.now() - 5 * 24 * 60 * 60 * 1000).toISOString(), // Last week
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'mp4',
    name: 'strategy-meeting.mp4',
    description: 'Recording of the strategy planning meeting',
    size: 2_442_044,
    createdBy: 'José Freitas',
    createdAt: new Date('2023-12-05T15:40:30').toISOString(),
    updatedAt: new Date(Date.now() - 20 * 24 * 60 * 60 * 1000).toISOString(), // Last month
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'docx',
    name: 'project-proposal.docx',
    description: 'Detailed project proposal document',
    size: 3_567_890,
    createdBy: 'Olivier Tassinari',
    createdAt: new Date('2024-03-01T09:15:00').toISOString(),
    updatedAt: new Date('2024-03-02T14:30:45').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'png',
    name: 'logo-design-final.png',
    description: 'Final version of the company logo design',
    size: 1_234_567,
    createdBy: 'Kenan Yusuf',
    createdAt: new Date('2024-02-28T16:20:00').toISOString(),
    updatedAt: new Date('2024-02-28T16:20:00').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'mp4',
    name: 'product-demo.mp4',
    description: 'Video demonstration of the new product features',
    size: 15_789_012,
    createdBy: 'Olivier Tassinari',
    createdAt: new Date('2024-02-25T11:45:00').toISOString(),
    updatedAt: new Date(Date.now() - 60 * 24 * 60 * 60 * 1000).toISOString(), // Last 3 months
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'zip',
    name: 'project-assets.zip',
    description: 'Compressed folder containing all project assets',
    size: 87_654_321,
    createdBy: 'José Freitas',
    createdAt: new Date('2024-03-03T13:00:00').toISOString(),
    updatedAt: new Date('2024-03-03T13:00:00').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'docx',
    name: 'meeting-minutes-2024-03-10.docx',
    description: 'Minutes from the team meeting on March 10, 2024',
    size: 567_890,
    createdBy: 'Kenan Yusuf',
    createdAt: new Date('2024-03-10T14:00:00').toISOString(),
    updatedAt: new Date('2024-03-10T16:30:00').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'png',
    name: 'ui-mockup-v2.png',
    description: 'Updated user interface mockup',
    size: 3_456_789,
    createdBy: 'Olivier Tassinari',
    createdAt: new Date('2024-03-05T10:20:00').toISOString(),
    updatedAt: new Date('2024-03-05T10:20:00').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'mp4',
    name: 'user-feedback-session.mp4',
    description: 'Recording of user feedback session',
    size: 234_567_890,
    createdBy: 'José Freitas',
    createdAt: new Date('2024-03-08T13:45:00').toISOString(),
    updatedAt: new Date('2024-03-08T15:30:00').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'zip',
    name: 'legacy-codebase.zip',
    description: 'Archive of the legacy project codebase',
    size: 567_890_123,
    createdBy: 'Kenan Yusuf',
    createdAt: new Date('2024-02-20T09:00:00').toISOString(),
    updatedAt: new Date('2024-02-20T09:00:00').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'docx',
    name: 'q1-2024-report.docx',
    description: 'Quarterly report for Q1 2024',
    size: 4_567_890,
    createdBy: 'Olivier Tassinari',
    createdAt: new Date('2024-03-31T23:59:59').toISOString(),
    updatedAt: new Date('2024-04-01T10:15:00').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'png',
    name: 'data-visualization.png',
    description: 'Chart showing project progress',
    size: 789_012,
    createdBy: 'José Freitas',
    createdAt: new Date('2024-03-15T11:30:00').toISOString(),
    updatedAt: new Date('2024-03-15T11:30:00').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'mp4',
    name: 'code-review-session.mp4',
    description: 'Recording of code review meeting',
    size: 345_678_901,
    createdBy: 'Kenan Yusuf',
    createdAt: new Date('2024-03-20T14:00:00').toISOString(),
    updatedAt: new Date('2024-03-20T16:45:00').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'zip',
    name: 'design-assets-v3.zip',
    description: 'Compressed folder of updated design assets',
    size: 98_765_432,
    createdBy: 'Olivier Tassinari',
    createdAt: new Date('2024-03-25T09:30:00').toISOString(),
    updatedAt: new Date('2024-03-25T09:30:00').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'docx',
    name: 'api-documentation.docx',
    description: 'Comprehensive API documentation',
    size: 2_345_678,
    createdBy: 'José Freitas',
    createdAt: new Date('2024-03-28T16:20:00').toISOString(),
    updatedAt: new Date('2024-03-29T11:45:00').toISOString(),
    state: 'uploaded',
  },
  {
    id: randomId(),
    type: 'png',
    name: 'error-screenshot.png',
    description: 'Screenshot of error message for debugging',
    size: 345_678,
    createdBy: 'Kenan Yusuf',
    createdAt: new Date('2024-03-30T08:15:00').toISOString(),
    updatedAt: new Date('2024-03-30T08:15:00').toISOString(),
    state: 'uploaded',
  },
];
