import * as React from 'react';
import { useDemoData } from '@mui/x-data-grid-generator';
import Button, { ButtonProps } from '@mui/material/Button';
import { createSvgIcon } from '@mui/material/utils';
import {
  DataGridPremium,
  GridCsvExportOptions,
  GridCsvGetRowsToExportParams,
  gridRowTreeSelector,
  GridToolbarContainer,
  gridFilteredSortedRowIdsSelector,
  useGridApiContext,
} from '@mui/x-data-grid-premium';

const getRowsWithGroups = ({ apiRef }: GridCsvGetRowsToExportParams) =>
  gridFilteredSortedRowIdsSelector(apiRef);

const getRowsWithoutGroups = ({ apiRef }: GridCsvGetRowsToExportParams) => {
  const rows = gridFilteredSortedRowIdsSelector(apiRef);
  const tree = gridRowTreeSelector(apiRef);

  return rows.filter((rowId) => tree[rowId].type !== 'group');
};

const ExportIcon = createSvgIcon(
  <path d="M19 12v7H5v-7H3v7c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-7h-2zm-6 .67l2.59-2.58L17 11.5l-5 5-5-5 1.41-1.41L11 12.67V3h2z" />,
  'SaveAlt',
);

function CustomToolbar() {
  const apiRef = useGridApiContext();

  const handleExport = (options: GridCsvExportOptions) =>
    apiRef.current.exportDataAsCsv(options);

  const buttonBaseProps: ButtonProps = {
    color: 'primary',
    size: 'small',
    startIcon: <ExportIcon />,
  };

  return (
    <GridToolbarContainer>
      <Button
        {...buttonBaseProps}
        onClick={() => handleExport({ getRowsToExport: getRowsWithGroups })}
      >
        Rows with groups
      </Button>
      <Button
        {...buttonBaseProps}
        onClick={() => handleExport({ getRowsToExport: getRowsWithoutGroups })}
      >
        Rows without groups
      </Button>
    </GridToolbarContainer>
  );
}

export default function CsvGetRowsToExportRowGrouping() {
  const { data, loading } = useDemoData({
    dataSet: 'Commodity',
    rowLength: 100,
    maxColumns: 6,
  });

  return (
    <div style={{ height: 300, width: '100%' }}>
      <DataGridPremium
        {...data}
        loading={loading}
        slots={{ toolbar: CustomToolbar }}
        initialState={{
          ...data.initialState,
          rowGrouping: {
            ...data.initialState?.rowGrouping,
            model: ['commodity'],
          },
        }}
      />
    </div>
  );
}
