---
title: React Charts
productId: x-charts
githubLabel: 'component: charts'
packageName: '@mui/x-charts'
---

# MUI X Charts

<p class="description">A collection of React chart components for data visualization.</p>

{{"component": "@mui/docs/ComponentLinkHeader", "design": false}}

## Overview

MUI X Charts is a library of production-ready components for rendering charts with React.
It uses [D3.js](https://d3js.org/) for data manipulation and SVGs for rendering.

The components provide a high level of customization, with beautiful defaults as well as extensive configuration props and flexible composition options.
They also have access to all [MUI System](https://mui.com/system/getting-started/) tools such as theme overrides and the `sx` prop.

{{"demo": "ChartsOverviewDemo.js", "defaultCodeOpen": true}}

## All MUI X Charts

{{"component": "modules/components/ChartComponentsGrid.js"}}

## Using this documentation

Each Chart type has two accompanying documents:

1. **Overview** – a general description of built-in features
2. **Demo** – a collection of custom examples

## Supported features

Features shared across Chart components such as axes and legends are described in standalone documents:

{{"component": "modules/components/ChartFeaturesGrid.js"}}
