---
title: Charts - Legend
productId: x-charts
components: ChartsLegend, DefaultChartsLegend, ChartsText, ContinuousColorLegend, PiecewiseColorLegend
---

# Charts - Legend

<p class="description">Legend is the UI element mapping symbols and colors to the series' label.</p>

## Basic display

In chart components, the legend links series with `label` properties and their color.

{{"demo": "BasicLegend.js"}}

## Customization

### Position

The legend can either be displayed in a `'column'` or `'row'` layout controlled with the `direction` property.

It can also be moved with the `position: { vertical, horizontal }` property which defines how the legend aligns within the SVG.

- `vertical` can be `'top'`, `'middle'`, or `'bottom'`.
- `horizontal` can be `'left'`, `'middle'`, or `'right'`.

You can add spacing to a given `position` with the `padding` property, which can be either a number or an object `{ top, bottom, left, right }`.
This `padding` will add space between the SVG borders and the legend.

By default, the legend is placed above the charts.

{{"demo": "LegendPositionNoSnap.js", "hideToolbar": true, "bg": "playground"}}

### Hiding

You can hide the legend with the property `slotProps.legend.hidden`.

{{"demo": "HiddenLegend.js"}}

### Dimensions

Inside the legend, you can customize the pixel value of the width and height of the mark with the `itemMarkWidth` and `itemMarkHeight` props.

You can also access the `markGap` prop to change the gap between the mark and its label, or the `itemGap` to change the gap between two legend items.
Both props impact the values defined in pixels.

{{"demo": "LegendDimensionNoSnap.js", "hideToolbar": true, "bg": "playground"}}

### Label styling

To break lines in legend labels, use the special `\n` character. To customize the label style, you should not use CSS.
Instead, pass a styling object to the `labelStyle` property.

{{"demo": "LegendTextStylingNoSnap.js", "hideToolbar": true, "bg": "playground"}}

:::info
The `labelStyle` property is needed to measure text size, and then place legend items at the correct position.
Style applied by other means will not be taken into account.
Which can lead to label overflow.
:::

### Rounded symbol

To create a rounded symbol, use the `legendClasses.mark` to apply CSS on marks.
Notice that SVG `rect` uses `ry` property to control the symbol's corner radius instead of `border-radius`.

{{"demo": "LegendRoundedSymbol.js"}}

## Color legend

To display legend associated to a [colorMap](https://mui.com/x/react-charts/styling/#values-color), you can use:

- `<ContinuousColorLegend />` if you're using `colorMap.type='continuous'`
- `<PiecewiseColorLegend />` if you're using `colorMap.type='piecewise'`.

### Select data

To select the color mapping to represent, use the following props:

- `axisDirection` can be `'x'`, `'y'`, or `'z'`. It indicates which axis contain the `colorMap` definition.
- `axisId` The id of the axis to use in case the selected direction contains multiple ones.

{{"demo": "BasicColorLegend.js"}}

### Position

This component position is done exactly the same way as the [legend for series](#position).

### Continuous color mapping

To modify the shape of the gradient, use the `length` and `thickness` props.
The `length` can either be a number (in px) or a percentage string. The `"100%"` corresponds to the SVG dimension.

To format labels use the `minLabel`/`maxLabel`.
They accept either a string to display.
Or a function `({value, formattedValue}) => string`.

The labels and gradient bar alignment can be modified by the `align` prop.

{{"demo": "ContinuousInteractiveDemoNoSnap.js", "hideToolbar": true, "bg": "playground"}}

### Piecewise color mapping

The piecewise Legend is quite similar to the series legend.
It accepts the same props for [customization](#dimensions).

The props `hideFirst` and `hideLast` allows to hide the two extreme pieces: values lower than the min threshold, and value higher than the max threshold.

To override labels generated by default, provide a `labelFormatter` prop.
It takes the min/max of the piece and returns the label.

Values can be `null` for the first and last pieces.
And returning `null` removes the piece from the legend.

```ts
labelFormatter = ({ min, max, formattedMin, formattedMax }) => string | null;
```

{{"demo": "PiecewiseInteractiveDemoNoSnap.js", "hideToolbar": true, "bg": "playground"}}

## Click event

You can pass an `onItemClick` function to the `ChartsLegend` or `PiecewiseColorLegend` components to handle click events.
They both provide the following signature.

```js
const clickHandler = (
  event, // The click event.
  context, // An object that identifies the clicked item.
  index, // The index of the clicked item.
) => {};
```

The `context` object contains different properties depending on the legend type.
Click the legend items to see their content.

{{"demo": "LegendClickNoSnap.js"}}
