<!-- markdownlint-disable-next-line -->
<p align="center">
  <a href="https://mui.com/x/" rel="noopener" target="_blank"><img width="150" height="133" src="https://mui.com/static/logo.svg" alt="MUI X logo"></a>
</p>

<h1 align="center">MUI X</h1>

<div align="center">

[![License](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/mui/mui-x/blob/HEAD/LICENSE)
[![npm latest package](https://img.shields.io/npm/v/@mui/x-data-grid/latest.svg)](https://www.npmjs.com/package/@mui/x-data-grid)
[![npm downloads](https://img.shields.io/npm/dm/@mui/x-data-grid.svg)](https://www.npmjs.com/package/@mui/x-data-grid)
[![GitHub branch status](https://img.shields.io/github/checks-status/mui/mui-x/HEAD)](https://github.com/mui/mui-x/commits/HEAD/)
[![Coverage status](https://img.shields.io/codecov/c/github/mui/mui-x.svg)](https://codecov.io/gh/mui/mui-x/)
[![Follow on X](https://img.shields.io/twitter/follow/MUI_X_.svg?label=follow+MUI+X)](https://x.com/MUI_X_)
[![Renovate status](https://img.shields.io/badge/renovate-enabled-brightgreen.svg)](https://github.com/mui/mui-x/issues/2081)
[![Average time to resolve an issue](https://isitmaintained.com/badge/resolution/mui/mui-x.svg)](https://isitmaintained.com/project/mui/mui-x 'Average time to resolve an issue')
[![Open Collective backers and sponsors](https://img.shields.io/opencollective/all/mui-org)](https://opencollective.com/mui-org)
[![OpenSSF Best Practices](https://www.bestpractices.dev/projects/6293/badge)](https://www.bestpractices.dev/projects/6293)

</div>

[MUI X](https://mui.com/x/) is a suite of advanced React UI components for a wide range of complex use cases.
Each component provides best-in-class UX and DX, with sophisticated UX workflows for data-rich applications.
Components include the Data Grid, Date and Time Pickers, Charts, and Tree View.

MUI X extends the core functionality of [Material UI](https://github.com/mui/material-ui/), but the advanced components also stand on their own and can be fully customized to meet the needs of any design system.

MUI X is **open-core**: [Community](#community-plan) components are MIT-licensed and free forever, while more advanced features and components require a [Pro](#pro-plan) or [Premium](#premium-plan) commercial license.
See [Licensing](#licensing) for more information.

## Documentation

Get started in the [MUI X documentation](https://mui.com/x/introduction/).

- [Data Grid](https://mui.com/x/react-data-grid/)
- [Date and Time Pickers](https://mui.com/x/react-date-pickers/)
- [Charts](https://mui.com/x/react-charts/)
- [Tree View](https://mui.com/x/react-tree-view/)

### Installation

- [Data Grid installation](https://mui.com/x/react-data-grid/getting-started/#installation)
- [Date and Time Pickers installation](https://mui.com/x/react-date-pickers/getting-started/#installation)
- [Charts installation](https://mui.com/x/react-charts/getting-started/#installation)
- [Tree View installation](https://mui.com/x/react-tree-view/getting-started/#installation)

## Licensing

The MUI X team has been building MIT-licensed React components since 2014, starting with Material UI, and we're committed to the continued advancement of our open-source libraries.
Anything we release under an MIT license will remain MIT-licensed forever.
Learn more about [our stewardship ethos](https://mui-org.notion.site/Stewardship-542a2226043d4f4a96dfb429d16cf5bd).

We offer commercial licenses to developers who need the most advanced components and features that can't reasonably be maintained by the open-source community alone.
These licenses make it possible for us to support a full-time staff of engineers.

Rest assured that when we release features commercially, it's only because we believe you won't find a better MIT-licensed alternative anywhere else.

See the [Licensing page](https://mui.com/x/introduction/licensing/) for complete details.

### Plans

#### Community plan

The free Community version of MUI X contains components and features that we believe are maintainable by contributions from the open-source community.
It's published under an [MIT license](https://www.tldrlegal.com/license/mit-license) and it's [free forever](https://mui-org.notion.site/Stewardship-542a2226043d4f4a96dfb429d16cf5bd#20f609acab4441cf9346614119fbbac1).

- [`@mui/x-data-grid`](https://www.npmjs.com/package/@mui/x-data-grid)
- [`@mui/x-date-pickers`](https://www.npmjs.com/package/@mui/x-date-pickers)
- [`@mui/x-charts`](https://www.npmjs.com/package/@mui/x-charts)
- [`@mui/x-tree-view`](https://www.npmjs.com/package/@mui/x-tree-view)

#### Pro plan

MUI X Pro expands on the Community version with more advanced features and functionality.
The Data Grid Pro comes with multi-filtering, multi-sorting, column resizing, and column pinning; you also gain access to the Date and Time Range Picker components, advanced Charts, and drag-and-drop reordering for the Tree View.

The Pro version is available under a commercial license—visit the [Pricing page](https://mui.com/pricing/) for details.

- [`@mui/x-data-grid-pro`](https://www.npmjs.com/package/@mui/x-data-grid-pro)
- [`@mui/x-date-pickers-pro`](https://www.npmjs.com/package/@mui/x-date-pickers-pro)
- [`@mui/x-charts-pro`](https://www.npmjs.com/package/@mui/x-charts-pro)
- [`@mui/x-tree-view-pro`](https://www.npmjs.com/package/@mui/x-tree-view-pro)

#### Premium plan

MUI X Premium unlocks the most advanced features of the Data Grid, including row grouping and Excel exporting, as well as everything offered in the Pro plan.

The Premium version is available under a commercial license—visit the [Pricing page](https://mui.com/pricing/) for details.

- [`@mui/x-data-grid-premium`](https://www.npmjs.com/package/@mui/x-data-grid-premium)

## Support

From community guidance to critical business support, we're here to help.
Read the [Support guide](https://mui.com/x/introduction/support/) for details.

## Contributing

Read the [Contributing guide](/CONTRIBUTING.md) to learn about our development process, how to propose bug fixes and improvements, and how to build and test your changes.

Contributing to MUI X is about more than just issues and pull requests!
There are many other ways to [support MUI X](https://mui.com/material-ui/getting-started/faq/#mui-is-an-awesome-organization-how-can-i-support-it) beyond contributing to the code base.

## Changelog

The [changelog](https://github.com/mui/mui-x/releases) is regularly updated to reflect what's changed in each new release.

## Roadmap

Future plans and high-priority features and enhancements can be found in the [roadmap](https://mui.com/x/introduction/roadmap/).

## Security

For details on supported versions and contact information for reporting security issues, please refer to the [security policy](https://github.com/mui/mui-x/security/policy).
