# CampusClubs - Student Club Management Software

CampusClubs is a web-based application designed to help university clubs and organizations streamline their management activities. It provides an integrated platform for event creation, member management, and announcement sharing, enhancing the student experience.

## Table of Contents

1. [Introduction](#introduction)
2. [Projects within the Repository](#projects-within-the-repository)
3. [Technologies](#technologies)
4. [Setup](#setup)
5. [Usage](#usage)
6. [Contributors](#contributors)

## Introduction

CampusClubs aims to simplify club management activities for university clubs and organizations. With our user-friendly interface and efficient tools, clubs can easily manage their events, members, and announcements, staying connected with their campus community.

## Projects within the Repository

This repository contains two main projects:

1. **Client** - A Next.js application that is used as a Static Deploy to the University Server.
2. **Server** - A .NET Core application that is built using the .NET Core CLI.

## Technologies

The system was developed using a range of technologies:

1. **Client** - Built with Next.js, the client side of our software is designed to be user-friendly and efficient.
2. **Server** - The server side is built with .NET Core, providing robust and reliable backend support.

## Setup

To set up the project locally, follow these steps:

1. Clone the repository
2. Set up the Next.js environment for the client
3. Set up the .NET Core environment for the server

## Usage

- User Registration and Login: Users need to register on the application using their university credentials. Once registered, they can log in to access the various features of the application.
- Join a Club: Users can browse through the various clubs and organizations listed on the application and choose to join any club of their interest.
- Manage Club Activities: Club managers can use the application to manage their club members, create events, and share announcements. All these updates are immediately reflected on the application and are visible to the respective club members.

- Participate in Events: Users can view the events created by the clubs they are part of and choose to participate in them.

## Contributors

This project was managed and developed by [Muhammed Oguz](https://github.com/muhammedogz) and [Süleyman Gölbol](https://github.com/sglbl) as a part of our graduation project. It will used by the students of Gebze Technical University.
