# Contributing to logly

Welcome to logly! We appreciate your interest and contributions.

## How to Contribute

We welcome contributions in the form of bug reports, feature requests, code contributions, documentation improvements, or any other ways you'd like to help.

To contribute, follow these steps:

1. Fork the repository to your GitHub account.
2. Clone the forked repository to your local machine.
```bash
   git clone https://github.com/your-username/logly.git
   cd logly
```
3. Create a new branch for your contribution.
```bash
   git checkout -b my-contribution
```
4. Make your changes and commit them.
```bash
   git add .
   git commit -m "my contribution"
```
5. Push your changes to your forked repository.
```bash
   git push origin my-contribution
```
6. Open a pull request in this repository. Include a detailed description of your changes and any relevant information.
7. Wait for your pull request to be reviewed and merged.
8. Celebrate your contribution!
9. Don't forget to update your forked repository if the original repository has been updated since your contribution was merged.
```bash
   git remote add upstream
    git fetch upstream
    git checkout main
    git merge upstream/main
    git push origin main
```

## Code Style and Guidelines
make sure your code is formatted according to the [PEP 8](https://www.python.org/dev/peps/pep-0008/) style guide. 

## Reporting Issues
If you encounter any issues or have suggestions for improvement, please open an issue on the GitHub repository. Include a detailed description of the problem or enhancement you're suggesting.

##  Code of Conduct
Please note that by participating in this project, you agree to abide by our [Code of Conduct](CODE_OF_CONDUCT.md).

## License
By contributing to this project, you agree that your contributions will be licensed under the [project's LICENSE](LICENSE).

Thank you for your contributions!
