% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bearing.R
\name{bearing}
\alias{bearing}
\title{Calculate the bearing given two points}
\usage{
bearing(x, y, x2, y2)
}
\arguments{
\item{x}{Longitude of point 1}

\item{y}{Latitude of point 1}

\item{x2}{Longitude of point 2}

\item{y2}{Latitude of point 2}
}
\value{
Bearing in radians from point 1 to point 2 (from -pi to pi)
}
\description{
This function calculates the bearing (direction) for something (e.g. an animal)
moving from point 1 to point 2.
}
\examples{
# Example 1
bearing(x = 0, y = 0, x2 = 2, y2 = 2)

# Example 2
library(data.table)

d = data.table(x  = rep(0, 21),
               y  = rep(0, 21),
               x2 = seq(-10, 10, 1),
               y2 = rep(2, 21) )

               d[, bearing := bearing(x, y, x2, y2), by = 1:nrow(d)]

               plot(bearing ~ x2, d, type = 'l')
}
