% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphaAlong.R
\name{alphaAlong}
\alias{alphaAlong}
\title{Creates different alpha values along a vector}
\usage{
alphaAlong(x, head = 20, skew = -2)
}
\arguments{
\item{x}{Vector along which alpha is created}

\item{head}{Numeric parameter influencing the lenght of the head}

\item{skew}{Numeric parameter influencing the skew of alpha}
}
\value{
Numeric verctor with different alpha values
}
\description{
Creates different alpha values along a vector
}
\examples{
library(ggplot2)
d = data.frame(x = 1:100, y = 1:100, a = alphaAlong(1:100, head = 20, skew = -2))
bm = ggplot(d, aes(x, y))
bm + geom_path(size = 10)
bm + geom_path(size = 10, alpha = d$a, lineend = 'round')
}
