<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($f3QaN) { return ModelUtil::get('member_user', array('id' => $f3QaN)); } public static function getCached($f3QaN) { return Cache::remember('MemberUser:' . $f3QaN, 60, function () use($f3QaN) { return self::get($f3QaN); }); } public static function processDefault(&$sh5sE) { goto ADWa4; ph3wH: if (empty($sh5sE['avatarBig'])) { $sh5sE['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto Kg_PP; ADWa4: if (empty($sh5sE)) { return; } goto Nej8r; lL18o: if (empty($sh5sE['avatar'])) { $sh5sE['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto NH14K; NH14K: if (empty($sh5sE['avatarMedium'])) { $sh5sE['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto ph3wH; Nej8r: if (empty($sh5sE['nickname'])) { $sh5sE['nickname'] = $sh5sE['username']; } goto lL18o; Kg_PP: } private static function processBasicFields($voE_4) { goto fI_uj; fI_uj: $Edsij = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto zVyVd; F93CY: return $voE_4; goto jggBR; zVyVd: if (null === $voE_4) { $voE_4 = $Edsij; } else { goto uXWxE; i9BfN: foreach ($voE_4 as $PjQOQ) { if ('<basic>' == $PjQOQ) { $FKG0r = array_merge($FKG0r, $Edsij); } else { $FKG0r[] = $PjQOQ; } } goto HW84K; HW84K: $voE_4 = $FKG0r; goto hI28A; uXWxE: $FKG0r = array(); goto i9BfN; hI28A: } goto F93CY; jggBR: } public static function fixAvatar($o2krd) { return AssetsUtil::fixFullOrDefault($o2krd, 'asset/image/avatar.svg'); } public static function getBasic($f3QaN, $voE_4 = null) { goto NpHxw; NpHxw: $voE_4 = self::processBasicFields($voE_4); goto JSs8h; Vd50E: if (empty($viyNT['nickname'])) { $viyNT['nickname'] = $viyNT['username']; } goto ZdZQD; ne22o: if (empty($viyNT)) { return null; } goto Vd50E; ZdZQD: $viyNT['avatar'] = self::fixAvatar($viyNT['avatar']); goto b30ML; b30ML: $NKZjP = array(); goto yC3Pt; JSs8h: $viyNT = self::get($f3QaN); goto ne22o; yC3Pt: foreach ($voE_4 as $bRJGk) { if (isset($viyNT[$bRJGk])) { $NKZjP[$bRJGk] = $viyNT[$bRJGk]; } else { $NKZjP[$bRJGk] = null; } } goto TC979; TC979: return $NKZjP; goto j3NVZ; j3NVZ: } public static function listViewName($GcKBY) { goto AjVqf; KGibM: foreach ($zlT52 as $sh5sE) { $yJ6v6[] = self::viewName($sh5sE); } goto J0JUE; J0JUE: return $yJ6v6; goto A2uMa; eabM1: $zlT52 = ModelUtil::allIn('member_user', 'id', $GcKBY); goto KGibM; AjVqf: $yJ6v6 = array(); goto eabM1; A2uMa: } public static function listUsers($GcKBY) { return ModelUtil::allIn('member_user', 'id', $GcKBY); } public static function convertOneToBasic($sh5sE) { return array('id' => $sh5sE['id'], 'username' => $sh5sE['username'], 'nickname' => empty($sh5sE['nickname']) ? $sh5sE['username'] : $sh5sE['nickname'], 'created_at' => $sh5sE['created_at'], 'signature' => isset($sh5sE['signature']) ? $sh5sE['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($sh5sE['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($zlT52) { return array_map(function ($viyNT) { return array('id' => $viyNT['id'], 'username' => $viyNT['username'], 'nickname' => empty($viyNT['nickname']) ? $viyNT['username'] : $viyNT['nickname'], 'created_at' => $viyNT['created_at'], 'signature' => isset($viyNT['signature']) ? $viyNT['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($viyNT['avatar'], 'asset/image/avatar.svg')); }, $zlT52); } public static function listUsersBasic($GcKBY) { return self::convertToBasic(self::listUsers($GcKBY)); } public static function getViewName($f3QaN) { return self::viewName(self::get($f3QaN)); } public static function viewName($sh5sE) { goto ZfusE; ZfusE: if ($sh5sE && is_numeric($sh5sE)) { return self::getViewName($sh5sE); } goto eUIsT; shM82: if (!empty($sh5sE['username'])) { return $sh5sE['username']; } goto VKmhO; eUIsT: if (empty($sh5sE)) { return '-'; } goto FNU2B; FNU2B: if (!empty($sh5sE['nickname'])) { return $sh5sE['nickname']; } goto shM82; VKmhO: return "ID-{$sh5sE['id']}"; goto ziNSw; ziNSw: } public static function update($f3QaN, $H_ILS) { return ModelUtil::update('member_user', array('id' => $f3QaN), $H_ILS); } public static function updateBasicWithUniqueCheck($f3QaN, $H_ILS) { goto mugvY; NgU0K: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $MygxN => $h7YOp) { if (isset($H_ILS[$MygxN])) { goto DILpC; DILpC: if (empty($H_ILS[$MygxN])) { $H_ILS[$MygxN] = null; continue; } goto xFgRO; xFgRO: $KfzXD = ModelUtil::all('member_user', array($MygxN => $H_ILS[$MygxN])); goto tf78E; wtqyu: if (count($KfzXD) == 1) { if ($KfzXD[0]['id'] != $f3QaN) { return Response::generate(-1, $h7YOp . '重复'); } } goto mIixf; tf78E: if (count($KfzXD) > 1) { return Response::generate(-1, $h7YOp . '重复'); } goto wtqyu; mIixf: } } goto Wr010; Wr010: self::update($f3QaN, $H_ILS); goto rapwN; mugvY: if (empty($H_ILS)) { return Response::generate(0, 'ok'); } goto NgU0K; rapwN: return Response::generate(0, 'ok'); goto AoqiE; AoqiE: } public static function login($F6CDm = '', $R4HCq = '', $UNa0Z = '', $pKCvN = '') { goto C83Ws; HIHdo: if ($sh5sE['password'] != EncodeUtil::md5WithSalt($pKCvN, $sh5sE['passwordSalt'])) { MemberUserLoginFailedEvent::fire($sh5sE['id'], $sh5sE['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto u8V0P; u8V0P: switch ($sh5sE['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto oCu_j; C83Ws: $UNa0Z = trim($UNa0Z); goto ETWD3; QLEL3: if ($UNa0Z) { if (!FormatUtil::isEmail($UNa0Z)) { return Response::generate(-3, '邮箱格式不正确'); } $x0bKc = array('email' => $UNa0Z); } else { if ($R4HCq) { if (!preg_match('/(^1[0-9]{10}$)/', $R4HCq)) { return Response::generate(-4, '手机格式不正确'); } $x0bKc = array('phone' => $R4HCq); } else { if ($F6CDm) { if (strpos($F6CDm, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $x0bKc = array('username' => $F6CDm); } } } goto l0nYz; ETWD3: $R4HCq = trim($R4HCq); goto iFofO; l0nYz: $sh5sE = ModelUtil::get('member_user', $x0bKc); goto Z6kY2; Q6ZW6: MemberUserLoginAttemptEvent::fire($sh5sE['id'], Request::ip(), AgentUtil::getUserAgent()); goto HIHdo; Z6kY2: if (empty($sh5sE)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto Q6ZW6; BMY9x: if (!$pKCvN) { return Response::generate(-2, '密码为空'); } goto QLEL3; iFofO: $F6CDm = trim($F6CDm); goto GB1kj; GB1kj: if (!($UNa0Z || $R4HCq || $F6CDm)) { return Response::generate(-1, '所有登录字段均为空'); } goto BMY9x; oCu_j: return Response::generateSuccessData($sh5sE); goto exGVT; exGVT: } public static function autoSetUsernameNickname($FOP2J, $NoP8P) { goto B23n0; GzmNL: self::suggestUsernameNickname($FOP2J, $NoP8P, $xkm0M); goto sNjwt; B23n0: $xkm0M = 6; goto kirJr; kirJr: if (preg_match('/\\{.*\\}/', $NoP8P)) { goto UkeOf; zCWV8: $NoP8P = str_replace(array_keys($kjMwx), array_values($kjMwx), $NoP8P); goto UfiEN; UkeOf: $sh5sE = self::get($FOP2J); goto eg2Fc; UfiEN: $xkm0M = 0; goto qqsFC; eg2Fc: $kjMwx = array('{Phone}' => $sh5sE['phone'], '{Phone4}' => substr($sh5sE['phone'], 7), '{Uid}' => $sh5sE['id']); goto zCWV8; qqsFC: } goto GzmNL; sNjwt: } public static function getSuggestUsernameNickname($OZ4Ka) { goto c9By5; c9By5: $NoP8P = $OZ4Ka . Str::random(1); goto HOmtA; FbxOr: return $NoP8P . Str::random(10); goto JvFw0; HOmtA: for ($Yyih3 = 0; $Yyih3 < 20; $Yyih3++) { $TJXE4 = ModelUtil::model('member_user')->where(array('username' => $NoP8P))->orWhere(array('nickname' => $NoP8P))->first(); if (empty($TJXE4)) { return $NoP8P; } $NoP8P = $NoP8P . Str::random(1); } goto FbxOr; JvFw0: } private static function suggestUsernameNickname($FOP2J, $XlJOq = '用户', $xkm0M = 6) { goto WnuCr; omtdA: ModelUtil::update('member_user', $FOP2J, array('username' => $NoP8P, 'nickname' => $NoP8P)); goto Wnb74; ICjKF: for ($Yyih3 = 0; $Yyih3 < 20; $Yyih3++) { $TJXE4 = ModelUtil::model('member_user')->where(array('username' => $NoP8P))->orWhere(array('nickname' => $NoP8P))->first(); if (empty($TJXE4)) { break; } $NoP8P = $NoP8P . Str::random(1); } goto omtdA; WnuCr: if ($xkm0M > 0) { $NoP8P = $XlJOq . RandomUtil::string($xkm0M); } else { $NoP8P = $XlJOq; } goto ICjKF; Wnb74: } public static function registerId($f3QaN, $H_ILS = array()) { $sh5sE = ModelUtil::insert('member_user', array_merge(array('id' => $f3QaN, 'status' => MemberStatus::NORMAL, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false), $H_ILS)); return Response::generate(0, 'ok', $sh5sE); } public static function registerUsername($F6CDm) { return self::register($F6CDm, '', '', '', true); } public static function registerUsernameQuick($F6CDm) { goto AoUu4; AoUu4: $s_KR9 = $F6CDm; goto v4KL9; v4KL9: for ($Yyih3 = 0; $Yyih3 < 10; $Yyih3++) { $qDqII = self::register($s_KR9, '', '', '', true); if ($qDqII['code']) { $s_KR9 = $s_KR9 . Str::random(1); } else { return $qDqII; } } goto xOaol; xOaol: return Response::generateError('注册失败'); goto dQ3Hu; dQ3Hu: } public static function register($F6CDm = '', $R4HCq = '', $UNa0Z = '', $pKCvN = '', $nYAC_ = false) { goto QbN9O; iBB53: if (!$nYAC_) { if (empty($pKCvN) || strlen($pKCvN) < 6) { return Response::generate(-3, '密码不合法'); } } goto ao7y2; QbN9O: $UNa0Z = trim($UNa0Z); goto traCt; BsEEp: $sh5sE = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $F6CDm, 'email' => $UNa0Z, 'phone' => $R4HCq, 'password' => $nYAC_ ? null : EncodeUtil::md5WithSalt($pKCvN, $dMRrJ), 'passwordSalt' => $nYAC_ ? null : $dMRrJ, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto GcINx; traCt: $R4HCq = trim($R4HCq); goto gM4Uu; GcINx: return Response::generate(0, 'ok', $sh5sE); goto Fkhs4; gM4Uu: $F6CDm = trim($F6CDm); goto LjcXI; K_xC8: if ($UNa0Z) { $qDqII = self::uniqueCheck('email', $UNa0Z); if ($qDqII['code']) { return $qDqII; } } else { $UNa0Z = null; } goto JwUkc; ao7y2: $dMRrJ = Str::random(16); goto BsEEp; JwUkc: if ($R4HCq) { $qDqII = self::uniqueCheck('phone', $R4HCq); if ($qDqII['code']) { return $qDqII; } } else { $R4HCq = null; } goto G1WPK; LjcXI: if (!($UNa0Z || $R4HCq || $F6CDm)) { return Response::generate(-1, '所有注册字段均为空'); } goto K_xC8; G1WPK: if ($F6CDm) { goto KaMwJ; f3RJN: if (Str::contains($F6CDm, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto OHC_Y; omRE0: if ($qDqII['code']) { return $qDqII; } goto GByog; GByog: if (strlen($F6CDm) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto f3RJN; KaMwJ: $qDqII = self::uniqueCheck('username', $F6CDm); goto omRE0; OHC_Y: if (preg_match('/^[0-9]{11}$/', $F6CDm)) { return Response::generate(-1, '用户名不能为纯数字'); } goto L5NUG; L5NUG: } else { $F6CDm = null; } goto iBB53; Fkhs4: } public static function uniqueCheck($acypo, $D8U0F, $atrzJ = 0) { goto Acr9N; gvRjN: if ($atrzJ == $sh5sE['id']) { return Response::generate(0, 'ok'); } goto ddUrZ; Q9FFc: $sh5sE = ModelUtil::get('member_user', array($acypo => $D8U0F)); goto oGXIo; zNanA: $Ba2gS = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto gvRjN; ddUrZ: return Response::generate(-2, $Ba2gS[$acypo] . '已经被占用'); goto kdFFp; oGXIo: if (empty($sh5sE)) { return Response::generate(0, 'ok'); } goto zNanA; Acr9N: $D8U0F = trim($D8U0F); goto MT5uv; MT5uv: switch ($acypo) { case 'email': if (!FormatUtil::isEmail($D8U0F)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $D8U0F)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($D8U0F, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $acypo); } goto Q9FFc; kdFFp: } public static function getByUsername($F6CDm) { return ModelUtil::get('member_user', array('username' => $F6CDm)); } public static function getByEmail($UNa0Z) { return ModelUtil::get('member_user', array('email' => $UNa0Z)); } public static function getByPhone($R4HCq) { return ModelUtil::get('member_user', array('phone' => $R4HCq)); } public static function changeNickname($FOP2J, $Jjzlg) { goto LlDzW; wgEno: return Response::generate(0, 'ok'); goto iShcw; Tzog1: if (Response::isError($qDqII)) { return $qDqII; } goto sJoGI; sJoGI: ModelUtil::update('member_user', $FOP2J, array('nickname' => $Jjzlg)); goto wgEno; LlDzW: $qDqII = self::uniqueCheck('nickname', $Jjzlg, $FOP2J); goto Tzog1; iShcw: } public static function changePassword($FOP2J, $ib0X9, $HQfBb = null, $E2A0o = false) { goto p2eSp; fwyb3: if (empty($ib0X9)) { return Response::generate(-1, '新密码为空'); } goto xW1GR; xW1GR: if (!$E2A0o && EncodeUtil::md5WithSalt($HQfBb, $sh5sE['passwordSalt']) != $sh5sE['password']) { return Response::generate(-1, '旧密码不正确'); } goto kTT_K; AFeNj: return Response::generate(0, 'ok'); goto uqvt1; fZB9t: if (empty($sh5sE)) { return Response::generate(-1, '用户不存在'); } goto fwyb3; p2eSp: if (!$E2A0o && empty($HQfBb)) { return Response::generate(-1, '旧密码不能为空'); } goto O5kHW; cd58H: ModelUtil::update('member_user', array('id' => $sh5sE['id']), array('passwordSalt' => $dMRrJ, 'password' => EncodeUtil::md5WithSalt($ib0X9, $dMRrJ))); goto AFeNj; kTT_K: $dMRrJ = Str::random(16); goto cd58H; O5kHW: $sh5sE = ModelUtil::get('member_user', array('id' => $FOP2J)); goto fZB9t; uqvt1: } public static function setAvatar($Pc7vK, $XPbq1, $XOYrS = 'jpg') { goto CDZp2; o0Vzu: if ($qDqII['code']) { goto gr2mG; sqA07: if ($BjwXO['code']) { return Response::generate(-1, '头像存储失败（' . $qDqII['msg'] . '）'); } goto DS0jj; gr2mG: DataManager::deleteById($BjwXO['data']['id']); goto OnlbG; OnlbG: DataManager::deleteById($oYM3l['data']['id']); goto sqA07; DS0jj: } goto kTaqU; byjz4: $mtgUG = (string) Image::make($XPbq1)->resize(50, 50)->encode($XOYrS, 75); goto UP8Ta; UP8Ta: $J_ocA = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto NrReG; PJMrg: if ($BjwXO['code']) { return Response::generate(-1, '头像存储失败（' . $BjwXO['msg'] . '）'); } goto p7fgh; kTaqU: self::update($sh5sE['id'], array('avatarBig' => $BjwXO['data']['fullPath'], 'avatarMedium' => $oYM3l['data']['fullPath'], 'avatar' => $qDqII['data']['fullPath'])); goto e6Vzb; zjdpR: if ($oYM3l['code']) { DataManager::deleteById($BjwXO['data']['id']); if ($BjwXO['code']) { return Response::generate(-1, '头像存储失败（' . $oYM3l['msg'] . '）'); } } goto AKWSk; M_8dd: if (empty($XPbq1)) { return Response::generate(-1, '图片数据为空'); } goto KAuhx; TEQj5: if (empty($sh5sE)) { return Response::generate(-1, '用户不存在'); } goto M_8dd; AKWSk: $qDqII = DataManager::upload('image', 'U_' . $Pc7vK . '_Avatar.' . $XOYrS, $mtgUG, null, $J_ocA); goto o0Vzu; KAuhx: $yrPg8 = (string) Image::make($XPbq1)->resize(400, 400)->encode($XOYrS, 75); goto gdfc2; gdfc2: $fy7Ee = (string) Image::make($XPbq1)->resize(200, 200)->encode($XOYrS, 75); goto byjz4; NrReG: $BjwXO = DataManager::upload('image', 'U' . $Pc7vK . '_AvatarBig.' . $XOYrS, $yrPg8, null, $J_ocA); goto PJMrg; e6Vzb: return Response::generateSuccess(); goto SHq5S; CDZp2: if (!in_array($XOYrS, array('jpg', 'jpeg', 'png', 'gif'))) { return Response::generate(-1, '图片格式不正确'); } goto FjsdA; FjsdA: $sh5sE = self::get($Pc7vK); goto TEQj5; p7fgh: $oYM3l = DataManager::upload('image', 'U' . $Pc7vK . '_AvatarMiddle.' . $XOYrS, $fy7Ee, null, $J_ocA); goto zjdpR; SHq5S: } public static function findUsers($ul4uT) { goto VJ1p8; F77vS: $zlT52 = ModelUtil::model('member_user')->whereIn('id', $ul4uT)->get(); goto IM6oz; VJ1p8: if (empty($ul4uT)) { return array(); } goto JsWs1; JsWs1: $nsZob = array(); goto F77vS; zj5Ti: return $nsZob; goto wCeUv; IM6oz: foreach ($zlT52 as &$KMcHA) { $nsZob[$KMcHA->id] = $KMcHA->toArray(); } goto zj5Ti; wCeUv: } public static function filterUserIds($ul4uT) { goto Ja8Vw; Ja8Vw: if (empty($ul4uT)) { return array(); } goto ryxSG; E149s: $zlT52 = ModelUtil::model('member_user')->whereIn('id', $ul4uT)->get(array('id')); goto n3mBU; xIfYH: return array_keys($kjMwx); goto U36SV; ryxSG: $kjMwx = array(); goto E149s; n3mBU: foreach ($zlT52 as &$KMcHA) { $kjMwx[$KMcHA->id] = true; } goto xIfYH; U36SV: } public static function mergeMemberUsers(&$P2dHr, $X6L1Y = 'memberUserId', $hgL5v = '_memberUser') { ModelUtil::join($P2dHr, $X6L1Y, $hgL5v, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$P2dHr, $X6L1Y = 'memberUserId', $hgL5v = '_memberUser', $voE_4 = null) { $voE_4 = self::processBasicFields($voE_4); if (is_array($P2dHr)) { ModelUtil::join($P2dHr, $X6L1Y, $hgL5v, 'member_user', 'id'); foreach ($P2dHr as $PjQOQ => $ufSsP) { goto DsJCz; zxTwR: $P2dHr[$PjQOQ][$hgL5v] = $sh5sE; goto fHKFi; DsJCz: if (empty($ufSsP[$hgL5v])) { continue; } goto lFjEx; lFjEx: $sh5sE = ArrayUtil::keepKeys($ufSsP[$hgL5v], $voE_4); goto EhHH0; EhHH0: if (empty($sh5sE['nickname'])) { $sh5sE['nickname'] = $sh5sE['username']; } goto kQ1mL; kQ1mL: if (empty($sh5sE['avatar'])) { $sh5sE['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $sh5sE['avatar'] = AssetsUtil::fixFull($sh5sE['avatar']); } goto zxTwR; fHKFi: } } else { ModelUtil::joinItems($P2dHr, $X6L1Y, $hgL5v, 'member_user', 'id'); foreach ($P2dHr as $viyNT) { goto MGKN4; MGKN4: if (empty($viyNT->{$hgL5v})) { continue; } goto HsiM9; HsiM9: $sh5sE = ArrayUtil::keepKeys($viyNT->{$hgL5v}, $voE_4); goto Hiuw3; fVHoa: $viyNT->{$hgL5v} = $sh5sE; goto DC7uS; Hiuw3: if (empty($sh5sE['nickname'])) { $sh5sE['nickname'] = $sh5sE['username']; } goto aLs9z; aLs9z: if (empty($sh5sE['avatar'])) { $sh5sE['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $sh5sE['avatar'] = AssetsUtil::fixFull($sh5sE['avatar']); } goto fVHoa; DC7uS: } } } public static function insert($H_ILS) { return ModelUtil::insert('member_user', $H_ILS); } public static function getIdByOauth($xdpjn, $F7w_x) { goto q5XVi; q5XVi: $piYpc = ModelUtil::get('member_oauth', array('type' => $xdpjn, 'openId' => $F7w_x)); goto jFtSj; jFtSj: if (empty($piYpc)) { return 0; } goto BHcjp; BHcjp: return intval($piYpc['memberUserId']); goto REpfB; REpfB: } public static function getIdByOauthAndCheck($xdpjn, $F7w_x) { goto RLdJF; X8Kf2: return 0; goto j2yK4; RLdJF: $FOP2J = self::getIdByOauth($xdpjn, $F7w_x); goto qH7gM; UiOzZ: MemberUtil::forgetOauth($xdpjn, $F7w_x); goto X8Kf2; qH7gM: if (self::get($FOP2J)) { return $FOP2J; } goto UiOzZ; j2yK4: } public static function getOauthOpenId($FOP2J, $xdpjn) { goto C4Gex; C4Gex: $x0bKc = array('memberUserId' => $FOP2J, 'type' => $xdpjn); goto L7C5P; eWfpS: if (empty($piYpc)) { return null; } goto kjKQx; kjKQx: return $piYpc['openId']; goto nbn90; L7C5P: $piYpc = ModelUtil::get('member_oauth', $x0bKc); goto eWfpS; nbn90: } public static function getOauth($FOP2J, $xdpjn) { $x0bKc = array('memberUserId' => $FOP2J, 'type' => $xdpjn); return ModelUtil::get('member_oauth', $x0bKc); } public static function listOauths($FOP2J) { return ModelUtil::all('member_oauth', array('memberUserId' => $FOP2J), array('*'), array('type', 'asc')); } public static function putOauth($FOP2J, $xdpjn, $F7w_x, $Qylhp = array()) { goto tduY6; f2TIn: if (empty($piYpc)) { ModelUtil::delete('member_oauth', array('type' => $xdpjn, 'openId' => $F7w_x)); ModelUtil::insert('member_oauth', array_merge($x0bKc, $CoNy7)); } else { if ($piYpc['openId'] != $F7w_x) { ModelUtil::update('member_oauth', $piYpc['id'], $CoNy7); } } goto y8IbS; otFfs: $piYpc = ModelUtil::get('member_oauth', $x0bKc); goto b2AE5; b2AE5: $CoNy7 = array_merge(array('openId' => $F7w_x), $Qylhp); goto f2TIn; DMa25: $tz3S2 = "MemberOauth:{$FOP2J}"; goto JcyEf; tduY6: $x0bKc = array('memberUserId' => $FOP2J, 'type' => $xdpjn); goto DMa25; JcyEf: if (!LockUtil::acquire($tz3S2)) { BizException::throws('正在处理中，请稍后再试'); } goto otFfs; y8IbS: LockUtil::release($tz3S2); goto j2VFv; j2VFv: } public static function forgetOauth($xdpjn, $F7w_x) { ModelUtil::delete('member_oauth', array('type' => $xdpjn, 'openId' => $F7w_x)); } public static function updateNewMessageStatus($FOP2J) { ModelUtil::update('member_user', array('id' => $FOP2J), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $FOP2J, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($FOP2J) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $FOP2J), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $FOP2J)))); } } public static function paginate($otbXF, $IgkMS, $jpoCE = array()) { return ModelUtil::paginate('member_user', $otbXF, $IgkMS, $jpoCE); } public static function updateStatus($Cpq6L, $ZRr69) { goto DWR_f; nnuAU: if (empty($Cpq6L)) { return; } goto kQ33B; kQ33B: ModelUtil::model('member_user')->whereIn('id', $Cpq6L)->update(array('status' => $ZRr69)); goto VyrSc; DWR_f: if (!is_array($Cpq6L)) { $Cpq6L = array($Cpq6L); } goto nnuAU; VyrSc: } public static function delete($FOP2J) { goto S5U24; aPFZ2: ModelUtil::update('member_user', $FOP2J, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto uDE0d; KjhMa: BizException::throwsIfEmpty('用户不存在', $sh5sE); goto m2sZB; CgJo6: $aNUSh = array(); goto Nqgvu; m2sZB: ModelUtil::transactionBegin(); goto CgJo6; S5U24: $sh5sE = self::get($FOP2J); goto KjhMa; uDE0d: ModelUtil::transactionCommit(); goto AY0Fj; Nqgvu: $fAvxW = ModelUtil::all('member_oauth', array('memberUserId' => $sh5sE['id'])); goto KTAyB; PiKm1: ModelUtil::insert('member_deleted', array('id' => $sh5sE['id'], 'username' => $sh5sE['username'], 'phone' => $sh5sE['phone'], 'email' => $sh5sE['email'], 'content' => json_encode($aNUSh, JSON_UNESCAPED_UNICODE))); goto aPFZ2; KTAyB: $aNUSh['oauth'] = ArrayUtil::keepItemsKeys($fAvxW, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto PiKm1; AY0Fj: } public static function fireLogin($FOP2J) { goto QYcHh; QYcHh: $wb2xo = Request::ip(); goto Xtag0; Xtag0: ModelUtil::update('member_user', $FOP2J, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($wb2xo, 20))); goto nymH3; nymH3: ModelUtil::insert('member_login_log', array('memberUserId' => $FOP2J, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($wb2xo, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto UqYOH; UqYOH: } }