<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Api\Controller; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\Session; use Illuminate\Support\Str; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\FileUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Misc\Captcha\CaptchaFacade; use ModStart\Module\ModuleBaseController; use Module\Member\Auth\MemberUser; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserUpdatedEvent; use Module\Member\Support\MemberLoginCheck; use Module\Member\Util\MemberUtil; use Module\Vendor\Job\MailSendJob; use Module\Vendor\Job\SmsSendJob; use Module\Vendor\Sms\SmsUtil; use Module\Vendor\Support\ResponseCodes; class MemberProfileController extends ModuleBaseController implements MemberLoginCheck { public function nickname() { goto nw1cz; nw1cz: $WnaVd = InputPackage::buildFromInput(); goto CdXuI; CdXuI: $Jjzlg = $WnaVd->getTrimString('nickname'); goto DMPg7; DMPg7: BizException::throwsIfEmpty('昵称为空', $Jjzlg); goto w1AO3; JRCRv: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'nickname')); goto lriK2; eN4J5: BizException::throwsIfResponseError($qDqII); goto JRCRv; w1AO3: if (!CaptchaFacade::check($WnaVd->getTrimString('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto sxQ4N; sxQ4N: $qDqII = MemberUtil::changeNickname(MemberUser::id(), $Jjzlg); goto eN4J5; lriK2: return Response::generate(0, '修改成功', null, '[reload]'); goto B51jr; B51jr: } public function password() { goto cqd0Q; glxC0: $teXu4 = $WnaVd->getTrimString('passwordOld'); goto pbl6L; cqd0Q: $WnaVd = InputPackage::buildFromInput(); goto glxC0; if_Vd: if ($yHskt != $nWcU7) { return Response::generate(-1, '两次新密码输入不一致'); } goto VErez; VErez: $sh5sE = MemberUser::get(); goto hdyKz; h3IrU: return Response::generate(0, '修改成功', null, '[reload]'); goto uoS5D; pbl6L: $yHskt = $WnaVd->getTrimString('passwordNew'); goto ZxAb_; QWDyz: if ($qDqII['code']) { return Response::generate(-1, $qDqII['msg']); } goto ZrbPT; ZrbPT: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'password')); goto h3IrU; ZxAb_: $nWcU7 = $WnaVd->getTrimString('passwordRepeat'); goto if_Vd; hdyKz: if (empty($sh5sE['password'])) { $qDqII = MemberUtil::changePassword(MemberUser::id(), $yHskt, null, true); } else { $qDqII = MemberUtil::changePassword(MemberUser::id(), $yHskt, $teXu4); } goto QWDyz; uoS5D: } public function avatar() { goto OAD6p; OAD6p: $WnaVd = InputPackage::buildFromInput(); goto mbNGf; cMHNS: if (empty($o2krd)) { return Response::generate(-1, '头像内容为空'); } goto TZ4dM; TZ4dM: switch ($WnaVd->getTrimString('type')) { case 'cropper': goto T6nSh; dgLkP: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'avatar')); goto tcZ6N; umUfZ: $o2krd = @base64_decode($o2krd); goto xEd_T; xEd_T: if (empty($o2krd)) { return Response::generate(-1, '头像内容为空'); } goto f3eS7; E_x1O: if ($qDqII['code']) { return $qDqII; } goto dgLkP; tcZ6N: return Response::generate(0, '保存成功', null, '[reload]'); goto YJ_wL; sLZe0: if (empty($O_gHF)) { return Response::generate(-1, '头像数据为空'); } goto umUfZ; T6nSh: $O_gHF = null; goto gJgih; gJgih: if (Str::startsWith($o2krd, 'data:image/jpeg;base64,')) { $O_gHF = 'jpg'; $o2krd = substr($o2krd, strlen('data:image/jpeg;base64,')); } else { if (Str::startsWith($o2krd, 'data:image/png;base64,')) { $O_gHF = 'png'; $o2krd = substr($o2krd, strlen('data:image/png;base64,')); } } goto sLZe0; f3eS7: $qDqII = MemberUtil::setAvatar(MemberUser::id(), $o2krd, $O_gHF); goto E_x1O; YJ_wL: default: goto y9QTf; ObXyp: if (empty($o2krd)) { return Response::generate(-1, '读取头像文件失败:-1'); } goto ypz3G; UMDue: if ($qDqII['code']) { return $qDqII; } goto ZM1M4; OIm59: return Response::generate(0, '保存成功', null, '[reload]'); goto TBHoX; y9QTf: $o2krd = FileUtil::savePathToLocalTemp($o2krd); goto ObXyp; ZM1M4: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'avatar')); goto OIm59; ArwaX: if (!in_array($XOYrS, config('data.upload.image.extensions'))) { return Response::generate(-1, '头像格式不合法'); } goto u2sj_; U8wss: if (empty($o2krd)) { return Response::generate(-1, '读取头像文件失败:-2'); } goto wXmVd; ypz3G: $XOYrS = FileUtil::extension($o2krd); goto ArwaX; u2sj_: $o2krd = FileUtil::safeGetContent($o2krd); goto U8wss; wXmVd: $qDqII = MemberUtil::setAvatar(MemberUser::id(), $o2krd, $XOYrS); goto UMDue; TBHoX: } goto nr0L1; mbNGf: $o2krd = $WnaVd->getTrimString('avatar'); goto cMHNS; nr0L1: } public function captchaRaw() { return CaptchaFacade::create('default'); } public function captcha() { $BCqnl = $this->captchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($BCqnl->getOriginalContent()))); } public function email() { goto SH1Uk; M5ab9: $UNa0Z = $WnaVd->getEmail('email'); goto wLId7; CP4gS: if (!FormatUtil::isEmail($UNa0Z)) { return Response::generate(-1, '邮箱格式不正确'); } goto NexZd; SH1Uk: $WnaVd = InputPackage::buildFromInput(); goto M5ab9; iRqG2: if (!empty($gFhW2)) { if ($gFhW2['id'] != MemberUser::id()) { return Response::generate(-1, '该邮箱已被其他账户绑定'); } if ($gFhW2['id'] == MemberUser::id() && $gFhW2['email'] == $UNa0Z) { if (!empty($gFhW2['emailVerified'])) { return Response::generate(-1, '邮箱未修改，无需重新绑定。'); } } } goto S8g07; wLId7: $MK3KS = $WnaVd->getTrimString('verify'); goto h0_zK; h0_zK: if (empty($UNa0Z)) { return Response::generate(-1, '邮箱不能为空'); } goto CP4gS; XjlUC: if ($MK3KS != Session::get('memberProfileEmailVerify')) { return Response::generate(-1, '验证码不正确'); } goto DrPdf; yO2ky: return Response::generate(0, '修改成功', null, '[reload]'); goto tXyTS; N7AhO: if ($UNa0Z != Session::get('memberProfileEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto wr9v1; NexZd: if (empty($MK3KS)) { return Response::generate(-1, '验证码不能为空'); } goto XjlUC; BQUL9: Session::forget('memberProfileEmailVerify'); goto WXwQh; cNJO2: Session::forget('memberProfileEmail'); goto yO2ky; DrPdf: if (Session::get('memberProfileEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '验证码已过期'); } goto N7AhO; WXwQh: Session::forget('memberProfileEmailVerifyTime'); goto cNJO2; rhkL9: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'email')); goto BQUL9; wr9v1: $gFhW2 = MemberUtil::getByEmail($UNa0Z); goto iRqG2; S8g07: MemberUtil::update(MemberUser::id(), array('emailVerified' => true, 'email' => $UNa0Z)); goto rhkL9; tXyTS: } public function emailVerify() { goto vk8Yk; vk8Yk: $UNa0Z = Input::get('target'); goto br0Ct; mOFV1: $MK3KS = rand(100000, 999999); goto Xr7Kz; Xr7Kz: Session::put('memberProfileEmailVerify', $MK3KS); goto ZUKGV; a9YAo: if (!FormatUtil::isEmail($UNa0Z)) { return Response::generate(-1, '邮箱格式不正确'); } goto dEEEi; ZUKGV: Session::put('memberProfileEmailVerifyTime', time()); goto NMnw3; wON8b: if (!empty($gFhW2)) { if ($gFhW2['id'] != MemberUser::id()) { return Response::generate(-1, '该邮箱已被其他账户绑定'); } if ($gFhW2['id'] == MemberUser::id() && $gFhW2['email'] == $UNa0Z) { if (!empty($gFhW2['emailVerified'])) { return Response::generate(-1, '邮箱未修改，无需重新绑定。'); } } } goto XnKsM; dEEEi: if (!CaptchaFacade::check(Input::get('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto Mn9R0; NMnw3: Session::put('memberProfileEmail', $UNa0Z); goto hU06j; Mn9R0: $gFhW2 = MemberUtil::getByEmail($UNa0Z); goto wON8b; hU06j: MailSendJob::create($UNa0Z, '验证码', 'verify', array('code' => $MK3KS)); goto ISJhJ; br0Ct: if (empty($UNa0Z)) { return Response::generate(-1, '邮箱不能为空'); } goto a9YAo; XnKsM: if (Session::get('memberProfileEmailVerifyTime') && $UNa0Z == Session::get('memberProfileEmail')) { if (Session::get('memberProfileEmailVerifyTime') + 60 * 10 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto mOFV1; ISJhJ: return Response::generate(0, '验证码发送成功'); goto RFo3P; RFo3P: } public function phone() { goto eHC20; JX6Im: if ($R4HCq != Session::get('memberProfilePhone')) { return Response::generate(-1, '两次手机不一致'); } goto hlSJG; eTozf: Session::forget('memberProfilePhoneVerifyTime'); goto Qjh6m; c2qih: if (!FormatUtil::isPhone($R4HCq)) { return Response::generate(-1, '手机格式不正确'); } goto paoX3; il83N: return Response::generate(0, '修改成功', null, '[reload]'); goto Vtmb1; L7hap: MemberUtil::update(MemberUser::id(), array('phoneVerified' => true, 'phone' => $R4HCq)); goto S6Nsr; hlSJG: $gFhW2 = MemberUtil::getByPhone($R4HCq); goto Mdlrq; paoX3: if (empty($MK3KS)) { return Response::generate(-1, '验证码不能为空'); } goto Vlt4n; Duyto: $R4HCq = $WnaVd->getPhone('phone'); goto cd1Ga; Qjh6m: Session::forget('memberProfilePhone'); goto il83N; Vlt4n: if ($MK3KS != Session::get('memberProfilePhoneVerify')) { return Response::generate(-1, '验证码不正确'); } goto lMxHg; cd1Ga: $MK3KS = $WnaVd->getTrimString('verify'); goto I4JgD; I4JgD: if (empty($R4HCq)) { return Response::generate(-1, '手机不能为空'); } goto c2qih; lMxHg: if (Session::get('memberProfilePhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '验证码已过期'); } goto JX6Im; eHC20: $WnaVd = InputPackage::buildFromInput(); goto Duyto; S6Nsr: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'phone')); goto nIlNG; nIlNG: Session::forget('memberProfilePhoneVerify'); goto eTozf; Mdlrq: if (!empty($gFhW2)) { if ($gFhW2['id'] != MemberUser::id()) { return Response::generate(-1, '该手机已被其他账户绑定'); } if ($gFhW2['id'] == MemberUser::id() && $gFhW2['phone'] == $R4HCq) { if (!empty($gFhW2['phoneVerified'])) { return Response::generate(-1, '手机号未修改，无需重新绑定。'); } } } goto L7hap; Vtmb1: } public function phoneVerify() { goto m0na8; d0C4L: Session::put('memberProfilePhoneVerify', $MK3KS); goto voFpG; v1LTG: if (!FormatUtil::isPhone($R4HCq)) { return Response::generate(-1, '手机格式不正确'); } goto swNfX; EGp0Y: if (!empty($gFhW2)) { if ($gFhW2['id'] != MemberUser::id()) { return Response::generate(-1, '该手机已被其他账户绑定'); } if ($gFhW2['id'] == MemberUser::id() && $gFhW2['phone'] == $R4HCq) { if (!empty($gFhW2['phoneVerified'])) { return Response::generate(-1, '手机号未修改，无需重新绑定。'); } } } goto U9SXk; voFpG: Session::put('memberProfilePhoneVerifyTime', time()); goto llCUO; Eg2np: return Response::generate(0, '验证码发送成功'); goto I53Zz; Stew2: SmsSendJob::create($R4HCq, 'verify', array('code' => $MK3KS)); goto Eg2np; h059t: if (empty($R4HCq)) { return Response::generate(-1, '手机不能为空'); } goto v1LTG; swNfX: if (!CaptchaFacade::check(Input::get('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '图片验证码错误'); } goto iiVgJ; llCUO: Session::put('memberProfilePhone', $R4HCq); goto Stew2; iiVgJ: $gFhW2 = MemberUtil::getByPhone($R4HCq); goto EGp0Y; Vud3L: $MK3KS = rand(100000, 999999); goto d0C4L; m0na8: $R4HCq = Input::get('target'); goto h059t; U9SXk: if (Session::get('memberProfilePhoneVerifyTime') && $R4HCq == Session::get('memberProfilePhone')) { if (Session::get('memberProfilePhoneVerifyTime') + 60 * 2 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto Vud3L; I53Zz: } public function oauthUnbind() { goto sLDn0; sLDn0: $WnaVd = InputPackage::buildFromInput(); goto M2sMX; dmbkF: $i1mqq = MemberOauth::getOrFail($acypo); goto gZI_P; gZI_P: BizException::throwsIfEmpty('授权方式不存在', $i1mqq); goto V2etu; bRNQR: return Response::generate(0, '解绑成功', null, '[reload]'); goto t1RmB; V2etu: $F7w_x = MemberUtil::getOauthOpenId(MemberUser::id(), $i1mqq->oauthKey()); goto HM1FA; M2sMX: $acypo = $WnaVd->getTrimString('type'); goto dmbkF; HM1FA: if ($F7w_x) { MemberUtil::forgetOauth($i1mqq->oauthKey(), $F7w_x); } goto bRNQR; t1RmB: } public function delete() { goto L4lIx; zxc9F: $WnaVd = InputPackage::buildFromInput(); goto kUhH_; wzbNr: $sh5sE = MemberUser::get(); goto UBDWs; UBDWs: if ($sh5sE['deleteAtTime'] > 0) { return Response::generateError('账号正在注销中'); } goto zxc9F; UiOkY: MemberUtil::update(MemberUser::id(), array('deleteAtTime' => time() + TimeUtil::PERIOD_MONTH)); goto oNBk9; s7OyT: BizException::throwsIf('请勾选同意选项', $AKiil != 'yes'); goto UiOkY; L4lIx: if (!modstart_config('Member_DeleteEnable', false)) { return Response::generateError('注销账号功能未开启'); } goto wzbNr; oNBk9: return Response::generate(0, '申请注销成功', null, '[reload]'); goto mhVEP; kUhH_: $AKiil = $WnaVd->getTrimString('agree'); goto s7OyT; mhVEP: } public function deleteRevert() { goto qemGd; FmFic: MemberUtil::update(MemberUser::id(), array('deleteAtTime' => 0)); goto LlFlX; DapCK: $sh5sE = MemberUser::get(); goto NUNQb; NUNQb: if (empty($sh5sE['deleteAtTime'])) { return Response::generateError('账号没有注销操作'); } goto FmFic; LlFlX: return Response::generate(0, '撤销操作成功', null, '[reload]'); goto RUFRy; qemGd: if (!modstart_config('Member_DeleteEnable', false)) { return Response::generateError('注销账号功能未开启'); } goto DapCK; RUFRy: } }