<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Api\Controller; use Illuminate\Support\Facades\Log; use Illuminate\Support\Facades\Session; use Illuminate\Support\Str; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\CurlUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\FileUtil; use ModStart\Core\Util\StrUtil; use ModStart\Misc\Captcha\CaptchaFacade; use ModStart\Module\ModuleBaseController; use Module\Member\Auth\MemberUser; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserLoginedEvent; use Module\Member\Events\MemberUserLogoutEvent; use Module\Member\Events\MemberUserPasswordResetedEvent; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Oauth\AbstractOauth; use Module\Member\Provider\RegisterProcessor\AbstractMemberRegisterProcessorProvider; use Module\Member\Provider\RegisterProcessor\MemberRegisterProcessorProvider; use Module\Member\Util\MemberUtil; use Module\Member\Util\SecurityUtil; use Module\Vendor\Job\MailSendJob; use Module\Vendor\Job\SmsSendJob; use Module\Vendor\Support\ResponseCodes; use Module\Vendor\Util\SessionUtil; class AuthController extends ModuleBaseController { public function checkRedirectSafety($Wfu7_) { goto WC86j; VNunD: BizException::throws('登录跳转路径异常'); goto GGfBC; WC86j: if (!modstart_config('Member_LoginRedirectCheckEnable', false)) { return; } goto lgetA; uDLzD: $bELoJ = explode('
', $bELoJ); goto x1_Ld; x1_Ld: $bELoJ = array_filter($bELoJ); goto rBjk6; DlVs9: if (empty($Qylhp['host'])) { return; } goto yPCDN; rBjk6: foreach ($bELoJ as $viyNT) { if ($Qylhp['host'] == $viyNT) { return; } } goto VNunD; yPCDN: if ($Qylhp['host'] == Request::domain()) { return; } goto yz8AU; lgetA: $Qylhp = parse_url($Wfu7_); goto DlVs9; yz8AU: $bELoJ = modstart_config('Member_LoginRedirectWhiteList', ''); goto uDLzD; GGfBC: } public function oauthTryLogin($xdpjn = null) { goto WCfOz; dDf8Q: BizException::throwsIfEmpty('授权类型为空', $xdpjn); goto Jdco0; Jdco0: $i1mqq = MemberOauth::getOrFail($xdpjn); goto upcTl; PRxVt: BizException::throwsIfResponseError($qDqII); goto rbOdZ; heWpH: if (empty($IFLia)) { return Response::generate(-1, '用户授权数据为空'); } goto shkq2; uncAX: return Response::generate(0, null, array('memberUserId' => 0)); goto fl13g; WCfOz: $IFLia = Session::get('oauthUserInfo', array()); goto heWpH; upcTl: $qDqII = $i1mqq->processTryLogin(array('userInfo' => $IFLia)); goto PRxVt; rbOdZ: if ($qDqII['data']['memberUserId'] > 0) { goto k7v8T; Ts4DY: Session::forget('oauthUserInfo'); goto hzhgY; hzhgY: return Response::generateSuccessData(array('memberUserId' => $qDqII['data']['memberUserId'])); goto iLDVJ; k7v8T: Session::put('memberUserId', $qDqII['data']['memberUserId']); goto jy0e6; jy0e6: MemberUtil::fireLogin($qDqII['data']['memberUserId']); goto Ts4DY; iLDVJ: } goto uncAX; shkq2: if (empty($xdpjn)) { $WnaVd = InputPackage::buildFromInput(); $xdpjn = $WnaVd->getTrimString('type'); } goto dDf8Q; fl13g: } public function oauthBind($xdpjn = null) { goto KVZrn; SdZXM: if (modstart_config('Member_OauthBindPhoneEnable')) { $CoNy7['phoneVerified'] = true; } goto rPPNz; SQN0r: $i1mqq = MemberOauth::getOrFail($xdpjn); goto oygcQ; xxMmt: if ($NEhpL > 0) { goto hWCr7; A5T3G: return Response::generate(0, null, null, $Wfu7_); goto kwEGe; hWCr7: $qDqII = $i1mqq->processBindToUser(array('memberUserId' => $NEhpL, 'userInfo' => $IFLia)); goto Jx3Ln; qtY2R: Session::forget('oauthUserInfo'); goto A5T3G; Jx3Ln: BizException::throwsIfResponseError($qDqII); goto qtY2R; kwEGe: } goto C31XS; f40Zt: $slYWy = $WnaVd->getTrimString('phoneVerify'); goto cGEu1; dOk95: Session::forget('oauthUserInfo'); goto KmWbR; iIrC0: $Wfu7_ = $WnaVd->getTrimString('redirect', modstart_web_url('member')); goto rvejG; h0PoN: $qDqII = MemberUtil::register($F6CDm, $R4HCq, $UNa0Z, null, true); goto n0clw; cGEu1: $UNa0Z = $WnaVd->getEmail('email'); goto iyCX0; d5cnW: if ($qDqII['data']['memberUserId'] > 0) { goto hUU4u; ZYlvU: return Response::generateSuccessData(array('memberUserId' => $qDqII['data']['memberUserId'])); goto xBkyD; hUU4u: Session::put('memberUserId', $qDqII['data']['memberUserId']); goto FsioL; FsioL: MemberUtil::fireLogin($qDqII['data']['memberUserId']); goto ELASe; ELASe: Session::forget('oauthUserInfo'); goto ZYlvU; xBkyD: } goto rQdrL; rQdrL: if (modstart_config()->getWithEnv('registerDisable', false) && !modstart_config()->getWithEnv('registerOauthEnable', false)) { return Response::generate(-1, '用户注册已禁用'); } goto IE7Sd; rvejG: $xdpjn = $WnaVd->getTrimString('type', $xdpjn); goto bx3of; nZT1Z: $R4HCq = $WnaVd->getPhone('phone'); goto f40Zt; n0clw: if ($qDqII['code']) { return Response::generate(-1, $qDqII['msg']); } goto Ij672; UL6C6: if (!Session::get('oauthBindCaptchaPass', false)) { if (!CaptchaFacade::check($BCqnl)) { SessionUtil::atomicProduce('oauthBindCaptchaPassCount', 1); return Response::generate(-1, '请重新进行安全验证'); } } goto gbVhu; rPPNz: if (modstart_config('Member_OauthBindEmailEnable')) { $CoNy7['emailVerified'] = true; } goto qn4yE; bx3of: $IFLia = Session::get('oauthUserInfo', array()); goto IZCrT; mvDo_: if (Str::contains($F6CDm, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto mJ2OA; qn4yE: $CoNy7['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto U4GHj; e1uNa: $qDqII = $i1mqq->processBindToUser(array('memberUserId' => $FOP2J, 'userInfo' => $IFLia)); goto M1ZlX; U4GHj: if (!empty($CoNy7)) { MemberUtil::update($FOP2J, $CoNy7); } goto e1uNa; IE7Sd: $F6CDm = $WnaVd->getTrimString('username'); goto mvDo_; KmWbR: return Response::generate(0, null); goto ioS0v; iLZ9d: BizException::throwsIfResponseError($qDqII); goto d5cnW; gbVhu: if (!SessionUtil::atomicConsume('oauthBindCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto j59Qp; mJ2OA: if (preg_match('/^\\d{11}$/', $F6CDm)) { return Response::generate(-1, '用户名不能为纯数字'); } goto nZT1Z; M1ZlX: BizException::throwsIfResponseError($qDqII); goto TFMTG; Ij672: $FOP2J = $qDqII['data']['id']; goto Se9du; Xb0VG: Session::put('memberUserId', $FOP2J); goto WIRzy; iyCX0: $kuud8 = $WnaVd->getTrimString('emailVerify'); goto awtCf; oygcQ: $NEhpL = Session::get('memberUserId', 0); goto xxMmt; C31XS: $qDqII = $i1mqq->processTryLogin(array('userInfo' => $IFLia)); goto iLZ9d; KVZrn: $WnaVd = InputPackage::buildFromInput(); goto iIrC0; Se9du: $CoNy7 = array(); goto SdZXM; j59Qp: if (modstart_config('Member_OauthBindPhoneEnable')) { goto wtojh; fXHk7: if (Session::get('oauthBindPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '手机验证码已过期'); } goto Yscmb; Yscmb: if ($R4HCq != Session::get('oauthBindPhone')) { return Response::generate(-1, '两次手机不一致'); } goto k5Ldq; wtojh: if (empty($R4HCq)) { return Response::generate(-1, '请输入手机'); } goto Zg3wZ; Zg3wZ: $ADnC2 = Session::get('oauthBindPhoneVerify'); goto E6eEo; E6eEo: if ($slYWy != $ADnC2) { Log::info('Member.OauthBind.PhoneVerifyError - ' . $slYWy . ' - ' . $ADnC2); return Response::generate(-1, '手机验证码不正确.'); } goto fXHk7; k5Ldq: } goto M2NjJ; TFMTG: EventUtil::fire(new MemberUserRegisteredEvent($FOP2J)); goto lcqC4; awtCf: $BCqnl = $WnaVd->getTrimString('captcha'); goto UL6C6; lcqC4: if (!empty($IFLia['avatar'])) { goto YHnkl; praF3: if (!empty($P2pmR['body'])) { if (empty($XOYrS) && !empty($qDqII['headerMap']['content-type'])) { $XOYrS = FileUtil::mimeToExt($qDqII['headerMap']['content-type']); if (!in_array($XOYrS, $tCllb)) { Log::info('Member.Auth.OauthBind.AvatarExtGuessError - ' . $XOYrS . ' - ' . $IFLia['avatar']); $XOYrS = null; } } if (!empty($XOYrS)) { MemberUtil::setAvatar($FOP2J, $P2pmR['body'], $XOYrS); } } goto AMhGF; EKCH7: if (!in_array($XOYrS, $tCllb)) { Log::info('Member.Auth.OauthBind.AvatarExtError - ' . $XOYrS . ' - ' . $IFLia['avatar']); $XOYrS = null; } goto cIEe8; YHnkl: $XOYrS = FileUtil::extension($IFLia['avatar']); goto ZN7MA; ZN7MA: $tCllb = array('jpg', 'jpeg', 'png', 'gif'); goto EKCH7; cIEe8: $P2pmR = CurlUtil::get($IFLia['avatar'], array(), array('returnHeader' => true)); goto praF3; AMhGF: } goto Xb0VG; M2NjJ: if (modstart_config('Member_OauthBindEmailEnable')) { goto dPCfq; tUggZ: if ($UNa0Z != Session::get('oauthBindEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto VRqBi; wWH7C: if (Session::get('oauthBindEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '邮箱验证码已过期'); } goto tUggZ; R2NZ1: if ($kuud8 != $DUbj6) { Log::info('Member.OauthBind.EmailVerifyError - ' . $kuud8 . ' - ' . $DUbj6); return Response::generate(-1, '邮箱验证码不正确.'); } goto wWH7C; uNwxm: $DUbj6 = Session::get('oauthBindEmailVerify'); goto R2NZ1; dPCfq: if (empty($UNa0Z)) { return Response::generate(-1, '请输入邮箱'); } goto uNwxm; VRqBi: } goto h0PoN; IZCrT: if (empty($IFLia)) { return Response::generate(-1, '用户授权数据为空'); } goto SQN0r; WIRzy: MemberUtil::fireLogin($FOP2J); goto dOk95; ioS0v: } public function oauthCallback($xdpjn = null, $NCwsf = null) { goto sltBr; AbOrR: Session::put('oauthUserInfo', $gOLUn); goto r5SeH; GLMZ5: if (empty($teIAj)) { $teIAj = $WnaVd->getTrimString('auth_code'); } goto BA4Ug; iF7ha: $i1mqq = MemberOauth::getOrFail($xdpjn); goto mI9Kk; gRVts: if (empty($NCwsf)) { $NCwsf = $WnaVd->getTrimString('callback', null); } goto zjKQQ; NDFvD: if ($oVAck) { Session::put('oauthViewOpenId_' . $xdpjn, $gOLUn['openid']); return Response::generateSuccess(); } goto AbOrR; mI9Kk: $SdkRD = Session::get('oauthLoginParam', array()); goto Ual2o; Ual2o: Session::forget('oauthLoginParam'); goto o_62a; LJ06c: $oVAck = $WnaVd->getBoolean('view', false); goto NDFvD; E_amk: if (0 != $qDqII['code']) { return $qDqII; } goto N8s2e; zjKQQ: $teIAj = $WnaVd->getTrimString('code'); goto GLMZ5; tEkTd: if (!isset($qDqII['code'])) { return Response::generate(-1, '登录失败(返回结果为空)'); } goto E_amk; OwAGg: if (empty($xdpjn)) { $xdpjn = $WnaVd->getTrimString('type'); } goto gRVts; N8s2e: $gOLUn = $qDqII['data']['userInfo']; goto LJ06c; BA4Ug: if (empty($teIAj)) { return Response::generate(-1, '登录失败(code为空)', null, '/'); } goto iF7ha; o_62a: $qDqII = $i1mqq->processLogin(array_merge($SdkRD, array('code' => $teIAj, 'callback' => $NCwsf))); goto tEkTd; r5SeH: return Response::generate(0, 'ok', array('user' => $gOLUn)); goto Uw3FB; sltBr: $WnaVd = InputPackage::buildFromInput(); goto OwAGg; Uw3FB: } public function oauthLogin($xdpjn = null, $NCwsf = null) { goto V_8b2; vtbt_: $qDqII = $i1mqq->processRedirect($SdkRD); goto ihIvc; CztAl: $Zq2oP = $WnaVd->getBoolean('silence', false); goto NxVol; TK0Gi: return Response::generate(0, 'ok', array('redirect' => $qDqII['data']['redirect'])); goto mT08z; ihIvc: BizException::throwsIfResponseError($qDqII); goto TK0Gi; Us9gz: $SdkRD = array('callback' => $NCwsf, 'silence' => $Zq2oP); goto DL4ey; ZS1DU: if (empty($xdpjn)) { $xdpjn = $WnaVd->getTrimString('type'); } goto t5IVi; V_8b2: if ($y_Rto = modstart_config()->getWithEnv('oauthDisableText')) { return Response::generateError($y_Rto); } goto QZfaz; t5IVi: if (empty($NCwsf)) { $NCwsf = $WnaVd->getTrimString('callback', 'NO_CALLBACK'); } goto CztAl; NxVol: $i1mqq = MemberOauth::getOrFail($xdpjn); goto Us9gz; QZfaz: $WnaVd = InputPackage::buildFromInput(); goto ZS1DU; DL4ey: Session::put('oauthLoginParam', $SdkRD); goto vtbt_; mT08z: } public function ssoClientLogoutPrepare() { goto ltVCE; OfOFp: if (empty($FHCS0)) { return Response::generate(-1, '请配置 同步登录服务端地址'); } goto paZyL; HpsLU: $FHCS0 = modstart_config('ssoClientServer', ''); goto OfOFp; ltVCE: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, '请开启 同步登录客户端'); } goto dKmaj; dKmaj: $WnaVd = InputPackage::buildFromInput(); goto qR7uY; DMtcl: return Response::generate(0, 'ok', array('redirect' => $Wfu7_)); goto r5Hiz; qR7uY: $AZ6pH = $WnaVd->getTrimString('domainUrl'); goto HpsLU; paZyL: $Wfu7_ = $FHCS0 . '_logout' . '?' . http_build_query(array('redirect' => $AZ6pH . '/sso/client_logout')); goto DMtcl; r5Hiz: } public function ssoClientLogout() { goto MRAQ0; AooYv: return Response::generate(0, 'ok'); goto sOM_9; CujW_: Session::forget('memberUserId'); goto AooYv; MRAQ0: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, '请开启 同步登录客户端'); } goto CujW_; sOM_9: } public function ssoServerLogout() { goto P5hxo; RimLe: return Response::generate(0, 'ok'); goto dwxkq; zBTvE: Session::forget('memberUserId'); goto RimLe; P5hxo: if (!modstart_config('ssoServerEnable', false)) { return Response::generate(-1, '请开启 同步登录服务端'); } goto zBTvE; dwxkq: } public function ssoServerSuccess() { goto HlDJo; pPXxB: $WnaVd = InputPackage::buildFromInput(); goto V8py3; zFFdN: foreach ($wrfsN as $viyNT) { if (trim($viyNT) == $ES1S3) { $wxnAu = true; } } goto Yuu3L; evTiO: $JwDOv = md5(md5($iVT9A) . md5($js0ll . '') . md5($D3pIg) . md5($F6CDm)); goto kMROX; cZ_OW: $iVT9A = modstart_config('ssoServerSecret'); goto daBp6; Yh4_v: $F6CDm = $sh5sE['username']; goto evTiO; Yuu3L: if (!$wxnAu) { return Response::generate(-1, '数据错误(2)'); } goto YjlZg; YjlZg: $D3pIg = $AZ6pH . '/sso/server'; goto sMTXI; CxXme: $wrfsN = explode('
', modstart_config('ssoServerClientList', '')); goto ht6gr; V8py3: $ES1S3 = $WnaVd->getTrimString('client'); goto vcdcn; KAO49: if (empty($AZ6pH) || empty($ES1S3)) { return Response::generate(-1, '数据错误'); } goto CxXme; npHuo: return Response::generate(0, null, array('redirect' => $Wfu7_)); goto yq71w; sMTXI: $js0ll = time(); goto Yh4_v; kMROX: $Wfu7_ = $ES1S3 . '?server=' . urlencode($D3pIg) . '&timestamp=' . $js0ll . '&username=' . urlencode(base64_encode($F6CDm)) . '&sign=' . $JwDOv; goto npHuo; HlDJo: if (!modstart_config('ssoServerEnable', false)) { return Response::generate(-1, '请开启 同步登录服务端'); } goto Q2u3F; vcdcn: $AZ6pH = $WnaVd->getTrimString('domainUrl'); goto KAO49; ht6gr: $wxnAu = false; goto zFFdN; AYX04: $sh5sE = MemberUtil::get($FOP2J); goto cZ_OW; Q2u3F: $FOP2J = Session::get('memberUserId', 0); goto IBlHH; daBp6: if (empty($iVT9A)) { return Response::generate(-1, '请设置 同步登录服务端通讯秘钥'); } goto pPXxB; IBlHH: if (!$FOP2J) { return Response::generate(-1, '未登录'); } goto AYX04; yq71w: } public function ssoServer() { goto Nhasq; Cup36: return Response::generate(0, 'ok', array('isLogin' => $TBpJn)); goto RCQd0; gFDMg: $WnaVd = InputPackage::buildFromInput(); goto WzmY0; N12fJ: if ($JwDOv != $d8ArT) { return Response::generate(-1, 'sign 错误'); } goto Cvkak; oohvT: if (!$wxnAu) { return Response::generate(-1, '请在 同步登陆服务端增加客户端地址 ' . $ES1S3); } goto MwBXV; Hrx6g: $d8ArT = md5(md5($OAlA5) . md5($js0ll . '') . md5($ES1S3)); goto N12fJ; bSaQU: $js0ll = $WnaVd->getInteger('timestamp'); goto v42Sf; WzmY0: $ES1S3 = $WnaVd->getTrimString('client'); goto bSaQU; v42Sf: $JwDOv = $WnaVd->getTrimString('sign'); goto eeb0J; Nhasq: if (!modstart_config('ssoServerEnable', false)) { return Response::generate(-1, '请开启 同步登录服务端'); } goto gFDMg; hpG43: if (empty($js0ll)) { return Response::generate(-1, 'timestamp 为空'); } goto LQzjV; LQzjV: if (empty($JwDOv)) { return Response::generate(-1, 'sign 为空'); } goto oE756; oE756: $OAlA5 = modstart_config('ssoServerSecret'); goto cgTyA; MwBXV: $TBpJn = false; goto Fa5Bk; Cvkak: if (abs(time() - $js0ll) > 3600) { return Response::generate(-1, 'timestamp 错误'); } goto pzSir; cgTyA: if (empty($OAlA5)) { return Response::generate(-1, '请设置 同步登录服务端通讯秘钥'); } goto Hrx6g; B1P_E: foreach ($wrfsN as $viyNT) { if (trim($viyNT) == $ES1S3) { $wxnAu = true; } } goto oohvT; pzSir: $wrfsN = explode('
', modstart_config('ssoServerClientList', '')); goto Jn9Ls; Fa5Bk: if (intval(Session::get('memberUserId', 0)) > 0) { $TBpJn = true; } goto Cup36; eeb0J: if (empty($ES1S3)) { return Response::generate(-1, 'client 为空'); } goto hpG43; Jn9Ls: $wxnAu = false; goto B1P_E; RCQd0: } public function ssoClient() { goto QDYMz; H7daA: if (empty($FHCS0)) { return Response::generate(-1, '请配置 同步登录服务端地址'); } goto v9Zfx; hv5Ni: $sh5sE = MemberUtil::getByUsername($F6CDm); goto ah1UM; DWjpp: $JwDOv = $WnaVd->getTrimString('sign'); goto keoy2; aR0jk: if (empty($js0ll)) { return Response::generate(-1, 'timestamp为空'); } goto tgwvH; yfJe8: $D3pIg = $WnaVd->getTrimString('server'); goto efqSi; gRMts: if (empty($Kfrho)) { return Response::generate(-1, '请设置 同步登录客户端通讯秘钥'); } goto qeTJQ; Vde5_: if ($D3pIg != $FHCS0) { return Response::generate(-1, '同步登录 服务端地址不是配置的' . $FHCS0); } goto hv5Ni; v9Zfx: $Kfrho = modstart_config('ssoClientSecret'); goto gRMts; SUgQN: if (empty($F6CDm)) { return Response::generate(-1, '同步登录返回的用户名为空'); } goto aR0jk; kBuZB: Session::put('memberUserId', $sh5sE['id']); goto anrdY; qeTJQ: $WnaVd = InputPackage::buildFromInput(); goto yfJe8; QDYMz: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, '请开启 同步登录客户端'); } goto bPv1I; bPv1I: $FHCS0 = modstart_config('ssoClientServer', ''); goto H7daA; ah1UM: if (empty($sh5sE)) { goto djTd9; qqq3I: if ($qDqII['code']) { return Response::generate(-1, $qDqII['msg']); } goto pxJYP; pxJYP: $sh5sE = MemberUtil::get($qDqII['data']['id']); goto jdTTp; djTd9: $qDqII = MemberUtil::register($F6CDm, null, null, null, true); goto qqq3I; jdTTp: } goto kBuZB; jXJd7: return Response::generate(0, 'ok'); goto HJ0M2; keoy2: $F6CDm = @base64_decode($WnaVd->getTrimString('username')); goto SUgQN; efqSi: $js0ll = $WnaVd->getInteger('timestamp'); goto DWjpp; ie31w: $d8ArT = md5(md5($Kfrho) . md5($js0ll . '') . md5($D3pIg) . md5($F6CDm)); goto rCWWO; rCWWO: if ($JwDOv != $d8ArT) { return Response::generate(-1, 'sign错误'); } goto Ow9LN; tgwvH: if (empty($JwDOv)) { return Response::generate(-1, 'sign为空'); } goto ie31w; anrdY: MemberUtil::fireLogin($sh5sE['id']); goto jXJd7; Ow9LN: if (abs(time() - $js0ll) > 3600) { return Response::generate(-1, 'timestamp错误'); } goto Vde5_; HJ0M2: } public function ssoClientPrepare() { goto TwxB_; TwxB_: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, 'SSO未开启'); } goto umSuo; umSuo: $FHCS0 = modstart_config('ssoClientServer'); goto px_cF; RHN1L: $Wfu7_ = $FHCS0 . '?client=' . urlencode($ES1S3) . '&timestamp=' . $js0ll . '&sign=' . $JwDOv; goto UoinS; bkqaT: if (!Str::endsWith($ES1S3, '/sso/client')) { return Response::generate(-1, 'client参数错误'); } goto uXQ3_; px_cF: $Kfrho = modstart_config('ssoClientSecret'); goto dzfxk; YKozu: $ES1S3 = $WnaVd->getTrimString('client', '/'); goto bkqaT; nzDMS: $JwDOv = md5(md5($Kfrho) . md5($js0ll . '') . md5($ES1S3)); goto RHN1L; dzfxk: $WnaVd = InputPackage::buildFromInput(); goto YKozu; UoinS: return Response::generate(0, 'ok', array('redirect' => $Wfu7_)); goto vrEuD; uXQ3_: $js0ll = time(); goto nzDMS; vrEuD: } public function logout() { goto AdaBL; Osb0N: Session::forget('memberUserId'); goto N1Mya; p2fL4: return Response::generateSuccess(); goto MDEB9; AdaBL: $FOP2J = MemberUser::id(); goto Osb0N; N1Mya: if ($FOP2J > 0) { EventUtil::fire(new MemberUserLogoutEvent($FOP2J)); } goto p2fL4; MDEB9: } public function login() { goto Bmjf1; tKovK: $pKCvN = $WnaVd->getTrimString('password'); goto gWhdF; TmaDj: $sh5sE = null; goto ICtET; YceBT: MemberUtil::fireLogin($sh5sE['id']); goto Bkned; Bkned: EventUtil::fire(new MemberUserLoginedEvent($sh5sE['id'])); goto ibrjK; yeWIy: if (!$sh5sE) { $qDqII = MemberUtil::login($F6CDm, null, null, $pKCvN); if (0 == $qDqII['code']) { $sh5sE = $qDqII['data']; } } goto vT0Z9; ZlvXZ: if (empty($pKCvN)) { return Response::generate(-1, '请输入密码'); } goto GMAIV; fyFLe: if (!$sh5sE) { $FebY3 = Session::pull('memberUserLoginFailedTip', null); return Response::generate(ResponseCodes::CAPTCHA_ERROR, '登录失败:用户或密码错误' . ($FebY3 ? '，' . $FebY3 : '')); } goto VLo6j; GMAIV: if (modstart_config('loginCaptchaEnable', false)) { $Mim0e = SecurityUtil::loginCaptchaProvider(); if ($Mim0e) { $qDqII = $Mim0e->validate(); if (Response::isError($qDqII)) { return Response::generate(-1, $qDqII['msg']); } } else { if (!CaptchaFacade::check($WnaVd->getTrimString('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '登录失败:图片验证码错误', null, '[js]$(\'[data-captcha]\').click();'); } } } goto TmaDj; VLo6j: Session::put('memberUserId', $sh5sE['id']); goto YceBT; gWhdF: if (empty($F6CDm)) { return Response::generate(-1, '请输入用户'); } goto ZlvXZ; Bmjf1: $WnaVd = InputPackage::buildFromInput(); goto JADem; Kjd1C: if (!$sh5sE) { $qDqII = MemberUtil::login(null, null, $F6CDm, $pKCvN); if (0 == $qDqII['code']) { $sh5sE = $qDqII['data']; } } goto fyFLe; JADem: $F6CDm = $WnaVd->getTrimString('username'); goto tKovK; ibrjK: return Response::generateSuccess(); goto edrym; ICtET: $UJH6U = null; goto yeWIy; vT0Z9: if (!$sh5sE) { $qDqII = MemberUtil::login(null, $F6CDm, null, $pKCvN); if (0 == $qDqII['code']) { $sh5sE = $qDqII['data']; } } goto Kjd1C; edrym: } public function loginCaptchaRaw() { return CaptchaFacade::create('default'); } public function loginPhoneCaptchaRaw() { return CaptchaFacade::create('default'); } public function loginPhone() { goto zPwtS; MDOHx: Session::forget('loginPhone'); goto LcOra; LcOra: Session::put('memberUserId', $sh5sE['id']); goto Psmkd; Z92ba: $MK3KS = $WnaVd->getTrimString('verify'); goto tJQek; Sp6T4: Session::forget('loginPhoneVerify'); goto XV6_8; PGwRs: if ($MK3KS != $JqFey) { Log::info('Member.LoginPhone.LoginVerifyError - ' . $MK3KS . ' - ' . $JqFey); return Response::generate(-1, '手机验证码不正确'); } goto yPnYH; XV6_8: Session::forget('loginPhoneVerifyTime'); goto MDOHx; Psmkd: MemberUtil::fireLogin($sh5sE['id']); goto r54zD; eIJob: $WnaVd = InputPackage::buildFromInput(); goto suP1H; cOG40: if (empty($sh5sE)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto Sp6T4; yPnYH: if (Session::get('loginPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '手机验证码已过期'); } goto zbHyk; c5Oao: return Response::generate(0, null); goto RUt1T; y8xbL: if (empty($MK3KS)) { return Response::generate(-1, '验证码不能为空'); } goto UppSI; zbHyk: if ($R4HCq != Session::get('loginPhone')) { return Response::generate(-1, '两次手机不一致'); } goto iYvQc; iYvQc: $sh5sE = MemberUtil::getByPhone($R4HCq); goto UN2xu; UppSI: $JqFey = Session::get('loginPhoneVerify'); goto PGwRs; zPwtS: if (!modstart_config('Member_LoginPhoneEnable', false)) { return Response::generate(-1, '手机快捷登录未开启'); } goto eIJob; r54zD: EventUtil::fire(new MemberUserLoginedEvent($sh5sE)); goto c5Oao; tJQek: if (empty($R4HCq)) { return Response::generate(-1, '手机为空或不正确'); } goto y8xbL; suP1H: $R4HCq = $WnaVd->getPhone('phone'); goto Z92ba; UN2xu: if (empty($sh5sE) && modstart_config('Member_LoginPhoneAutoRegister', false)) { goto rzB3T; M2ro4: $qDqII = MemberUtil::register(null, $R4HCq, null, null, true); goto uIcFp; rzB3T: foreach (MemberRegisterProcessorProvider::listAll() as $VPEOp) { $qDqII = $VPEOp->preCheck(); if (Response::isError($qDqII)) { return $qDqII; } } goto M2ro4; i77DD: $FOP2J = $qDqII['data']['id']; goto uFKKE; uFKKE: MemberUtil::autoSetUsernameNickname($FOP2J, modstart_config('Member_LoginPhoneNameSuggest', '用户')); goto GINtH; F1MTu: foreach (MemberRegisterProcessorProvider::listAll() as $VPEOp) { $VPEOp->postProcess($FOP2J); } goto VSI4Q; bQtGa: Session::forget('registerCaptchaPass'); goto F1MTu; iEf8q: $CoNy7['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto qSaTr; QzhNz: EventUtil::fire(new MemberUserRegisteredEvent($FOP2J)); goto bQtGa; VSI4Q: $sh5sE = MemberUtil::get($FOP2J); goto zVDLL; GINtH: $CoNy7 = array(); goto oxXv3; oxXv3: $CoNy7['phoneVerified'] = true; goto iEf8q; uIcFp: if ($qDqII['code']) { return Response::generate(-1, $qDqII['msg']); } goto i77DD; qSaTr: if (!empty($CoNy7)) { MemberUtil::update($FOP2J, $CoNy7); } goto QzhNz; zVDLL: } goto cOG40; RUt1T: } public function loginPhoneVerify() { goto twHnd; Gv7PK: return Response::generate(0, '验证码发送成功'); goto FjXXN; q23qJ: $WnaVd = InputPackage::buildFromInput(); goto EgRpo; twHnd: if (!modstart_config('Member_LoginPhoneEnable', false)) { return Response::generate(-1, '手机快捷登录未开启'); } goto q23qJ; van1o: $VPEOp = SecurityUtil::loginCaptchaProvider(); goto ob0BU; t4qpc: Session::put('loginPhoneVerifyTime', time()); goto oJI7j; w0P2_: SmsSendJob::create($R4HCq, 'verify', array('code' => $MK3KS)); goto Gv7PK; C7Ymm: if (empty($sh5sE) && !modstart_config('Member_LoginPhoneAutoRegister', false)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto MZXQR; oJI7j: Session::put('loginPhone', $R4HCq); goto w0P2_; kpfVI: $MK3KS = rand(100000, 999999); goto vOEHM; ob0BU: if ($VPEOp) { $qDqII = $VPEOp->validate(); if (Response::isError($qDqII)) { return $qDqII; } } else { $BCqnl = $WnaVd->getTrimString('captcha'); if (!CaptchaFacade::check($BCqnl)) { return Response::generate(-1, '图片验证码错误'); } } goto rJ0X_; EgRpo: $R4HCq = $WnaVd->getPhone('target'); goto laztN; vOEHM: Session::put('loginPhoneVerify', $MK3KS); goto t4qpc; laztN: if (empty($R4HCq)) { return Response::generate(-1, '手机为空或格式不正确'); } goto van1o; rJ0X_: $sh5sE = MemberUtil::getByPhone($R4HCq); goto C7Ymm; MZXQR: if (Session::get('loginPhoneVerifyTime') && $R4HCq == Session::get('loginPhone')) { if (Session::get('loginPhoneVerifyTime') + 60 > time()) { return Response::generate(-1, '验证码发送频繁，请稍后再试!'); } } goto kpfVI; FjXXN: } public function loginPhoneCaptcha() { $BCqnl = $this->loginCaptchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($BCqnl->getOriginalContent()))); } public function loginCaptcha() { $BCqnl = $this->loginCaptchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($BCqnl->getOriginalContent()))); } public function registerPhone() { goto vFM8q; Zoa5Y: $CoNy7['phoneVerified'] = true; goto mLn37; CEy_2: foreach (MemberRegisterProcessorProvider::listAll() as $VPEOp) { $qDqII = $VPEOp->preCheck(); if (Response::isError($qDqII)) { return $qDqII; } } goto y08A8; x4K0g: Session::forget('registerCaptchaPass'); goto GGjpB; GGjpB: foreach (MemberRegisterProcessorProvider::listAll() as $VPEOp) { $VPEOp->postProcess($FOP2J); } goto UdTt6; UdTt6: Session::put('memberUserId', $FOP2J); goto JiXqP; fCDmm: if (empty($R4HCq)) { return Response::generate(-1, '请输入手机'); } goto S4oHR; FB1ya: $WnaVd = InputPackage::buildFromInput(); goto E7d5Q; iApSX: if (!modstart_config('Member_RegisterPhoneEnable', false)) { return Response::generate(-1, '手机快速注册未开启'); } goto FB1ya; vFM8q: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto iApSX; n4NxT: if ($R4HCq != Session::get('registerPhone')) { return Response::generate(-1, '两次手机不一致'); } goto CEy_2; rkZbc: if (!empty($CoNy7)) { MemberUtil::update($FOP2J, $CoNy7); } goto z3wwh; kbgM5: if ($qDqII['code']) { return Response::generate(-1, $qDqII['msg']); } goto AT3U_; S4oHR: $ADnC2 = Session::get('registerPhoneVerify'); goto EEoeM; stNRU: if (Session::get('registerPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '手机验证码已过期'); } goto n4NxT; AT3U_: $FOP2J = $qDqII['data']['id']; goto Eu0tM; ciOyJ: $CoNy7 = array(); goto Zoa5Y; lzGAK: $slYWy = $WnaVd->getTrimString('phoneVerify'); goto fCDmm; y08A8: $qDqII = MemberUtil::register(null, $R4HCq, null, null, true); goto kbgM5; URR9r: EventUtil::fire(new MemberUserLoginedEvent($FOP2J)); goto wyitk; z3wwh: EventUtil::fire(new MemberUserRegisteredEvent($FOP2J)); goto x4K0g; mLn37: $CoNy7['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto rkZbc; np4Tn: $R4HCq = $WnaVd->getPhone('phone'); goto lzGAK; E7d5Q: if (modstart_config('Member_AgreementEnable', false)) { if (!$WnaVd->getBoolean('agreement')) { return Response::generateError('请先同意 ' . modstart_config('Member_AgreementTitle', '用户使用协议')); } } goto np4Tn; EEoeM: if ($slYWy != $ADnC2) { Log::info('Member.RegisterPhone.PhoneVerifyError - ' . $slYWy . ' - ' . $ADnC2); return Response::generate(-1, '手机验证码不正确.'); } goto stNRU; JiXqP: MemberUtil::fireLogin($FOP2J); goto URR9r; Eu0tM: MemberUtil::autoSetUsernameNickname($FOP2J, modstart_config('Member_LoginPhoneNameSuggest', '用户')); goto ciOyJ; wyitk: return Response::generate(0, '注册成功', array('id' => $FOP2J)); goto nNyAI; nNyAI: } public function register() { goto hbKus; hbKus: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto O97wA; oeqgZ: $CoNy7['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto WBXT5; EJtVE: if (modstart_config('Member_AgreementEnable', false)) { if (!$WnaVd->getBoolean('agreement')) { return Response::generateError('请先同意 ' . modstart_config('Member_AgreementTitle', '用户使用协议')); } } goto xFUn6; aMD8C: $R4HCq = $WnaVd->getPhone('phone'); goto Q57Ty; MqSFb: if (modstart_config('registerEmailEnable')) { $CoNy7['emailVerified'] = true; } goto oeqgZ; ecO7Q: $nWcU7 = $WnaVd->getTrimString('passwordRepeat'); goto CpFNq; VFFNd: if ($qDqII['code']) { return Response::generate(-1, $qDqII['msg']); } goto n1E3W; FjQfq: $qDqII = MemberUtil::register($F6CDm, $R4HCq, $UNa0Z, $pKCvN); goto VFFNd; n1E3W: $FOP2J = $qDqII['data']['id']; goto dqqLC; pTQq8: if (empty($pKCvN)) { return Response::generate(-1, '请输入密码'); } goto hNwOi; dqqLC: $CoNy7 = array(); goto zddcw; T3MzB: if (Str::contains($F6CDm, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto l5det; ltTmN: $pKCvN = $WnaVd->getTrimString('password'); goto ecO7Q; WBXT5: if (!empty($CoNy7)) { MemberUtil::update($FOP2J, $CoNy7); } goto RX3kA; l5det: if (preg_match('/^\\d{11}$/', $F6CDm)) { return Response::generate(-1, '用户名不能为纯数字'); } goto C6tzB; RX3kA: EventUtil::fire(new MemberUserRegisteredEvent($FOP2J)); goto ptuUR; Ej_Tl: return Response::generate(0, '注册成功', array('id' => $FOP2J)); goto m_HB_; ptuUR: Session::forget('registerCaptchaPass'); goto HFmwR; BxGFm: foreach (MemberRegisterProcessorProvider::listAll() as $VPEOp) { $qDqII = $VPEOp->preCheck(); if (Response::isError($qDqII)) { return $qDqII; } } goto FjQfq; I1VLg: if (modstart_config('registerPhoneEnable')) { goto ZcsG1; UeQ0C: if ($R4HCq != Session::get('registerPhone')) { return Response::generate(-1, '两次手机不一致'); } goto n5qM7; qKNDi: if ($slYWy != $ADnC2) { Log::info('Member.Register.PhoneVerifyError - ' . $slYWy . ' - ' . $ADnC2); return Response::generate(-1, '手机验证码不正确.'); } goto fT03T; fT03T: if (Session::get('registerPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '手机验证码已过期'); } goto UeQ0C; RBsrF: $ADnC2 = Session::get('registerPhoneVerify'); goto qKNDi; ZcsG1: if (empty($R4HCq)) { return Response::generate(-1, '请输入手机'); } goto RBsrF; n5qM7: } goto T2fPl; O97wA: $WnaVd = InputPackage::buildFromInput(); goto EJtVE; C6tzB: if (!Session::get('registerCaptchaPass', false)) { if (!CaptchaFacade::check($BCqnl)) { SessionUtil::atomicProduce('registerCaptchaPassCount', 1); return Response::generate(-1, '请重新进行安全验证'); } } goto flu9X; Q57Ty: $slYWy = $WnaVd->getTrimString('phoneVerify'); goto D7vWN; D7vWN: $UNa0Z = $WnaVd->getEmail('email'); goto cm2z4; hNwOi: if ($pKCvN != $nWcU7) { return Response::generate(-1, '两次输入密码不一致'); } goto BxGFm; CpFNq: $BCqnl = $WnaVd->getTrimString('captcha'); goto ungS6; xFUn6: $F6CDm = $WnaVd->getTrimString('username'); goto aMD8C; zddcw: if (modstart_config('registerPhoneEnable')) { $CoNy7['phoneVerified'] = true; } goto MqSFb; flu9X: if (!SessionUtil::atomicConsume('registerCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto I1VLg; T2fPl: if (modstart_config('registerEmailEnable')) { goto ZmGtX; hSvKa: if ($UNa0Z != Session::get('registerEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto yr6Fi; TkngX: $DUbj6 = Session::get('registerEmailVerify'); goto m8frk; m8frk: if ($kuud8 != $DUbj6) { Log::info('Member.Register.EmailVerifyError - ' . $kuud8 . ' - ' . $DUbj6); return Response::generate(-1, '邮箱验证码不正确.'); } goto oiblv; ZmGtX: if (empty($UNa0Z)) { return Response::generate(-1, '请输入邮箱'); } goto TkngX; oiblv: if (Session::get('registerEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '邮箱验证码已过期'); } goto hSvKa; yr6Fi: } goto pTQq8; HFmwR: foreach (MemberRegisterProcessorProvider::listAll() as $VPEOp) { $VPEOp->postProcess($FOP2J); } goto Ej_Tl; ungS6: if (empty($F6CDm)) { return Response::generate(-1, '用户名不能为空'); } goto T3MzB; cm2z4: $kuud8 = $WnaVd->getTrimString('emailVerify'); goto ltTmN; m_HB_: } public function registerEmailVerify() { goto B2suv; x5YBz: $UNa0Z = $WnaVd->getEmail('target'); goto TUPKG; ucpj2: Session::put('registerEmailVerify', $MK3KS); goto IDin1; IDin1: Session::put('registerEmailVerifyTime', time()); goto teTCN; w68up: if (!Session::get('registerCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto O0Fsg; cs3Yb: MailSendJob::create($UNa0Z, '注册账户验证码', 'verify', array('code' => $MK3KS)); goto ucpj2; TUPKG: if (empty($UNa0Z)) { return Response::generate(-1, '邮箱不能为空'); } goto w68up; LD88N: if (!empty($sh5sE)) { return Response::generate(-1, '邮箱已经被占用'); } goto SqDMZ; Eh1te: $WnaVd = InputPackage::buildFromInput(); goto x5YBz; B2suv: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto Hnrq3; OfmMM: return Response::generate(0, '验证码发送成功'); goto ZAoz0; O0Fsg: if (!SessionUtil::atomicConsume('registerCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto XMjZW; Hnrq3: if (!modstart_config('registerEmailEnable')) { return Response::generate(-1, '注册未开启邮箱'); } goto Eh1te; SqDMZ: if (Session::get('registerEmailVerifyTime') && $UNa0Z == Session::get('registerEmail')) { if (Session::get('registerEmailVerifyTime') + 60 > time()) { return Response::generate(-1, '验证码发送频繁，请稍后再试!'); } } goto JryqE; JryqE: $MK3KS = rand(100000, 999999); goto cs3Yb; XMjZW: $sh5sE = MemberUtil::getByEmail($UNa0Z); goto LD88N; teTCN: Session::put('registerEmail', $UNa0Z); goto OfmMM; ZAoz0: } public function registerPhoneVerify() { goto MdnKp; FhIUC: if (Session::get('registerPhoneVerifyTime') && $R4HCq == Session::get('registerPhone')) { if (Session::get('registerPhoneVerifyTime') + 60 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto ojMG8; GwaK6: Session::put('registerPhoneVerify', $MK3KS); goto rtx5m; dDZNT: return Response::generate(0, '验证码发送成功'); goto RY324; bmpug: if (!SessionUtil::atomicConsume('registerCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto UwqOp; fGBNL: if (!empty($sh5sE)) { return Response::generate(-1, '手机已经被占用'); } goto FhIUC; UwqOp: $sh5sE = MemberUtil::getByPhone($R4HCq); goto fGBNL; XoMvk: if (!Session::get('registerCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto bmpug; Ly7rw: SmsSendJob::create($R4HCq, 'verify', array('code' => $MK3KS)); goto GwaK6; rXxwS: $WnaVd = InputPackage::buildFromInput(); goto en5Jm; MdnKp: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto vFytc; ojMG8: $MK3KS = rand(100000, 999999); goto Ly7rw; en5Jm: $R4HCq = $WnaVd->getPhone('target'); goto noyPT; GjQAa: Session::put('registerPhone', $R4HCq); goto dDZNT; vFytc: if (!modstart_config('registerPhoneEnable')) { return Response::generate(-1, '注册未开启手机'); } goto rXxwS; noyPT: if (empty($R4HCq)) { return Response::generate(-1, '手机不能为空'); } goto XoMvk; rtx5m: Session::put('registerPhoneVerifyTime', time()); goto GjQAa; RY324: } public function registerCaptchaVerify() { goto e0CgA; jX1KJ: if ($VPEOp) { $qDqII = $VPEOp->validate(); if (Response::isError($qDqII)) { return $qDqII; } } else { goto TE3H8; m1Vyw: $BCqnl = $WnaVd->getTrimString('captcha'); goto DjUZM; DjUZM: if (!CaptchaFacade::check($BCqnl)) { SessionUtil::atomicRemove('registerCaptchaPassCount'); return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto xVUdU; TE3H8: $WnaVd = InputPackage::buildFromInput(); goto m1Vyw; xVUdU: } goto a4OY_; NRLVF: $PapN1 = 1; goto XCV19; Sv_wC: if (modstart_config('registerPhoneEnable')) { $PapN1++; } goto Y1prH; XCV19: if (modstart_config('registerEmailEnable')) { $PapN1++; } goto Sv_wC; a4OY_: Session::put('registerCaptchaPass', true); goto NRLVF; e0CgA: $VPEOp = SecurityUtil::registerCaptchaProvider(); goto jX1KJ; OeMub: return Response::generateSuccess(); goto ck38L; Y1prH: SessionUtil::atomicProduce('registerCaptchaPassCount', $PapN1); goto OeMub; ck38L: } public function oauthBindCaptchaVerify() { goto NogEo; ZJSBt: if (modstart_config('Member_OauthBindPhoneEnable')) { $IUhd_++; } goto Xv8kZ; x6Oaw: return Response::generateSuccess(); goto Cw5mo; wM5B7: if (!CaptchaFacade::check($BCqnl)) { SessionUtil::atomicRemove('oauthBindCaptchaPassCount'); return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto WDqBx; Xv8kZ: if (modstart_config('Member_OauthBindEmailEnable')) { $IUhd_++; } goto Z51oc; WDqBx: Session::put('oauthBindCaptchaPass', true); goto CEiSl; M_RpT: $BCqnl = $WnaVd->getTrimString('captcha'); goto wM5B7; CEiSl: $IUhd_ = 1; goto ZJSBt; Z51oc: SessionUtil::atomicProduce('oauthBindCaptchaPassCount', $IUhd_); goto x6Oaw; NogEo: $WnaVd = InputPackage::buildFromInput(); goto M_RpT; Cw5mo: } public function oauthBindCaptchaRaw() { return CaptchaFacade::create('default'); } public function oauthBindCaptcha() { goto LLxkM; wB5J7: $BCqnl = $this->oauthBindCaptchaRaw(); goto C_xJY; LLxkM: Session::forget('oauthBindCaptchaPass'); goto wB5J7; C_xJY: return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($BCqnl->getOriginalContent()))); goto aL_nA; aL_nA: } public function oauthBindEmailVerify() { goto aYLU0; UzG0m: MailSendJob::create($UNa0Z, '注册账户验证码', 'verify', array('code' => $MK3KS)); goto YRygs; C914l: if (!Session::get('oauthBindCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto brCWY; g6c4t: return Response::generate(0, '验证码发送成功'); goto snsLc; tZCWu: if (!empty($sh5sE)) { return Response::generate(-1, '邮箱已经被占用'); } goto DwYTc; DwYTc: if (Session::get('oauthBindEmailVerifyTime') && $UNa0Z == Session::get('oauthBindEmail')) { if (Session::get('oauthBindEmailVerifyTime') + 60 > time()) { return Response::generate(-1, '验证码发送频繁，请稍后再试!'); } } goto fYiuF; YRygs: Session::put('oauthBindEmailVerify', $MK3KS); goto J38ur; q6ZpJ: if (empty($UNa0Z)) { return Response::generate(-1, '邮箱不能为空'); } goto C914l; aYLU0: if (!modstart_config('Member_OauthBindEmailEnable')) { return Response::generate(-1, '授权登录未开启邮箱'); } goto WG7T0; fYiuF: $MK3KS = rand(100000, 999999); goto UzG0m; RkSA7: Session::put('oauthBindEmail', $UNa0Z); goto g6c4t; J38ur: Session::put('oauthBindEmailVerifyTime', time()); goto RkSA7; WG7T0: $WnaVd = InputPackage::buildFromInput(); goto zNvHw; brCWY: if (!SessionUtil::atomicConsume('oauthBindCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto zgJFH; zNvHw: $UNa0Z = $WnaVd->getEmail('target'); goto q6ZpJ; zgJFH: $sh5sE = MemberUtil::getByEmail($UNa0Z); goto tZCWu; snsLc: } public function oauthBindPhoneVerify() { goto ynl0p; N1CIc: $WnaVd = InputPackage::buildFromInput(); goto nJg_a; yMBEC: $MK3KS = rand(100000, 999999); goto Oojdq; HmOBB: return Response::generate(0, '验证码发送成功'); goto JA9TR; Oojdq: SmsSendJob::create($R4HCq, 'verify', array('code' => $MK3KS)); goto KCcGV; djaiw: $sh5sE = MemberUtil::getByPhone($R4HCq); goto XuU0Y; FVjq9: Session::put('oauthBindPhone', $R4HCq); goto HmOBB; fY8B5: if (empty($R4HCq)) { return Response::generate(-1, '手机不能为空'); } goto Ibs4F; Ibs4F: if (!Session::get('oauthBindCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto vpboq; ujfxr: Session::put('oauthBindPhoneVerifyTime', time()); goto FVjq9; vpboq: if (!SessionUtil::atomicConsume('oauthBindCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto djaiw; KCcGV: Session::put('oauthBindPhoneVerify', $MK3KS); goto ujfxr; XuU0Y: if (!empty($sh5sE)) { return Response::generate(-1, '手机已经被占用'); } goto Xi8cO; nJg_a: $R4HCq = $WnaVd->getPhone('target'); goto fY8B5; ynl0p: if (!modstart_config('Member_OauthBindPhoneEnable')) { return Response::generate(-1, '注册未开启手机'); } goto N1CIc; Xi8cO: if (Session::get('oauthBindPhoneVerifyTime') && $R4HCq == Session::get('oauthBindPhone')) { if (Session::get('oauthBindPhoneVerifyTime') + 60 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto yMBEC; JA9TR: } public function registerCaptchaRaw() { return CaptchaFacade::create('default'); } public function registerCaptcha() { goto oltJu; wK5xo: $BCqnl = $this->registerCaptchaRaw(); goto iKopN; oltJu: Session::forget('registerCaptchaPass'); goto wK5xo; iKopN: return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($BCqnl->getOriginalContent()))); goto Ta0w0; Ta0w0: } public function retrievePhone() { goto HROLe; HROLe: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto BtZO2; kcdyk: if (empty($R4HCq)) { return Response::generate(-1, '手机为空或不正确'); } goto UgGtd; VXabP: $sh5sE = MemberUtil::getByPhone($R4HCq); goto AooCD; DFNzI: $JqFey = Session::get('retrievePhoneVerify'); goto rCGkl; b3LnR: Session::forget('retrievePhoneVerify'); goto wKMla; POjQd: return Response::generate(0, null); goto S9SBI; AooCD: if (empty($sh5sE)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto b3LnR; czTto: if (!modstart_config('retrievePhoneEnable', false)) { return Response::generate(-1, '找回密码没有开启'); } goto Dnlwn; lwZ0W: if ($R4HCq != Session::get('retrievePhone')) { return Response::generate(-1, '两次手机不一致'); } goto VXabP; ABNGy: if (Session::get('retrievePhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '手机验证码已过期'); } goto lwZ0W; u8Vgh: Session::forget('retrievePhone'); goto Ojb8B; BtZO2: $WnaVd = InputPackage::buildFromInput(); goto czTto; wKMla: Session::forget('retrievePhoneVerifyTime'); goto u8Vgh; Dnlwn: $R4HCq = $WnaVd->getPhone('phone'); goto hqCnp; UgGtd: if (empty($MK3KS)) { return Response::generate(-1, '验证码不能为空'); } goto DFNzI; Ojb8B: Session::put('retrieveMemberUserId', $sh5sE['id']); goto POjQd; hqCnp: $MK3KS = $WnaVd->getTrimString('verify'); goto kcdyk; rCGkl: if ($MK3KS != $JqFey) { Log::info('Member.RetrievePhone.PhoneVerifyError - ' . $MK3KS . ' - ' . $JqFey); return Response::generate(-1, '手机验证码不正确'); } goto ABNGy; S9SBI: } public function retrievePhoneVerify() { goto S_E7w; lQ_dc: $WnaVd = InputPackage::buildFromInput(); goto kd1D4; UOhE5: Session::put('retrievePhoneVerifyTime', time()); goto TA68u; TA68u: Session::put('retrievePhone', $R4HCq); goto bWFOh; S_E7w: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto lQ_dc; GpCkA: $BCqnl = $WnaVd->getTrimString('captcha'); goto fEToc; VJbut: $sh5sE = MemberUtil::getByPhone($R4HCq); goto A_yeP; kd1D4: $R4HCq = $WnaVd->getPhone('target'); goto p1auR; RVjgF: $MK3KS = rand(100000, 999999); goto B5WXp; A_yeP: if (empty($sh5sE)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto kupNg; fEToc: if (!CaptchaFacade::check($BCqnl)) { return Response::generate(-1, '图片验证码错误'); } goto VJbut; WsnWp: return Response::generate(0, '验证码发送成功'); goto CK0xL; B5WXp: Session::put('retrievePhoneVerify', $MK3KS); goto UOhE5; kupNg: if (Session::get('retrievePhoneVerifyTime') && $R4HCq == Session::get('retrievePhone')) { if (Session::get('retrievePhoneVerifyTime') + 60 * 2 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto RVjgF; bWFOh: SmsSendJob::create($R4HCq, 'verify', array('code' => $MK3KS)); goto WsnWp; p1auR: if (empty($R4HCq)) { return Response::generate(-1, '手机为空或格式不正确'); } goto GpCkA; CK0xL: } public function retrieveEmail() { goto XJ2ET; zvtax: Session::forget('retrieveEmailVerifyTime'); goto ujlG4; zSrqO: if (!modstart_config('retrieveEmailEnable', false)) { return Response::generate(-1, '找回密码没有开启'); } goto b8VkR; oHCr1: $sh5sE = MemberUtil::getByEmail($UNa0Z); goto F8xa0; fJMGV: if (empty($UNa0Z)) { return Response::generate(-1, '邮箱为空或格式不正确'); } goto fNOAV; kFNYt: if (Session::get('retrieveEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '邮箱验证码已过期'); } goto PzUxg; fjqBC: return Response::generate(0, null); goto q2rEO; vLPS9: Session::forget('retrieveEmailVerify'); goto zvtax; z2xAp: $MK3KS = $WnaVd->getTrimString('verify'); goto fJMGV; iwZle: $UNa0Z = $WnaVd->getEmail('email'); goto z2xAp; fNOAV: if (empty($MK3KS)) { return Response::generate(-1, '验证码不能为空'); } goto if6S1; ujlG4: Session::forget('retrieveEmail'); goto jAXsx; if6S1: $JqFey = Session::get('retrieveEmailVerify'); goto vQFJ8; PzUxg: if ($UNa0Z != Session::get('retrieveEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto oHCr1; b8VkR: $WnaVd = InputPackage::buildFromInput(); goto iwZle; XJ2ET: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto zSrqO; F8xa0: if (empty($sh5sE)) { return Response::generate(-1, '邮箱没有绑定任何账号'); } goto vLPS9; jAXsx: Session::put('retrieveMemberUserId', $sh5sE['id']); goto fjqBC; vQFJ8: if ($MK3KS != $JqFey) { Log::info('Member.RetrieveEmail.PhoneVerifyError - ' . $MK3KS . '- ' . $JqFey); return Response::generate(-1, '邮箱验证码不正确'); } goto kFNYt; q2rEO: } public function retrieveEmailVerify() { goto EhgDi; cKyFZ: $MK3KS = rand(100000, 999999); goto sMvi_; e1J91: return Response::generate(0, '验证码发送成功'); goto gHkPl; SwGCn: $sh5sE = MemberUtil::getByEmail($UNa0Z); goto vIDKS; EhgDi: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto NJPqk; h7_fO: if (Session::get('retrieveEmailVerifyTime') && $UNa0Z == Session::get('retrieveEmail')) { if (Session::get('retrieveEmailVerifyTime') + 60 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto cKyFZ; vIDKS: if (empty($sh5sE)) { return Response::generate(-1, '邮箱没有绑定任何账号'); } goto h7_fO; Adqpt: if (empty($UNa0Z)) { return Response::generate(-1, '邮箱格式不正确或为空'); } goto domb2; sMvi_: MailSendJob::create($UNa0Z, '找回密码验证码', 'verify', array('code' => $MK3KS)); goto CC1z7; Ln5FP: Session::put('retrieveEmail', $UNa0Z); goto e1J91; kQl80: Session::put('retrieveEmailVerifyTime', time()); goto Ln5FP; q0H2l: $UNa0Z = $WnaVd->getEmail('target'); goto Adqpt; NJPqk: $WnaVd = InputPackage::buildFromInput(); goto q0H2l; CC1z7: Session::put('retrieveEmailVerify', $MK3KS); goto kQl80; domb2: $BCqnl = $WnaVd->getTrimString('captcha'); goto oMrVO; oMrVO: if (!CaptchaFacade::check($BCqnl)) { return Response::generate(-1, '图片验证码错误'); } goto SwGCn; gHkPl: } public function retrieveResetInfo() { goto tgmVm; jJwwI: $F6CDm = $sh5sE['username']; goto b9Ot6; tgmVm: $tOTDv = Session::get('retrieveMemberUserId'); goto LvKzG; b0edb: return Response::generate(0, null, array('memberUser' => array('username' => $F6CDm))); goto FF0hj; bBzuv: $sh5sE = MemberUtil::get($tOTDv); goto jJwwI; b9Ot6: if (empty($F6CDm)) { $F6CDm = $sh5sE['phone']; } goto FKe5Q; LvKzG: if (empty($tOTDv)) { return Response::generate(-1, '请求错误'); } goto bBzuv; FKe5Q: if (empty($F6CDm)) { $F6CDm = $sh5sE['email']; } goto b0edb; FF0hj: } public function retrieveReset() { goto VzXbA; a64_E: Session::forget('retrieveMemberUserId'); goto ZDz9j; XEk1G: $qDqII = MemberUtil::changePassword($sh5sE['id'], $pKCvN, null, true); goto Fv2M3; Fv2M3: if ($qDqII['code']) { return Response::generate(-1, $qDqII['msg']); } goto mP6SQ; StdCM: if (empty($sh5sE)) { return Response::generate(-1, '用户不存在'); } goto XEk1G; H89ZM: if (empty($tOTDv)) { return Response::generate(-1, '请求错误'); } goto opZaT; IX43o: $WnaVd = InputPackage::buildFromInput(); goto JSAD3; mP6SQ: EventUtil::fire(new MemberUserPasswordResetedEvent($sh5sE['id'], $pKCvN)); goto a64_E; ZDz9j: return Response::generate(0, '成功设置新密码,请您登录'); goto wZaf9; hMtGB: if ($pKCvN != $nWcU7) { return Response::generate(-1, '两次输入密码不一致'); } goto Rn1tO; WcNEC: if (empty($pKCvN)) { return Response::generate(-1, '请输入密码'); } goto hMtGB; opZaT: $pKCvN = $WnaVd->getTrimString('password'); goto E8RR3; E8RR3: $nWcU7 = $WnaVd->getTrimString('passwordRepeat'); goto WcNEC; Rn1tO: $sh5sE = MemberUtil::get($tOTDv); goto StdCM; VzXbA: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto IX43o; JSAD3: $tOTDv = Session::get('retrieveMemberUserId'); goto H89ZM; wZaf9: } public function retrieveCaptchaRaw() { return CaptchaFacade::create('default'); } public function retrieveCaptcha() { $BCqnl = $this->retrieveCaptchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($BCqnl->getOriginalContent()))); } }