<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $Jzn3I) { $Jzn3I->init('member_user')->field(function ($Jzn3I) { $Jzn3I->id('id', 'ID'); MemberAdminList::callGridField($Jzn3I); $Jzn3I->display('avatar', '头像')->hookRendering(function (AbstractField $MygxN, $viyNT, $IE0f3) { $Xpoo8 = AssetsUtil::fixOrDefault($viyNT->avatar, 'asset/image/avatar.svg'); $s9iqY = AssetsUtil::fixOrDefault($viyNT->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$s9iqY}' class='tw-inline-block' data-image-preview>\n                        <img src='{$Xpoo8}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $Jzn3I->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $MygxN, $viyNT, $IE0f3) { switch ($MygxN->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($viyNT->username), modstart_admin_url('member/show', array('_id' => $viyNT->id)))->width('90%')->height('90%')->render()); break; } }); $Jzn3I->text('email', '邮箱'); $Jzn3I->text('phone', '手机'); $Jzn3I->text('nickname', '昵称'); if (MemberOauth::hasEnableItems()) { $Jzn3I->display('_oauth', '授权')->hookRendering(function (AbstractField $MygxN, $viyNT, $IE0f3) { $u8I90 = array(); $w9B0l = MemberUtil::listOauths($viyNT->id); foreach ($w9B0l as $Aiov9) { goto DHrou; zOpPK: if ($i1mqq) { $xWQvo = $i1mqq->color(); $RKCjZ = $i1mqq->title(); } goto erdbB; e3QGF: $u8I90[] = '<a style="color:' . $xWQvo . ';" href="javascript:;" data-tip-popover="' . $RKCjZ . '"><i class="iconfont icon-dot"></i></a>'; goto T9er7; DHrou: $xWQvo = null; goto L8yaB; erdbB: if (empty($xWQvo)) { $xWQvo = ColorUtil::pick($Aiov9['type']); } goto e3QGF; fGoaA: $i1mqq = MemberOauth::getByOauthKey($Aiov9['type']); goto zOpPK; L8yaB: $RKCjZ = $Aiov9['type']; goto fGoaA; T9er7: } return join('', $u8I90); }); } $Jzn3I->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $blfSB = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($blfSB) { $Jzn3I->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $cGwQk = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($cGwQk) { $Jzn3I->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $Jzn3I->date('vipExpire', 'VIP过期'); } $Jzn3I->display('registerIp', '注册IP'); $Jzn3I->display('created_at', '注册时间'); $Jzn3I->canBatchSelect(true); $Jzn3I->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $cgGEv) { $cgGEv->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $cgGEv) { $cgGEv->eq('id', L('ID')); $cgGEv->like('username', '用户名'); $cgGEv->like('email', '邮箱')->autoHide(true); $cgGEv->like('phone', '手机')->autoHide(true); $cgGEv->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $cgGEv->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $cgGEv->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $RtD2p) { $viyNT = $RtD2p->item(); $RtD2p->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $viyNT->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function add(AdminDialogPage $otbXF) { goto Bb_XT; ERTBK: return $otbXF->pageTitle('创建用户')->body($qWiu1)->handleForm($qWiu1, function (Form $qWiu1) { AdminPermission::demoCheck(); $H_ILS = $qWiu1->dataForming(); $F6CDm = !empty($H_ILS['username']) ? $H_ILS['username'] : null; $R4HCq = !empty($H_ILS['phone']) ? $H_ILS['phone'] : null; $UNa0Z = !empty($H_ILS['email']) ? $H_ILS['email'] : null; $wsIYp = ArrayUtil::keepKeys($H_ILS, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $qDqII = MemberUtil::register($F6CDm, $R4HCq, $UNa0Z, $H_ILS['password']); BizException::throwsIfResponseError($qDqII); if (!empty($wsIYp)) { if (isset($wsIYp['vipExpire']) && TimeUtil::isDateEmpty($wsIYp['vipExpire'])) { $wsIYp['vipExpire'] = null; } MemberUtil::update($qDqII['data']['id'], $wsIYp); } EventUtil::fire(new MemberUserRegisteredEvent($qDqII['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto bgLDj; CcwNm: $qWiu1->showSubmit(false)->showReset(false); goto ERTBK; ukUt2: $qWiu1->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $qWiu1) { $qWiu1->text('username', '用户名'); $qWiu1->text('phone', '手机'); $qWiu1->text('email', '邮箱'); $qWiu1->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto ZH6Ge; ZH6Ge: $qWiu1->layoutPanel('高级', function (Form $qWiu1) { $qWiu1->text('nickname', '昵称'); $qWiu1->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $qWiu1->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $qWiu1->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $qWiu1->date('vipExpire', 'VIP过期'); } }); goto CcwNm; Bb_XT: $qWiu1 = Form::make(''); goto ukUt2; bgLDj: } public function edit(AdminDialogPage $otbXF) { goto E7OT1; TQusS: BizException::throwsIfEmpty('用户不存在', $sh5sE); goto MAvr4; RW5Sk: $qWiu1->layoutPanel('高级', function (Form $qWiu1) { $qWiu1->text('nickname', '昵称'); $qWiu1->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $qWiu1->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $qWiu1->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $qWiu1->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto RvtUc; E7OT1: $sh5sE = ModelUtil::get('member_user', CRUDUtil::id()); goto TQusS; RvtUc: $qWiu1->item($sh5sE)->fillFields(); goto dLS2z; CWQLL: $qWiu1 = Form::make(''); goto ov41B; Zkszv: return $otbXF->pageTitle('修改信息')->body($qWiu1)->handleForm($qWiu1, function (Form $qWiu1) use($sh5sE) { AdminPermission::demoCheck(); $H_ILS = $qWiu1->dataForming(); $JWrqK = ArrayUtil::keepKeys($H_ILS, array('username', 'phone', 'email')); $wsIYp = ArrayUtil::keepKeys($H_ILS, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $qDqII = MemberUtil::updateBasicWithUniqueCheck($sh5sE['id'], $JWrqK); BizException::throwsIfResponseError($qDqII); if (isset($wsIYp['vipExpire']) && TimeUtil::isDateEmpty($wsIYp['vipExpire'])) { $wsIYp['vipExpire'] = null; } MemberUtil::update($sh5sE['id'], $wsIYp); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto Y2Ffn; ov41B: $qWiu1->layoutPanel('基础', function (Form $qWiu1) { $qWiu1->display('id', '用户ID')->addable(true); $qWiu1->text('username', '用户名'); $qWiu1->text('phone', '手机'); $qWiu1->text('email', '邮箱'); }); goto RW5Sk; MAvr4: if (Request::isPost()) { goto QVbAs; TvTs5: $WnaVd = InputPackage::buildFromInput(); goto WUpb9; WUpb9: switch ($WnaVd->getTrimString('_action')) { case 'itemCellEdit': goto wcYmB; WjEaB: return Response::generateSuccess(); goto EMkBG; K_h1x: switch ($WnaVd->getTrimString('column')) { case 'status': $CoNy7['status'] = $WnaVd->getInteger('value'); break; } goto I61_M; I61_M: if (!empty($CoNy7)) { MemberUtil::update($sh5sE['id'], $CoNy7); } goto WjEaB; wcYmB: $CoNy7 = array(); goto K_h1x; EMkBG: } goto ZV3qw; QVbAs: AdminPermission::demoCheck(); goto TvTs5; ZV3qw: } goto CWQLL; dLS2z: $qWiu1->showSubmit(false)->showReset(false); goto Zkszv; Y2Ffn: } public function select(AdminDialogPage $otbXF) { goto EKl42; FcAfo: $xqDAM->disableCUD(); goto OnZSt; a2Tfq: CRUDUtil::registerGridResource($xqDAM, '\\' . __CLASS__); goto cMrGX; OnZSt: $xqDAM->canSingleSelectItem(true); goto a2Tfq; cMrGX: if (Request::isPost()) { return $xqDAM->request(); } goto KlPJv; EKl42: $xqDAM = $this->grid(); goto FcAfo; KlPJv: return $otbXF->pageTitle('选择用户')->body($xqDAM); goto yAWyo; yAWyo: } public function search() { goto aCx_5; aCx_5: $WnaVd = InputPackage::buildFromInput(); goto ntaPx; TLauf: $EOboI = MemberUtil::paginate(1, 10, $jpoCE); goto vONwT; vONwT: $P2dHr = array_map(function ($viyNT) { return array('value' => intval($viyNT['id']), 'name' => htmlspecialchars(MemberUtil::viewName($viyNT)), 'avatar' => AssetsUtil::fixOrDefault($viyNT['avatar'], 'asset/image/avatar.svg')); }, $EOboI['records']); goto BZ4LS; ntaPx: $geaiP = $WnaVd->getTrimString('keywords'); goto sOv1E; g7y1d: $jpoCE['whereOperate'] = array('username', 'like', "%{$geaiP}%"); goto TLauf; BZ4LS: return Response::jsonSuccessData($P2dHr); goto oxXln; sOv1E: $jpoCE = array(); goto g7y1d; oxXln: } public function resetPassword(AdminConfigBuilder $Jzn3I) { goto MlZRk; MlZRk: $f3QaN = CRUDUtil::id(); goto Il78X; hLxzK: BizException::throwsIfEmpty('用户不存在', $sh5sE); goto QNVOL; QNVOL: $Jzn3I->useDialog(); goto h9pRT; h9pRT: $Jzn3I->pageTitle('重置密码'); goto Ih3DP; HUkcV: return $Jzn3I; goto DyXyv; Il78X: $sh5sE = MemberUtil::get($f3QaN); goto hLxzK; vBoYb: if (Request::isPost()) { return $Jzn3I->formRequest(function (Form $qWiu1) use($sh5sE) { AdminPermission::demoCheck(); $H_ILS = $qWiu1->dataForming(); $qDqII = MemberUtil::changePassword($sh5sE['id'], $H_ILS['passwordNew'], null, true); BizException::throwsIfResponseError($qDqII); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto HUkcV; Ih3DP: $Jzn3I->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto vBoYb; DyXyv: } public function sendMessage(AdminConfigBuilder $Jzn3I) { goto L5hlN; S7eUa: $Jzn3I->pageTitle('发送消息'); goto kwBb0; kwBb0: $Jzn3I->richHtml('content', '消息内容')->required(); goto eIveD; qVnlU: $sh5sE = MemberUtil::get($f3QaN); goto lBp8i; xKYTz: $Jzn3I->useDialog(); goto S7eUa; L5hlN: $f3QaN = CRUDUtil::id(); goto qVnlU; q5tnd: return $Jzn3I; goto dbz6Z; lBp8i: BizException::throwsIfEmpty('用户不存在', $sh5sE); goto xKYTz; eIveD: if (Request::isPost()) { return $Jzn3I->formRequest(function (Form $qWiu1) use($sh5sE) { AdminPermission::demoCheck(); $H_ILS = $qWiu1->dataForming(); $qDqII = MemberMessageUtil::send($sh5sE['id'], $H_ILS['content']); BizException::throwsIfResponseError($qDqII); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto q5tnd; dbz6Z: } public function show() { goto doCyu; v0hMC: $u81eB = MemberAdminShowPanelProvider::listAll(); goto AOU8P; AOU8P: return view('module::Member.View.admin.memberUser.show', array('record' => $feu3u, 'showPanelProviders' => $u81eB)); goto VffvX; doCyu: $feu3u = MemberUtil::get(CRUDUtil::id()); goto v0hMC; VffvX: } public function delete() { goto q5iky; tp1px: MemberUtil::delete(CRUDUtil::id()); goto glWZR; glWZR: return Response::redirect(CRUDUtil::jsGridRefresh()); goto kwjR4; q5iky: AdminPermission::demoCheck(); goto tp1px; kwjR4: } public function statusForbidden() { goto CBLHC; hcUic: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto ahQ3x; CBLHC: AdminPermission::demoCheck(); goto hcUic; ahQ3x: return Response::redirect(CRUDUtil::jsGridRefresh()); goto vtLkm; vtLkm: } public function export(ExportHandle $zb1UB) { $WydWH = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $zb1UB->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($WydWH)->handleFetch(function ($otbXF, $IgkMS, $fhnbY, $SdkRD) { $Zij9I = ModelUtil::model('member_user'); $Zij9I = $Zij9I->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($fhnbY as $Lcsyi) { if (!empty($Lcsyi['id']['eq'])) { $Zij9I = $Zij9I->where('id', $Lcsyi['id']['eq']); } elseif (!empty($Lcsyi['status']['eq'])) { $Zij9I = $Zij9I->where('status', $Lcsyi['status']['eq']); } elseif (!empty($Lcsyi['groupId']['eq'])) { $Zij9I = $Zij9I->where('groupId', $Lcsyi['groupId']['eq']); } elseif (!empty($Lcsyi['vipId']['eq'])) { $Zij9I = $Zij9I->where('vipId', $Lcsyi['vipId']['eq']); } elseif (!empty($Lcsyi['username']['like'])) { $Zij9I = $Zij9I->where('username', 'like', '%' . $Lcsyi['username']['like'] . '%'); } elseif (!empty($Lcsyi['email']['like'])) { $Zij9I = $Zij9I->where('email', 'like', '%' . $Lcsyi['email']['like'] . '%'); } elseif (!empty($Lcsyi['phone']['like'])) { $Zij9I = $Zij9I->where('phone', 'like', '%' . $Lcsyi['phone']['like'] . '%'); } } $NKZjP = $Zij9I->paginate($IgkMS, array('*'), 'page', $otbXF)->toArray(); $smQSA = array(); foreach ($NKZjP['data'] as $viyNT) { goto O9Ihw; FhA8J: $fHAFr[] = $viyNT['username']; goto Ym3IT; N9CQt: $smQSA[] = $fHAFr; goto yXao5; vwYDz: $fHAFr[] = TypeUtil::name(Gender::class, $viyNT['gender']); goto i5cdL; CJXxI: $fHAFr[] = $viyNT['id']; goto FhA8J; Ym3IT: $fHAFr[] = $viyNT['email']; goto Htmyn; Htmyn: $fHAFr[] = $viyNT['phone']; goto QS6Sa; O9Ihw: $fHAFr = array(); goto CJXxI; QS6Sa: $fHAFr[] = $viyNT['created_at']; goto vwYDz; i5cdL: $fHAFr[] = $viyNT['realname']; goto MXHYd; MXHYd: $fHAFr[] = $viyNT['signature']; goto N9CQt; yXao5: } return array('list' => $smQSA, 'total' => $NKZjP['total']); })->performCommon(); } }